/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.ratelimit.configuration;

import com.tplink.smb.omada.ratelimit.dto.LimiterRuleDTO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ratelimit")
public class LimiterRuleConfig {
    private List<LimiterRuleDTO> rule;
    private Set<String> resourceKeySet;

    @PostConstruct
    public void init() {
        if (CollectionUtils.isEmpty(this.rule)) {
            this.rule = new ArrayList<LimiterRuleDTO>();
            this.resourceKeySet = new HashSet<String>();
            return;
        }
        this.resourceKeySet = this.rule.stream().map(LimiterRuleDTO::getResourceKey).collect(Collectors.toSet());
    }

    @Generated
    public LimiterRuleConfig() {
    }

    @Generated
    public List<LimiterRuleDTO> getRule() {
        return this.rule;
    }

    @Generated
    public Set<String> getResourceKeySet() {
        return this.resourceKeySet;
    }

    @Generated
    public void setRule(List<LimiterRuleDTO> rule) {
        this.rule = rule;
    }

    @Generated
    public void setResourceKeySet(Set<String> resourceKeySet) {
        this.resourceKeySet = resourceKeySet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimiterRuleConfig)) {
            return false;
        }
        LimiterRuleConfig other = (LimiterRuleConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<LimiterRuleDTO> this$rule = this.getRule();
        List<LimiterRuleDTO> other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !((Object)this$rule).equals(other$rule)) {
            return false;
        }
        Set<String> this$resourceKeySet = this.getResourceKeySet();
        Set<String> other$resourceKeySet = other.getResourceKeySet();
        return !(this$resourceKeySet == null ? other$resourceKeySet != null : !((Object)this$resourceKeySet).equals(other$resourceKeySet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LimiterRuleConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LimiterRuleDTO> $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : ((Object)$rule).hashCode());
        Set<String> $resourceKeySet = this.getResourceKeySet();
        result = result * 59 + ($resourceKeySet == null ? 43 : ((Object)$resourceKeySet).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LimiterRuleConfig(rule=" + this.getRule() + ", resourceKeySet=" + this.getResourceKeySet() + ")";
    }
}

