/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local.utils;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class ScheduleBeanFactory {
    private static final Logger log = LoggerFactory.getLogger(ScheduleBeanFactory.class);
    private static ListableBeanFactory beanFactory;

    public static Object getBean(String var1) {
        if (beanFactory == null) {
            log.warn("Spring Bean Factory has not been initialed, failed to get bean {}", (Object)var1);
            return null;
        }
        return beanFactory.getBean(var1);
    }

    public static <T> Map<String, T> getBeans(Class<T> clazz) {
        if (beanFactory == null) {
            log.warn("Spring Bean Factory has not been initialed, failed to get beans {}", clazz);
            return Collections.emptyMap();
        }
        return beanFactory.getBeansOfType(clazz);
    }

    public static <T> T getBean(Class<T> clazz) {
        if (beanFactory == null) {
            log.warn("Spring Bean Factory has not been initialed, failed to get bean {}", clazz);
            return null;
        }
        return (T)beanFactory.getBean(clazz);
    }

    public static Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> clazz) {
        if (beanFactory == null) {
            log.warn("Spring Bean Factory has not been initialed, failed to get bean {}", clazz);
            return null;
        }
        return beanFactory.getBeansWithAnnotation(clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        if (beanFactory == null) {
            log.warn("Spring Bean Factory has not been initialed, failed to get bean {}", clazz);
            return null;
        }
        return beanFactory.getBeansOfType(clazz);
    }

    public static void setBeanFactory(ListableBeanFactory listableBeanFactory) {
        beanFactory = listableBeanFactory;
    }
}

