/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local.quartz;

import com.tplink.smb.component.schedule.api.MisfireStrategy;
import com.tplink.smb.component.schedule.api.exception.ScheduleException;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskIdentityDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTypeEnum;
import com.tplink.smb.component.schedule.common.domain.TimeZoneInfo;
import com.tplink.smb.component.schedule.common.utils.TimeConverter;
import com.tplink.smb.component.schedule.port.local.quartz.IgnoreDSTCronTriggerImpl;
import com.tplink.smb.component.schedule.port.local.quartz.QuartzJob;
import com.tplink.smb.component.schedule.port.local.utils.ScheduleUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class QuartzScheduleService {
    private static final Logger log = LoggerFactory.getLogger(QuartzScheduleService.class);
    private SchedulerFactoryBean schedulerFactoryBean;

    public void addSchedule(ScheduleTaskDO task) {
        if (task == null) {
            return;
        }
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobDetail jobDetail = this.generateJobDetail(task);
        Trigger trigger = this.generateTrigger(task);
        if (trigger == null) {
            return;
        }
        try {
            HashSet<Trigger> triggerSet = new HashSet<Trigger>(1);
            triggerSet.add(trigger);
            scheduler.scheduleJob(jobDetail, triggerSet, true);
            log.debug("schedule job {} with trigger {}", (Object)jobDetail, (Object)trigger);
        }
        catch (SchedulerException e) {
            log.error("quartz schedule task ({}) with error : {}", new Object[]{task.getIdentity().toString(), e.getMessage(), e});
        }
    }

    public void deleteSchedule(ScheduleTaskIdentityDO taskIdentity) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            scheduler.deleteJob(ScheduleUtils.taskIdentity2JobKey(taskIdentity));
        }
        catch (SchedulerException e) {
            log.error("quartz delete task ({}) with error : {}", new Object[]{taskIdentity.toString(), e.getMessage(), e});
        }
    }

    public void pauseSchedule(ScheduleTaskIdentityDO taskIdentity) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            scheduler.pauseJob(ScheduleUtils.taskIdentity2JobKey(taskIdentity));
        }
        catch (SchedulerException e) {
            log.error("pause job failed, identity:{}, {}", new Object[]{taskIdentity.getName(), taskIdentity.getParam(), e});
        }
    }

    public void resumeSchedule(ScheduleTaskIdentityDO taskIdentity) {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            scheduler.resumeJob(ScheduleUtils.taskIdentity2JobKey(taskIdentity));
        }
        catch (SchedulerException e) {
            log.error("resume job failed, identity:{}, {}", new Object[]{taskIdentity.getName(), taskIdentity.getParam(), e});
        }
    }

    public void pauseAll() {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            scheduler.pauseAll();
        }
        catch (SchedulerException e) {
            log.error("pause all job failed");
        }
    }

    public void resumeAll() {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            scheduler.resumeAll();
        }
        catch (SchedulerException e) {
            log.error("resume all job failed");
        }
    }

    public void addAll(List<ScheduleTaskDO> tasks) {
        tasks.forEach(this::addSchedule);
    }

    public void clear() {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        try {
            scheduler.clear();
        }
        catch (SchedulerException e) {
            log.error("quartz cannot clear.", (Throwable)e);
        }
    }

    public Optional<Long> getNextFireTimeByQuartzTrigger(ScheduleTaskDO task) {
        try {
            List triggers = this.schedulerFactoryBean.getScheduler().getTriggersOfJob(ScheduleUtils.taskIdentity2JobKey(task.getIdentity()));
            if (!triggers.isEmpty()) {
                return Optional.ofNullable(triggers.get(0)).map(trigger -> trigger.getFireTimeAfter(new Date())).map(Date::getTime);
            }
        }
        catch (SchedulerException e) {
            log.info("quartz can not get triggers of task ({})", (Object)task.getIdentity(), (Object)e);
        }
        return Optional.empty();
    }

    private JobDetail generateJobDetail(ScheduleTaskDO task) {
        int shardingSize = -1;
        if (Objects.equals(Boolean.TRUE, task.getEnableSharding())) {
            shardingSize = task.getShardingSize();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        dataMap.put("name", task.getIdentity().getName());
        dataMap.put("param", task.getIdentity().getParam());
        dataMap.put("handler_name", task.getHandlerName());
        dataMap.put("data_map", task.getDataMap());
        dataMap.put("delete_after_executed", task.getDeleteAfterExecuted());
        dataMap.put("sharding_size", shardingSize);
        JobDataMap jobDataMap = new JobDataMap(dataMap);
        return JobBuilder.newJob(QuartzJob.class).withIdentity(ScheduleUtils.taskIdentity2JobKey(task.getIdentity())).usingJobData(jobDataMap).build();
    }

    private Trigger generateTrigger(ScheduleTaskDO task) {
        JobKey jobFor = ScheduleUtils.taskIdentity2JobKey(task.getIdentity());
        if (Objects.equals(task.getScheduleTypeEnum(), ScheduleTypeEnum.CRON)) {
            CronExpression cronExpression;
            try {
                cronExpression = new CronExpression(task.getCron());
                if (task.getTimeZoneInfo() == null) {
                    return new IgnoreDSTCronTriggerImpl(jobFor.getName(), jobFor.getGroup(), task.getCron(), new Date(), task.getMisfireStrategy());
                }
                cronExpression.setTimeZone(TimeZoneInfo.toTimeZone((TimeZoneInfo)task.getTimeZoneInfo()));
            }
            catch (ParseException parseEx) {
                log.error("invalid cron expression", (Throwable)parseEx);
                throw new ScheduleException("invalid cron expression " + task.getCron());
            }
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((CronExpression)cronExpression).withMisfireHandlingInstructionDoNothing();
            if (MisfireStrategy.EXECUTE_ONCE.name().equals(task.getMisfireStrategy())) {
                scheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            }
            return TriggerBuilder.newTrigger().withIdentity(jobFor.getName(), jobFor.getGroup()).forJob(jobFor).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        }
        if (Objects.equals(task.getScheduleTypeEnum(), ScheduleTypeEnum.FIX_RATE)) {
            SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(task.getFixedRate().intValue()).withMisfireHandlingInstructionNextWithRemainingCount().repeatForever();
            if (MisfireStrategy.EXECUTE_ONCE.name().equals(task.getMisfireStrategy())) {
                scheduleBuilder.withMisfireHandlingInstructionNowWithRemainingCount();
            }
            long delayMills = Optional.ofNullable(task.getDelay()).map(TimeConverter::sec2Mills).filter(time -> time > 0).orElse(30000).intValue();
            return TriggerBuilder.newTrigger().withIdentity(jobFor.getName(), jobFor.getGroup()).forJob(jobFor).withSchedule((ScheduleBuilder)scheduleBuilder).startAt(new Date(System.currentTimeMillis() + delayMills)).build();
        }
        if (Objects.equals(task.getScheduleTypeEnum(), ScheduleTypeEnum.TIMESTAMP)) {
            if (task.getTimestamp() == null) {
                return null;
            }
            SimpleScheduleBuilder scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow().withRepeatCount(0);
            return TriggerBuilder.newTrigger().withIdentity(jobFor.getName(), jobFor.getGroup()).forJob(jobFor).withSchedule((ScheduleBuilder)scheduleBuilder).startAt(new Date(TimeConverter.sec2Mills((Long)task.getTimestamp()))).build();
        }
        throw new ScheduleException("unknown schedule type.");
    }

    public void setSchedulerFactoryBean(SchedulerFactoryBean schedulerFactoryBean) {
        this.schedulerFactoryBean = schedulerFactoryBean;
    }
}

