/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local.quartz;

import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.ShardingParam;
import com.tplink.smb.component.schedule.common.ScheduleTaskRepository;
import com.tplink.smb.component.schedule.common.TaskExecutorService;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskIdentityDO;
import com.tplink.smb.component.schedule.port.local.utils.ScheduleBeanFactory;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class QuartzJob
extends QuartzJobBean {
    private TaskExecutorService taskExecutorService = ScheduleBeanFactory.getBean(TaskExecutorService.class);
    private ScheduleTaskRepository scheduleTaskRepository = ScheduleBeanFactory.getBean(ScheduleTaskRepository.class);

    protected void executeInternal(JobExecutionContext context) {
        long executeTimeMills = System.currentTimeMillis();
        long scheduledTimeMills = context.getScheduledFireTime().getTime();
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String name = jobDataMap.getString("name");
        String param = jobDataMap.getString("param");
        String handlerName = jobDataMap.getString("handler_name");
        Boolean deleteAfterExecuted = jobDataMap.getBoolean("delete_after_executed");
        int shardingSize = jobDataMap.getInt("sharding_size");
        Map dataMap = (Map)jobDataMap.get((Object)"data_map");
        if (shardingSize >= 1) {
            this.trigger(name, param, handlerName, dataMap, scheduledTimeMills, executeTimeMills, new ShardingParam(Integer.valueOf(shardingSize), Integer.valueOf(0), null, null));
        } else {
            this.trigger(name, param, handlerName, dataMap, scheduledTimeMills, executeTimeMills, null);
        }
        if (Boolean.TRUE.equals(deleteAfterExecuted)) {
            this.scheduleTaskRepository.deleteByIdentity(ScheduleTaskIdentityDO.of((String)name, (String)param));
        }
    }

    private void trigger(String name, String param, String handlerName, Map<String, Object> dataMap, long scheduledTimeMills, long executeTimeMills, ShardingParam shardingParam) {
        ScheduledEvent event = ScheduledEvent.builder().triggerId(this.generateTriggerId()).taskName(name).taskParam(param).handlerName(handlerName).taskDataMap(dataMap).scheduledTime(Long.valueOf(scheduledTimeMills)).triggerTime(Long.valueOf(executeTimeMills)).shardingParam(shardingParam).build();
        this.taskExecutorService.executeTask(event);
    }

    private String generateTriggerId() {
        return String.valueOf(Math.random());
    }
}

