/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local.quartz;

import com.tplink.smb.component.schedule.api.MisfireStrategy;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreDSTCronTriggerImpl
extends CronTriggerImpl {
    private static final Logger log = LoggerFactory.getLogger(IgnoreDSTCronTriggerImpl.class);
    private Date naiveStartTime;

    public IgnoreDSTCronTriggerImpl(String name, String group, String cron, Date naiveStartTime, String misfireStrategy) {
        try {
            this.setName(name);
            this.setGroup(group);
            this.setNaiveStartTime(naiveStartTime);
            this.setCronExpression(cron);
            TimeZone timeZone = TimeZone.getTimeZone("UTC");
            timeZone.setRawOffset(TimeZone.getDefault().getRawOffset());
            this.setTimeZone(timeZone);
            if (MisfireStrategy.EXECUTE_ONCE.name().equals(misfireStrategy)) {
                this.setMisfireInstruction(1);
            } else {
                this.setMisfireInstruction(2);
            }
        }
        catch (ParseException parseEx) {
            log.error("Cron expression {} is invalid.", (Object)cron);
        }
    }

    public Date getFireTimeAfter(Date afterTime) {
        if (afterTime == null) {
            afterTime = new Date();
        }
        if (this.getNaiveStartTime().after(afterTime)) {
            afterTime = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && afterTime.compareTo(this.getEndTime()) >= 0) {
            return null;
        }
        Date pot = this.getTimeAfter(afterTime);
        return this.getEndTime() != null && pot != null && pot.after(this.getEndTime()) ? null : pot;
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.setNextFireTime(this.getFireTimeAfter(this.naiveStartTime));
        return this.getNextFireTime();
    }

    public Date getNaiveStartTime() {
        return this.naiveStartTime;
    }

    public void setNaiveStartTime(Date naiveStartTime) {
        this.naiveStartTime = naiveStartTime;
    }
}

