/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local.core;

import com.tplink.smb.component.schedule.api.ScheduleService;
import com.tplink.smb.component.schedule.common.ScheduleTaskRepository;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskIdentityDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTypeEnum;
import com.tplink.smb.component.schedule.port.local.quartz.QuartzScheduleService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalScheduleService
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(LocalScheduleService.class);
    private QuartzScheduleService quartzScheduleService;
    private ScheduleTaskRepository scheduleTaskRepository;
    private volatile boolean started = false;

    public synchronized void startSchedule() {
        this.startAll();
        this.started = true;
    }

    public synchronized void stopSchedule() {
        this.stopAll();
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void unregisterEvent() {
        this.stopSchedule();
    }

    public synchronized void startAllCronOrFixRateTask() {
        if (this.isStarted()) {
            List<ScheduleTaskDO> tasks = this.scheduleTaskRepository.findAll().stream().filter(this::isCronOrFixRateTask).collect(Collectors.toList());
            this.quartzScheduleService.addAll(tasks);
        }
    }

    synchronized void startTask(ScheduleTaskDO task) {
        if (this.isStarted()) {
            this.quartzScheduleService.addSchedule(task);
        }
    }

    synchronized void stopTask(ScheduleTaskIdentityDO taskIdentity) {
        this.quartzScheduleService.deleteSchedule(taskIdentity);
    }

    synchronized void pauseTask(ScheduleTaskIdentityDO taskIdentity) {
        this.quartzScheduleService.pauseSchedule(taskIdentity);
    }

    synchronized void resumeTask(ScheduleTaskIdentityDO taskIdentity) {
        this.quartzScheduleService.resumeSchedule(taskIdentity);
    }

    synchronized void pauseAll() {
        this.quartzScheduleService.pauseAll();
    }

    synchronized void resumeAll() {
        this.quartzScheduleService.resumeAll();
    }

    Optional<Long> getNextScheduledTime(ScheduleTaskDO scheduleTask) {
        if (!this.isStarted()) {
            return Optional.empty();
        }
        return this.quartzScheduleService.getNextFireTimeByQuartzTrigger(scheduleTask);
    }

    private void startAll() {
        List tasks = this.scheduleTaskRepository.findAll();
        this.quartzScheduleService.addAll(tasks);
    }

    private void stopAll() {
        this.quartzScheduleService.clear();
    }

    private boolean isCronOrFixRateTask(ScheduleTaskDO task) {
        return Objects.equals(task.getScheduleTypeEnum(), ScheduleTypeEnum.CRON) || Objects.equals(task.getScheduleTypeEnum(), ScheduleTypeEnum.FIX_RATE);
    }

    public void setScheduleTaskRepository(ScheduleTaskRepository scheduleTaskRepository) {
        this.scheduleTaskRepository = scheduleTaskRepository;
    }

    public void setQuartzScheduleService(QuartzScheduleService quartzScheduleService) {
        this.quartzScheduleService = quartzScheduleService;
    }
}

