/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local.core;

import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.TaskKey;
import com.tplink.smb.component.schedule.api.exception.ScheduleException;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.component.schedule.api.handler.SystemTimeChangedListener;
import com.tplink.smb.component.schedule.api.handler.TaskTriggerUpdateHandler;
import com.tplink.smb.component.schedule.common.ScheduleTaskRepository;
import com.tplink.smb.component.schedule.common.TaskExecutorService;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTaskIdentityDO;
import com.tplink.smb.component.schedule.common.domain.ScheduleTypeEnum;
import com.tplink.smb.component.schedule.common.utils.TimeConverter;
import com.tplink.smb.component.schedule.port.local.core.LocalScheduleService;
import com.tplink.smb.component.schedule.port.local.utils.ScheduleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalScheduleCenter
implements ScheduleCenter {
    private static final Logger log = LoggerFactory.getLogger(LocalScheduleCenter.class);
    private ScheduleTaskRepository scheduleTaskRepository;
    private TaskExecutorService taskExecutorService;
    private LocalScheduleService localScheduleService;
    private List<SystemTimeChangedListener> systemTimeChangedListenerList = Collections.synchronizedList(new ArrayList());
    private ConcurrentHashMap<ScheduleTaskIdentityDO, TaskTriggerUpdateHandler> taskTriggerUpdateHandlers = new ConcurrentHashMap();

    public void registerSimpleSerialHandler(String handlerName, ScheduledEventHandler scheduledEventHandler) {
        ThreadPoolExecutor serialExecutor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(2), r -> new Thread(r, "schedule-serial-executor#" + handlerName), new ThreadPoolExecutor.DiscardPolicy(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                log.warn("Executing and waiting jobs are more than 3, discard.");
                super.rejectedExecution(r, e);
            }
        });
        serialExecutor.allowCoreThreadTimeOut(true);
        this.registerEventHandler(handlerName, scheduledEventHandler, serialExecutor);
    }

    public void registerSimpleConcurrentHandler(String handlerName, ScheduledEventHandler scheduledEventHandler, int nThreads) {
        ThreadPoolExecutor concurrentExecutor = new ThreadPoolExecutor(nThreads, nThreads, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(nThreads * 2), r -> new Thread(r, "schedule-concurrent-executor#" + handlerName), new ThreadPoolExecutor.DiscardPolicy(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                log.warn("The executor and queue is full, discard");
                super.rejectedExecution(r, e);
            }
        });
        concurrentExecutor.allowCoreThreadTimeOut(true);
        this.registerEventHandler(handlerName, scheduledEventHandler, concurrentExecutor);
    }

    public void registerEventHandler(String handlerName, ScheduledEventHandler scheduledEventHandler, ExecutorService executor) {
        this.taskExecutorService.addTaskExecutor(handlerName, scheduledEventHandler, executor);
    }

    public void registerEventHandler(String handlerName, ScheduledEventHandler scheduledEventHandler, ExecutorService executor, ScheduledExecutorService scheduledExecutor) {
        this.registerEventHandler(handlerName, scheduledEventHandler, executor);
    }

    public void unregisterEventHandler(String handlerName) {
        this.taskExecutorService.deleteTaskExecutor(handlerName);
    }

    public void addSystemTimeChangedListener(SystemTimeChangedListener systemTimeChangedListener) {
        this.systemTimeChangedListenerList.add(systemTimeChangedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTask(ScheduleTask scheduleTask) {
        ScheduleTaskDO task = ScheduleTaskDO.fromScheduleTask((ScheduleTask)scheduleTask);
        task.setShardBatchSize(null);
        task.setShardBatchDelayMill(null);
        this.validateIdentity(task);
        this.validateHandlerName(task);
        this.validateTrigger(task);
        this.validateSharding(task);
        LocalScheduleCenter localScheduleCenter = this;
        synchronized (localScheduleCenter) {
            this.scheduleTaskRepository.save(task);
            this.localScheduleService.startTask(task);
        }
    }

    public void saveTask(ScheduleTask scheduleTask, TaskTriggerUpdateHandler taskTriggerUpdateHandler) {
        this.saveTask(scheduleTask);
        this.taskTriggerUpdateHandlers.put(ScheduleTaskIdentityDO.of((String)scheduleTask.getTaskKey().getName(), (String)scheduleTask.getTaskKey().getParam()), taskTriggerUpdateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTask(TaskKey taskKey) {
        ScheduleTaskIdentityDO taskIdentity = ScheduleTaskIdentityDO.from((TaskKey)taskKey);
        LocalScheduleCenter localScheduleCenter = this;
        synchronized (localScheduleCenter) {
            this.scheduleTaskRepository.deleteByIdentity(taskIdentity);
            this.localScheduleService.stopTask(taskIdentity);
        }
    }

    public Optional<ScheduleTask> findTask(TaskKey taskKey) {
        return this.scheduleTaskRepository.findByIdentity(ScheduleTaskIdentityDO.from((TaskKey)taskKey)).map(ScheduleTaskDO::toScheduleTask);
    }

    public List<ScheduleTask> findTasksByTaskName(String taskName) {
        return this.scheduleTaskRepository.findByName(taskName).stream().map(ScheduleTaskDO::toScheduleTask).collect(Collectors.toList());
    }

    public List<ScheduleTask> findTasksByHandlerName(String handlerName) {
        return this.scheduleTaskRepository.findByHandlerName(handlerName).stream().map(ScheduleTaskDO::toScheduleTask).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ScheduleTask> updateTimestamp(TaskKey taskKey, Long timestamp) {
        Optional optTask;
        if (timestamp == null) {
            throw new ScheduleException("invalid timestamp: null for task" + taskKey);
        }
        if (timestamp <= ScheduleUtils.currentTimeSeconds()) {
            log.info("invalid timestamp {} for taskKey {}. early than now. the task may not be execute.", (Object)timestamp, (Object)taskKey);
        }
        ScheduleTaskIdentityDO taskIdentity = ScheduleTaskIdentityDO.from((TaskKey)taskKey);
        LocalScheduleCenter localScheduleCenter = this;
        synchronized (localScheduleCenter) {
            optTask = this.scheduleTaskRepository.updateTimestamp(taskIdentity, TimeConverter.mills2Sec((Long)timestamp));
            if (!optTask.isPresent()) {
                log.warn("Update timestamp failed. Task {} does not exists.", (Object)taskKey);
            } else {
                this.localScheduleService.startTask((ScheduleTaskDO)optTask.get());
            }
        }
        return optTask.map(ScheduleTaskDO::toScheduleTask);
    }

    public Optional<Long> getNextScheduledTime(TaskKey taskKey) {
        ScheduleTaskDO taskPO = this.scheduleTaskRepository.findByIdentity(ScheduleTaskIdentityDO.from((TaskKey)taskKey)).orElse(null);
        if (taskPO == null) {
            log.info("task with key {} does not exists.", (Object)taskKey);
            return Optional.empty();
        }
        return this.localScheduleService.getNextScheduledTime(taskPO);
    }

    public void pauseJob(TaskKey taskKey) {
        ScheduleTaskIdentityDO taskIdentity = ScheduleTaskIdentityDO.from((TaskKey)taskKey);
        this.localScheduleService.pauseTask(taskIdentity);
    }

    public void pauseAll() {
        this.localScheduleService.pauseAll();
    }

    public void resumeAll() {
        this.localScheduleService.resumeAll();
    }

    public void resumeJob(TaskKey taskKey) {
        ScheduleTaskIdentityDO taskIdentity = ScheduleTaskIdentityDO.from((TaskKey)taskKey);
        this.localScheduleService.resumeTask(taskIdentity);
    }

    private void validateIdentity(ScheduleTaskDO scheduleTask) {
        if (scheduleTask.getIdentity().getName() == null || scheduleTask.getIdentity().getName().isEmpty()) {
            throw new ScheduleException("task name cannot be null or empty");
        }
        if (scheduleTask.getIdentity().getParam() != null && scheduleTask.getIdentity().getParam().isEmpty()) {
            throw new ScheduleException("task param cannot be empty");
        }
    }

    private void validateHandlerName(ScheduleTaskDO scheduleTask) {
        if (scheduleTask.getHandlerName() != null && scheduleTask.getHandlerName().isEmpty()) {
            throw new ScheduleException("handlerName cannot be empty");
        }
    }

    private void validateTrigger(ScheduleTaskDO scheduleTask) {
        ScheduleTypeEnum scheduleType = scheduleTask.getScheduleTypeEnum();
        if (Objects.equals(ScheduleTypeEnum.CRON, scheduleType)) {
            if (scheduleTask.getCron() == null || !CronExpression.isValidExpression((String)scheduleTask.getCron())) {
                throw new ScheduleException("invalid cron time setting: " + scheduleTask.getCron());
            }
        } else if (Objects.equals(ScheduleTypeEnum.FIX_RATE, scheduleType)) {
            if (scheduleTask.getFixedRate() == null || scheduleTask.getFixedRate() <= 0) {
                throw new ScheduleException("invalid fixed rate " + scheduleTask.getFixedRate());
            }
            if (scheduleTask.getDelay() != null && scheduleTask.getDelay() < 0) {
                log.warn("delay {} invalid for task {}", (Object)scheduleTask.getDelay(), (Object)scheduleTask.getIdentity());
            }
        } else if (Objects.equals(ScheduleTypeEnum.TIMESTAMP, scheduleType) && scheduleTask.getTimestamp() == null) {
            throw new ScheduleException("invalid timestamp: null for task" + scheduleTask.getIdentity());
        }
    }

    private void validateSharding(ScheduleTaskDO scheduleTask) {
        boolean invalidShardingSize;
        boolean bl = invalidShardingSize = scheduleTask.getShardingSize() == null || scheduleTask.getShardingSize() != 1;
        if (Boolean.TRUE.equals(scheduleTask.getEnableSharding()) && invalidShardingSize) {
            throw new ScheduleException(" invalid sharding size : local version must be 1" + scheduleTask.getShardingSize());
        }
    }

    public List<SystemTimeChangedListener> getSystemTimeChangedListenerList() {
        return this.systemTimeChangedListenerList;
    }

    public void updateTaskTriggers() {
        this.taskTriggerUpdateHandlers.forEach((key, handler) -> this.scheduleTaskRepository.findByIdentity(key).map(ScheduleTaskDO::toScheduleTask).ifPresent(task -> this.saveTask(handler.handle(task))));
    }

    public void setScheduleTaskRepository(ScheduleTaskRepository scheduleTaskRepository) {
        this.scheduleTaskRepository = scheduleTaskRepository;
    }

    public void setTaskExecutorService(TaskExecutorService taskExecutorService) {
        this.taskExecutorService = taskExecutorService;
    }

    public void setLocalScheduleService(LocalScheduleService localScheduleService) {
        this.localScheduleService = localScheduleService;
    }
}

