/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.schedule.port.local;

import com.tplink.smb.component.schedule.port.local.core.LocalScheduleCenter;
import com.tplink.smb.component.schedule.port.local.core.LocalScheduleService;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SystemTimeCheckTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SystemTimeCheckTask.class);
    private LocalScheduleCenter localScheduleCenter;
    private LocalScheduleService localScheduleService;
    private static final ScheduledExecutorService scheduledThreadPool = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "smb-schedule-local-system-time-check-task"));
    private static final long MIN_SYNC = 300000L;
    private static final int INIT_DELAY = 30000;
    private static final int EXECUTE_DELAY = 30000;
    private static final long MAX_DELTA = 210000L;
    private final Object lock = new Object();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private long previousJvmTime = 0L;
    private long previousSysTime = 0L;
    private long lastTimeSyncJvmTime = 0L;
    private boolean needTimeSync = false;

    @PostConstruct
    public void start() {
        scheduledThreadPool.scheduleWithFixedDelay(this, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        this.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doRun() {
        Object object = this.lock;
        synchronized (object) {
            if (this.previousSysTime == 0L) {
                this.previousSysTime = Instant.now().toEpochMilli();
                this.previousJvmTime = this.runtimeMXBean.getUptime();
                log.debug("First check system time, set values. {}", (Object)this);
                return true;
            }
            long currentSysTime = Instant.now().toEpochMilli();
            long currentJvmTime = this.runtimeMXBean.getUptime();
            log.debug("Checking system time. {} currentJvmTime: [{}]; currentSysTime: [{}]; ", new Object[]{this, currentJvmTime, new Date(currentSysTime)});
            boolean timeSynced = false;
            try {
                if (this.needTimeSync) {
                    log.debug("Need to handle previous time sync.");
                    if (currentJvmTime - this.lastTimeSyncJvmTime > 300000L) {
                        this.doSyncTime();
                        timeSynced = true;
                        this.needTimeSync = false;
                        this.lastTimeSyncJvmTime = currentJvmTime;
                        boolean bl = true;
                        return bl;
                    }
                    log.debug("Time sync need to wait next task execution.");
                    boolean bl = true;
                    return bl;
                }
                long sysDelta = Math.abs(this.previousSysTime - currentSysTime);
                long jvmDelta = Math.abs(this.previousJvmTime - currentJvmTime);
                log.debug("sysDelta:[{}]; jvmDelta:[{}]", (Object)sysDelta, (Object)jvmDelta);
                if (Math.abs(sysDelta - jvmDelta) <= 210000L) {
                    log.debug("Time is not changed, no need to handle time sync.");
                    boolean bl = true;
                    return bl;
                }
                if (this.lastTimeSyncJvmTime == 0L || currentJvmTime - this.lastTimeSyncJvmTime > 300000L) {
                    log.debug("Time changed! Need to handle previous time sync.");
                    this.doSyncTime();
                    timeSynced = true;
                    this.needTimeSync = false;
                    this.lastTimeSyncJvmTime = currentJvmTime;
                } else {
                    log.debug("Need time sync, wait next task execution.");
                    this.needTimeSync = true;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (timeSynced) {
                    this.previousSysTime = currentSysTime;
                    this.previousJvmTime = currentJvmTime;
                } else {
                    this.previousSysTime += currentJvmTime - this.previousJvmTime;
                    this.previousJvmTime = currentJvmTime;
                }
            }
        }
    }

    public String toString() {
        return "previousJvmTime: [" + this.previousJvmTime + "]; previousSysTime: [" + new Date(this.previousSysTime) + "]; lastTimeSyncJvmTime: [" + this.lastTimeSyncJvmTime + "]; ";
    }

    private void doSyncTime() {
        try {
            scheduledThreadPool.execute(() -> {
                this.rescheduleCronAndFixRateTask();
                log.info("reschedule all cron and fixrate task");
                this.localScheduleCenter.getSystemTimeChangedListenerList().forEach(systemTimeChangedListener -> {
                    try {
                        log.debug("handle systemTime changed listener {}", systemTimeChangedListener.getClass());
                        systemTimeChangedListener.handle();
                    }
                    catch (Exception e) {
                        log.error("Execute systemTimeChangedListener {} with exception.", systemTimeChangedListener.getClass(), (Object)e);
                    }
                });
                this.localScheduleCenter.updateTaskTriggers();
            });
        }
        catch (RejectedExecutionException rejectedEx) {
            log.error("Do sync fail for thread pool reject.", (Throwable)rejectedEx);
        }
    }

    private void rescheduleCronAndFixRateTask() {
        this.localScheduleService.startAllCronOrFixRateTask();
    }

    public void setLocalScheduleCenter(LocalScheduleCenter localScheduleCenter) {
        this.localScheduleCenter = localScheduleCenter;
    }

    public void setLocalScheduleService(LocalScheduleService localScheduleService) {
        this.localScheduleService = localScheduleService;
    }
}

