/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.external.openapi.webhook;

import com.tplink.smb.omada.logmanager.api.external.webhook.WebhookSettingTestVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class OpenApiWebhookSettingTestVO {
    @Schema(name="name", description="Webhook name. It should contain 1 to 128 characters.")
    @NotNull(message="Webhook name should not be null")
    @Length(min=1, max=128, message="Webhook Name Length should be in [1,128]")
    private @NotNull(message="Webhook name should not be null") @Length(min=1, max=128, message="Webhook Name Length should be in [1,128]") String name;
    @Schema(name="shardedSecret", description="Webhook Sharded Secret. It should contain 0 to 128 characters.")
    @Length(max=128, message="Webhook sharded secret Length should be in [0,128]")
    private @Length(max=128, message="Webhook sharded secret Length should be in [0,128]") String shardedSecret;
    @Schema(name="urlList", description="Webhook URL List. Up to 3 entries are allowed for the URL list", example="[http(s)://webhook.site/4a566f9e-0b77-42e2-9a34-a78]")
    @NotEmpty(message="Webhook URL List should not be empty and can contain a maximum of three URL entries")
    private @NotEmpty(message="Webhook URL List should not be empty and can contain a maximum of three URL entries") List<String> urlList;
    @NotNull(message="template should not be null")
    @Schema(name="template", description="Webhook template, it should be a value as follow: 0:Omada template, 1:Google chat template. Example: 0. ")
    @Range(min=0L, max=1L, message="template value should be int number in [0,1]")
    private @NotNull(message="template should not be null") @Range(min=0L, max=1L, message="template value should be int number in [0,1]") Integer template;

    public WebhookSettingTestVO toWebhookSettingTestVO(String webhookId) {
        return new WebhookSettingTestVO().setWebhookId(webhookId).setName(this.getName()).setToken(this.getShardedSecret()).setUrlList(this.getUrlList()).setTemplate(this.getTemplate());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getShardedSecret() {
        return this.shardedSecret;
    }

    @Generated
    public List<String> getUrlList() {
        return this.urlList;
    }

    @Generated
    public Integer getTemplate() {
        return this.template;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setShardedSecret(String shardedSecret) {
        this.shardedSecret = shardedSecret;
    }

    @Generated
    public void setUrlList(List<String> urlList) {
        this.urlList = urlList;
    }

    @Generated
    public void setTemplate(Integer template) {
        this.template = template;
    }

    @Generated
    public String toString() {
        return "OpenApiWebhookSettingTestVO(name=" + this.getName() + ", shardedSecret=" + this.getShardedSecret() + ", urlList=" + this.getUrlList() + ", template=" + this.getTemplate() + ")";
    }

    @Generated
    public OpenApiWebhookSettingTestVO(String name, String shardedSecret, List<String> urlList, Integer template) {
        this.name = name;
        this.shardedSecret = shardedSecret;
        this.urlList = urlList;
        this.template = template;
    }

    @Generated
    public OpenApiWebhookSettingTestVO() {
    }
}

