/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.external.openapi.webhook;

import com.tplink.smb.omada.logmanager.api.external.webhook.WebhookSettingAddVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

public class OpenApiWebhookSettingAddVO {
    @Schema(name="name", description="Webhook name. It should contain 1 to 128 characters.")
    @NotBlank(message="Webhook name should not be null or blank")
    @Length(min=1, max=128, message="Webhook Name Length should be in [1,128]")
    private @NotBlank(message="Webhook name should not be null or blank") @Length(min=1, max=128, message="Webhook Name Length should be in [1,128]") String name;
    @Schema(name="urlList", description="Webhook URL List. Up to 3 entries are allowed for the URL list", example=" [http(s)://webhook.site/4a566f9e-0b77-42e2-9a34-a78]")
    @NotEmpty(message="Webhook URL List should not be empty and can contain a maximum of three URL entries")
    private @NotEmpty(message="Webhook URL List should not be empty and can contain a maximum of three URL entries") List<String> urlList;
    @NotNull(message="Retry Policy should not be null")
    @Schema(name="retryPolicy", description="Webhook retry policy. It should be a value as follows: 0:None, 1:Important (Up to 5 retries over 60 minutes), 2:Critical (Up to 5 retries over 24 hours)")
    @Range(min=0L, max=2L, message="Retry policy value should be int number in [0,2]")
    private @NotNull(message="Retry Policy should not be null") @Range(min=0L, max=2L, message="Retry policy value should be int number in [0,2]") Integer retryPolicy;
    @Schema(name="shardedSecret", description="Webhook Sharded Secret. It should contain 0 to 128 characters.")
    @Length(max=128, message="Webhook sharded secret Length should be in [0,128]")
    private @Length(max=128, message="Webhook sharded secret Length should be in [0,128]") String shardedSecret;
    @NotNull(message="template should not be null")
    @Schema(name="template", description="Webhook template, it should be a value as follow: 0:Omada template, 1:Google chat template. Example: 0. ")
    @Range(min=0L, max=1L, message="template value should be int number in [0,1]")
    private @NotNull(message="template should not be null") @Range(min=0L, max=1L, message="template value should be int number in [0,1]") Integer template;

    public WebhookSettingAddVO toWebhookSettingAddVO() {
        return new WebhookSettingAddVO().setName(this.getName()).setUrlList(this.getUrlList()).setRetryPolicy(this.getRetryPolicy()).setToken(this.shardedSecret).setTemplate(this.getTemplate());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getUrlList() {
        return this.urlList;
    }

    @Generated
    public Integer getRetryPolicy() {
        return this.retryPolicy;
    }

    @Generated
    public String getShardedSecret() {
        return this.shardedSecret;
    }

    @Generated
    public Integer getTemplate() {
        return this.template;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUrlList(List<String> urlList) {
        this.urlList = urlList;
    }

    @Generated
    public void setRetryPolicy(Integer retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Generated
    public void setShardedSecret(String shardedSecret) {
        this.shardedSecret = shardedSecret;
    }

    @Generated
    public void setTemplate(Integer template) {
        this.template = template;
    }

    @Generated
    public String toString() {
        return "OpenApiWebhookSettingAddVO(name=" + this.getName() + ", urlList=" + this.getUrlList() + ", retryPolicy=" + this.getRetryPolicy() + ", shardedSecret=" + this.getShardedSecret() + ", template=" + this.getTemplate() + ")";
    }
}

