/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.external.openapi.log;

import com.tplink.smb.omada.logmanager.api.external.dto.NotificationSettingVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.LogAlertEmailOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.LogNotificationOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.WebhookConfigOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class LogNotificationSettingOpenApiVO {
    @Schema(name="webhookConfig", description="Log Notification Webhook Config (This config applies to the Omada Pro Controller only)")
    private WebhookConfigOpenApiVO webhookConfig;
    @Schema(name="logNotifications", description="Log Notification List")
    private List<LogNotificationOpenApiVO> logNotifications;
    @Schema(name="alertEmailSetting", description="Log Alert Email (This config applies to the log site view)")
    private LogAlertEmailOpenApiVO alertEmailSetting;

    public static LogNotificationSettingOpenApiVO fromNotificationSettingVO(NotificationSettingVO notificationSettingVO, Boolean isSite) {
        ArrayList<LogNotificationOpenApiVO> logNotificationOpenApiVOS = new ArrayList<LogNotificationOpenApiVO>();
        logNotificationOpenApiVOS.addAll(notificationSettingVO.getAlertNotifications().stream().map(notificationVO -> LogNotificationOpenApiVO.fromAlertLogNotificationVO(notificationVO)).collect(Collectors.toList()));
        logNotificationOpenApiVOS.addAll(notificationSettingVO.getEventNotifications().stream().map(notificationVO -> LogNotificationOpenApiVO.fromEventLogNotificationVO(notificationVO)).collect(Collectors.toList()));
        LogNotificationSettingOpenApiVO notificationSettingOpenApiVO = new LogNotificationSettingOpenApiVO().setLogNotifications(logNotificationOpenApiVOS);
        notificationSettingOpenApiVO.setWebhookConfig(WebhookConfigOpenApiVO.fromWebhookConfigVO(notificationSettingVO.getWebhookSetting()));
        if (Boolean.TRUE.equals(isSite)) {
            notificationSettingOpenApiVO.setAlertEmailSetting(LogAlertEmailOpenApiVO.fromAlertEmailSettingVO(notificationSettingVO.getAlertEmailSetting()));
        }
        return notificationSettingOpenApiVO;
    }

    @Generated
    public LogNotificationSettingOpenApiVO setWebhookConfig(WebhookConfigOpenApiVO webhookConfig) {
        this.webhookConfig = webhookConfig;
        return this;
    }

    @Generated
    public LogNotificationSettingOpenApiVO setLogNotifications(List<LogNotificationOpenApiVO> logNotifications) {
        this.logNotifications = logNotifications;
        return this;
    }

    @Generated
    public LogNotificationSettingOpenApiVO setAlertEmailSetting(LogAlertEmailOpenApiVO alertEmailSetting) {
        this.alertEmailSetting = alertEmailSetting;
        return this;
    }

    @Generated
    public WebhookConfigOpenApiVO getWebhookConfig() {
        return this.webhookConfig;
    }

    @Generated
    public List<LogNotificationOpenApiVO> getLogNotifications() {
        return this.logNotifications;
    }

    @Generated
    public LogAlertEmailOpenApiVO getAlertEmailSetting() {
        return this.alertEmailSetting;
    }

    @Generated
    public LogNotificationSettingOpenApiVO() {
    }

    @Generated
    public LogNotificationSettingOpenApiVO(WebhookConfigOpenApiVO webhookConfig, List<LogNotificationOpenApiVO> logNotifications, LogAlertEmailOpenApiVO alertEmailSetting) {
        this.webhookConfig = webhookConfig;
        this.logNotifications = logNotifications;
        this.alertEmailSetting = alertEmailSetting;
    }

    @Generated
    public String toString() {
        return "LogNotificationSettingOpenApiVO(webhookConfig=" + this.getWebhookConfig() + ", logNotifications=" + this.getLogNotifications() + ", alertEmailSetting=" + this.getAlertEmailSetting() + ")";
    }
}

