/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.external.openapi.log;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.NotificationSettingVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.LogAlertEmailOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.LogNotificationEditOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.WebhookConfigEditOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class LogNotificationSettingEditOpenApiVO {
    @Schema(name="webhookConfig", description="Log Notification Webhook Config (This config applies to the Omada Pro Controller only)")
    private WebhookConfigEditOpenApiVO webhookConfig;
    @Schema(name="logNotifications", description="Log Notification List")
    @NotEmpty(message="Log Notification list should not bu null or empty")
    private @NotEmpty(message="Log Notification list should not bu null or empty") List<LogNotificationEditOpenApiVO> logNotifications;
    @Schema(name="alertEmailSetting", description="Log Alert Email (This config applies to the log site view)")
    private LogAlertEmailOpenApiVO alertEmailSetting;

    public static NotificationSettingVO toNotificationSettingVO(LogNotificationSettingEditOpenApiVO logNotificationSettingVO, Boolean isSite, List<String> alertKeys, List<String> eventKeys) {
        ArrayList alertNotifications = new ArrayList();
        ArrayList eventNotifications = new ArrayList();
        alertNotifications.addAll(logNotificationSettingVO.getLogNotifications().stream().filter(logNotification -> alertKeys.contains(logNotification.getKey())).map(logNotification -> LogNotificationEditOpenApiVO.toAlertLogNotificationVO(logNotification)).collect(Collectors.toList()));
        eventNotifications.addAll(logNotificationSettingVO.getLogNotifications().stream().filter(logNotification -> eventKeys.contains(logNotification.getKey())).map(logNotification -> LogNotificationEditOpenApiVO.toEventLogNotificationVO(logNotification)).collect(Collectors.toList()));
        NotificationSettingVO notificationSettingVO = NotificationSettingVO.builder().alertNotifications(alertNotifications).eventNotifications(eventNotifications).build();
        if (Objects.nonNull(logNotificationSettingVO.getWebhookConfig())) {
            notificationSettingVO.setWebhookSetting(WebhookConfigEditOpenApiVO.toWebhookConfigVO(logNotificationSettingVO.getWebhookConfig()));
        } else {
            notificationSettingVO.setWebhookSetting(null);
        }
        if (Boolean.TRUE.equals(isSite)) {
            notificationSettingVO.setAlertEmailSetting(LogAlertEmailOpenApiVO.toAlertEmailSettingVO(logNotificationSettingVO.getAlertEmailSetting()));
        }
        return notificationSettingVO;
    }

    public boolean check(Boolean isSite) {
        return !Boolean.TRUE.equals(isSite) || this.checkAlertEmail();
    }

    private boolean checkAlertEmail() {
        if (Objects.isNull(this.alertEmailSetting) || Objects.isNull(this.alertEmailSetting.getAlertEmailEnable())) {
            return false;
        }
        if (Boolean.TRUE.equals(this.alertEmailSetting.getDelayEnable())) {
            Integer delay = this.alertEmailSetting.getDelay();
            return !Objects.isNull(delay) && delay >= 0 && delay <= 99999;
        }
        return true;
    }

    private boolean checkWebhook() {
        if (Boolean.TRUE.equals(this.getWebhookConfig().getWebhookEnable()) && T.a((String)this.getWebhookConfig().getWebhookId())) {
            return false;
        }
        return this.checkNotificationWebhook();
    }

    private boolean checkNotificationWebhook() {
        for (LogNotificationEditOpenApiVO notificationEditOpenApiVO : this.logNotifications) {
            if (!Objects.isNull(notificationEditOpenApiVO) && !Objects.isNull(notificationEditOpenApiVO.getWebhook())) continue;
            return false;
        }
        return true;
    }

    @Generated
    public void setWebhookConfig(WebhookConfigEditOpenApiVO webhookConfig) {
        this.webhookConfig = webhookConfig;
    }

    @Generated
    public void setLogNotifications(List<LogNotificationEditOpenApiVO> logNotifications) {
        this.logNotifications = logNotifications;
    }

    @Generated
    public void setAlertEmailSetting(LogAlertEmailOpenApiVO alertEmailSetting) {
        this.alertEmailSetting = alertEmailSetting;
    }

    @Generated
    public WebhookConfigEditOpenApiVO getWebhookConfig() {
        return this.webhookConfig;
    }

    @Generated
    public List<LogNotificationEditOpenApiVO> getLogNotifications() {
        return this.logNotifications;
    }

    @Generated
    public LogAlertEmailOpenApiVO getAlertEmailSetting() {
        return this.alertEmailSetting;
    }

    @Generated
    public LogNotificationSettingEditOpenApiVO() {
    }

    @Generated
    public LogNotificationSettingEditOpenApiVO(WebhookConfigEditOpenApiVO webhookConfig, List<LogNotificationEditOpenApiVO> logNotifications, LogAlertEmailOpenApiVO alertEmailSetting) {
        this.webhookConfig = webhookConfig;
        this.logNotifications = logNotifications;
        this.alertEmailSetting = alertEmailSetting;
    }

    @Generated
    public String toString() {
        return "LogNotificationSettingEditOpenApiVO(webhookConfig=" + this.getWebhookConfig() + ", logNotifications=" + this.getLogNotifications() + ", alertEmailSetting=" + this.getAlertEmailSetting() + ")";
    }
}

