/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.external.openapi.log;

import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.logmanager.api.external.dto.NotificationSettingVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.LogAlertEmailOpenApiVO;
import com.tplink.smb.omada.logmanager.api.external.openapi.log.LogNotificationEditOpenApiV2VO;
import com.tplink.smb.omada.logmanager.api.external.openapi.webhook.WebhookConfigEditOpenApiVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class LogNotificationSettingEditOpenApiV2VO {
    @Schema(name="webhookConfig", description="Log Notification Webhook Config (This config applies to the Omada Pro Controller only)")
    private WebhookConfigEditOpenApiVO webhookConfig;
    @Schema(name="alertNotifications", description="Alert Notification List")
    private List<LogNotificationEditOpenApiV2VO> alertNotifications;
    @Schema(name="eventNotifications", description="Event Notification List")
    private List<LogNotificationEditOpenApiV2VO> eventNotifications;
    @Schema(name="alertEmailSetting", description="Log Alert Email (This config applies to the log site view)")
    private LogAlertEmailOpenApiVO alertEmailSetting;
    @Schema(name="eventEmailSetting", description="Log Event Email (This config applies to the log site view)")
    private LogAlertEmailOpenApiVO eventEmailSetting;

    public static NotificationSettingVO toNotificationSettingVO(LogNotificationSettingEditOpenApiV2VO logNotificationSettingVO, Boolean isSite, List<String> alertKeys, List<String> eventKeys) {
        ArrayList alertNotifications = new ArrayList();
        ArrayList eventNotifications = new ArrayList();
        alertNotifications.addAll(logNotificationSettingVO.getAlertNotifications().stream().filter(logNotification -> alertKeys.contains(logNotification.getKey())).map(logNotification -> LogNotificationEditOpenApiV2VO.toLogNotificationVO(logNotification)).collect(Collectors.toList()));
        eventNotifications.addAll(logNotificationSettingVO.getEventNotifications().stream().filter(logNotification -> eventKeys.contains(logNotification.getKey())).map(logNotification -> LogNotificationEditOpenApiV2VO.toLogNotificationVO(logNotification)).collect(Collectors.toList()));
        NotificationSettingVO notificationSettingVO = NotificationSettingVO.builder().alertNotifications(alertNotifications).eventNotifications(eventNotifications).build();
        if (Objects.nonNull(logNotificationSettingVO.getWebhookConfig())) {
            notificationSettingVO.setWebhookSetting(WebhookConfigEditOpenApiVO.toWebhookConfigVO(logNotificationSettingVO.getWebhookConfig()));
        }
        if (Boolean.TRUE.equals(isSite)) {
            notificationSettingVO.setAlertEmailSetting(LogAlertEmailOpenApiVO.toAlertEmailSettingVO(logNotificationSettingVO.getAlertEmailSetting()));
            notificationSettingVO.setEventEmailSetting(LogAlertEmailOpenApiVO.toEventEmailSettingVO(logNotificationSettingVO.getEventEmailSetting()));
        }
        return notificationSettingVO;
    }

    public boolean check(Boolean isPro, Boolean isSite) {
        if (Boolean.TRUE.equals(isPro) && !this.checkWebhook()) {
            return false;
        }
        if (Boolean.TRUE.equals(isSite) && !this.checkAlertEmail()) {
            return false;
        }
        return !Boolean.TRUE.equals(isSite) || this.checkEventEmail();
    }

    private boolean checkAlertEmail() {
        if (Objects.isNull(this.alertEmailSetting) || Objects.isNull(this.alertEmailSetting.getAlertEmailEnable())) {
            return false;
        }
        if (Boolean.TRUE.equals(this.alertEmailSetting.getDelayEnable())) {
            Integer delay = this.alertEmailSetting.getDelay();
            return !Objects.isNull(delay) && delay >= 0 && delay <= 99999;
        }
        return true;
    }

    private boolean checkEventEmail() {
        if (Objects.isNull(this.eventEmailSetting) || Objects.isNull(this.eventEmailSetting.getAlertEmailEnable())) {
            return false;
        }
        if (Boolean.TRUE.equals(this.eventEmailSetting.getDelayEnable())) {
            Integer delay = this.eventEmailSetting.getDelay();
            return !Objects.isNull(delay) && delay >= 0 && delay <= 99999;
        }
        return true;
    }

    private boolean checkWebhook() {
        if (Boolean.TRUE.equals(this.getWebhookConfig().getWebhookEnable()) && T.a((String)this.getWebhookConfig().getWebhookId())) {
            return false;
        }
        return this.checkNotificationWebhook();
    }

    private boolean checkNotificationWebhook() {
        for (LogNotificationEditOpenApiV2VO notificationEditOpenApiVO : this.alertNotifications) {
            if (!Objects.isNull(notificationEditOpenApiVO) && !Objects.isNull(notificationEditOpenApiVO.getWebhook())) continue;
            return false;
        }
        for (LogNotificationEditOpenApiV2VO notificationEditOpenApiVO : this.eventNotifications) {
            if (!Objects.isNull(notificationEditOpenApiVO) && !Objects.isNull(notificationEditOpenApiVO.getWebhook())) continue;
            return false;
        }
        return true;
    }

    @Generated
    public void setWebhookConfig(WebhookConfigEditOpenApiVO webhookConfig) {
        this.webhookConfig = webhookConfig;
    }

    @Generated
    public void setAlertNotifications(List<LogNotificationEditOpenApiV2VO> alertNotifications) {
        this.alertNotifications = alertNotifications;
    }

    @Generated
    public void setEventNotifications(List<LogNotificationEditOpenApiV2VO> eventNotifications) {
        this.eventNotifications = eventNotifications;
    }

    @Generated
    public void setAlertEmailSetting(LogAlertEmailOpenApiVO alertEmailSetting) {
        this.alertEmailSetting = alertEmailSetting;
    }

    @Generated
    public void setEventEmailSetting(LogAlertEmailOpenApiVO eventEmailSetting) {
        this.eventEmailSetting = eventEmailSetting;
    }

    @Generated
    public WebhookConfigEditOpenApiVO getWebhookConfig() {
        return this.webhookConfig;
    }

    @Generated
    public List<LogNotificationEditOpenApiV2VO> getAlertNotifications() {
        return this.alertNotifications;
    }

    @Generated
    public List<LogNotificationEditOpenApiV2VO> getEventNotifications() {
        return this.eventNotifications;
    }

    @Generated
    public LogAlertEmailOpenApiVO getAlertEmailSetting() {
        return this.alertEmailSetting;
    }

    @Generated
    public LogAlertEmailOpenApiVO getEventEmailSetting() {
        return this.eventEmailSetting;
    }

    @Generated
    public LogNotificationSettingEditOpenApiV2VO() {
    }

    @Generated
    public LogNotificationSettingEditOpenApiV2VO(WebhookConfigEditOpenApiVO webhookConfig, List<LogNotificationEditOpenApiV2VO> alertNotifications, List<LogNotificationEditOpenApiV2VO> eventNotifications, LogAlertEmailOpenApiVO alertEmailSetting, LogAlertEmailOpenApiVO eventEmailSetting) {
        this.webhookConfig = webhookConfig;
        this.alertNotifications = alertNotifications;
        this.eventNotifications = eventNotifications;
        this.alertEmailSetting = alertEmailSetting;
        this.eventEmailSetting = eventEmailSetting;
    }

    @Generated
    public String toString() {
        return "LogNotificationSettingEditOpenApiV2VO(webhookConfig=" + this.getWebhookConfig() + ", alertNotifications=" + this.getAlertNotifications() + ", eventNotifications=" + this.getEventNotifications() + ", alertEmailSetting=" + this.getAlertEmailSetting() + ", eventEmailSetting=" + this.getEventEmailSetting() + ")";
    }
}

