/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.logmanager.api.external.openapi;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.logmanager.api.external.audit.AuditLogVO;
import com.tplink.smb.omada.logmanager.api.internal.dto.AuditLogResourceEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.OperateResultEnumDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

public class AuditLogOpenApiVO {
    @Schema(name="time", description="Log Creation TimeStamp, Unit:ms", example="1677660067182")
    private Long time;
    @Schema(name="operator", description="Operator", example="user1")
    private String operator;
    @Schema(name="resource", description="Log Creation Resource. It should be a value as follows: WEB\u3001Open API", example="WEB")
    private String resource;
    @Schema(name="ip", description="User Login IP address", example="127.0.0.1")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String ip;
    @Schema(name="auditType", description="Log Type", example="Log")
    private String auditType;
    @Schema(name="level", description="Log Level. It should be a value as follows: Error, Warning, Information.", example="Information")
    private String level;
    @Schema(name="result", description="Operation Result, it should be a value as follows: Succeed\u3001Failed", example="Succeed")
    private String result;
    @Schema(name="content", description="Log Content", example="Dashboard Tab test-Tab added successfully.")
    private String content;
    @Schema(name="label", description="Configuration card or request path, may be empty.", example="MENU.CLIENTS or /openapi/v1/{omadacId}/sites/{siteId}/site/reset/log-notification")
    private String label;
    @Schema(name="oldValue", description="Configuration before modification, may be empty.", example="{\"dpi\":\"false\",\"loggingTraffic\":\"false\"}")
    private Object oldValue;
    @Schema(name="newValue", description="Configuration after modification, may be empty.", example="{\"dpi\":\"true\",\"loggingTraffic\":\"true\"}")
    private Object newValue;

    public static AuditLogOpenApiVO fromAuditLogVO(AuditLogVO auditLogVO) {
        return new AuditLogOpenApiVO().setTime(auditLogVO.getTime()).setOperator(auditLogVO.getOperator()).setResource(AuditLogResourceEnumDTO.resolve((Integer)auditLogVO.getResource()).getResourceString()).setIp(auditLogVO.getIp()).setAuditType(auditLogVO.getAuditType()).setLevel(auditLogVO.getLevel()).setResult(OperateResultEnumDTO.resolve((Integer)auditLogVO.getResult()).getResultString()).setContent(auditLogVO.getContent()).setLabel(auditLogVO.getLabel()).setOldValue(AuditLogOpenApiVO.getOldOrNewValueAsObject(auditLogVO.getOldValue())).setNewValue(AuditLogOpenApiVO.getOldOrNewValueAsObject(auditLogVO.getNewValue()));
    }

    private static Object getOldOrNewValueAsObject(String string) {
        if (T.c((String)string)) {
            return string;
        }
        try {
            return x.a((String)string, Object.class);
        }
        catch (Exception e2) {
            return string;
        }
    }

    @Generated
    public AuditLogOpenApiVO setTime(Long time) {
        this.time = time;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setOperator(String operator) {
        this.operator = operator;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setResource(String resource) {
        this.resource = resource;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setIp(String ip) {
        this.ip = ip;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setAuditType(String auditType) {
        this.auditType = auditType;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setLevel(String level) {
        this.level = level;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setResult(String result) {
        this.result = result;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setContent(String content) {
        this.content = content;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setLabel(String label) {
        this.label = label;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setOldValue(Object oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @Generated
    public AuditLogOpenApiVO setNewValue(Object newValue) {
        this.newValue = newValue;
        return this;
    }

    @Generated
    public Long getTime() {
        return this.time;
    }

    @Generated
    public String getOperator() {
        return this.operator;
    }

    @Generated
    public String getResource() {
        return this.resource;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getAuditType() {
        return this.auditType;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Object getOldValue() {
        return this.oldValue;
    }

    @Generated
    public Object getNewValue() {
        return this.newValue;
    }

    @Generated
    public AuditLogOpenApiVO() {
    }

    @Generated
    public AuditLogOpenApiVO(Long time, String operator, String resource, String ip, String auditType, String level, String result, String content, String label, Object oldValue, Object newValue) {
        this.time = time;
        this.operator = operator;
        this.resource = resource;
        this.ip = ip;
        this.auditType = auditType;
        this.level = level;
        this.result = result;
        this.content = content;
        this.label = label;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Generated
    public String toString() {
        return "AuditLogOpenApiVO(time=" + this.getTime() + ", operator=" + this.getOperator() + ", resource=" + this.getResource() + ", ip=" + this.getIp() + ", auditType=" + this.getAuditType() + ", level=" + this.getLevel() + ", result=" + this.getResult() + ", content=" + this.getContent() + ", label=" + this.getLabel() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
    }
}

