/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.topology.port.schedule.task;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.omada.client.api.internal.f;
import com.tplink.smb.omada.client.api.internal.g;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.w;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.config.osg.OsgSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osg.client.OsgClientConfig;
import com.tplink.smb.omada.device.manage.message.config.osw.OswSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.osw.TopologyConfig;
import com.tplink.smb.omada.device.manage.message.config.osw.client.OswClientEntry;
import com.tplink.smb.omada.device.manage.message.config.osw.client.OswPortClient;
import com.tplink.smb.omada.identityaccess.api.external.dto.newui.NewUIConfigVO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.VmsDevicesDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApNvrEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseNvrEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOsgEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MultiOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OltOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.WiredApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.ApNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.MultiOswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.NvrNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OduNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OltNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OsgNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OtherNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.Port;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.StpLoopInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyDTO;
import com.tplink.smb.omada.manager.configuration.domain.model.omadac.u;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.device.o;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.a;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.c;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.m;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.n;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.osg.e;
import com.tplink.smb.omada.manager.j.a.a.d;
import com.tplink.smb.omada.manager.topology.domain.discovery.TopologyDevices;
import com.tplink.smb.omada.manager.topology.dto.PersistenceNodeDTO;
import com.tplink.smb.omada.manager.topology.port.cache.f;
import com.tplink.smb.omada.manager.topology.port.cache.g;
import com.tplink.smb.omada.manager.topology.port.cache.i;
import com.tplink.smb.omada.manager.topology.port.schedule.TopologyScheduleProperties;
import jakarta.annotation.Nonnull;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@KeepClassNameAndSetter
public class TopologyTask {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(TopologyTask.class);
    @Autowired
    private LockService b;
    @Autowired
    private com.tplink.smb.omada.manager.topology.port.cache.c c;
    @Autowired
    private com.tplink.smb.omada.manager.topology.port.cache.g d;
    @Autowired
    private com.tplink.smb.omada.manager.topology.port.cache.f e;
    @Autowired
    private l f;
    @Qualifier(value="commonTopologyWorkGroup")
    @Autowired
    private ExecutorService g;
    @Autowired
    private com.tplink.smb.omada.manager.topology.domain.discovery.a h;
    @Autowired
    private com.tplink.smb.omada.manager.device.api.internal.c.c.a i;
    @Autowired
    private g j;
    @Autowired
    private f k;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.deviceimage.osg.i l;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.g.d.b m;
    @Autowired
    private O n;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.f o;
    @Autowired
    private TopologyScheduleProperties p;
    @Autowired
    private u q;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.g.d.a r;
    @Autowired
    private i s;
    @Autowired
    private com.tplink.smb.omada.identityaccess.api.internal.g t;
    private static final Set<String> u = Arrays.stream(DeviceTypeEnum.values()).map(DeviceTypeEnum::b).collect(Collectors.toSet());

    public boolean a(String omadacId, Set<String> sites) {
        a.debug("omadacId={}, topology calculate site num: {}", (Object)omadacId, (Object)sites.size());
        Boolean central = this.a(omadacId);
        for (String siteId : sites) {
            boolean needDiscovery = this.c.e(omadacId, siteId);
            if (!needDiscovery) {
                a.trace("no need to discover topology, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
                continue;
            }
            a.trace("start discover topology, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
            this.g.execute(() -> this.a(omadacId, siteId, central));
        }
        return true;
    }

    public OperationResponse a(String omadacId, String siteId) {
        return (OperationResponse)this.b.doWithTryLock("manager:topo.task.lock", (Object)(omadacId + siteId), () -> {
            if (!this.c.a(omadacId, siteId)) {
                return OperationResponse.SUCCESS;
            }
            a.debug("start discover topology, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
            if (this.c.b(omadacId, siteId)) {
                Boolean central = this.a(omadacId);
                com.tplink.smb.omada.common.concurrent.thread.b.a(() -> this.a(omadacId, siteId, central));
            }
            return OperationResponse.SUCCESS;
        }, () -> {
            a.warn("get lock to discover topology fail, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bA);
        });
    }

    private void a(String omadacId, String siteId, Boolean central) {
        HashMap<String, String> devices = new HashMap<String, String>();
        HashMap<String, Boolean> gatewayIpptModes = new HashMap<String, Boolean>();
        HashSet<String> slaveMacs = new HashSet<String>();
        HashMap<String, String> hbmDevices = new HashMap<String, String>();
        HashMap<String, Integer> mlagMacToRoleMap = new HashMap<String, Integer>();
        HashMap<String, List<n>> vrrpMacToInfoMap = new HashMap<String, List<n>>();
        List deviceList = this.f.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new d(siteId));
        Set<String> onlineDevices = deviceList.stream().map(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d::X).collect(Collectors.toSet());
        Set pendingDevices = this.f.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new d("PENDING-SITE"));
        this.a(siteId, deviceList, devices, gatewayIpptModes, slaveMacs, hbmDevices, mlagMacToRoleMap, vrrpMacToInfoMap);
        Boolean newUI = Boolean.TRUE;
        try {
            OperationResponse response = this.t.h(omadacId);
            newUI = Objects.nonNull(response.getResult()) ? ((NewUIConfigVO)response.getResult()).getNewUI() : Boolean.TRUE;
        }
        catch (Exception e2) {
            a.warn("omadacId: {} get UI config failed, default new UI.", (Object)omadacId);
        }
        TopologyDTO oldTopologyDTO = Boolean.TRUE.equals(newUI) ? this.m.a(omadacId, siteId) : null;
        HashMap<String, PersistenceNodeDTO> disconnectedNodes = new HashMap<String, PersistenceNodeDTO>();
        HashMap<String, PersistenceNodeDTO> forgetNodes = new HashMap<String, PersistenceNodeDTO>();
        HashMap<String, PersistenceNodeDTO> otherNodes = new HashMap<String, PersistenceNodeDTO>();
        HashMap<String, PersistenceNodeDTO> vigiNodes = new HashMap<String, PersistenceNodeDTO>();
        HashMap<String, PersistenceNodeDTO> partialMemOfflineMultiOswNodes = new HashMap<String, PersistenceNodeDTO>();
        HashMap<String, Map<String, Port>> uplinkToDownlinkHbmDevMap = new HashMap<String, Map<String, Port>>();
        HashMap<String, Map<String, Port>> uplinkToDownlinkVigiDevMap = new HashMap<String, Map<String, Port>>();
        HashMap<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>> hbmVrrpMemInternalLinks = new HashMap<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>>();
        Object offlineOsgNode = null;
        if (!Objects.isNull(oldTopologyDTO) && !Objects.isNull(oldTopologyDTO.getTopology())) {
            Network oldTopology = oldTopologyDTO.getTopology();
            for (Object node : oldTopology.nodes()) {
                if (!CollectionUtils.isEmpty(hbmDevices)) {
                    this.a(siteId, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node, (Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)oldTopology, devices, hbmDevices, uplinkToDownlinkHbmDevMap, hbmVrrpMemInternalLinks);
                }
                if (node instanceof MultiOswNode) {
                    MultiOswNode multiOswNode = (MultiOswNode)node;
                    this.a(omadacId, siteId, (Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)oldTopology, disconnectedNodes, forgetNodes, multiOswNode, onlineDevices, pendingDevices, partialMemOfflineMultiOswNodes);
                    continue;
                }
                if (devices.containsKey(node.getMac()) || Objects.equals(node.getType(), "omada controller") || slaveMacs.contains(node.getMac())) continue;
                if (Objects.equals(node.getType(), "other")) {
                    otherNodes.put(node.getMac(), new PersistenceNodeDTO(node.getMac(), (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node, oldTopology.inEdges(node), oldTopology.outEdges(node), false));
                    continue;
                }
                if (Objects.equals(node.getType(), "NVR") || Objects.equals(node.getType(), "IPC")) {
                    vigiNodes.put(node.getMac(), new PersistenceNodeDTO(node.getMac(), (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node, oldTopology.inEdges(node), oldTopology.outEdges(node), false));
                    this.a(siteId, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node, (Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)oldTopology, devices, hbmDevices, uplinkToDownlinkVigiDevMap, hbmVrrpMemInternalLinks);
                    continue;
                }
                Optional deviceOpt = this.n.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new d(siteId), new G(node.getMac()));
                if (onlineDevices.contains(node.getMac()) || pendingDevices.contains(node.getMac())) {
                    if (!a.isDebugEnabled()) continue;
                    a.debug("device {} is not disconnected, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)node.getMac()));
                    continue;
                }
                if (Objects.isNull(offlineOsgNode)) {
                    Object object = offlineOsgNode = Objects.equals(node.getType(), "gateway") ? node : null;
                }
                if (deviceOpt.isPresent()) {
                    node.setName(((o)deviceOpt.get()).f_());
                    disconnectedNodes.put(node.getMac(), new PersistenceNodeDTO(node.getMac(), (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node, oldTopology.inEdges(node), oldTopology.outEdges(node), false));
                    continue;
                }
                forgetNodes.put(node.getMac(), new PersistenceNodeDTO(node.getMac(), (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node, oldTopology.inEdges(node), oldTopology.outEdges(node), false));
            }
            if (a.isDebugEnabled()) {
                a.debug("omadaId={},siteId={},disconnectedNodes={},forgetNodes={},otherNodes={},vigiNodes={},partialMemOfflineMultiOswNodes={}, offlineOsgNode:{}", new Object[]{omadacId, siteId, PIIJacksonUtil.parseToStr(disconnectedNodes), PIIJacksonUtil.parseToStr(forgetNodes), PIIJacksonUtil.parseToStr(otherNodes), PIIJacksonUtil.parseToStr(vigiNodes), PIIJacksonUtil.parseToStr(partialMemOfflineMultiOswNodes), PIIJacksonUtil.parseToStr(offlineOsgNode)});
                a.debug("siteId:{}, uplinkToDownlinkHbmDevMap:{}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr(uplinkToDownlinkHbmDevMap));
            }
        }
        VmsDevicesDTO vmsDevicesDTO = new VmsDevicesDTO();
        if (Boolean.TRUE.equals(central)) {
            try {
                vmsDevicesDTO = this.r.a(omadacId, siteId, devices);
            }
            catch (Exception e3) {
                a.warn("fail to query site vms device for omadacId : {} siteId : {}", (Object)omadacId, (Object)siteId);
            }
        }
        Set offlineVigiMacs = Optional.ofNullable(vmsDevicesDTO.getOfflineVigiMacs()).orElse(new HashSet());
        if (!CollectionUtils.isEmpty(vigiNodes)) {
            for (String vigiMac : vigiNodes.keySet()) {
                if (!offlineVigiMacs.contains(vigiMac)) continue;
                disconnectedNodes.put(vigiMac, (PersistenceNodeDTO)vigiNodes.get(vigiMac));
            }
        }
        MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology = null;
        if (CollectionUtils.isEmpty(devices)) {
            forgetNodes.putAll(otherNodes);
            a.trace("No connected device found, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
            if (Objects.isNull(oldTopologyDTO) || Objects.isNull(oldTopologyDTO.getTopology()) || CollectionUtils.isEmpty(disconnectedNodes)) {
                a.trace("No disconnected device found, omadacId={}, siteId={}", (Object)omadacId, (Object)siteId);
                this.c.c(omadacId, siteId);
                this.m.d(omadacId, siteId);
                return;
            }
            disconnectedTopology = com.tplink.smb.omada.manager.topology.domain.discovery.b.a(disconnectedNodes, forgetNodes, null);
            if (a.isDebugEnabled()) {
                a.debug("siteId:{}, only disconnectedTopology nodes = {} ; edges = {}", new Object[]{siteId, PIIJacksonUtil.parseToStr((Object)disconnectedTopology.nodes()), PIIJacksonUtil.parseToStr((Object)disconnectedTopology.edges())});
            }
            String id = this.m.b(omadacId, siteId);
            TopologyDTO dto = new TopologyDTO(id, disconnectedTopology, Long.valueOf(System.currentTimeMillis()));
            this.m.a(omadacId, siteId, dto);
            this.c.c(omadacId, siteId);
            return;
        }
        Set<String> lldpExceptMacs = this.a(disconnectedNodes, forgetNodes);
        if (a.isDebugEnabled()) {
            a.debug("siteId:{}, lldpExceptMacs:{}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr(lldpExceptMacs));
        }
        Set<String> vigiMaybeHbmMacs = vigiNodes.keySet().stream().filter(mac -> !offlineVigiMacs.contains(mac)).collect(Collectors.toSet());
        if (a.isDebugEnabled()) {
            a.debug("siteId:{}, vigiMaybeHbmMacs:{}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr(vigiMaybeHbmMacs));
        }
        TopologyDevices topologyDevices = this.h.a(omadacId, siteId, devices, vmsDevicesDTO, lldpExceptMacs, gatewayIpptModes, hbmDevices, uplinkToDownlinkHbmDevMap, vigiMaybeHbmMacs, mlagMacToRoleMap, vrrpMacToInfoMap);
        if (!CollectionUtils.isEmpty(vigiMaybeHbmMacs) && a.isDebugEnabled()) {
            a.debug("siteId:{}, vigiMaybeHbmMacs left:{}, try add lldp to its original uplink", (Object)siteId, (Object)PIIJacksonUtil.parseToStr(vigiMaybeHbmMacs));
            this.a(siteId, vigiMaybeHbmMacs, topologyDevices, uplinkToDownlinkVigiDevMap, vigiNodes);
        }
        if (!CollectionUtils.isEmpty(topologyDevices.getVrrpOswMap())) {
            com.tplink.smb.omada.manager.topology.domain.discovery.b.a(topologyDevices.getVrrpOswMap(), hbmVrrpMemInternalLinks);
        }
        this.a(topologyDevices, partialMemOfflineMultiOswNodes, disconnectedNodes);
        if (!CollectionUtils.isEmpty(otherNodes)) {
            HashSet onlineOther = new HashSet(otherNodes.keySet());
            onlineOther.retainAll(topologyDevices.getOtherMap().keySet());
            otherNodes.keySet().removeAll(onlineOther);
            forgetNodes.putAll(otherNodes);
            if (a.isDebugEnabled()) {
                a.debug("siteId = {}, forget nodes after put discOther = {}", (Object)siteId, forgetNodes);
            }
        }
        if (!CollectionUtils.isEmpty(disconnectedNodes)) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a rootByOfflineOsg;
            if (Objects.isNull(topologyDevices.getRootNode()) && !Objects.isNull(rootByOfflineOsg = this.a((Map<String, PersistenceNodeDTO>)disconnectedNodes, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)offlineOsgNode, topologyDevices, (Map<String, String>)hbmDevices))) {
                topologyDevices.setRootNode(rootByOfflineOsg);
                if (a.isDebugEnabled()) {
                    a.debug("omadacId:{}, siteId:{}, find root node by offLineOsg, root node:{}", new Object[]{omadacId, siteId, PIIJacksonUtil.parseToStr((Object)rootByOfflineOsg)});
                }
            }
            disconnectedTopology = com.tplink.smb.omada.manager.topology.domain.discovery.b.a(disconnectedNodes, forgetNodes, topologyDevices);
            if (a.isDebugEnabled()) {
                a.debug("siteId:{}, disconnectedTopology nodes = {} ; edges = {}", new Object[]{siteId, PIIJacksonUtil.parseToStr((Object)disconnectedTopology.nodes()), PIIJacksonUtil.parseToStr((Object)disconnectedTopology.edges())});
            }
        }
        this.a(siteId, topologyDevices, devices.size(), disconnectedNodes, disconnectedNodes.size());
        long start = System.currentTimeMillis();
        MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology = null;
        try {
            topology = com.tplink.smb.omada.manager.topology.domain.discovery.b.a(topologyDevices, disconnectedTopology);
        }
        catch (Exception e4) {
            a.warn("Fail to calculate topology siteId= {}", (Object)siteId, (Object)e4);
        }
        a.debug("site={} topology calculate cost: {}ms", (Object)siteId, (Object)(System.currentTimeMillis() - start));
        if (topology == null) {
            this.c.c(omadacId, siteId);
            this.m.d(omadacId, siteId);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a rootNode = topologyDevices.getRootNode();
        if (Objects.nonNull(rootNode) && Objects.equals("other", rootNode.getType()) && topology.nodes().contains(rootNode) && CollectionUtils.isEmpty((Collection)topology.successors((Object)rootNode))) {
            topology.removeNode((Object)rootNode);
            com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.b commonSiteSetting = this.o.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new d(siteId)).orElse(null);
            if (Objects.nonNull(commonSiteSetting)) {
                commonSiteSetting.b(null);
                this.o.a(commonSiteSetting);
            }
        }
        List<StpLoopInfoDTO> stpLoopInfos = com.tplink.smb.omada.manager.topology.domain.discovery.b.a(topology, topologyDevices);
        this.a(siteId, topology, stpLoopInfos);
        String id = this.m.b(omadacId, siteId);
        TopologyDTO dto = new TopologyDTO(id, topology, Long.valueOf(System.currentTimeMillis()));
        dto.setExistRootNode(Boolean.valueOf(topologyDevices.existRootNode()));
        dto.setStpLoopInfos(stpLoopInfos);
        this.m.a(omadacId, siteId, dto);
        this.c.c(omadacId, siteId);
        this.c.a(omadacId, siteId, this.p.getTopoRefreshPeriod());
        if (topologyDevices.getOdu() != null) {
            this.a(omadacId, siteId, topologyDevices, topologyDevices.getOdu());
        }
        Map apClientsMap = null;
        try {
            apClientsMap = this.j.e(omadacId, siteId);
        }
        catch (Exception e5) {
            a.warn("Fail to call clientStatInternalApiService.listSiteApClientMacs, This is OK When updating controller to CBC 6.0 . If this error continues after that, maybe something went wrong", (Throwable)e5);
        }
        if (topologyDevices.getOsg() != null) {
            this.a(omadacId, siteId, topologyDevices.getOsg(), (Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, (Map<String, String>)devices, (Map<String, Set<String>>)apClientsMap);
        }
        if (topologyDevices.getOswMap() != null) {
            this.a(omadacId, siteId, topologyDevices, (Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, apClientsMap, stpLoopInfos);
        }
    }

    private Set<String> a(Map<String, PersistenceNodeDTO> disconnectedNodes, Map<String, PersistenceNodeDTO> forgetNodes) {
        HashSet<String> lldpExceptMacs = new HashSet<String>();
        disconnectedNodes.values().forEach(dto -> {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a patt29463$temp = dto.getNode();
            if (patt29463$temp instanceof MultiOswNode) {
                MultiOswNode multiOswNode = (MultiOswNode)patt29463$temp;
                multiOswNode.getMacToNodeMap().values().forEach(oswNode -> {
                    if (Objects.equals(oswNode.getStatus(), DeviceStatusEnum.a.n())) {
                        lldpExceptMacs.add(oswNode.getMac());
                    }
                });
            } else {
                lldpExceptMacs.add(dto.getMac());
            }
        });
        forgetNodes.values().forEach(dto -> {
            lldpExceptMacs.add(dto.getMac());
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a patt30008$temp = dto.getNode();
            if (patt30008$temp instanceof MultiOswNode) {
                MultiOswNode multiOswNode = (MultiOswNode)patt30008$temp;
                lldpExceptMacs.addAll(multiOswNode.getMacToNodeMap().keySet());
            }
        });
        return lldpExceptMacs;
    }

    private void a(TopologyDevices topologyDevices, Map<String, PersistenceNodeDTO> partialMemOfflineMultiOswNodes, Map<String, PersistenceNodeDTO> disconnectedNodes) {
        PersistenceNodeDTO dto;
        Map<String, MultiOswNode> mlagOswMap = topologyDevices.getMlagOswMap();
        Map<String, MultiOswNode> vrrpOswMap = topologyDevices.getVrrpOswMap();
        if (CollectionUtils.isEmpty(mlagOswMap) && CollectionUtils.isEmpty(vrrpOswMap) || CollectionUtils.isEmpty(partialMemOfflineMultiOswNodes)) {
            return;
        }
        if (!CollectionUtils.isEmpty(vrrpOswMap)) {
            for (MultiOswNode multiOswNode : vrrpOswMap.values()) {
                dto = this.a(multiOswNode, partialMemOfflineMultiOswNodes);
                if (Objects.isNull(dto)) {
                    if (!a.isDebugEnabled()) continue;
                    a.debug("fail to find old MultiOswNode for multiOswNode:{}", (Object)PIIJacksonUtil.parseToStr((Object)multiOswNode));
                    continue;
                }
                this.a(multiOswNode, dto, disconnectedNodes);
            }
        }
        if (!CollectionUtils.isEmpty(mlagOswMap)) {
            for (MultiOswNode multiOswNode : mlagOswMap.values()) {
                dto = this.a(multiOswNode, partialMemOfflineMultiOswNodes);
                if (Objects.isNull(dto)) {
                    if (!a.isDebugEnabled()) continue;
                    a.debug("fail to find old MultiOswNode for multiOswNode:{}", (Object)PIIJacksonUtil.parseToStr((Object)multiOswNode));
                    continue;
                }
                this.a(multiOswNode, dto, disconnectedNodes);
            }
        }
    }

    private void a(MultiOswNode multiOswNode, PersistenceNodeDTO dto, Map<String, PersistenceNodeDTO> disconnectedNodes) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node = dto.getNode();
        if (!(node instanceof MultiOswNode)) {
            return;
        }
        MultiOswNode oldMultiOsw = (MultiOswNode)node;
        switch (oldMultiOsw.getType()) {
            case "vrrp": {
                for (OswNode oswNode : oldMultiOsw.getMacToNodeMap().values()) {
                    if (!multiOswNode.getMacToNodeMap().containsKey(oswNode.getMac())) {
                        this.a(oswNode);
                        multiOswNode.getMacToNodeMap().put(oswNode.getMac(), oswNode);
                    }
                    OswNode onlineMem = (OswNode)multiOswNode.getMacToNodeMap().get(oswNode.getMac());
                    onlineMem.setMultiSwitchNum(oswNode.getMultiSwitchNum());
                }
                List edges = Optional.ofNullable(multiOswNode.getVrrpInternalLinkEdges()).orElse(new ArrayList());
                edges.addAll(oldMultiOsw.getVrrpInternalLinkEdges());
                multiOswNode.setVrrpInternalLinkEdges(edges);
                multiOswNode.setAllMemOffline(Boolean.valueOf(false));
                multiOswNode.setMac(dto.getMac());
                disconnectedNodes.remove(dto.getMac());
                if (a.isDebugEnabled()) {
                    a.debug("remove oldMultiOsw:{} for disconnectedNodes", (Object)PIIJacksonUtil.parseToStr((Object)dto));
                }
                dto.setNode((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)multiOswNode);
                disconnectedNodes.put(dto.getMac(), dto);
                if (!a.isDebugEnabled()) break;
                a.debug("update multiOsw:{} with oldMultiOsw:{}, and disconnected node:{}", new Object[]{PIIJacksonUtil.parseToStr((Object)multiOswNode), PIIJacksonUtil.parseToStr((Object)oldMultiOsw), PIIJacksonUtil.parseToStr((Object)disconnectedNodes.get(dto.getMac()))});
                break;
            }
            case "mlag": {
                for (OswNode oswNode : oldMultiOsw.getMacToNodeMap().values()) {
                    if (multiOswNode.getMacToNodeMap().containsKey(oswNode.getMac())) continue;
                    multiOswNode.getMacToNodeMap().put(oswNode.getMac(), oswNode);
                }
                multiOswNode.setPrimaryMac(oldMultiOsw.getPrimaryMac());
                multiOswNode.setSecondaryMac(oldMultiOsw.getSecondaryMac());
                disconnectedNodes.remove(dto.getMac());
                if (a.isDebugEnabled()) {
                    a.debug("remove oldMultiOsw:{} for disconnectedNodes", (Object)PIIJacksonUtil.parseToStr((Object)dto));
                }
                dto.setMac(multiOswNode.getMac());
                dto.setNode((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)multiOswNode);
                disconnectedNodes.put(dto.getMac(), dto);
                if (!a.isDebugEnabled()) break;
                a.debug("update multiOsw:{} with oldMultiOsw:{}, and disconnected node:{}", new Object[]{PIIJacksonUtil.parseToStr((Object)multiOswNode), PIIJacksonUtil.parseToStr((Object)oldMultiOsw), PIIJacksonUtil.parseToStr((Object)disconnectedNodes.get(dto.getMac()))});
                break;
            }
        }
    }

    private void a(OswNode oswNode) {
        oswNode.setRole(null);
        oswNode.setVlansAsMaster(null);
        if (!CollectionUtils.isEmpty((Collection)oswNode.getVrrpGroupList())) {
            oswNode.getVrrpGroupList().forEach(vrrpGroupDTO -> vrrpGroupDTO.setIsMaster(Boolean.valueOf(false)));
        }
    }

    private PersistenceNodeDTO a(MultiOswNode multiOswNode, Map<String, PersistenceNodeDTO> partialMemOfflineMultiOswNodes) {
        Set connMemMacs = multiOswNode.getMacToNodeMap().keySet();
        for (PersistenceNodeDTO dto : partialMemOfflineMultiOswNodes.values()) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node = dto.getNode();
            if (!(node instanceof MultiOswNode)) continue;
            MultiOswNode oldMultiOswNode = (MultiOswNode)node;
            if (!connMemMacs.stream().anyMatch(oldMultiOswNode.getMacToNodeMap().keySet()::contains)) continue;
            return dto;
        }
        return null;
    }

    private void a(String omadacId, String siteId, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> oldTopology, Map<String, PersistenceNodeDTO> disconnectedNodes, Map<String, PersistenceNodeDTO> forgetNodes, MultiOswNode multiOswNode, Set<String> onlineDevices, Set<String> pendingDevices, Map<String, PersistenceNodeDTO> partialMemOfflineMultiOswNodes) {
        int onlineMem = 0;
        int offlineMem = 0;
        int forgetMem = 0;
        for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
            Optional deviceOpt = this.n.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new d(siteId), new G(oswNode.getMac()));
            if (onlineDevices.contains(oswNode.getMac()) || pendingDevices.contains(oswNode.getMac())) {
                if (a.isDebugEnabled()) {
                    a.debug("device {} is not disconnected, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                ++onlineMem;
                continue;
            }
            if (deviceOpt.isPresent()) {
                oswNode.setStatus(Integer.valueOf(DeviceStatusEnum.a.n()));
                oswNode.setName(((o)deviceOpt.get()).f_());
                ++offlineMem;
                continue;
            }
            ++forgetMem;
        }
        if (Objects.equals(offlineMem, 0) && Objects.equals(forgetMem, 0)) {
            return;
        }
        if (Objects.equals(onlineMem, 0) && Objects.equals(offlineMem, 0)) {
            forgetNodes.put(multiOswNode.getMac(), new PersistenceNodeDTO(multiOswNode.getMac(), (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)multiOswNode, oldTopology.inEdges((Object)multiOswNode), oldTopology.outEdges((Object)multiOswNode), false));
            return;
        }
        if (!Objects.equals(offlineMem, 0)) {
            PersistenceNodeDTO persistenceNodeDTO = new PersistenceNodeDTO(multiOswNode.getMac(), (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)multiOswNode, oldTopology.inEdges((Object)multiOswNode), oldTopology.outEdges((Object)multiOswNode), false);
            if (Objects.equals(onlineMem, 0)) {
                multiOswNode.setAllMemOffline(Boolean.valueOf(true));
            } else {
                multiOswNode.setAllMemOffline(Boolean.valueOf(false));
                partialMemOfflineMultiOswNodes.put(multiOswNode.getMac(), persistenceNodeDTO);
            }
            disconnectedNodes.put(multiOswNode.getMac(), persistenceNodeDTO);
        }
    }

    private void a(String siteId, Set<String> vigiMaybeHbmMacs, TopologyDevices topologyDevices, Map<String, Map<String, Port>> uplinkToDownlinkVigiDevMap, Map<String, PersistenceNodeDTO> vigiNodes) {
        Map<String, String> hbmVigiDevices = vigiMaybeHbmMacs.stream().filter(vigiNodes::containsKey).collect(Collectors.toMap(mac -> mac, mac -> ((PersistenceNodeDTO)vigiNodes.get(mac)).getNode().getType()));
        for (String vigiMac : vigiMaybeHbmMacs) {
            OswNode originalUplinkNode;
            PersistenceNodeDTO persistenceNodeDTO = vigiNodes.get(vigiMac);
            if (Objects.isNull(persistenceNodeDTO) || CollectionUtils.isEmpty(persistenceNodeDTO.getInEdges())) {
                if (!a.isInfoEnabled()) continue;
                a.info("siteId:{}, fail to find original info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                continue;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = persistenceNodeDTO.getInEdges().iterator().next();
            if (inEdge instanceof BaseOswEdge) {
                BaseOswEdge baseOswEdge = (BaseOswEdge)inEdge;
                originalUplinkNode = topologyDevices.getOswMap().get(baseOswEdge.getFromNodeMac());
                if (Objects.isNull(originalUplinkNode) || !uplinkToDownlinkVigiDevMap.containsKey(originalUplinkNode.getMac())) {
                    if (!a.isInfoEnabled()) continue;
                    a.info("siteId:{}, fail to find original uplink info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                    continue;
                }
                if (!this.a(siteId, topologyDevices, vigiMac, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode)) continue;
                this.h.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode, hbmVigiDevices, uplinkToDownlinkVigiDevMap);
                continue;
            }
            if (inEdge instanceof BaseOsgEdge) {
                OsgNode osgNode = topologyDevices.getOsg();
                if (Objects.isNull(osgNode) || !uplinkToDownlinkVigiDevMap.containsKey(osgNode.getMac())) {
                    if (!a.isInfoEnabled()) continue;
                    a.info("siteId:{}, fail to find original uplink info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                    continue;
                }
                if (!this.a(siteId, topologyDevices, vigiMac, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)osgNode)) continue;
                this.h.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)osgNode, hbmVigiDevices, uplinkToDownlinkVigiDevMap);
                continue;
            }
            if (inEdge instanceof ApNvrEdge || inEdge instanceof WiredApEdge) {
                originalUplinkNode = topologyDevices.getApMap().get(inEdge.getFromNodeMac());
                if (Objects.isNull(originalUplinkNode) || !uplinkToDownlinkVigiDevMap.containsKey(originalUplinkNode.getMac())) {
                    if (!a.isInfoEnabled()) continue;
                    a.info("siteId:{}, fail to find original uplink info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                    continue;
                }
                if (!this.a(siteId, topologyDevices, vigiMac, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode)) continue;
                this.h.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode, hbmVigiDevices, uplinkToDownlinkVigiDevMap);
                continue;
            }
            if (inEdge instanceof BaseOltEdge) {
                BaseOltEdge baseOltEdge = (BaseOltEdge)inEdge;
                originalUplinkNode = topologyDevices.getOltMap().get(baseOltEdge.getFromNodeMac());
                if (Objects.isNull(originalUplinkNode) || !uplinkToDownlinkVigiDevMap.containsKey(originalUplinkNode.getMac())) {
                    if (!a.isInfoEnabled()) continue;
                    a.info("siteId:{}, fail to find original uplink info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                    continue;
                }
                if (!this.a(siteId, topologyDevices, vigiMac, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode)) continue;
                this.h.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode, hbmVigiDevices, uplinkToDownlinkVigiDevMap);
                continue;
            }
            if (inEdge instanceof BaseNvrEdge) {
                BaseNvrEdge baseNvrEdge = (BaseNvrEdge)inEdge;
                if (!CollectionUtils.isEmpty(topologyDevices.getNvrMap())) {
                    originalUplinkNode = topologyDevices.getNvrMap().get(baseNvrEdge.getFromNodeMac());
                    if (Objects.isNull(originalUplinkNode) || !uplinkToDownlinkVigiDevMap.containsKey(originalUplinkNode.getMac())) {
                        if (!a.isInfoEnabled()) continue;
                        a.info("siteId:{}, fail to find original uplink info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                        continue;
                    }
                    this.h.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode, hbmVigiDevices, uplinkToDownlinkVigiDevMap);
                    continue;
                }
            }
            if (inEdge instanceof MultiOswEdge) {
                MultiOswEdge multiOswEdge = (MultiOswEdge)inEdge;
                List edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getToNodeMac(), vigiMac)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(edges)) {
                    if (!a.isInfoEnabled()) continue;
                    a.info("siteId:{}, fail to find any edge in multiOswEdge for hbm vigi:{}, multiOswEdge:{}", new Object[]{siteId, com.tplink.smb.omada.common.util.e.a.d((String)vigiMac), PIIJacksonUtil.parseToStr((Object)multiOswEdge)});
                    continue;
                }
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : edges) {
                    OswNode originalUplinkNode2 = topologyDevices.getOswMap().get(edge2.getFromNodeMac());
                    if (Objects.isNull(originalUplinkNode2) || !uplinkToDownlinkVigiDevMap.containsKey(originalUplinkNode2.getMac())) {
                        if (!a.isInfoEnabled()) continue;
                        a.info("siteId:{}, fail to find original uplink info for hbm vigi:{}", (Object)siteId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)vigiMac));
                        continue;
                    }
                    this.h.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)originalUplinkNode2, hbmVigiDevices, uplinkToDownlinkVigiDevMap);
                }
                continue;
            }
            if (!a.isInfoEnabled()) continue;
            a.info("siteId:{}, unknown inEdge for hbmVigi:{}, inEdge:{}", new Object[]{siteId, com.tplink.smb.omada.common.util.e.a.d((String)vigiMac), PIIJacksonUtil.parseToStr((Object)inEdge)});
        }
    }

    private boolean a(String siteId, TopologyDevices topologyDevices, String vigiMac, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a originalUplinkNode) {
        NvrNode nvrNode;
        if (((Map)Optional.ofNullable(topologyDevices.getNvrMap()).orElse(new HashMap())).containsKey(vigiMac) && !CollectionUtils.isEmpty((Collection)(nvrNode = topologyDevices.getNvrMap().get(vigiMac)).getNeighbors()) && !nvrNode.getNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), originalUplinkNode.getMac()))) {
            if (a.isInfoEnabled()) {
                a.info("siteId:{}, nvr:{} lldp is not empty and has no originalUplink:{}, maybe changed to another topo, won't add lldp to its original uplink", new Object[]{siteId, com.tplink.smb.omada.common.util.e.a.d((String)nvrNode.getMac()), com.tplink.smb.omada.common.util.e.a.d((String)originalUplinkNode.getMac())});
            }
            return false;
        }
        return true;
    }

    private com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a(Map<String, PersistenceNodeDTO> disconnectedNodes, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a offlineOsgNode, TopologyDevices topologyDevices, Map<String, String> hbmDevices) {
        if (Objects.isNull(offlineOsgNode) || !disconnectedNodes.containsKey(offlineOsgNode.getMac())) {
            return null;
        }
        PersistenceNodeDTO persistenceNodeDTO = disconnectedNodes.get(offlineOsgNode.getMac());
        if (CollectionUtils.isEmpty(persistenceNodeDTO.getOutEdges())) {
            return null;
        }
        HashMap<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> typeToDownLinkNodes = new HashMap<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : persistenceNodeDTO.getOutEdges()) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a osgDownLinkNode = com.tplink.smb.omada.manager.topology.domain.discovery.a.a(edge.getToNodeMac(), topologyDevices);
            if (Objects.isNull(osgDownLinkNode)) continue;
            typeToDownLinkNodes.computeIfAbsent(osgDownLinkNode.getType(), k2 -> new ArrayList()).add(osgDownLinkNode);
        }
        List<String> typeList = Arrays.asList("vrrp", "mlag", "switch", "olt", "other", "ap");
        for (String type : typeList) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a root = this.a(typeToDownLinkNodes, type, hbmDevices);
            if (Objects.isNull(root)) continue;
            return root;
        }
        return null;
    }

    private com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a(Map<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> typeToDownLinkNodes, String type, Map<String, String> hbmDevices) {
        List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> nodes = typeToDownLinkNodes.get(type);
        if (!CollectionUtils.isEmpty(nodes)) {
            if (nodes.size() == 1) {
                return nodes.get(0);
            }
            List onLineNodes = nodes.stream().filter(node -> {
                if (!(node instanceof MultiOswNode)) {
                    return !hbmDevices.containsKey(node.getMac());
                }
                MultiOswNode multiOswNode = (MultiOswNode)node;
                return !hbmDevices.keySet().containsAll(multiOswNode.getMacToNodeMap().keySet());
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(onLineNodes)) {
                return nodes.get(0);
            }
            return (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)onLineNodes.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void a(String siteId, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> oldTopology, Map<String, String> devices, Map<String, String> hbmDevices, Map<String, Map<String, Port>> uplinkToDownlinkHbmDevMap, Map<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>> hbmVrrpMemInternalLinks) {
        if (node instanceof MultiOswNode) {
            multiOswNode = (MultiOswNode)node;
            for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
                if (!hbmDevices.containsKey(oswNode.getMac())) continue;
                if (Objects.equals(multiOswNode.getType(), "vrrp")) {
                    hbmVrrpMemInternalLinks.put(oswNode.getMac(), multiOswNode.getVrrpInternalLinkEdges());
                }
                if (CollectionUtils.isEmpty((Collection)(predecessors = oldTopology.predecessors((Object)node)))) continue;
                pre = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
                abstractEdges = oldTopology.edgesConnecting((Object)pre, (Object)node);
                if (CollectionUtils.isEmpty((Collection)abstractEdges)) {
                    if (TopologyTask.a.isInfoEnabled()) {
                        TopologyTask.a.info("siteId:{}, no edge between pre and node:{}, {}", new Object[]{siteId, com.tplink.smb.omada.common.util.e.a.d((String)pre.getMac()), com.tplink.smb.omada.common.util.e.a.d((String)node.getMac())});
                    }
                    return;
                }
                optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)abstractEdges.iterator().next();
                if (optEdge instanceof MultiOswEdge) {
                    multiOswEdge = (MultiOswEdge)optEdge;
                    edges = ((List)Optional.ofNullable(multiOswEdge.getEdges()).orElse(new ArrayList<E>())).stream().filter((Predicate<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OswNode com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a ), (Lcom/tplink/smb/omada/manager/configuration/api/internal/topology/dto/edge/a;)Z)((OswNode)oswNode)).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(edges)) continue;
                    if (pre instanceof MultiOswNode) {
                        preMultiOswNode = (MultiOswNode)pre;
                        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e : edges) {
                            preOswNode = (OswNode)preMultiOswNode.getMacToNodeMap().get(e.getFromNodeMac());
                            if (Objects.isNull(preOswNode)) continue;
                            this.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)preOswNode, e, uplinkToDownlinkHbmDevMap, true);
                        }
                        continue;
                    }
                    for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e : edges) {
                        this.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oswNode, pre, e, uplinkToDownlinkHbmDevMap, true);
                    }
                    continue;
                }
                if (!TopologyTask.a.isInfoEnabled()) continue;
                TopologyTask.a.info("siteId:{}, unKnown edge between pre and node, edge:{}, pre:{}, node:{}", new Object[]{siteId, PIIJacksonUtil.parseToStr((Object)optEdge), com.tplink.smb.omada.common.util.e.a.d((String)pre.getMac()), com.tplink.smb.omada.common.util.e.a.d((String)node.getMac())});
            }
            return;
        }
        if (!com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.G.contains(node.getType()) && !hbmDevices.containsKey(node.getMac())) {
            return;
        }
        predecessors = oldTopology.predecessors((Object)node);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            successors = oldTopology.successors((Object)node);
            if (CollectionUtils.isEmpty((Collection)successors)) {
                return;
            }
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a suc : successors) {
                outEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oldTopology.edgesConnecting((Object)node, (Object)suc).iterator().next();
                if (suc instanceof MultiOswNode) {
                    sucMultiOswNode = (MultiOswNode)suc;
                    if (outEdge instanceof MultiOswEdge) {
                        multiOswEdge = (MultiOswEdge)outEdge;
                        edges = ((List)Optional.ofNullable(multiOswEdge.getEdges()).orElse(new ArrayList<E>())).stream().filter((Predicate<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, b(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a ), (Lcom/tplink/smb/omada/manager/configuration/api/internal/topology/dto/edge/a;)Z)((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node)).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(edges)) {
                            return;
                        }
                        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e : edges) {
                            sucOswNode = (OswNode)sucMultiOswNode.getMacToNodeMap().get(e.getToNodeMac());
                            if (Objects.isNull(sucOswNode) || !devices.containsKey(sucOswNode.getMac())) continue;
                            this.a(node, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)sucOswNode, e, uplinkToDownlinkHbmDevMap, false);
                        }
                        continue;
                    }
                }
                if (!devices.containsKey(suc.getMac())) continue;
                this.a(node, suc, outEdge, uplinkToDownlinkHbmDevMap, false);
            }
            return;
        }
        pre = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
        abstractEdges = oldTopology.edgesConnecting((Object)pre, (Object)node);
        if (CollectionUtils.isEmpty((Collection)abstractEdges)) {
            if (TopologyTask.a.isInfoEnabled()) {
                TopologyTask.a.info("siteId:{}, no edge between pre and node:{}, {}", new Object[]{siteId, com.tplink.smb.omada.common.util.e.a.d((String)pre.getMac()), com.tplink.smb.omada.common.util.e.a.d((String)node.getMac())});
            }
            return;
        }
        optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)abstractEdges.iterator().next();
        if (!(pre instanceof MultiOswNode)) ** GOTO lbl-1000
        preMultiOswNode = (MultiOswNode)pre;
        if (optEdge instanceof MultiOswEdge) {
            multiOswEdge = (MultiOswEdge)optEdge;
            edges = ((List)Optional.ofNullable(multiOswEdge.getEdges()).orElse(new ArrayList<E>())).stream().filter((Predicate<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a ), (Lcom/tplink/smb/omada/manager/configuration/api/internal/topology/dto/edge/a;)Z)((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)node)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(edges)) {
                return;
            }
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e : edges) {
                preOswNode = (OswNode)preMultiOswNode.getMacToNodeMap().get(e.getFromNodeMac());
                if (Objects.isNull(preOswNode)) continue;
                this.a(node, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)preOswNode, e, uplinkToDownlinkHbmDevMap, true);
            }
        } else lbl-1000:
        // 2 sources

        {
            this.a(node, pre, optEdge, uplinkToDownlinkHbmDevMap, true);
        }
    }

    private void a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a neighbor, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge, Map<String, Map<String, Port>> uplinkToDownlinkHbmDevMap, boolean upToDown) {
        if (edge instanceof BaseOswEdge) {
            BaseOswEdge baseOswEdge = (BaseOswEdge)edge;
            if (upToDown) {
                uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), baseOswEdge.getUpLink());
                return;
            }
            if (edge instanceof OswOswEdge) {
                OswOswEdge oswOswEdge = (OswOswEdge)edge;
                uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), oswOswEdge.getDownLink());
                return;
            }
        }
        if (edge instanceof BaseOsgEdge) {
            BaseOsgEdge baseOsgEdge = (BaseOsgEdge)edge;
            if (upToDown) {
                uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), baseOsgEdge.getUpLink());
                return;
            }
            if (edge instanceof OsgOswEdge) {
                OsgOswEdge osgOswEdge = (OsgOswEdge)edge;
                uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), osgOswEdge.getDownLink());
                return;
            }
        }
        if (edge instanceof BaseOltEdge) {
            BaseOltEdge baseOltEdge = (BaseOltEdge)edge;
            uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), baseOltEdge.getUpLink());
            return;
        }
        if (edge instanceof WiredApEdge || edge instanceof ApNvrEdge) {
            uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), null);
            return;
        }
        if (edge instanceof BaseNvrEdge) {
            BaseNvrEdge baseNvrEdge = (BaseNvrEdge)edge;
            uplinkToDownlinkHbmDevMap.computeIfAbsent(neighbor.getMac(), k2 -> new HashMap()).put(node.getMac(), baseNvrEdge.getUpLink());
            return;
        }
        if (a.isInfoEnabled()) {
            a.info("unknown edge between neighbor and node, edge:{}", (Object)PIIJacksonUtil.parseToStr((Object)edge));
        }
    }

    private void a(String siteId, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, List<StpLoopInfoDTO> stpLoopInfos) {
        if (a.isDebugEnabled()) {
            a.debug("siteId={}, topology nodes {}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr((Object)topology.nodes()));
            a.debug("siteId={}, topology edges {}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr((Object)topology.edges()));
            a.debug("siteId={}, topology stpLoopInfos {}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr(stpLoopInfos));
        }
    }

    private void a(String siteId, TopologyDevices topologyDevices, int deviceNum, Map<String, PersistenceNodeDTO> disconnectedNodes, int disconnNodesNum) {
        try {
            Map<String, OtherNode> otherMap;
            Map<String, OltNode> oltMap;
            Map<String, ApNode> apMap;
            Map<String, OswNode> oswMap;
            if (deviceNum < 100 && a.isDebugEnabled()) {
                a.debug("siteId={}, topologyDevices {}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr((Object)topologyDevices));
                a.debug("siteId={}, disconnectedNodes {}", (Object)siteId, (Object)PIIJacksonUtil.parseToStr(disconnectedNodes));
                return;
            }
            if (Objects.nonNull(topologyDevices.getOsg()) && a.isDebugEnabled()) {
                a.debug("siteId={}, osgNode {}", (Object)siteId, (Object)x.a((Object)topologyDevices.getOsg()));
            }
            if (!CollectionUtils.isEmpty(oswMap = topologyDevices.getOswMap()) && a.isDebugEnabled()) {
                oswMap.values().forEach(oswNode -> a.debug("siteId={}, oswNode <{}>", (Object)siteId, (Object)x.a((Object)oswNode)));
            }
            if (!CollectionUtils.isEmpty(apMap = topologyDevices.getApMap()) && a.isDebugEnabled()) {
                apMap.values().forEach(apNode -> a.debug("siteId={}, apNode <{}>", (Object)siteId, (Object)x.a((Object)apNode)));
            }
            if (!CollectionUtils.isEmpty(oltMap = topologyDevices.getOltMap()) && a.isDebugEnabled()) {
                oltMap.values().forEach(oltNode -> a.debug("siteId={}, oltNode <{}>", (Object)siteId, (Object)x.a((Object)oltNode)));
            }
            if (!CollectionUtils.isEmpty(otherMap = topologyDevices.getOtherMap()) && a.isDebugEnabled()) {
                otherMap.values().forEach(otherNode -> a.debug("siteId={}, otherNode <{}>", (Object)siteId, (Object)x.a((Object)otherNode)));
            }
            if (Objects.nonNull(topologyDevices.getOmadacNode()) && a.isDebugEnabled()) {
                a.debug("siteId={}, omadacNode {}", (Object)siteId, (Object)x.a((Object)topologyDevices.getOmadacNode()));
            }
            if (Objects.nonNull(topologyDevices.getRootNode()) && a.isDebugEnabled()) {
                a.debug("siteId={}, rootNode {}", (Object)siteId, (Object)x.a((Object)topologyDevices.getRootNode()));
            }
            if (disconnNodesNum > 0 && a.isDebugEnabled()) {
                disconnectedNodes.values().forEach(disconnectedNode -> a.debug("siteId={}, disconnectedNode {}", (Object)siteId, (Object)x.a((Object)disconnectedNode)));
            }
        }
        catch (Exception e2) {
            a.warn("siteId={} failed to print topology node", (Object)siteId, (Object)e2);
        }
    }

    private void a(String siteId, List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.d> deviceList, Map<String, String> devices, Map<String, Boolean> gatewayIpptModes, Set<String> slaveMacs, Map<String, String> hbmDevices, Map<String, Integer> mlagMacToRoleMap, Map<String, List<n>> vrrpMacToInfoMap) {
        for (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d device : deviceList) {
            a.debug("siteId={}, topology query device: {}", (Object)siteId, (Object)device.X());
            if (!device.at().e()) {
                a.debug("siteId={} topology: lost device={}", (Object)siteId, (Object)device.X());
                continue;
            }
            if (Objects.equals(device.at(), DeviceStatusEnum.s)) {
                hbmDevices.put(device.X(), device.an().b());
            }
            if (DeviceTypeEnum.c.c(device.an().b())) {
                m oswStackImageInfo;
                c oswImage = (c)device;
                if (!Objects.isNull(oswImage.bc().I())) {
                    a mlagImageStatus = oswImage.bc().I();
                    mlagMacToRoleMap.put(device.X(), mlagImageStatus.b());
                }
                if (!CollectionUtils.isEmpty((Collection)oswImage.bG())) {
                    vrrpMacToInfoMap.put(device.X(), oswImage.bG());
                }
                if (Objects.nonNull(oswStackImageInfo = oswImage.bF()) && Objects.nonNull(oswStackImageInfo.c()) && !Boolean.TRUE.equals(oswStackImageInfo.g())) {
                    a.debug("siteId={} topology: exclude slaver osw={}", (Object)siteId, (Object)device.X());
                    slaveMacs.add(device.X());
                    continue;
                }
            }
            if (DeviceTypeEnum.b.c(device.an().b())) {
                e osg = (e)device;
                gatewayIpptModes.put(device.X(), osg.aZ().Z());
            }
            devices.put(device.X(), device.an().b());
        }
        if (a.isDebugEnabled()) {
            a.debug("siteId:{}, heartBeatMissed devices:{}, mlag devices:{}, vrrp devices:{}", new Object[]{siteId, PIIJacksonUtil.parseToStr(hbmDevices), PIIJacksonUtil.parseToStr(mlagMacToRoleMap), PIIJacksonUtil.parseToStr(vrrpMacToInfoMap)});
        }
    }

    private void a(String omadacId, String siteId, TopologyDevices topologyDevices, OduNode odu) {
        Set oduClients = odu.getArps();
        f.a preResult = this.e.f(omadacId, siteId, odu.getMac());
        Set<String> sendClients = new HashSet<String>();
        if (topologyDevices.onlyOdu()) {
            if (preResult == null) {
                if (a.isDebugEnabled()) {
                    a.debug("This is first time to discovery odu <{}>, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)odu.getMac()), omadacId, siteId});
                }
            } else if (Objects.equals(oduClients, preResult.a())) {
                return;
            }
            this.e.a(omadacId, siteId, odu.getMac(), new f.a(oduClients));
            sendClients = oduClients;
        } else {
            if (!Objects.isNull(preResult) && CollectionUtils.isEmpty(preResult.a())) {
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("previously sent client to odu <{}>, need to clear, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)odu.getMac()), omadacId, siteId});
            }
            this.e.a(omadacId, siteId, odu.getMac(), new f.a(sendClients));
        }
        if (a.isDebugEnabled()) {
            a.debug("send clients to odu:{}, siteId:{}", (Object)PIIJacksonUtil.parseToStr(sendClients), (Object)siteId);
        }
        com.tplink.smb.omada.manager.device.api.internal.c.c.a.c request = new com.tplink.smb.omada.manager.device.api.internal.c.c.a.c();
        request.b(odu.getMac());
        request.c(DeviceTypeEnum.b.b());
        request.a(omadacId);
        HashMap<String, OsgClientConfig> setMap = new HashMap<String, OsgClientConfig>();
        OsgClientConfig config = com.tplink.smb.omada.manager.topology.dto.a.a.a(sendClients);
        setMap.put(OsgSetKeyEnum.CLIENT.key(), config);
        request.a(setMap);
        this.i.b(request);
    }

    private void a(String omadacId, String siteId, OsgNode osg, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Map<String, String> devices, Map<String, Set<String>> apClientsMap) {
        f.c preResult;
        Set<String> osgClients = Collections.emptySet();
        if (topology != null) {
            osgClients = this.b(omadacId, siteId, osg, topology, devices, apClientsMap);
        }
        if ((preResult = this.e.e(omadacId, siteId, osg.getMac())) == null) {
            a.debug("This is first time to discovery osg <{}>, omadacId={}, siteId={}", new Object[]{osg.getMac(), omadacId, siteId});
        } else if (Objects.equals(osgClients, preResult.a())) {
            return;
        }
        this.e.a(omadacId, siteId, osg.getMac(), new f.c(osgClients));
        if (a.isDebugEnabled()) {
            a.debug("omadacId:{}, siteId:{}, send clients:{} to osg:{}", new Object[]{omadacId, siteId, PIIJacksonUtil.parseToStr(osgClients), com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac())});
        }
        com.tplink.smb.omada.manager.device.api.internal.c.c.a.c request = new com.tplink.smb.omada.manager.device.api.internal.c.c.a.c();
        request.b(osg.getMac());
        request.c(DeviceTypeEnum.b.b());
        request.a(omadacId);
        HashMap<String, OsgClientConfig> setMap = new HashMap<String, OsgClientConfig>();
        OsgClientConfig config = com.tplink.smb.omada.manager.topology.dto.a.a.a(osgClients);
        setMap.put(OsgSetKeyEnum.CLIENT.key(), config);
        request.a(setMap);
        this.i.b(request);
    }

    @Nonnull
    private Set<String> b(String omadacId, String siteId, @Nonnull OsgNode osgNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Map<String, String> devices, Map<String, Set<String>> apClientsMap) {
        if (CollectionUtils.isEmpty((Collection)osgNode.getArps())) {
            return Collections.emptySet();
        }
        HashSet<String> clients = new HashSet<String>(osgNode.getArps());
        Set successors = topology.successors((Object)osgNode);
        if (!CollectionUtils.isEmpty((Collection)successors)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
                if (com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.D.contains(successor.getType())) {
                    if (successor instanceof MultiOswNode) {
                        MultiOswNode multiOswNode = (MultiOswNode)successor;
                        clients.removeAll(multiOswNode.getMacToNodeMap().keySet());
                    } else {
                        clients.remove(successor.getMac());
                    }
                }
                this.a(omadacId, siteId, successor, topology, clients, new HashSet<String>(), apClientsMap);
            }
        } else {
            a.debug("no successors after osg <{}>, omadacId={}, siteId={}", new Object[]{osgNode.getMac(), omadacId, siteId});
        }
        Set wirelessClient = new HashSet(0);
        Optional optional = this.l.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(osgNode.getMac()));
        if (optional.isPresent() && Boolean.TRUE.equals(((e)optional.get()).ao())) {
            wirelessClient = this.j.d(omadacId, siteId, osgNode.getMac());
        }
        Iterator iterator = clients.iterator();
        while (iterator.hasNext()) {
            String clientMac = (String)iterator.next();
            if (devices.containsKey(clientMac) && Objects.nonNull(devices.get(clientMac)) && u.contains(devices.get(clientMac))) {
                a.debug("exclude omada device  client <{}> from osg clients, omadacId={}, siteId={}", new Object[]{clientMac, omadacId, siteId});
                iterator.remove();
            }
            if (!wirelessClient.contains(clientMac)) continue;
            a.debug("exclude wireless client <{}> from osg clients, omadacId={}, siteId={}", new Object[]{clientMac, omadacId, siteId});
            iterator.remove();
        }
        return clients;
    }

    private void a(String omadacId, String siteId, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<String> clients, Set<String> filterMacs, Map<String, Set<String>> apClientsMap) {
        if (node instanceof com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b) {
            return;
        }
        if (filterMacs.contains(node.getMac())) {
            return;
        }
        if (node instanceof OswNode) {
            this.b(omadacId, siteId, (OswNode)node, clients);
        } else if (node instanceof ApNode) {
            this.a(omadacId, siteId, (ApNode)node, clients, apClientsMap);
        } else if (node instanceof MultiOswNode) {
            MultiOswNode multiOswNode = (MultiOswNode)node;
            this.a(omadacId, siteId, multiOswNode, clients);
        }
        filterMacs.add(node.getMac());
        Set successors = topology.successors((Object)node);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
            if (!Objects.equals("other", successor.getType()) && !com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.G.contains(successor.getType())) {
                clients.remove(successor.getMac());
            }
            this.a(omadacId, siteId, successor, topology, clients, filterMacs, apClientsMap);
        }
    }

    private void a(String omadacId, String siteId, @Nonnull MultiOswNode multiOswNode, Set<String> clients) {
        for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
            this.a(omadacId, siteId, oswNode, clients);
        }
    }

    private void a(String omadacId, String siteId, @Nonnull OswNode node, Set<String> clients) {
        if (CollectionUtils.isEmpty((Collection)node.getPorts())) {
            return;
        }
        ArrayList allPorts = new ArrayList(node.getPorts());
        allPorts.addAll(Optional.ofNullable(node.getDadLinkPorts()).orElse(new ArrayList()));
        allPorts.addAll(Optional.ofNullable(node.getPeerLinkPorts()).orElse(new ArrayList()));
        allPorts.addAll(Optional.ofNullable(node.getInternalLinkPorts()).orElse(new ArrayList()));
        if (CollectionUtils.isEmpty(allPorts)) {
            if (a.isInfoEnabled()) {
                a.info("Failed to find ports for multi mem <{}>, omadacId={}, siteId={}", new Object[]{node.getMac(), omadacId, siteId});
            }
            return;
        }
        for (Port port : allPorts) {
            if (port.isUpper() || CollectionUtils.isEmpty((Collection)port.getFdbMacs())) continue;
            clients.removeAll(port.getFdbMacs());
        }
    }

    private void b(String omadacId, String siteId, @Nonnull OswNode node, Set<String> clients) {
        List ports = node.getPorts();
        if (CollectionUtils.isEmpty((Collection)ports)) {
            if (a.isInfoEnabled()) {
                a.info("Failed to find ports for <{}>, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)node.getMac()), omadacId, siteId});
            }
            return;
        }
        for (Port port : ports) {
            if (port.isUpper() || CollectionUtils.isEmpty((Collection)port.getFdbMacs())) continue;
            clients.removeAll(port.getFdbMacs());
        }
    }

    private void a(String omadacId, String siteId, @Nonnull ApNode apNode, Set<String> clients, Map<String, Set<String>> apClientsMap) {
        Set apClients = apClientsMap == null ? this.j.c(omadacId, siteId, apNode.getMac()) : apClientsMap.get(apNode.getMac());
        if (a.isDebugEnabled()) {
            a.debug("found clients from ap <{}>, omadacId={}, siteId={}, clients: {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), omadacId, siteId, PIIJacksonUtil.parseToStr((Object)apClients)});
        }
        if (CollectionUtils.isEmpty((Collection)apClients)) {
            return;
        }
        clients.removeAll(apClients);
    }

    private void a(String omadacId, String siteId, TopologyDevices topologyDevices, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Map<String, Set<String>> apClientsMap, List<StpLoopInfoDTO> stpLoopInfos) {
        if (CollectionUtils.isEmpty(topologyDevices.getOswMap())) {
            return;
        }
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        OsgNode osg = topologyDevices.getOsg();
        Map<String, MultiOswNode> mlagOswMap = topologyDevices.getMlagOswMap();
        Map<String, MultiOswNode> vrrpOswMap = topologyDevices.getVrrpOswMap();
        HashSet<String> includeMacs = new HashSet<String>();
        HashSet<String> excludeMacs = new HashSet<String>();
        Map<String, List<Port>> loopCascadePortsMap = this.a(omadacId, siteId, stpLoopInfos);
        for (OswNode oswNode : oswMap.values()) {
            if (mlagOswMap.containsKey(oswNode.getMac()) || vrrpOswMap.containsKey(oswNode.getMac())) {
                this.a(omadacId, siteId, topologyDevices, topology, oswNode, includeMacs, excludeMacs, apClientsMap);
                continue;
            }
            oswNode.setUpperPort(com.tplink.smb.omada.manager.topology.b.b.a(oswNode, null, topology));
            if (!Objects.isNull(oswNode.getUpperPort())) {
                ArrayList<Port> noClientPorts = new ArrayList<Port>();
                noClientPorts.add(oswNode.getUpperPort());
                oswNode.setNoClientPorts(noClientPorts);
            }
            int upPort = oswNode.getUpperPort() == null ? -1 : oswNode.getUpperPort().getPortId();
            String upStandardPort = oswNode.getUpperPort() == null ? null : oswNode.getUpperPort().getStandardOswPort();
            HashSet<String> cascadeStandardPorts = new HashSet<String>();
            HashSet<String> sendCascadeStandardPorts = new HashSet<String>();
            Set<Integer> cascadePorts = com.tplink.smb.omada.manager.topology.b.b.a(oswNode, topology, cascadeStandardPorts, sendCascadeStandardPorts, loopCascadePortsMap);
            HashSet<String> downCascadeStandardPorts = new HashSet<String>(cascadeStandardPorts);
            if (Objects.nonNull(oswNode.getUpperPort())) {
                downCascadeStandardPorts.remove(oswNode.getUpperPort().getStandardOswPort());
            }
            if (!CollectionUtils.isEmpty((Collection)oswNode.getNoClientPorts())) {
                oswNode.getNoClientPorts().forEach(port -> downCascadeStandardPorts.remove(port.getStandardOswPort()));
            }
            Map<String, Port> mac2PortMap = this.a(omadacId, siteId, oswNode, topology, downCascadeStandardPorts, apClientsMap);
            Set<OswPortClient> oswClients = this.a(mac2PortMap);
            if (a.isDebugEnabled()) {
                a.debug("omadacId:{}, siteId:{}, osw:{}, upperPort:{}, cascadePorts:{}, sendCascadeStandardPorts:{}, oswClients:{}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), PIIJacksonUtil.parseToStr((Object)oswNode.getUpperPort()), PIIJacksonUtil.parseToStr(cascadePorts), PIIJacksonUtil.parseToStr(sendCascadeStandardPorts), PIIJacksonUtil.parseToStr(oswClients)});
            }
            if (!this.a(omadacId, siteId, oswNode.getMac(), upStandardPort, sendCascadeStandardPorts, new HashSet<OswPortClient>(oswClients), includeMacs, excludeMacs)) {
                if (!a.isDebugEnabled()) continue;
                a.debug("topology of osw <{}> not changed, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), omadacId, siteId});
                continue;
            }
            if (a.isDebugEnabled()) {
                a.debug("topology of osw <{}> changed, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), omadacId, siteId});
            }
            com.tplink.smb.omada.manager.device.api.internal.c.c.a.c request = new com.tplink.smb.omada.manager.device.api.internal.c.c.a.c();
            request.b(oswNode.getMac());
            request.c(DeviceTypeEnum.c.b());
            request.a(omadacId);
            HashMap<String, TopologyConfig> setMap = new HashMap<String, TopologyConfig>();
            TopologyConfig topologyConfig = com.tplink.smb.omada.manager.topology.dto.a.b.a(upPort, upStandardPort, cascadePorts, sendCascadeStandardPorts, new ArrayList<OswPortClient>(oswClients));
            if (a.isDebugEnabled()) {
                a.debug("omadacId={}, siteId={}, send osw:{} client config={}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), PIIJacksonUtil.parseToStr((Object)topologyConfig)});
            }
            setMap.put(OswSetKeyEnum.TOPOLOGY.key(), topologyConfig);
            request.a(setMap);
            this.i.b(request);
        }
        if (!(CollectionUtils.isEmpty(includeMacs) && CollectionUtils.isEmpty(excludeMacs) || osg == null)) {
            this.k.a(omadacId, siteId, osg.getMac(), includeMacs, excludeMacs);
        }
    }

    private void a(String omadacId, String siteId, TopologyDevices topologyDevices, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode, Set<String> includeMacs, Set<String> excludeMacs, Map<String, Set<String>> apClientsMap) {
        int upPort;
        MultiOswNode multiOswNode = null;
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            multiOswNode = topologyDevices.getMlagOswMap().get(oswNode.getMac());
        } else if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            multiOswNode = topologyDevices.getVrrpOswMap().get(oswNode.getMac());
        }
        if (Objects.isNull(multiOswNode)) {
            return;
        }
        oswNode.setUpperPort(com.tplink.smb.omada.manager.topology.b.b.a(multiOswNode, oswNode, topology));
        int n2 = upPort = oswNode.getUpperPort() == null ? -1 : oswNode.getUpperPort().getPortId();
        if (!Objects.isNull(oswNode.getUpperPort())) {
            ArrayList<Port> noClientPorts = new ArrayList<Port>();
            noClientPorts.add(oswNode.getUpperPort());
            oswNode.setNoClientPorts(noClientPorts);
        }
        String upStandardPort = oswNode.getUpperPort() == null ? null : oswNode.getUpperPort().getStandardOswPort();
        HashSet<String> cascadeStandardPorts = new HashSet<String>();
        HashSet<String> sendCascadeStandardPorts = new HashSet<String>();
        Set<Integer> cascadePorts = com.tplink.smb.omada.manager.topology.b.b.a(multiOswNode, oswNode, topology, cascadeStandardPorts, sendCascadeStandardPorts);
        HashSet<String> downCascadeStandardPorts = new HashSet<String>(cascadeStandardPorts);
        if (Objects.nonNull(oswNode.getUpperPort())) {
            downCascadeStandardPorts.remove(oswNode.getUpperPort().getStandardOswPort());
        }
        if (!CollectionUtils.isEmpty((Collection)oswNode.getNoClientPorts())) {
            oswNode.getNoClientPorts().forEach(port -> downCascadeStandardPorts.remove(port.getStandardOswPort()));
        }
        Map<String, Port> mac2PortMap = this.a(omadacId, siteId, multiOswNode, oswNode, topology, downCascadeStandardPorts, apClientsMap);
        Set<OswPortClient> oswClients = this.a(mac2PortMap);
        if (a.isDebugEnabled()) {
            a.debug("omadacId:{}, siteId:{}, osw:{}, upperPort:{}, cascadePorts:{}, sendCascadeStandardPorts:{}, oswClients:{}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), PIIJacksonUtil.parseToStr((Object)oswNode.getUpperPort()), PIIJacksonUtil.parseToStr(cascadePorts), PIIJacksonUtil.parseToStr(sendCascadeStandardPorts), PIIJacksonUtil.parseToStr(oswClients)});
        }
        if (!this.a(omadacId, siteId, oswNode.getMac(), upStandardPort, sendCascadeStandardPorts, new HashSet<OswPortClient>(oswClients), includeMacs, excludeMacs)) {
            if (a.isDebugEnabled()) {
                a.debug("topology of multiOswmem osw <{}> not changed, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), omadacId, siteId});
            }
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("topology of multiOswmem osw <{}> changed, omadacId={}, siteId={}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), omadacId, siteId});
        }
        com.tplink.smb.omada.manager.device.api.internal.c.c.a.c request = new com.tplink.smb.omada.manager.device.api.internal.c.c.a.c();
        request.b(oswNode.getMac());
        request.c(DeviceTypeEnum.c.b());
        request.a(omadacId);
        HashMap<String, TopologyConfig> setMap = new HashMap<String, TopologyConfig>();
        TopologyConfig topologyConfig = com.tplink.smb.omada.manager.topology.dto.a.b.a(upPort, upStandardPort, cascadePorts, sendCascadeStandardPorts, new ArrayList<OswPortClient>(oswClients));
        if (a.isDebugEnabled()) {
            a.debug("omadacId={}, siteId={}, send osw:{} client config={}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), PIIJacksonUtil.parseToStr((Object)topologyConfig)});
        }
        setMap.put(OswSetKeyEnum.TOPOLOGY.key(), topologyConfig);
        request.a(setMap);
        this.i.b(request);
    }

    private Map<String, Port> a(String omadacId, String siteId, MultiOswNode multiOswNode, OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull Set<String> downCascadeStandardPorts, Map<String, Set<String>> apClientsMap) {
        HashMap<String, Port> clientsMacs = new HashMap<String, Port>(16);
        downCascadeStandardPorts.forEach(standardPort -> {
            for (Port oswPort : oswNode.getPorts()) {
                if (!Objects.equals(oswPort.getStandardOswPort(), standardPort) || CollectionUtils.isEmpty((Collection)oswPort.getFdbMacs())) continue;
                oswPort.getFdbMacs().forEach(mac -> clientsMacs.put((String)mac, oswPort));
                break;
            }
        });
        if (CollectionUtils.isEmpty(clientsMacs)) {
            return Collections.emptyMap();
        }
        Set successors = topology.successors((Object)multiOswNode);
        if (!CollectionUtils.isEmpty((Collection)successors)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
                if (com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.D.contains(successor.getType())) {
                    if (Objects.equals(successor.getType(), "mlag") || Objects.equals(successor.getType(), "vrrp")) {
                        MultiOswNode multiOswSuccessor = (MultiOswNode)successor;
                        clientsMacs.keySet().removeAll(multiOswSuccessor.getMacToNodeMap().keySet());
                    } else {
                        clientsMacs.keySet().remove(successor.getMac());
                    }
                }
                this.a(omadacId, siteId, successor, topology, clientsMacs.keySet(), new HashSet<String>(), apClientsMap);
            }
        } else if (a.isDebugEnabled()) {
            a.debug("no successors after multiOsw <{}>, omadacId={}, siteId={}", new Object[]{PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), omadacId, siteId});
        }
        return clientsMacs;
    }

    private Map<String, List<Port>> a(String omadacId, String siteId, List<StpLoopInfoDTO> stpLoopInfos) {
        if (CollectionUtils.isEmpty(stpLoopInfos)) {
            return new HashMap<String, List<Port>>();
        }
        HashMap<String, List<Port>> result = new HashMap<String, List<Port>>();
        for (StpLoopInfoDTO stpLoopInfo : stpLoopInfos) {
            String mac = stpLoopInfo.getMac();
            Set edges = stpLoopInfo.getEdges();
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : edges) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a typeEnum = com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.a((Integer)edge.getType());
                switch (typeEnum) {
                    case m: {
                        OswOswEdge oswOswEdge = (OswOswEdge)edge;
                        if (Objects.equals(mac, oswOswEdge.getFromNodeMac())) {
                            result.computeIfAbsent(mac, k2 -> new ArrayList()).add(oswOswEdge.getUpLink());
                            result.computeIfAbsent(oswOswEdge.getToNodeMac(), k2 -> new ArrayList()).add(oswOswEdge.getDownLink());
                            break;
                        }
                        if (!Objects.equals(mac, oswOswEdge.getToNodeMac())) break;
                        result.computeIfAbsent(mac, k2 -> new ArrayList()).add(oswOswEdge.getDownLink());
                        result.computeIfAbsent(oswOswEdge.getFromNodeMac(), k2 -> new ArrayList()).add(oswOswEdge.getUpLink());
                        break;
                    }
                    case b: {
                        OsgOswEdge osgOswEdge = (OsgOswEdge)edge;
                        if (!Objects.equals(mac, osgOswEdge.getToNodeMac())) break;
                        result.computeIfAbsent(mac, k2 -> new ArrayList()).add(osgOswEdge.getDownLink());
                        break;
                    }
                    case n: {
                        OswApEdge oswApEdge = (OswApEdge)edge;
                        if (!Objects.equals(mac, oswApEdge.getFromNodeMac()) && !Objects.equals(mac, oswApEdge.getToNodeMac())) break;
                        result.computeIfAbsent(mac, k2 -> new ArrayList()).add(oswApEdge.getUpLink());
                        break;
                    }
                    case w: {
                        ApOswEdge apOswEdge = (ApOswEdge)edge;
                        if (!Objects.equals(mac, apOswEdge.getToNodeMac())) break;
                        result.computeIfAbsent(mac, k2 -> new ArrayList()).add(apOswEdge.getDownLink());
                        break;
                    }
                    case o: {
                        OswOltEdge oswOltEdge = (OswOltEdge)edge;
                        if (!Objects.equals(mac, oswOltEdge.getFromNodeMac())) break;
                        result.computeIfAbsent(mac, k2 -> new ArrayList()).add(oswOltEdge.getUpLink());
                        break;
                    }
                    case j: {
                        OltOswEdge oltOswEdge = (OltOswEdge)edge;
                        if (!Objects.equals(mac, oltOswEdge.getToNodeMac())) break;
                        result.computeIfAbsent(mac, k2 -> new ArrayList()).add(oltOswEdge.getDownLink());
                        break;
                    }
                }
            }
        }
        if (a.isDebugEnabled()) {
            a.debug("omadacId: {} siteId: {}, loopCascadePortsMap: {}", new Object[]{omadacId, siteId, PIIJacksonUtil.parseToStr(result)});
        }
        return result;
    }

    private Map<String, Port> a(String omadacId, String siteId, OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull Set<String> downCascadeStandardPorts, Map<String, Set<String>> apClientsMap) {
        HashMap<String, Port> clientsMacs = new HashMap<String, Port>(16);
        downCascadeStandardPorts.forEach(standardPort -> {
            for (Port oswPort : oswNode.getPorts()) {
                if (!Objects.equals(oswPort.getStandardOswPort(), standardPort) || CollectionUtils.isEmpty((Collection)oswPort.getFdbMacs())) continue;
                oswPort.getFdbMacs().forEach(mac -> clientsMacs.put((String)mac, oswPort));
                break;
            }
        });
        if (CollectionUtils.isEmpty(clientsMacs)) {
            return Collections.emptyMap();
        }
        Set successors = topology.successors((Object)oswNode);
        if (!CollectionUtils.isEmpty((Collection)successors)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
                if (com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.D.contains(successor.getType())) {
                    if (successor instanceof MultiOswNode) {
                        MultiOswNode multiOswNode = (MultiOswNode)successor;
                        clientsMacs.keySet().removeAll(multiOswNode.getMacToNodeMap().keySet());
                    } else {
                        clientsMacs.keySet().remove(successor.getMac());
                    }
                }
                this.a(omadacId, siteId, successor, topology, clientsMacs.keySet(), new HashSet<String>(), apClientsMap);
            }
        } else {
            a.debug("no successors after osw <{}>, omadacId={}, siteId={}", new Object[]{oswNode.getMac(), omadacId, siteId});
        }
        return clientsMacs;
    }

    @Nonnull
    private Set<OswPortClient> a(@Nonnull Map<String, Port> clientsMacs) {
        HashMap<Integer, OswPortClient> clientMap = new HashMap<Integer, OswPortClient>();
        for (Map.Entry<String, Port> entry : clientsMacs.entrySet()) {
            Port port = entry.getValue();
            int portId = port.getPortId();
            OswPortClient oswPortClient = (OswPortClient)clientMap.get(portId);
            if (Objects.isNull(oswPortClient)) {
                oswPortClient = new OswPortClient(port.getPortId(), port.getStandardOswPort(), new ArrayList());
                clientMap.put(portId, oswPortClient);
            }
            oswPortClient.getClients().add(new OswClientEntry(entry.getKey()));
        }
        return new HashSet<OswPortClient>(clientMap.values());
    }

    private boolean a(String omadacId, String siteId, String mac, String upStandardPort, Set<String> cascadeStandardPorts, Set<OswPortClient> oswPortClients, Set<String> includeMacs, Set<String> excludeMacs) {
        g.b oldTopologyResult = this.d.d(omadacId, siteId, mac);
        if (oldTopologyResult == null) {
            a.debug("This is first time to discovery osw <{}>, omadacId={}, siteId={}", new Object[]{mac, omadacId, siteId});
            this.d.a(omadacId, siteId, mac, new g.b(upStandardPort, cascadeStandardPorts, oswPortClients));
            return true;
        }
        String oldUpPort = oldTopologyResult.a();
        if (Objects.equals(oldUpPort, upStandardPort) && Objects.equals(cascadeStandardPorts, oldTopologyResult.b()) && Objects.equals(oswPortClients, oldTopologyResult.c())) {
            return false;
        }
        Set newClients = oswPortClients.stream().flatMap(oswPortClient -> oswPortClient.getClients().stream().map(OswClientEntry::getMac)).collect(Collectors.toSet());
        Set oldClients = oldTopologyResult.c().stream().flatMap(oswPortClient -> oswPortClient.getClients().stream().map(OswClientEntry::getMac)).collect(Collectors.toSet());
        includeMacs.addAll(newClients.stream().filter(newMac -> !oldClients.contains(newMac)).collect(Collectors.toSet()));
        excludeMacs.addAll(oldClients.stream().filter(oldMac -> !newClients.contains(oldMac)).collect(Collectors.toSet()));
        this.d.a(omadacId, siteId, mac, new g.b(upStandardPort, cascadeStandardPorts, oswPortClients));
        return true;
    }

    public Boolean a(String omadacId) {
        Optional optionalOmadac = this.q.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId));
        AtomicBoolean central = new AtomicBoolean(false);
        optionalOmadac.ifPresent(omadac -> central.set(w.a.a(omadac.c())));
        a.debug("omadacId : {} is central [{}]", (Object)omadacId, (Object)central.get());
        return central.get();
    }

    private static /* synthetic */ boolean a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge) {
        return Objects.equals(edge.getToNodeMac(), node.getMac());
    }

    private static /* synthetic */ boolean b(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge) {
        return Objects.equals(edge.getFromNodeMac(), node.getMac());
    }

    private static /* synthetic */ boolean a(OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge) {
        return Objects.equals(edge.getToNodeMac(), oswNode.getMac());
    }
}

