/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.topology.port.schedule;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.component.lock.api.LockService;
import com.tplink.smb.component.schedule.api.ScheduleCenter;
import com.tplink.smb.component.schedule.api.ScheduleTask;
import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.omada.common.concurrent.thread.c;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.manager.topology.port.schedule.TopologyScheduleProperties;
import com.tplink.smb.omada.manager.topology.port.schedule.b;
import com.tplink.smb.omada.manager.topology.port.schedule.task.TopologyTask;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@com.tplink.smb.omada.common.spring.b
public class a
implements ScheduledEventHandler {
    @Generated
    private static final Logger c = LoggerFactory.getLogger(a.class);
    private static final String d = "monitor_topology";
    private static final String e = "thread_pool_queued_tasks_size";
    public static final String a = "thread_pool_rejected_tasks_total";
    public static final String b = "pool_name";
    @Autowired
    private LockService f;
    @Autowired
    private TopologyTask g;
    @Autowired
    private ScheduleCenter h;
    @Autowired
    private TopologyScheduleProperties i;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.active.a j;
    @Autowired
    private MeterRegistry k;
    private static final int l = 60000;
    private ThreadPoolExecutor m;

    @PostConstruct
    public void a() {
        com.tplink.smb.omada.common.concurrent.thread.a.a(() -> {
            ScheduleTask topologyScheduleTask = ScheduleTask.builder().withIdentity(d).withFixedRateTrigger(Integer.valueOf(this.i.getSchedulePeriod() * 60000), Integer.valueOf(this.i.getStartDelay() * 60000)).withEnableSharding(Integer.valueOf(this.i.getPartitions())).build();
            this.h.saveTask(topologyScheduleTask);
            String poolName = "manager-schedule-topology-pool";
            this.m = new ThreadPoolExecutor(1, this.i.getPartitions(), 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new b(this, poolName));
            ExecutorService executor = com.tplink.smb.omada.common.concurrent.thread.c.a((MeterRegistry)this.k, (ExecutorService)this.m, (String)poolName, (String)"executor_metric", (Tag[])new Tag[0]);
            this.h.registerEventHandler(d, (ScheduledEventHandler)this, executor);
        });
    }

    @PreDestroy
    public void b() {
        if (this.m != null) {
            this.m.shutdown();
        }
    }

    public void handle(@Nonnull ScheduledEvent scheduledEvent) {
        Integer shardingIndex = scheduledEvent.getShardingParam().getShardingIndex();
        Integer shardingSize = scheduledEvent.getShardingParam().getShardingSize();
        String taskParam = scheduledEvent.getTaskParam();
        if (W.a((long)scheduledEvent.getScheduledTime(), (int)60000)) {
            c.warn("scheduled task timeout, shardingIndex={}, shardingSize={}, taskParam={}", new Object[]{shardingIndex, shardingSize, taskParam});
            return;
        }
        this.f.doWithTryLock("manager:topo.task.lock", (Object)(taskParam + ":" + shardingIndex), () -> {
            this.a(shardingIndex);
            return true;
        }, () -> {
            c.warn("get topology task lock for partition fail, task is running, taskParam={}, shardingIndex={}", (Object)taskParam, (Object)shardingIndex);
            return false;
        });
    }

    private void a(Integer shardingIndex) {
        Map activeSitesMap = this.j.a(shardingIndex.intValue());
        if (activeSitesMap == null || CollectionUtils.isEmpty((Map)activeSitesMap)) {
            c.trace("run topologyTask no active Site data found");
            return;
        }
        activeSitesMap.forEach((k2, v2) -> {
            boolean res = this.g.a((String)k2, (Set<String>)v2);
            c.trace("run topologyTask, shardingIndex={}, omadacId={}, res={}", new Object[]{shardingIndex, k2, res});
        });
    }
}

