/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.topology.port.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.tplink.smb.omada.client.api.internal.dto.TopoClientDTO;
import com.tplink.smb.omada.client.api.internal.dto.TopoVideoDTO;
import com.tplink.smb.omada.client.api.internal.g;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.c.E;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.LLDPNeighborDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.VmsDevicesDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.IpcNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.NvrNode;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.BaseTopologyDeviceDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.BaseTopologyNodeDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyDeviceBriefDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyIpcDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyNvrDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyVideoInfoDTO;
import com.tplink.smb.omada.manager.configuration.domain.model.omadac.u;
import com.tplink.smb.omada.manager.device.api.internal.dto.vigi.VigiDeviceTypeEnum;
import com.tplink.smb.omada.manager.j.a.a.c;
import com.tplink.smb.omada.manager.j.a.a.d;
import com.tplink.smb.omada.manager.topology.port.c.a;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class i {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(i.class);
    @Autowired
    private g b;
    @Autowired
    private u c;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.g.d.a d;
    @Autowired
    private a e;
    private final Cache<String, TopologyVideoInfoDTO> f = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
    private final Cache<String, Map<String, BaseTopologyDeviceDTO>> g = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).build();
    private static final Integer h = 1;

    public TopologyVideoInfoDTO a(String omadacId, String siteId, boolean isCentral) {
        try {
            TopologyVideoInfoDTO topologyVideoInfo = this.c(omadacId, siteId, isCentral);
            if (Objects.isNull(topologyVideoInfo)) {
                topologyVideoInfo = new TopologyVideoInfoDTO();
            }
            Map managedVigiMap = Optional.ofNullable(topologyVideoInfo.getOnlineVideoMap()).orElse(new HashMap());
            Set allManagedVigiMacs = Optional.ofNullable(topologyVideoInfo.getAllManagedVigi()).orElse(new HashSet());
            Map<String, BaseTopologyDeviceDTO> clientVideoMap = this.a(omadacId, siteId);
            HashSet<String> nonMnaagedIpcMacs = new HashSet<String>();
            Map<String, BaseTopologyDeviceDTO> resultMap = this.a(managedVigiMap, clientVideoMap, allManagedVigiMacs, nonMnaagedIpcMacs);
            topologyVideoInfo.setNonManagedIpc(nonMnaagedIpcMacs);
            topologyVideoInfo.setAllManagedVigi(allManagedVigiMacs);
            topologyVideoInfo.setOnlineVideoMap(resultMap);
            return topologyVideoInfo;
        }
        catch (Exception e2) {
            a.warn("get vms device exception, site id {}", (Object)siteId, (Object)e2);
            return new TopologyVideoInfoDTO();
        }
    }

    public Map<String, BaseTopologyDeviceDTO> b(String omadacId, String siteId, boolean isCentral) {
        TopologyVideoInfoDTO topologyVideoInfoDTO = this.c(omadacId, siteId, isCentral);
        return Optional.ofNullable(topologyVideoInfoDTO).map(TopologyVideoInfoDTO::getOnlineVideoMap).orElse(new HashMap());
    }

    public TopologyVideoInfoDTO c(String omadacId, String siteId, boolean isCentral) {
        try {
            if (!isCentral) {
                return new TopologyVideoInfoDTO();
            }
            TopologyVideoInfoDTO cacheVideos = (TopologyVideoInfoDTO)this.f.getIfPresent((Object)siteId);
            if (Objects.nonNull(cacheVideos)) {
                return cacheVideos;
            }
            long startTime = System.currentTimeMillis();
            Map vmsDevices = this.d.b(omadacId, siteId);
            this.e.a(System.currentTimeMillis() - startTime);
            if (Objects.isNull(vmsDevices)) {
                return new TopologyVideoInfoDTO();
            }
            TopologyVideoInfoDTO dto = new TopologyVideoInfoDTO();
            this.a(vmsDevices, dto);
            this.a(omadacId, siteId, vmsDevices);
            HashMap<String, BaseTopologyDeviceDTO> onlineResult = new HashMap<String, BaseTopologyDeviceDTO>();
            for (Map.Entry entry : vmsDevices.entrySet()) {
                BaseTopologyDeviceDTO node = (BaseTopologyDeviceDTO)entry.getValue();
                if (Boolean.TRUE.equals(node.getVigiOnline())) {
                    onlineResult.put(node.getMac(), node);
                }
                if (CollectionUtils.isEmpty((Collection)node.getSuccessors())) continue;
                node.getSuccessors().removeIf(successor -> {
                    if (successor instanceof BaseTopologyDeviceDTO) {
                        BaseTopologyDeviceDTO deviceDTO = (BaseTopologyDeviceDTO)successor;
                        return !Boolean.TRUE.equals(deviceDTO.getVigiOnline());
                    }
                    return false;
                });
                node.getSuccessors().forEach(successor -> {
                    if (successor instanceof BaseTopologyDeviceDTO) {
                        BaseTopologyDeviceDTO deviceDTO = (BaseTopologyDeviceDTO)successor;
                        onlineResult.put(deviceDTO.getMac(), deviceDTO);
                    }
                });
                node.setSuccessors(null);
            }
            dto.setOnlineVideoMap(onlineResult);
            this.f.put((Object)siteId, (Object)dto);
            if (a.isDebugEnabled()) {
                a.debug("omadacId={} siteId={} topology video from vms after rebuild by lldp and fileter online: {}", new Object[]{omadacId, siteId, dto});
            }
            return dto;
        }
        catch (Exception e2) {
            a.warn("fail to get video devices from vms for omadacId : {} siteId : {}", new Object[]{omadacId, siteId, e2});
            return new TopologyVideoInfoDTO();
        }
    }

    private void a(String omadacId, String siteId, Map<String, BaseTopologyDeviceDTO> vmsDevices) {
        if (CollectionUtils.isEmpty(vmsDevices)) {
            return;
        }
        List topoClientDTOList = this.b.b(omadacId, siteId, new ArrayList<String>(vmsDevices.keySet()));
        Map clientMap = topoClientDTOList.stream().collect(Collectors.toMap(TopoClientDTO::getMac, Function.identity()));
        vmsDevices.forEach((mac, vigiDTO) -> {
            TopoClientDTO topoClientDTO = (TopoClientDTO)clientMap.get(mac);
            if (topoClientDTO != null) {
                Long rtRxRate = topoClientDTO.getRtRxRate();
                Long rtTxRate = topoClientDTO.getRtTxRate();
                vigiDTO.setDevRxRate(rtRxRate == null || rtRxRate == 0L ? null : rtRxRate);
                vigiDTO.setDevTxRate(rtTxRate == null || rtTxRate == 0L ? null : rtTxRate);
            }
        });
    }

    private Map<String, BaseTopologyDeviceDTO> a(String omadacId, String siteId) {
        try {
            Map cacheVideos = (Map)this.g.getIfPresent((Object)siteId);
            if (!Objects.isNull(cacheVideos)) {
                return cacheVideos;
            }
            List topoVideoDTOS = this.b.d(omadacId, siteId);
            if (Objects.isNull(topoVideoDTOS)) {
                return Maps.newHashMap();
            }
            Map<String, BaseTopologyDeviceDTO> resultMap = topoVideoDTOS.stream().filter(topoVideoDTO -> Objects.equals(topoVideoDTO.getOnlineStatus(), h)).map(this::a).filter(Objects::nonNull).collect(Collectors.toMap(BaseTopologyNodeDTO::getMac, v2 -> v2, (exist, replace) -> exist));
            if (a.isDebugEnabled()) {
                a.debug("omadacId={} siteId={} topology video from client : {}", new Object[]{omadacId, siteId, topoVideoDTOS});
            }
            this.g.put((Object)siteId, resultMap);
            return resultMap;
        }
        catch (Exception e2) {
            a.warn("get vms device exception, site id {}", (Object)siteId, (Object)e2);
            return Maps.newHashMap();
        }
    }

    public void a(String omadacId, String siteId, @Nonnull VmsDevicesDTO vmsDevicesDTO, Map<String, String> devices) {
        Map<String, BaseTopologyDeviceDTO> videoMap = this.a(omadacId, siteId);
        if (CollectionUtils.isEmpty(videoMap)) {
            return;
        }
        Map nvrNodeMap = Optional.ofNullable(vmsDevicesDTO.getNvrMap()).orElse(new HashMap());
        Map ipcNodeMap = Optional.ofNullable(vmsDevicesDTO.getIpcMap()).orElse(new HashMap());
        for (Map.Entry<String, BaseTopologyDeviceDTO> entry : videoMap.entrySet()) {
            BaseTopologyDeviceDTO baseTopologyDeviceDTO = entry.getValue();
            if (baseTopologyDeviceDTO instanceof TopologyNvrDTO) {
                this.a(nvrNodeMap, (TopologyNvrDTO)baseTopologyDeviceDTO, devices);
                continue;
            }
            if (!(baseTopologyDeviceDTO instanceof TopologyIpcDTO)) continue;
            this.a(ipcNodeMap, (TopologyIpcDTO)baseTopologyDeviceDTO, devices, nvrNodeMap);
        }
        vmsDevicesDTO.setNvrMap(nvrNodeMap);
        vmsDevicesDTO.setIpcMap(ipcNodeMap);
    }

    private void a(Map<String, NvrNode> nvrNodeMap, @Nonnull TopologyNvrDTO nvrDTO, Map<String, String> devices) {
        if (nvrNodeMap.containsKey(nvrDTO.getMac())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)nvrDTO.getMacList())) {
            boolean existInMap = nvrDTO.getMacList().stream().anyMatch(nvrNodeMap::containsKey);
            if (existInMap) {
                return;
            }
        }
        String nvrMac = CollectionUtils.isEmpty((Collection)nvrDTO.getMacList()) ? nvrDTO.getMac() : (String)nvrDTO.getMacList().get(0);
        NvrNode nvrNode = new NvrNode(nvrMac);
        nvrNode.setIp(nvrDTO.getIp());
        nvrNode.setChannelNum(nvrDTO.getChannelNum());
        nvrNode.setConnectedChannel(nvrDTO.getConnectedChannel());
        nvrNode.setFirmwareVersion(nvrDTO.getFirmwareVersion());
        nvrNode.setHardwareVersion(nvrDTO.getHardwareVersion());
        nvrNode.setModelVersion(nvrDTO.getModelVersion());
        nvrNode.setModel(nvrDTO.getModel());
        nvrNode.setName(nvrDTO.getName());
        nvrNode.setManaged(Boolean.valueOf(false));
        nvrNodeMap.put(nvrMac, nvrNode);
        devices.put(nvrMac, VigiDeviceTypeEnum.b.a());
    }

    private void a(Map<String, IpcNode> ipcNodeMap, @Nonnull TopologyIpcDTO ipcDTO, Map<String, String> devices, @Nonnull Map<String, NvrNode> nvrNodeMap) {
        if (ipcNodeMap.containsKey(ipcDTO.getMac())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)ipcDTO.getMacList())) {
            boolean existInMap = ipcDTO.getMacList().stream().anyMatch(ipcNodeMap::containsKey);
            if (existInMap) {
                return;
            }
        }
        String ipcMac = CollectionUtils.isEmpty((Collection)ipcDTO.getMacList()) ? ipcDTO.getMac() : (String)ipcDTO.getMacList().get(0);
        IpcNode ipcNode = new IpcNode(ipcMac);
        ipcNode.setIp(ipcDTO.getIp());
        ipcNode.setFirmwareVersion(ipcDTO.getFirmwareVersion());
        ipcNode.setHardwareVersion(ipcDTO.getHardwareVersion());
        ipcNode.setModelVersion(ipcDTO.getModelVersion());
        ipcNode.setModel(ipcDTO.getModel());
        ipcNode.setName(ipcDTO.getName());
        ipcNode.setManaged(Boolean.valueOf(false));
        ipcNodeMap.put(ipcMac, ipcNode);
        devices.put(ipcMac, VigiDeviceTypeEnum.a.a());
        for (Map.Entry<String, NvrNode> entry : nvrNodeMap.entrySet()) {
            NvrNode nvrNode = entry.getValue();
            this.a(ipcMac, nvrNode);
        }
    }

    private void a(String ipcMac, NvrNode nvrNode) {
        if (Objects.isNull(nvrNode) || !Boolean.TRUE.equals(nvrNode.getDetected())) {
            return;
        }
        Set neighbors = Optional.ofNullable(nvrNode.getNeighbors()).orElse(new HashSet());
        for (LLDPNeighborDTO lldpNeighborDTO : neighbors) {
            if (!T.a((String)ipcMac, (String)lldpNeighborDTO.getMac())) continue;
            lldpNeighborDTO.setType(VigiDeviceTypeEnum.a.a());
            return;
        }
        if (CollectionUtils.isEmpty((Map)nvrNode.getNoCapOthers())) {
            return;
        }
        LLDPNeighborDTO lldpNeighborDTO = (LLDPNeighborDTO)nvrNode.getNoCapOthers().get(ipcMac);
        if (Objects.isNull(lldpNeighborDTO)) {
            return;
        }
        lldpNeighborDTO.setType(VigiDeviceTypeEnum.a.a());
        neighbors.add(lldpNeighborDTO);
        nvrNode.setNeighbors(neighbors);
    }

    public BaseTopologyDeviceDTO a(TopoVideoDTO vmsDevice) {
        TopologyIpcDTO result;
        if (Objects.equals(VigiDeviceTypeEnum.b.a(), vmsDevice.getDeviceType())) {
            TopologyNvrDTO nvrDTO = new TopologyNvrDTO();
            nvrDTO.setIp(vmsDevice.getIpAddressString());
            nvrDTO.setChannelNum(vmsDevice.getChannelNum());
            nvrDTO.setConnectedChannel(vmsDevice.getAddedChannelNum());
            nvrDTO.setFirmwareVersion(vmsDevice.getFirmwareVersion());
            nvrDTO.setModelVersion(vmsDevice.getHardwareVersion());
            nvrDTO.setMac(vmsDevice.getMacAddress());
            nvrDTO.setMacList(vmsDevice.getMacAddressList());
            nvrDTO.setModel(vmsDevice.getDeviceModel());
            nvrDTO.setName(vmsDevice.getDeviceName());
            nvrDTO.setVigiOnline(Boolean.valueOf(Objects.equals(E.b.a(), vmsDevice.getOnlineStatus())));
            if (!CollectionUtils.isEmpty((Collection)vmsDevice.getChildrenList())) {
                nvrDTO.setSuccessors(vmsDevice.getChildrenList().stream().filter(topoVideoDTO -> Objects.equals(VigiDeviceTypeEnum.a.a(), topoVideoDTO.getDeviceType())).map(this::a).collect(Collectors.toList()));
            }
            result = nvrDTO;
        } else if (Objects.equals(VigiDeviceTypeEnum.a.a(), vmsDevice.getDeviceType())) {
            TopologyIpcDTO ipcDTO = new TopologyIpcDTO();
            ipcDTO.setIp(vmsDevice.getIpAddressString());
            ipcDTO.setFirmwareVersion(vmsDevice.getFirmwareVersion());
            ipcDTO.setModelVersion(vmsDevice.getHardwareVersion());
            ipcDTO.setMac(vmsDevice.getMacAddress());
            ipcDTO.setMacList(vmsDevice.getMacAddressList());
            ipcDTO.setModel(vmsDevice.getDeviceModel());
            ipcDTO.setName(vmsDevice.getDeviceName());
            ipcDTO.setVigiOnline(Boolean.valueOf(Objects.equals(E.b.a(), vmsDevice.getOnlineStatus())));
            result = ipcDTO;
        } else {
            a.warn("Unknown video device type found, {}", (Object)vmsDevice);
            return null;
        }
        return result;
    }

    @Nonnull
    private Map<String, BaseTopologyDeviceDTO> a(@Nonnull Map<String, BaseTopologyDeviceDTO> vmsVideoMap, Map<String, BaseTopologyDeviceDTO> clientVideoMap, @Nonnull Set<String> allManagedVigiMacs, Set<String> nonMnaagedIpcMacs) {
        if (CollectionUtils.isEmpty(clientVideoMap)) {
            return vmsVideoMap;
        }
        HashMap<String, BaseTopologyDeviceDTO> result = new HashMap<String, BaseTopologyDeviceDTO>(vmsVideoMap);
        HashSet<String> tmpVmsVideoSet = new HashSet<String>();
        for (Map.Entry<String, BaseTopologyDeviceDTO> entry : clientVideoMap.entrySet()) {
            BaseTopologyDeviceDTO node = entry.getValue();
            if (allManagedVigiMacs.contains(node.getMac()) || tmpVmsVideoSet.contains(node.getMac())) continue;
            tmpVmsVideoSet.add(node.getMac());
            if (Objects.equals("IPC", node.getType())) {
                nonMnaagedIpcMacs.add(node.getMac());
            }
            result.put(node.getMac(), node);
        }
        return result;
    }

    private void a(Map<String, BaseTopologyDeviceDTO> result, TopologyVideoInfoDTO dto) {
        HashSet<TopologyDeviceBriefDTO> vmsVideoSet = new HashSet<TopologyDeviceBriefDTO>();
        HashSet<String> vmsVideoMacSet = new HashSet<String>();
        dto.setAllManagedVigiBrief(vmsVideoSet);
        dto.setAllManagedVigi(vmsVideoMacSet);
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        for (Map.Entry<String, BaseTopologyDeviceDTO> entry : result.entrySet()) {
            BaseTopologyDeviceDTO node = entry.getValue();
            vmsVideoSet.add(this.a((BaseTopologyNodeDTO)node));
            vmsVideoMacSet.add(node.getMac());
            if (!CollectionUtils.isEmpty((Collection)node.getMacList())) {
                vmsVideoMacSet.addAll(node.getMacList());
            }
            if (CollectionUtils.isEmpty((Collection)node.getSuccessors())) continue;
            node.getSuccessors().forEach(successor -> {
                vmsVideoSet.add(this.a((BaseTopologyNodeDTO)successor));
                vmsVideoMacSet.add(successor.getMac());
                if (!CollectionUtils.isEmpty((Collection)successor.getMacList())) {
                    vmsVideoMacSet.addAll(node.getMacList());
                }
            });
        }
    }

    private TopologyDeviceBriefDTO a(BaseTopologyNodeDTO node) {
        return new TopologyDeviceBriefDTO(node.getMac(), node.getMacList(), node.getName(), node.getIp(), node.getModel(), node.getModelVersion(), node.getType());
    }

    public void a(c omadacId, d siteId) {
        if (Objects.isNull(omadacId) || Objects.isNull(siteId)) {
            a.warn("Trying to delete topo video cache with null omadacId or siteId. OmadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
        } else {
            this.f.invalidate((Object)siteId);
            this.g.invalidate((Object)siteId);
        }
    }
}

