/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.topology.domain.discovery;

import com.google.common.collect.Lists;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.Traverser;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.device.StandardOswPortIndex;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.inform.osw.stp.OswStpPortInfo;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.ApMeshInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.LLDPNeighborDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApIpcEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApNvrEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApOtherEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOsgEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.DisconnectedEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MeshApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MultiOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.NvrApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.NvrIpcEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.NvrIpcWirelessEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.NvrOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.NvrOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.NvrOtherEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OduOsgEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OltApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OltOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgIpcEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgNvrEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswIpcEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswNvrEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.WiredApApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.ApNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.IpcNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.MultiOswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.NvrNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OduNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OltNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OsgNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OtherNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.Port;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.StpLoopInfoDTO;
import com.tplink.smb.omada.manager.topology.domain.discovery.TopologyDevices;
import com.tplink.smb.omada.manager.topology.domain.discovery.a;
import com.tplink.smb.omada.manager.topology.dto.PersistenceNodeDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.util.CollectionUtils;

public class b {
    @Generated
    private static final Logger a = LogManager.getLogger(b.class);

    @Nullable
    public static MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> a(@Nonnull TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology) {
        List<ApNode> sortedApNodes;
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a rootNode;
        if (topologyDevices.isEmpty()) {
            a.debug("no omada device exist, stop discovery topology");
            return disconnectedTopology;
        }
        b.a(topologyDevices);
        MutableNetwork topology = NetworkBuilder.directed().allowsParallelEdges(true).build();
        if (Objects.isNull(topologyDevices.getOsg()) && Objects.nonNull(rootNode = topologyDevices.getRootNode()) && Objects.equals("other", rootNode.getType())) {
            OtherNode otherNode = (OtherNode)rootNode;
            topology.addNode((Object)otherNode);
            otherNode.setDetected(Boolean.valueOf(true));
            topologyDevices.getOtherMap().put(otherNode.getMac(), otherNode);
        }
        if (Objects.nonNull(topologyDevices.getOdu())) {
            b.g(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        }
        if (Objects.nonNull(topologyDevices.getOsg()) || Objects.nonNull(topologyDevices.getRootNode())) {
            b.f(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        } else {
            b.j(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        }
        if (!CollectionUtils.isEmpty(topologyDevices.getOswMap())) {
            b.c(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        }
        if (Objects.nonNull(topologyDevices.getOsg()) && Objects.nonNull(topologyDevices.getOmadacNode())) {
            b.a(topologyDevices.getOsg(), topologyDevices.getOmadacNode(), (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        }
        if (Objects.nonNull(topologyDevices.getOdu()) && Objects.nonNull(topologyDevices.getOmadacNode())) {
            b.a((OsgNode)topologyDevices.getOdu(), topologyDevices.getOmadacNode(), (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        }
        if (!CollectionUtils.isEmpty(topologyDevices.getOltMap())) {
            b.h(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
        }
        if (!CollectionUtils.isEmpty(sortedApNodes = b.b(topologyDevices, disconnectedTopology))) {
            for (ApNode apNode : sortedApNodes) {
                if (Boolean.TRUE.equals(apNode.getDetected())) {
                    a.trace("ap <{}> already detected", (Object)apNode.getMac());
                    continue;
                }
                b.b(apNode, topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
            }
        }
        b.a(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, disconnectedTopology);
        if (Objects.nonNull(topologyDevices.getOsg())) {
            b.b(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, disconnectedTopology);
        }
        if (!CollectionUtils.isEmpty(topologyDevices.getNvrMap())) {
            for (NvrNode nvrNode : topologyDevices.getNvrMap().values()) {
                if (Boolean.TRUE.equals(nvrNode.getDetected())) continue;
                b.a(nvrNode, topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology);
            }
        }
        if (Objects.isNull(disconnectedTopology) || CollectionUtils.isEmpty((Collection)disconnectedTopology.nodes())) {
            return topology;
        }
        HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> nodes = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : disconnectedTopology.nodes()) {
            MultiOswNode multiOswNode;
            if (Boolean.TRUE.equals(node.getDetected()) && (!(node instanceof MultiOswNode) || Boolean.TRUE.equals((multiOswNode = (MultiOswNode)node).getAllMemOffline()))) continue;
            nodes.add(node);
            nodes.addAll(disconnectedTopology.successors((Object)node));
            nodes.addAll(disconnectedTopology.predecessors((Object)node));
        }
        if (!CollectionUtils.isEmpty(nodes)) {
            if (a.isDebugEnabled()) {
                a.debug("disconnectedNodes left = {}", nodes);
            }
            b.a((MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, disconnectedTopology, nodes);
        }
        return topology;
    }

    public static void a(Map<String, MultiOswNode> vrrpOswMap, Map<String, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>> hbmVrrpMemInternalLinks) {
        for (MultiOswNode multiOswNode : vrrpOswMap.values()) {
            ArrayList<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> vrrpInternalLinkEdges = new ArrayList<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>();
            if (!CollectionUtils.isEmpty((Collection)multiOswNode.getVrrpInternalLinkEdges())) {
                vrrpInternalLinkEdges.addAll(multiOswNode.getVrrpInternalLinkEdges());
            }
            for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
                if (CollectionUtils.isEmpty((Collection)oswNode.getInternalLinkPorts())) continue;
                b.a(oswNode, multiOswNode, vrrpInternalLinkEdges);
            }
            for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
                if (!hbmVrrpMemInternalLinks.containsKey(oswNode.getMac())) continue;
                b.a(vrrpInternalLinkEdges, hbmVrrpMemInternalLinks.get(oswNode.getMac()));
                break;
            }
            multiOswNode.setVrrpInternalLinkEdges(vrrpInternalLinkEdges);
        }
    }

    private static void a(List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> vrrpInternalLinkEdges, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> oldVrrpInternalLinkEdges) {
        if (CollectionUtils.isEmpty(oldVrrpInternalLinkEdges)) {
            return;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : vrrpInternalLinkEdges) {
            OswOswEdge oldEdge;
            OswOswEdge oswOswEdge;
            if (!(edge instanceof OswOswEdge) || !Objects.isNull((oswOswEdge = (OswOswEdge)edge).getUpLink()) && !Objects.isNull(oswOswEdge.getDownLink()) || Objects.isNull(oldEdge = b.a(edge, oldVrrpInternalLinkEdges))) continue;
            if (a.isDebugEnabled()) {
                a.debug("vrrp internal link edge port lost:{},try to fill from old link:{}", (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)PIIJacksonUtil.parseToStr((Object)oldEdge));
            }
            if (Objects.isNull(oswOswEdge.getUpLink())) {
                String fromNodeMac = oswOswEdge.getFromNodeMac();
                if (Objects.equals(oldEdge.getFromNodeMac(), fromNodeMac)) {
                    oswOswEdge.setUpLink(oldEdge.getUpLink());
                } else {
                    oswOswEdge.setUpLink(oldEdge.getDownLink());
                }
            }
            if (!Objects.isNull(oswOswEdge.getDownLink())) continue;
            String toNodeMac = oswOswEdge.getToNodeMac();
            if (Objects.equals(oldEdge.getToNodeMac(), toNodeMac)) {
                oswOswEdge.setDownLink(oldEdge.getDownLink());
                continue;
            }
            oswOswEdge.setDownLink(oldEdge.getUpLink());
        }
    }

    private static OswOswEdge a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> oldVrrpInternalLinkEdges) {
        HashSet<String> macs = new HashSet<String>();
        macs.add(edge.getFromNodeMac());
        macs.add(edge.getToNodeMac());
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a oldEdge : oldVrrpInternalLinkEdges) {
            if (!macs.contains(oldEdge.getFromNodeMac()) || !macs.contains(oldEdge.getToNodeMac()) || !(oldEdge instanceof OswOswEdge)) continue;
            OswOswEdge oswOswEdge = (OswOswEdge)oldEdge;
            return oswOswEdge;
        }
        return null;
    }

    private static void a(OswNode oswNode, MultiOswNode multiOswNode, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> vrrpInternalLinkEdges) {
        for (Port port : oswNode.getInternalLinkPorts()) {
            if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) continue;
            for (LLDPNeighborDTO neighborDTO : port.getLldpNeighbors()) {
                if (!multiOswNode.getMacToNodeMap().containsKey(neighborDTO.getMac())) continue;
                OswNode toOswNode = (OswNode)multiOswNode.getMacToNodeMap().get(neighborDTO.getMac());
                if (b.a(vrrpInternalLinkEdges, oswNode.getMac(), toOswNode.getMac())) continue;
                Port downLink = b.a(oswNode.getMac(), toOswNode);
                OswOswEdge oswOswEdge = new OswOswEdge(port, downLink);
                oswOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
                oswOswEdge.setFromNodeAndToNode(oswNode.getMac(), toOswNode.getMac());
                OswStpPortInfo stpPortInfo = Optional.ofNullable(oswNode.getStpPortInfoMap()).map(stpPortMap -> (OswStpPortInfo)stpPortMap.get(port.getStandardOswPort())).orElse(null);
                b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                if (!Objects.isNull(downLink)) {
                    OswStpPortInfo downLinkStpPortInfo = Optional.ofNullable(toOswNode.getStpPortInfoMap()).map(stpPortMap -> (OswStpPortInfo)stpPortMap.get(downLink.getStandardOswPort())).orElse(null);
                    b.a(downLinkStpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                }
                vrrpInternalLinkEdges.add((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
            }
        }
    }

    private static boolean a(List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> vrrpInternalLinkEdges, String fromMac, String toMac) {
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : vrrpInternalLinkEdges) {
            if (Objects.equals(edge.getFromNodeMac(), toMac) && Objects.equals(edge.getToNodeMac(), fromMac)) {
                return true;
            }
            if (!Objects.equals(edge.getFromNodeMac(), fromMac) || !Objects.equals(edge.getToNodeMac(), toMac)) continue;
            return true;
        }
        return false;
    }

    private static Port a(String mac, OswNode oswNode) {
        if (CollectionUtils.isEmpty((Collection)oswNode.getInternalLinkPorts())) {
            return null;
        }
        for (Port port : oswNode.getInternalLinkPorts()) {
            if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors()) || !port.getLldpNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), mac))) continue;
            return port;
        }
        return null;
    }

    public static List<StpLoopInfoDTO> a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (topologyDevices.isEmpty() || CollectionUtils.isEmpty(topologyDevices.getOswMap())) {
            return Collections.emptyList();
        }
        HashMap<String, StpLoopInfoDTO> stpLoopInfoDTOMap = new HashMap<String, StpLoopInfoDTO>();
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        for (OswNode oswNode : oswMap.values()) {
            List blockedPorts = oswNode.getBlockedPorts();
            List partialBlockedPorts = oswNode.getPartialBlockedPorts();
            if (!CollectionUtils.isEmpty((Collection)blockedPorts)) {
                b.a(topology, topologyDevices, oswNode, blockedPorts, stpLoopInfoDTOMap);
            }
            if (CollectionUtils.isEmpty((Collection)partialBlockedPorts)) continue;
            b.b(topology, topologyDevices, oswNode, partialBlockedPorts, stpLoopInfoDTOMap);
        }
        List<StpLoopInfoDTO> stpLoopInfoDTOS = stpLoopInfoDTOMap.values().stream().toList();
        return stpLoopInfoDTOS;
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, OswNode oswNode, List<Port> blockedPorts, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        for (Port port : blockedPorts) {
            Optional.ofNullable(port.getLldpNeighbors()).orElseGet(() -> new HashSet()).stream().forEach(neighborDTO -> {
                String type;
                switch (type = neighborDTO.getType()) {
                    case "switch": {
                        b.d(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                        break;
                    }
                    case "gateway": {
                        b.c(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                        break;
                    }
                    case "ap": {
                        b.b(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                        break;
                    }
                    case "olt": {
                        b.a(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                    }
                }
            });
        }
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OltOswEdge edge;
        OswOltEdge edge2;
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        if (CollectionUtils.isEmpty(oltMap)) {
            return;
        }
        OltNode targetNode = oltMap.get(neighborDTO.getMac());
        if (targetNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            MultiOswNode multiOswNode = topologyDevices.getMlagOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and olt:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            MultiOswNode multiOswNode = topologyDevices.getVrrpOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and olt:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1) && Objects.equals(Optional.ofNullable((edge2 = (OswOltEdge)optEdge1).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("osw {} and olt {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)edge2);
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)oswNode);
        if (!Objects.isNull(optEdge2) && Objects.equals(Optional.ofNullable((edge = (OltOswEdge)optEdge2).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("olt {} and osw {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)edge);
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        edge = new OswOltEdge(port);
        Map lldpPortMap = targetNode.getLldpPortMap();
        if (lldpPortMap != null && lldpPortMap.get(oswNode.getMac()) != null) {
            Port downLink = new Port();
            downLink.setStandardOswPort((String)lldpPortMap.get(oswNode.getMac()));
            edge.setDownLink(downLink);
        }
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, MultiOswNode multiOswNode, OswNode oswNode, Port port, OltNode oltNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OltOswEdge edge2;
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
        List edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getToNodeMac(), oswNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges) && Objects.equals(Optional.ofNullable((edge2 = (OltOswEdge)edges.get(0)).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("olt {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge2));
            }
            if (CollectionUtils.isEmpty((Collection)edge2.getBlockedVlans())) {
                OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(edge2.getUpLink().getStandardOswPort());
                b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            }
            return;
        }
        edge2 = new OltOswEdge(port);
        edge2.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.j.a());
        edge2.setFromNodeAndToNode(oltNode.getMac(), oswNode.getMac());
        Port downLink = edge2.getDownLink();
        if (downLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(oswNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
        }
        multiOswEdge.getEdges().add(edge2);
    }

    private static void b(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, MultiOswNode multiOswNode, OswNode oswNode, Port port, OltNode oltNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
        List edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getToNodeMac(), oltNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : edges) {
                OswOltEdge oswOltEdge = (OswOltEdge)edge2;
                if (Objects.isNull(oswOltEdge.getUpLink()) || !Objects.equals(oswOltEdge.getUpLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                if (a.isInfoEnabled()) {
                    a.info("multiOswMem:{} and olt:{} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOltEdge));
                }
                if (CollectionUtils.isEmpty((Collection)oswOltEdge.getBlockedVlans())) {
                    OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOltEdge.getUpLink().getStandardOswPort());
                    b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOltEdge);
                }
                return;
            }
        }
        OswOltEdge edge3 = new OswOltEdge(port);
        edge3.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
        edge3.setFromNodeAndToNode(oswNode.getMac(), oltNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge3);
        multiOswEdge.getEdges().add(edge3);
    }

    private static void b(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OswApEdge edge;
        OswApEdge edge2;
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap)) {
            return;
        }
        ApNode targetNode = apMap.get(neighborDTO.getMac());
        if (targetNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            MultiOswNode multiOswNode = topologyDevices.getMlagOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and ap:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            MultiOswNode multiOswNode = topologyDevices.getVrrpOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and ap:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1) && Objects.equals(Optional.ofNullable((edge2 = (OswApEdge)optEdge1).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("osw {} and ap {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)edge2);
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)oswNode);
        if (!Objects.isNull(optEdge2) && Objects.equals(Optional.ofNullable((edge = (OswApEdge)optEdge2).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("ap {} and osw {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)edge);
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        edge = new OswApEdge(port, b.a(oswNode.getMac(), targetNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, MultiOswNode multiOswNode, OswNode oswNode, Port port, ApNode apNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OswApEdge edge2;
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
        List edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getToNodeMac(), oswNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges) && Objects.equals(Optional.ofNullable((edge2 = (OswApEdge)edges.get(0)).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("ap {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge2));
            }
            if (CollectionUtils.isEmpty((Collection)edge2.getBlockedVlans())) {
                OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(edge2.getUpLink().getStandardOswPort());
                b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            }
            return;
        }
        edge2 = new ApOswEdge(b.a(oswNode.getMac(), apNode), port);
        edge2.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.w.a());
        edge2.setFromNodeAndToNode(apNode.getMac(), oswNode.getMac());
        Port downLink = edge2.getDownLink();
        if (downLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(oswNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
        }
        multiOswEdge.getEdges().add(edge2);
    }

    private static void b(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, MultiOswNode multiOswNode, OswNode oswNode, Port port, ApNode apNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
        List edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getToNodeMac(), apNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : edges) {
                OswApEdge oswApEdge = (OswApEdge)edge2;
                if (Objects.isNull(oswApEdge.getUpLink()) || !Objects.equals(oswApEdge.getUpLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                if (a.isInfoEnabled()) {
                    a.info("multiOswMem:{} and ap:{} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswApEdge));
                }
                if (CollectionUtils.isEmpty((Collection)oswApEdge.getBlockedVlans())) {
                    OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswApEdge.getUpLink().getStandardOswPort());
                    b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswApEdge);
                }
                return;
            }
        }
        OswApEdge edge3 = new OswApEdge(port, b.a(oswNode.getMac(), apNode));
        edge3.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
        edge3.setFromNodeAndToNode(oswNode.getMac(), apNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge3);
        multiOswEdge.getEdges().add(edge3);
    }

    private static void c(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OsgOswEdge edge;
        if (Objects.isNull(topologyDevices.getOsg())) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(topology, topologyDevices.getOsg(), topologyDevices.getMlagOswMap().get(oswNode.getMac()), oswNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(topology, topologyDevices.getOsg(), topologyDevices.getVrrpOswMap().get(oswNode.getMac()), oswNode, port, stpLoopInfoDTOMap);
            return;
        }
        OsgNode osg = topologyDevices.getOsg();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)osg, (Object)oswNode);
        if (!Objects.isNull(optEdge) && Objects.equals(Optional.ofNullable((edge = (OsgOswEdge)optEdge).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("osg {} and osw {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge));
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        edge = new OsgOswEdge(port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.b.a());
        edge.setFromNodeAndToNode(osg.getMac(), oswNode.getMac());
        Port downLink = edge.getDownLink();
        if (downLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(oswNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OsgNode osg, MultiOswNode multiOswNode, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OsgOswEdge edge2;
        if (Objects.isNull(multiOswNode)) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)osg, (Object)multiOswNode);
        if (Objects.isNull(optEdge)) {
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge from osg:{} to multiOsw:{}, stop discoverOsgMultiOswLoopEdge", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
        List edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getToNodeMac(), oswNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges) && Objects.equals(Optional.ofNullable((edge2 = (OsgOswEdge)edges.get(0)).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("osg {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge2));
            }
            if (CollectionUtils.isEmpty((Collection)edge2.getBlockedVlans())) {
                OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(edge2.getDownLink().getStandardOswPort());
                b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            }
            return;
        }
        edge2 = new OsgOswEdge(port);
        edge2.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.b.a());
        edge2.setFromNodeAndToNode(osg.getMac(), oswNode.getMac());
        Port downLink = edge2.getDownLink();
        if (downLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(oswNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
        }
        multiOswEdge.getEdges().add(edge2);
    }

    private static void d(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OswOswEdge edge;
        OswOswEdge edge2;
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        OswNode targetNode = oswMap.get(neighborDTO.getMac());
        if (targetNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) || Boolean.TRUE.equals(oswNode.getVrrpMem()) || Boolean.TRUE.equals(targetNode.getMlagMem()) || Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            b.a(topology, topologyDevices, oswNode, targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1) && Objects.equals(Optional.ofNullable((edge2 = (OswOswEdge)optEdge1).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("osw1 {} and osw2 {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge2));
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)oswNode);
        if (!Objects.isNull(optEdge2) && Objects.equals(Optional.ofNullable((edge = (OswOswEdge)optEdge2).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            if (a.isInfoEnabled()) {
                a.info("osw1 {} and osw2 {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge));
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        edge = new OswOswEdge(port, b.d(oswNode.getMac(), targetNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        Port downLink = edge.getDownLink();
        if (downLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, OswNode oswNode, OswNode targetNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        Map mlagOswMap = Optional.ofNullable(topologyDevices.getMlagOswMap()).orElse(new HashMap());
        Map vrrpOswMap = Optional.ofNullable(topologyDevices.getVrrpOswMap()).orElse(new HashMap());
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) && Boolean.TRUE.equals(targetNode.getMlagMem())) {
            b.a(topology, topologyDevices, (MultiOswNode)mlagOswMap.get(oswNode.getMac()), oswNode, (MultiOswNode)mlagOswMap.get(targetNode.getMac()), targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) && Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            b.a(topology, topologyDevices, (MultiOswNode)vrrpOswMap.get(oswNode.getMac()), oswNode, (MultiOswNode)vrrpOswMap.get(targetNode.getMac()), targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) && Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            b.a(topology, topologyDevices, (MultiOswNode)mlagOswMap.get(oswNode.getMac()), oswNode, (MultiOswNode)vrrpOswMap.get(targetNode.getMac()), targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) && Boolean.TRUE.equals(targetNode.getMlagMem())) {
            b.a(topology, topologyDevices, (MultiOswNode)vrrpOswMap.get(oswNode.getMac()), oswNode, (MultiOswNode)mlagOswMap.get(targetNode.getMac()), targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(topology, topologyDevices, (MultiOswNode)mlagOswMap.get(oswNode.getMac()), oswNode, targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(topology, topologyDevices, (MultiOswNode)vrrpOswMap.get(oswNode.getMac()), oswNode, targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(targetNode.getMlagMem())) {
            b.a(topology, topologyDevices, oswNode, (MultiOswNode)mlagOswMap.get(targetNode.getMac()), targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            b.a(topology, topologyDevices, oswNode, (MultiOswNode)vrrpOswMap.get(targetNode.getMac()), targetNode, port, stpLoopInfoDTOMap);
        }
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, OswNode oswNode, MultiOswNode targetMultiOsw, OswNode targetNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        if (Objects.isNull(targetMultiOsw)) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetMultiOsw);
        if (!Objects.isNull(optEdge1)) {
            MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge1;
            List edges = multiOswEdge.getEdges().stream().filter(edge1 -> Objects.equals(edge1.getFromNodeMac(), oswNode.getMac()) && Objects.equals(edge1.getToNodeMac(), targetNode.getMac())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(edges)) {
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : edges) {
                    OswOswEdge oswOswEdge = (OswOswEdge)e2;
                    if (Objects.isNull(oswOswEdge.getUpLink()) || !Objects.equals(oswOswEdge.getUpLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                    if (a.isInfoEnabled()) {
                        a.info("osw {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOswEdge));
                    }
                    if (CollectionUtils.isEmpty((Collection)oswOswEdge.getBlockedVlans())) {
                        OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOswEdge.getUpLink().getStandardOswPort());
                        b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                    }
                    return;
                }
            }
            OswOswEdge edge = new OswOswEdge(port, b.c(oswNode.getMac(), targetNode));
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
            OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
            b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            Port downLink = edge.getDownLink();
            if (downLink != null) {
                OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
                b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            }
            multiOswEdge.getEdges().add(edge);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetMultiOsw, (Object)oswNode);
        if (Objects.isNull(optEdge2)) {
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between osw:{} and multiOsw:{}, stop discoverOswMultiOswLoopEdge", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr(targetMultiOsw.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge2;
        List edges = multiOswEdge.getEdges().stream().filter(edge1 -> Objects.equals(edge1.getFromNodeMac(), targetNode.getMac()) && Objects.equals(edge1.getToNodeMac(), oswNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e3 : edges) {
                OswOswEdge oswOswEdge = (OswOswEdge)e3;
                if (Objects.isNull(oswOswEdge.getDownLink()) || !Objects.equals(oswOswEdge.getDownLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                if (a.isInfoEnabled()) {
                    a.info("multiOswMem {} and osw {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOswEdge));
                }
                if (CollectionUtils.isEmpty((Collection)oswOswEdge.getBlockedVlans())) {
                    OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOswEdge.getDownLink().getStandardOswPort());
                    b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                }
                return;
            }
        }
        OswOswEdge edge = new OswOswEdge(b.c(oswNode.getMac(), targetNode), port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(targetNode.getMac(), oswNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        Port upLink = edge.getUpLink();
        if (upLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(upLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        multiOswEdge.getEdges().add(edge);
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, MultiOswNode multiOswNode, OswNode oswNode, OswNode targetNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        if (Objects.isNull(multiOswNode)) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1)) {
            MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge1;
            List edges = multiOswEdge.getEdges().stream().filter(edge1 -> Objects.equals(edge1.getFromNodeMac(), oswNode.getMac()) && Objects.equals(edge1.getToNodeMac(), targetNode.getMac())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(edges)) {
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : edges) {
                    OswOswEdge oswOswEdge = (OswOswEdge)e2;
                    if (Objects.isNull(oswOswEdge.getUpLink()) || !Objects.equals(oswOswEdge.getUpLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                    if (a.isInfoEnabled()) {
                        a.info("multiOswMem {} and osw {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOswEdge));
                    }
                    if (CollectionUtils.isEmpty((Collection)oswOswEdge.getBlockedVlans())) {
                        OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOswEdge.getUpLink().getStandardOswPort());
                        b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                    }
                    return;
                }
            }
            OswOswEdge edge = new OswOswEdge(port, b.c(oswNode.getMac(), targetNode));
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
            OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
            b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            Port downLink = edge.getDownLink();
            if (downLink != null) {
                OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
                b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            }
            multiOswEdge.getEdges().add(edge);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
        if (Objects.isNull(optEdge2)) {
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and osw:{}, stop discoverMultiOswOswLoopEdge", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge2;
        List edges = multiOswEdge.getEdges().stream().filter(edge1 -> Objects.equals(edge1.getFromNodeMac(), targetNode.getMac()) && Objects.equals(edge1.getToNodeMac(), oswNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e3 : edges) {
                OswOswEdge oswOswEdge = (OswOswEdge)e3;
                if (Objects.isNull(oswOswEdge.getDownLink()) || !Objects.equals(oswOswEdge.getDownLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                if (a.isInfoEnabled()) {
                    a.info("osw {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOswEdge));
                }
                if (CollectionUtils.isEmpty((Collection)oswOswEdge.getBlockedVlans())) {
                    OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOswEdge.getDownLink().getStandardOswPort());
                    b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                }
                return;
            }
        }
        OswOswEdge edge = new OswOswEdge(b.c(oswNode.getMac(), targetNode), port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(targetNode.getMac(), oswNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        Port upLink = edge.getUpLink();
        if (upLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(upLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        multiOswEdge.getEdges().add(edge);
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, MultiOswNode multiOswNode, OswNode oswNode, MultiOswNode targetMultiOsw, OswNode targetNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        if (Objects.isNull(multiOswNode) || Objects.isNull(targetMultiOsw)) {
            return;
        }
        if (multiOswNode.getMacToNodeMap().keySet().containsAll(targetMultiOsw.getMacToNodeMap().keySet()) && targetMultiOsw.getMacToNodeMap().keySet().containsAll(multiOswNode.getMacToNodeMap().keySet())) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetMultiOsw);
        if (!Objects.isNull(optEdge1)) {
            MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge1;
            List edges = multiOswEdge.getEdges().stream().filter(edge1 -> Objects.equals(edge1.getFromNodeMac(), oswNode.getMac()) && Objects.equals(edge1.getToNodeMac(), targetNode.getMac())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(edges)) {
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : edges) {
                    OswOswEdge oswOswEdge = (OswOswEdge)e2;
                    if (Objects.isNull(oswOswEdge.getUpLink()) || !Objects.equals(oswOswEdge.getUpLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                    if (a.isInfoEnabled()) {
                        a.info("multiOswMem {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOswEdge));
                    }
                    if (CollectionUtils.isEmpty((Collection)oswOswEdge.getBlockedVlans())) {
                        OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOswEdge.getUpLink().getStandardOswPort());
                        b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                    }
                    return;
                }
            }
            OswOswEdge edge = new OswOswEdge(port, b.c(oswNode.getMac(), targetNode));
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
            OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
            b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            Port downLink = edge.getDownLink();
            if (downLink != null) {
                OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
                b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            }
            multiOswEdge.getEdges().add(edge);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetMultiOsw, (Object)multiOswNode);
        if (Objects.isNull(optEdge2)) {
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and multiOsw:{}, stop discoverMultiOswMultiOswLoopEdge", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr(targetMultiOsw.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge2;
        List edges = multiOswEdge.getEdges().stream().filter(edge1 -> Objects.equals(edge1.getFromNodeMac(), targetNode.getMac()) && Objects.equals(edge1.getToNodeMac(), oswNode.getMac())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(edges)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e3 : edges) {
                OswOswEdge oswOswEdge = (OswOswEdge)e3;
                if (Objects.isNull(oswOswEdge.getDownLink()) || !Objects.equals(oswOswEdge.getDownLink().getStandardOswPort(), port.getStandardOswPort())) continue;
                if (a.isInfoEnabled()) {
                    a.info("multiOswMem {} and multiOswMem {} connected abnormally during calculating, edge = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswOswEdge));
                }
                if (CollectionUtils.isEmpty((Collection)oswOswEdge.getBlockedVlans())) {
                    OswStpPortInfo stpPortInfo = (OswStpPortInfo)((Map)Optional.ofNullable(oswNode.getStpPortInfoMap()).orElse(new HashMap())).get(oswOswEdge.getDownLink().getStandardOswPort());
                    b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)oswOswEdge);
                }
                return;
            }
        }
        OswOswEdge edge = new OswOswEdge(b.c(oswNode.getMac(), targetNode), port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(targetNode.getMac(), oswNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        Port upLink = edge.getUpLink();
        if (upLink != null) {
            OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(upLink.getStandardOswPort()))).orElse(null);
            b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        multiOswEdge.getEdges().add(edge);
    }

    private static void b(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, OswNode oswNode, List<Port> partialBlockedPorts, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        for (Port port : partialBlockedPorts) {
            Optional.ofNullable(port.getLldpNeighbors()).orElseGet(() -> new HashSet()).stream().forEach(neighborDTO -> {
                String type;
                switch (type = neighborDTO.getType()) {
                    case "switch": {
                        b.h(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                        break;
                    }
                    case "gateway": {
                        b.g(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                        break;
                    }
                    case "ap": {
                        b.f(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                        break;
                    }
                    case "olt": {
                        b.e(topology, topologyDevices, neighborDTO, oswNode, port, stpLoopInfoDTOMap);
                    }
                }
            });
        }
    }

    private static void e(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OltOswEdge edge;
        OswOltEdge edge2;
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        if (CollectionUtils.isEmpty(oltMap)) {
            return;
        }
        OltNode targetNode = oltMap.get(neighborDTO.getMac());
        if (targetNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            MultiOswNode multiOswNode = topologyDevices.getMlagOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and olt:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            MultiOswNode multiOswNode = topologyDevices.getVrrpOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and olt:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1) && Objects.equals(Optional.ofNullable((edge2 = (OswOltEdge)optEdge1).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)oswNode);
        if (!Objects.isNull(optEdge2) && Objects.equals(Optional.ofNullable((edge = (OltOswEdge)optEdge2).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        edge = new OswOltEdge(port);
        Map lldpPortMap = targetNode.getLldpPortMap();
        if (lldpPortMap != null && lldpPortMap.get(oswNode.getMac()) != null) {
            Port downLink = new Port();
            downLink.setStandardOswPort((String)lldpPortMap.get(oswNode.getMac()));
            edge.setDownLink(downLink);
        }
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void f(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OswApEdge edge;
        OswApEdge edge2;
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap)) {
            return;
        }
        ApNode targetNode = apMap.get(neighborDTO.getMac());
        if (targetNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            MultiOswNode multiOswNode = topologyDevices.getMlagOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and ap:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            MultiOswNode multiOswNode = topologyDevices.getVrrpOswMap().get(oswNode.getMac());
            if (Objects.isNull(multiOswNode)) {
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)targetNode);
            if (!Objects.isNull(optEdge)) {
                b.b(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge, stpLoopInfoDTOMap);
                return;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)multiOswNode);
            if (!Objects.isNull(optEdge1)) {
                b.a(topology, topologyDevices, multiOswNode, oswNode, port, targetNode, optEdge1, stpLoopInfoDTOMap);
                return;
            }
            if (a.isDebugEnabled()) {
                a.debug("fail to find edge between multiOsw:{} and ap:{}", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1) && Objects.equals(Optional.ofNullable((edge2 = (OswApEdge)optEdge1).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)oswNode);
        if (!Objects.isNull(optEdge2) && Objects.equals(Optional.ofNullable((edge = (OswApEdge)optEdge2).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        if (a.isInfoEnabled()) {
            a.info("osw {} and ap {} didn't connect during calculating", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
        }
        edge = new OswApEdge(port, b.a(oswNode.getMac(), targetNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
        OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
        b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void g(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OsgOswEdge edge;
        OsgNode osg = topologyDevices.getOsg();
        if (osg == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(topology, topologyDevices.getOsg(), topologyDevices.getMlagOswMap().get(oswNode.getMac()), oswNode, port, stpLoopInfoDTOMap);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(topology, topologyDevices.getOsg(), topologyDevices.getVrrpOswMap().get(oswNode.getMac()), oswNode, port, stpLoopInfoDTOMap);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)osg, (Object)oswNode);
        if (!Objects.isNull(optEdge) && Objects.equals(Optional.ofNullable((edge = (OsgOswEdge)optEdge).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        if (a.isInfoEnabled()) {
            a.info("osg {} and osw {} didn't connect during calculating", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
        }
        edge = new OsgOswEdge(port);
        if (Objects.nonNull(osg.getLldpPortMap()) && osg.getLldpPortMap().containsKey(oswNode.getMac())) {
            Integer osgPortId = (Integer)osg.getLldpPortMap().get(oswNode.getMac());
            Port osgPort = new Port();
            osgPort.setPortId(osgPortId.intValue());
            edge.setUpLink(osgPort);
        }
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.b.a());
        edge.setFromNodeAndToNode(osg.getMac(), oswNode.getMac());
        OswStpPortInfo stpDownPortInfo = Optional.ofNullable(oswNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(port.getStandardOswPort()))).orElse(null);
        b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
    }

    private static void h(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO, OswNode oswNode, Port port, Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap) {
        OswOswEdge edge;
        OswOswEdge edge2;
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        if (CollectionUtils.isEmpty(oswMap)) {
            return;
        }
        OswNode targetNode = oswMap.get(neighborDTO.getMac());
        if (targetNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) || Boolean.TRUE.equals(oswNode.getVrrpMem()) || Boolean.TRUE.equals(targetNode.getMlagMem()) || Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            b.a(topology, topologyDevices, oswNode, targetNode, port, stpLoopInfoDTOMap);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge1 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)targetNode);
        if (!Objects.isNull(optEdge1) && Objects.equals(Optional.ofNullable((edge2 = (OswOswEdge)optEdge1).getUpLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge2);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetNode, (Object)oswNode);
        if (!Objects.isNull(optEdge2) && Objects.equals(Optional.ofNullable((edge = (OswOswEdge)optEdge2).getDownLink()).map(Port::getStandardOswPort).orElse(null), port.getStandardOswPort())) {
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a existEdge = b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)targetNode);
        if (existEdge != null) {
            if (a.isDebugEnabled()) {
                a.debug("osw1:{} and osw2:{} edge already exists, use the same edge", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            b.a(stpLoopInfoDTOMap, oswNode, existEdge);
        } else {
            if (a.isInfoEnabled()) {
                a.info("osw1 {} and osw2 {} didn't connect during calculating", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()));
            }
            OswOswEdge edge3 = new OswOswEdge(port, b.c(oswNode.getMac(), targetNode));
            edge3.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
            edge3.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
            OswStpPortInfo stpUpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
            b.a(stpUpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge3);
            Port downLink = edge3.getDownLink();
            if (downLink != null) {
                OswStpPortInfo stpDownPortInfo = Optional.ofNullable(targetNode.getStpPortInfoMap()).flatMap(m2 -> Optional.ofNullable((OswStpPortInfo)m2.get(downLink.getStandardOswPort()))).orElse(null);
                b.a(stpDownPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge3);
            }
            b.a(stpLoopInfoDTOMap, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge3);
        }
    }

    private static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a a(Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap, OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a targetNode) {
        if (!Objects.equals(targetNode, "switch")) {
            return null;
        }
        StpLoopInfoDTO loopInfoDTO = stpLoopInfoDTOMap.get(targetNode.getMac());
        if (loopInfoDTO == null || CollectionUtils.isEmpty((Collection)loopInfoDTO.getEdges())) {
            return null;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : loopInfoDTO.getEdges()) {
            if (!Objects.equals(edge.getFromNodeMac(), targetNode.getMac()) || !Objects.equals(edge.getToNodeMac(), oswNode.getMac())) continue;
            return edge;
        }
        return null;
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> nodes) {
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a current : nodes) {
            List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> disconnectedPath;
            HashSet<String> visited;
            Set inEdges;
            if (Boolean.TRUE.equals(current.getDetected())) {
                inEdges = disconnectedTopology.inEdges((Object)current);
                if (CollectionUtils.isEmpty((Collection)inEdges)) {
                    visited = new HashSet<String>();
                    b.a(topology, disconnectedTopology, current, visited);
                    continue;
                }
                List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> disconnectedPath2 = b.b(topology, disconnectedTopology, current, null);
                b.a(topology, disconnectedTopology, disconnectedPath2);
                continue;
            }
            inEdges = disconnectedTopology.inEdges((Object)current);
            if (CollectionUtils.isEmpty((Collection)inEdges)) {
                visited = new HashSet();
                b.a(topology, disconnectedTopology, current, visited);
                continue;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
            if (!nodes.contains(disconnectedTopology.incidentNodes((Object)inEdge).nodeU())) {
                disconnectedPath = b.b(topology, disconnectedTopology, current, null);
                b.a(topology, disconnectedTopology, disconnectedPath);
            }
            if (Boolean.TRUE.equals(current.getDetected()) || !Boolean.TRUE.equals(((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)disconnectedTopology.incidentNodes((Object)inEdge).nodeU()).getDetected())) continue;
            disconnectedPath = b.b(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)disconnectedTopology.incidentNodes((Object)inEdge).nodeU(), current);
            b.a(topology, disconnectedTopology, disconnectedPath);
            Set successors = disconnectedTopology.successors((Object)current);
            if (CollectionUtils.isEmpty((Collection)successors)) continue;
            HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> newNodes = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>(successors);
            newNodes.add(current);
            b.a(topology, disconnectedTopology, newNodes);
        }
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a current, Set<String> visited) {
        Set successors;
        if (current instanceof MultiOswNode) {
            MultiOswNode multiOswNode = (MultiOswNode)current;
            if (visited.containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                return;
            }
            visited.addAll(multiOswNode.getMacToNodeMap().keySet());
        } else {
            if (visited.contains(current.getMac())) {
                return;
            }
            visited.add(current.getMac());
        }
        current.setDetected(Boolean.valueOf(true));
        if (!topology.nodes().contains(current)) {
            topology.addNode((Object)current);
        }
        if (CollectionUtils.isEmpty((Collection)(successors = disconnectedTopology.successors((Object)current)))) {
            return;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor : successors) {
            if (!topology.nodes().contains(successor)) {
                topology.addNode((Object)successor);
            }
            disconnectedTopology.edgesConnecting((Object)current, (Object)successor).forEach(edge -> {
                if (edge instanceof MultiOswEdge) {
                    MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
                    b.a(multiOswEdge, topology, current, successor);
                }
                if (CollectionUtils.isEmpty((Collection)topology.predecessors((Object)successor)) && !topology.hasEdgeConnecting((Object)successor, (Object)current)) {
                    topology.addEdge((Object)current, (Object)successor, edge);
                    if (a.isDebugEnabled()) {
                        a.debug("addDisconnectedTopo: add disconnectedEdge:{}", (Object)PIIJacksonUtil.parseToStr((Object)edge));
                    }
                }
            });
            b.a(topology, disconnectedTopology, successor, visited);
        }
    }

    public static MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> a(Map<String, PersistenceNodeDTO> disconnectedNodes, Map<String, PersistenceNodeDTO> forgetNodes, TopologyDevices topologyDevices) {
        MutableNetwork result = NetworkBuilder.directed().allowsParallelEdges(true).build();
        for (PersistenceNodeDTO discNode : disconnectedNodes.values()) {
            result.addNode((Object)discNode.getNode());
            discNode.setPreHandle(true);
            if (!CollectionUtils.isEmpty(discNode.getOutEdges())) {
                b.a(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)result, disconnectedNodes, forgetNodes, discNode);
            }
            HashSet<String> visitedMacs = new HashSet<String>();
            if (CollectionUtils.isEmpty(discNode.getInEdges())) continue;
            b.a(topologyDevices, (MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)result, disconnectedNodes, forgetNodes, discNode, visitedMacs);
        }
        return result;
    }

    private static void a(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, Map<String, PersistenceNodeDTO> disconnectedNodes, Map<String, PersistenceNodeDTO> forgetNodes, PersistenceNodeDTO currentNode, Set<String> visitedMacs) {
        if (currentNode == null || CollectionUtils.isEmpty(currentNode.getInEdges()) || visitedMacs.contains(currentNode.getMac())) {
            return;
        }
        visitedMacs.add(currentNode.getMac());
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge : currentNode.getInEdges()) {
            inEdge.setOfflineType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a());
            String fromMac = inEdge.getFromNodeMac();
            if (disconnectedNodes.containsKey(fromMac)) {
                MultiOswNode multiOswNode;
                PersistenceNodeDTO fromDTO = disconnectedNodes.get(fromMac);
                if (disconnectedTopology.addNode((Object)fromDTO.getNode())) {
                    fromDTO.setPreHandle(true);
                }
                if (!disconnectedTopology.hasEdgeConnecting((Object)fromDTO.getNode(), (Object)currentNode.getNode())) {
                    disconnectedTopology.addEdge((Object)fromDTO.getNode(), (Object)currentNode.getNode(), (Object)inEdge);
                }
                b.a(currentNode.getNode(), inEdge);
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a2 = fromDTO.getNode();
                if (a2 instanceof MultiOswNode && !Boolean.TRUE.equals((multiOswNode = (MultiOswNode)a2).getAllMemOffline())) continue;
                b.a(topologyDevices, disconnectedTopology, disconnectedNodes, forgetNodes, fromDTO, visitedMacs);
                continue;
            }
            if (forgetNodes.containsKey(fromMac)) {
                PersistenceNodeDTO forgetNode = forgetNodes.get(fromMac);
                if (Boolean.TRUE.equals(forgetNode.getPreHandle())) continue;
                forgetNode.setPreHandle(true);
                List<PersistenceNodeDTO> lastNotForgetNodes = b.a(currentNode.getNode(), forgetNode, forgetNodes, disconnectedNodes, topologyDevices, disconnectedTopology);
                if (CollectionUtils.isEmpty(lastNotForgetNodes)) continue;
                for (PersistenceNodeDTO lastNotForgetNode : lastNotForgetNodes) {
                    DisconnectedEdge newEdge = new DisconnectedEdge(lastNotForgetNode.getNode().getMac(), currentNode.getNode().getMac(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a());
                    if (!disconnectedTopology.hasEdgeConnecting((Object)lastNotForgetNode.getNode(), (Object)currentNode.getNode())) {
                        disconnectedTopology.addEdge((Object)lastNotForgetNode.getNode(), (Object)currentNode.getNode(), (Object)newEdge);
                        lastNotForgetNode.setPreHandle(true);
                    }
                    if (!disconnectedTopology.nodes().contains(lastNotForgetNode.getNode())) {
                        disconnectedTopology.addNode((Object)lastNotForgetNode.getNode());
                        lastNotForgetNode.setPreHandle(true);
                    }
                    b.a(topologyDevices, disconnectedTopology, disconnectedNodes, forgetNodes, lastNotForgetNode, visitedMacs);
                }
                continue;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a onlineNode = com.tplink.smb.omada.manager.topology.domain.discovery.a.a(fromMac, topologyDevices);
            if (onlineNode == null || disconnectedTopology.hasEdgeConnecting((Object)onlineNode, (Object)currentNode.getNode())) continue;
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a newInEdge = b.a(inEdge, onlineNode, currentNode.getNode());
            if (Objects.isNull(newInEdge)) {
                b.a(currentNode.getNode(), inEdge);
                disconnectedTopology.addEdge((Object)onlineNode, (Object)currentNode.getNode(), (Object)inEdge);
                continue;
            }
            b.a(currentNode.getNode(), newInEdge);
            disconnectedTopology.addEdge((Object)onlineNode, (Object)currentNode.getNode(), (Object)newInEdge);
        }
    }

    private static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a onlineNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node) {
        if (onlineNode instanceof MultiOswNode) {
            MultiOswNode multiOswNode = (MultiOswNode)onlineNode;
            if (!(inEdge instanceof MultiOswEdge)) {
                if (a.isInfoEnabled()) {
                    a.info("updateInEdge to multiEdge for disc topo, inEdge:{}, onLineNode:{}, disc node:{}", (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr((Object)onlineNode), (Object)PIIJacksonUtil.parseToStr((Object)node));
                }
                MultiOswEdge newInEdge = new MultiOswEdge();
                newInEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
                newInEdge.getToNodeMacs().add(node.getMac());
                newInEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
                newInEdge.setFromNodeMac(multiOswNode.getMac());
                newInEdge.setToNodeMac(node.getMac());
                newInEdge.getEdges().add(inEdge);
                return newInEdge;
            }
        }
        if (onlineNode instanceof OswNode) {
            OswNode oswNode = (OswNode)onlineNode;
            if (inEdge instanceof MultiOswEdge) {
                MultiOswEdge multiOswEdge = (MultiOswEdge)inEdge;
                if (!(node instanceof MultiOswNode)) {
                    com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge;
                    if (a.isInfoEnabled()) {
                        a.info("updateInEdge to ordinaryEdge for disc topo, inEdge:{}, onLineNode:{}, disc node:{}", (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr((Object)onlineNode), (Object)PIIJacksonUtil.parseToStr((Object)node));
                    }
                    if (Objects.isNull(edge = b.a(multiOswEdge, oswNode, node))) {
                        if (a.isInfoEnabled()) {
                            a.info("fail to find edge from multiOswEdge:{}, osw:{}, node:{}", (Object)PIIJacksonUtil.parseToStr((Object)multiOswEdge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)node.getMac()));
                        }
                        BaseOswEdge newInEdge = new BaseOswEdge(b.c(node.getMac(), oswNode));
                        newInEdge.setFromNodeAndToNode(oswNode.getMac(), node.getMac());
                        newInEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
                        return newInEdge;
                    }
                    return edge;
                }
            }
        }
        return null;
    }

    private static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a a(MultiOswEdge multiOswEdge, OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node) {
        if (CollectionUtils.isEmpty((Collection)multiOswEdge.getEdges())) {
            return null;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
            if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), node.getMac())) continue;
            return edge;
        }
        return null;
    }

    private static void a(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, Map<String, PersistenceNodeDTO> disconnectedNodes, Map<String, PersistenceNodeDTO> forgetNodes, PersistenceNodeDTO currentNode) {
        if (currentNode == null || CollectionUtils.isEmpty(currentNode.getOutEdges())) {
            return;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a outEdge : currentNode.getOutEdges()) {
            outEdge.setOfflineType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a());
            String toMac = outEdge.getToNodeMac();
            if (disconnectedNodes.containsKey(toMac)) {
                MultiOswNode multiOswNode;
                PersistenceNodeDTO toDTO = disconnectedNodes.get(toMac);
                if (Boolean.TRUE.equals(toDTO.getPreHandle())) continue;
                if (disconnectedTopology.addNode((Object)toDTO.getNode())) {
                    toDTO.setPreHandle(true);
                }
                if (!disconnectedTopology.hasEdgeConnecting((Object)currentNode.getNode(), (Object)toDTO.getNode())) {
                    disconnectedTopology.addEdge((Object)currentNode.getNode(), (Object)toDTO.getNode(), (Object)outEdge);
                }
                b.a(currentNode.getNode(), outEdge);
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a2 = toDTO.getNode();
                if (a2 instanceof MultiOswNode && !Boolean.TRUE.equals((multiOswNode = (MultiOswNode)a2).getAllMemOffline())) continue;
                b.a(topologyDevices, disconnectedTopology, disconnectedNodes, forgetNodes, toDTO);
                continue;
            }
            if (forgetNodes.containsKey(toMac)) {
                PersistenceNodeDTO forgetNode = forgetNodes.get(toMac);
                if (Boolean.TRUE.equals(forgetNode.getPreHandle())) continue;
                forgetNode.setPreHandle(true);
                List<PersistenceNodeDTO> nextNotForgetNodes = b.b(currentNode.getNode(), forgetNode, forgetNodes, disconnectedNodes, topologyDevices, disconnectedTopology);
                if (CollectionUtils.isEmpty(nextNotForgetNodes)) continue;
                for (PersistenceNodeDTO nextNotForgetNode : nextNotForgetNodes) {
                    if (Boolean.TRUE.equals(nextNotForgetNode.getPreHandle())) continue;
                    DisconnectedEdge newEdge = new DisconnectedEdge(currentNode.getNode().getMac(), nextNotForgetNode.getNode().getMac(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a());
                    if (!disconnectedTopology.hasEdgeConnecting((Object)currentNode.getNode(), (Object)nextNotForgetNode.getNode())) {
                        disconnectedTopology.addEdge((Object)currentNode.getNode(), (Object)nextNotForgetNode.getNode(), (Object)newEdge);
                        nextNotForgetNode.setPreHandle(true);
                    }
                    if (!disconnectedTopology.nodes().contains(nextNotForgetNode.getNode())) {
                        disconnectedTopology.addNode((Object)nextNotForgetNode.getNode());
                        nextNotForgetNode.setPreHandle(true);
                    }
                    b.a(topologyDevices, disconnectedTopology, disconnectedNodes, forgetNodes, nextNotForgetNode);
                }
                continue;
            }
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a onlineNode = com.tplink.smb.omada.manager.topology.domain.discovery.a.a(toMac, topologyDevices);
            if (onlineNode == null || disconnectedTopology.hasEdgeConnecting((Object)currentNode.getNode(), (Object)onlineNode)) continue;
            b.a(currentNode.getNode(), outEdge);
            disconnectedTopology.addEdge((Object)currentNode.getNode(), (Object)onlineNode, (Object)outEdge);
        }
    }

    private static void a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a currentOfflineNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge) {
        if (!(edge instanceof MultiOswEdge)) {
            return;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
        List edges = multiOswEdge.getEdges();
        if (CollectionUtils.isEmpty((Collection)edges)) {
            return;
        }
        if (!(currentOfflineNode instanceof MultiOswNode)) {
            edges.forEach(e2 -> e2.setOfflineType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a()));
            return;
        }
        MultiOswNode multiOswNode = (MultiOswNode)currentOfflineNode;
        HashSet offlineMembers = new HashSet();
        multiOswNode.getMacToNodeMap().forEach((mac, oswNode) -> {
            if (Objects.equals(DeviceStatusEnum.a.n(), oswNode.getStatus())) {
                offlineMembers.add(oswNode.getMac());
            }
        });
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a abstractEdge : edges) {
            if (!offlineMembers.contains(abstractEdge.getFromNodeMac()) && !offlineMembers.contains(abstractEdge.getToNodeMac())) continue;
            abstractEdge.setOfflineType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a());
        }
    }

    private static List<PersistenceNodeDTO> a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a disconnectedNode, PersistenceNodeDTO forgetNode, Map<String, PersistenceNodeDTO> forgetNodes, Map<String, PersistenceNodeDTO> disconnectedNodes, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology) {
        Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> inEdges = forgetNodes.get(forgetNode.getMac()).getInEdges();
        if (CollectionUtils.isEmpty(inEdges)) {
            forgetNode.setPreHandle(true);
            return null;
        }
        ArrayList<PersistenceNodeDTO> result = new ArrayList<PersistenceNodeDTO>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge : inEdges) {
            DisconnectedEdge newEdge;
            if (disconnectedNodes.containsKey(inEdge.getFromNodeMac())) {
                result.add(disconnectedNodes.get(inEdge.getFromNodeMac()));
                continue;
            }
            if (forgetNodes.containsKey(inEdge.getFromNodeMac()) && !Boolean.TRUE.equals(forgetNodes.get(inEdge.getFromNodeMac()).getPreHandle())) {
                List<PersistenceNodeDTO> lastNotForgetNodes = b.a(disconnectedNode, forgetNodes.get(inEdge.getFromNodeMac()), forgetNodes, disconnectedNodes, topologyDevices, disconnectedTopology);
                if (CollectionUtils.isEmpty(lastNotForgetNodes)) continue;
                lastNotForgetNodes.stream().forEach(persistenceNodeDTO -> result.add((PersistenceNodeDTO)persistenceNodeDTO));
                continue;
            }
            if (disconnectedNodes.containsKey(inEdge.getFromNodeMac()) || forgetNodes.containsKey(inEdge.getFromNodeMac())) continue;
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a connNode = com.tplink.smb.omada.manager.topology.domain.discovery.a.a(inEdge.getFromNodeMac(), topologyDevices);
            if (topologyDevices.isEmpty() || Objects.isNull(connNode) || Objects.isNull(newEdge = new DisconnectedEdge(connNode.getMac(), disconnectedNode.getMac(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a()))) continue;
            disconnectedTopology.addEdge((Object)connNode, (Object)disconnectedNode, (Object)newEdge);
        }
        return result;
    }

    private static List<PersistenceNodeDTO> b(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a disconnectedNode, PersistenceNodeDTO forgetNode, Map<String, PersistenceNodeDTO> forgetNodes, Map<String, PersistenceNodeDTO> disconnectedNodes, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology) {
        Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> outEdges = forgetNodes.get(forgetNode.getMac()).getOutEdges();
        if (CollectionUtils.isEmpty(outEdges)) {
            forgetNode.setPreHandle(true);
            return null;
        }
        ArrayList<PersistenceNodeDTO> result = new ArrayList<PersistenceNodeDTO>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a outEdge : outEdges) {
            DisconnectedEdge newEdge;
            if (disconnectedNodes.containsKey(outEdge.getToNodeMac()) && !Boolean.TRUE.equals(disconnectedNodes.get(outEdge.getToNodeMac()).getPreHandle())) {
                result.add(disconnectedNodes.get(outEdge.getToNodeMac()));
                continue;
            }
            if (forgetNodes.containsKey(outEdge.getToNodeMac()) && !Boolean.TRUE.equals(forgetNodes.get(outEdge.getToNodeMac()).getPreHandle())) {
                List<PersistenceNodeDTO> nextNotForgetNodes = b.b(disconnectedNode, forgetNodes.get(outEdge.getToNodeMac()), forgetNodes, disconnectedNodes, topologyDevices, disconnectedTopology);
                if (CollectionUtils.isEmpty(nextNotForgetNodes)) continue;
                nextNotForgetNodes.stream().forEach(persistenceNodeDTO -> result.add((PersistenceNodeDTO)persistenceNodeDTO));
                continue;
            }
            if (disconnectedNodes.containsKey(outEdge.getToNodeMac()) || forgetNodes.containsKey(outEdge.getToNodeMac())) continue;
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a connNode = com.tplink.smb.omada.manager.topology.domain.discovery.a.a(outEdge.getToNodeMac(), topologyDevices);
            if (topologyDevices.isEmpty() || Objects.isNull(connNode) || Objects.isNull(newEdge = new DisconnectedEdge(connNode.getMac(), disconnectedNode.getMac(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a()))) continue;
            disconnectedTopology.addEdge((Object)disconnectedNode, (Object)connNode, (Object)newEdge);
        }
        return result;
    }

    private static List<ApNode> b(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology) {
        ArrayList<ApNode> apNodes = new ArrayList<ApNode>();
        ArrayList<ApNode> secondApNodes = new ArrayList<ApNode>();
        if (CollectionUtils.isEmpty(topologyDevices.getApMap())) {
            return apNodes;
        }
        if (CollectionUtils.isEmpty(topologyDevices.getOtherMap()) && Objects.isNull(disconnectedTopology)) {
            return new ArrayList<ApNode>(topologyDevices.getApMap().values());
        }
        if (!CollectionUtils.isEmpty(topologyDevices.getOtherMap())) {
            for (ApNode apNode2 : topologyDevices.getApMap().values()) {
                boolean hasDetectedOtherNeighbor = ((Set)Optional.ofNullable(apNode2.getNeighbors()).orElse(new HashSet())).stream().anyMatch(lldpNeighborDTO -> T.a((String)"other", (String)lldpNeighborDTO.getType()) && Objects.nonNull(topologyDevices.getOtherMap().get(lldpNeighborDTO.getMac())) && Boolean.TRUE.equals(topologyDevices.getOtherMap().get(lldpNeighborDTO.getMac()).getDetected()));
                if (hasDetectedOtherNeighbor) {
                    apNodes.add(apNode2);
                    continue;
                }
                secondApNodes.add(apNode2);
            }
            if (!Objects.isNull(disconnectedTopology)) {
                Collections.sort(secondApNodes, Comparator.comparingInt(o2 -> disconnectedTopology.nodes().contains(o2) ? 0 : 1));
            }
            apNodes.addAll(secondApNodes);
        } else {
            topologyDevices.getApMap().values().forEach(apNode -> {
                if (disconnectedTopology.nodes().contains(apNode)) {
                    apNodes.add((ApNode)apNode);
                } else {
                    secondApNodes.add((ApNode)apNode);
                }
            });
            apNodes.addAll(secondApNodes);
        }
        return apNodes;
    }

    private static void a(TopologyDevices topologyDevices) {
        Set<String> apMacs = b.b(topologyDevices);
        if (CollectionUtils.isEmpty(apMacs)) {
            return;
        }
        Optional.ofNullable(topologyDevices.getOsg()).ifPresent(osgNode -> ((Set)Optional.ofNullable(osgNode.getNeighbors()).orElse(new HashSet())).removeIf(lldpNeighborDTO -> apMacs.contains(lldpNeighborDTO.getMac())));
        ((Map)Optional.ofNullable(topologyDevices.getOswMap()).orElse(new HashMap())).forEach((k2, v2) -> {
            if (CollectionUtils.isEmpty((Collection)v2.getPorts())) {
                return;
            }
            v2.getPorts().forEach(port -> {
                if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) {
                    return;
                }
                port.getLldpNeighbors().forEach(lldp -> {
                    if (apMacs.contains(lldp.getMac())) {
                        lldp.setDetected(Boolean.valueOf(true));
                    }
                });
            });
        });
        ((Map)Optional.ofNullable(topologyDevices.getApMap()).orElse(new HashMap())).forEach((k2, v2) -> {
            if (CollectionUtils.isEmpty((Collection)v2.getNeighbors())) {
                return;
            }
            v2.getNeighbors().forEach(lldpNeighborDTO -> {
                if (apMacs.contains(lldpNeighborDTO.getMac())) {
                    lldpNeighborDTO.setDetected(Boolean.valueOf(true));
                }
            });
        });
        b.a(topologyDevices, apMacs);
    }

    private static Set<String> b(TopologyDevices topologyDevices) {
        if (CollectionUtils.isEmpty(topologyDevices.getOltMap())) {
            return new HashSet<String>();
        }
        HashSet<String> apMacs = new HashSet<String>();
        topologyDevices.getOltMap().forEach((k2, v2) -> {
            if (CollectionUtils.isEmpty((Collection)v2.getNeighbors())) {
                return;
            }
            apMacs.addAll(v2.getNeighbors().stream().filter(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getType(), "ap") && Boolean.TRUE.equals(lldpNeighborDTO.getIsFiberOptic())).map(LLDPNeighborDTO::getMac).collect(Collectors.toList()));
        });
        return apMacs;
    }

    private static void a(TopologyDevices topologyDevices, Set<String> apMacs) {
        ((Map)Optional.ofNullable(topologyDevices.getOtherMap()).orElse(new HashMap())).forEach((k2, v2) -> {
            if (CollectionUtils.isEmpty((Collection)v2.getLldpNeighbors())) {
                return;
            }
            v2.getLldpNeighbors().forEach(lldpNeighborDTO -> {
                if (apMacs.contains(lldpNeighborDTO.getMac())) {
                    lldpNeighborDTO.setDetected(Boolean.valueOf(true));
                }
            });
        });
    }

    private static void c(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        a.debug("start discovery oswes.");
        HashMap<String, OswNode> unDiscoveryOsws = new HashMap<String, OswNode>(topologyDevices.getOswMap());
        topologyDevices.a(topologyDevices.getOswMap().keySet());
        List<OswNode> vfSwitchList = b.b(unDiscoveryOsws);
        OsgNode osg = topologyDevices.getOsg();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode = topologyDevices.getOmadacNode();
        if (osg != null) {
            topology.addNode((Object)osg);
            b.a(unDiscoveryOsws, topologyDevices, topology);
            if (CollectionUtils.isEmpty(unDiscoveryOsws)) {
                return;
            }
            b.a(vfSwitchList, topologyDevices, unDiscoveryOsws, topology);
            if (CollectionUtils.isEmpty(unDiscoveryOsws)) {
                return;
            }
        } else if (topologyDevices.getRootNode() != null) {
            b.a(topologyDevices, unDiscoveryOsws, topology);
        }
        HashSet<String> detectedFlagNodes = new HashSet<String>();
        OswNode lastFlagNode = null;
        while (!CollectionUtils.isEmpty(unDiscoveryOsws)) {
            OswNode flagNode = null;
            OswNode backUpVrrpMemFlagNode = null;
            OswNode backUpMlagMemFlagNode = null;
            OswNode backUpFlagNode = null;
            for (Map.Entry entry2 : unDiscoveryOsws.entrySet()) {
                OswNode oswNode = (OswNode)entry2.getValue();
                if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                    backUpVrrpMemFlagNode = oswNode;
                    break;
                }
                if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                    backUpMlagMemFlagNode = oswNode;
                    continue;
                }
                backUpFlagNode = oswNode;
            }
            flagNode = !Objects.isNull(backUpVrrpMemFlagNode) ? backUpVrrpMemFlagNode : (!Objects.isNull(backUpMlagMemFlagNode) ? backUpMlagMemFlagNode : backUpFlagNode);
            flagNode.setDetected(Boolean.valueOf(true));
            ArrayList<String> flagMacs = new ArrayList<String>();
            boolean flagByMultiOsw = b.a(topology, topologyDevices, flagNode, flagMacs);
            lastFlagNode = flagNode;
            unDiscoveryOsws.remove(flagNode.getMac());
            Map<String, OswNode> discoveryOsws = b.a(flagMacs, unDiscoveryOsws, flagByMultiOsw);
            b.a(flagNode, unDiscoveryOsws, discoveryOsws, topologyDevices, topology);
            if (CollectionUtils.isEmpty(unDiscoveryOsws)) break;
            List<OswNode> discoveryVfOsws = discoveryOsws.entrySet().stream().filter(entry -> Boolean.TRUE.equals(((OswNode)entry.getValue()).getSupportVf())).map(Map.Entry::getValue).collect(Collectors.toList());
            b.a(discoveryVfOsws, topologyDevices, unDiscoveryOsws, topology);
            if (detectedFlagNodes.contains(flagNode.getMac()) || CollectionUtils.isEmpty((Collection)flagNode.getPorts())) continue;
            detectedFlagNodes.add(flagNode.getMac());
            for (Port port : flagNode.getPorts()) {
                if (CollectionUtils.isEmpty((Collection)port.getFdbMacs())) continue;
                a.debug("discovery by flagNode, switch mac:{}, port:{}", (Object)flagNode.getMac(), (Object)port);
                b.b(flagNode, port, topologyDevices, topology);
            }
        }
        if (Objects.nonNull(lastFlagNode) && !detectedFlagNodes.contains(lastFlagNode.getMac()) && !CollectionUtils.isEmpty((Collection)lastFlagNode.getPorts())) {
            detectedFlagNodes.add(lastFlagNode.getMac());
            for (Port port : lastFlagNode.getPorts()) {
                if (CollectionUtils.isEmpty((Collection)port.getFdbMacs())) continue;
                a.debug("discovery by lastFlagNode, switch mac:{}, port:{}", (Object)lastFlagNode.getMac(), (Object)port);
                b.b(lastFlagNode, port, topologyDevices, topology);
            }
        }
    }

    private static boolean a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, OswNode flagNode, List<String> flagMacs) {
        MultiOswNode multiOswNode;
        if (Boolean.TRUE.equals(flagNode.getMlagMem()) && Objects.nonNull(multiOswNode = topologyDevices.getMlagOswMap().get(flagNode.getMac()))) {
            flagMacs.addAll(multiOswNode.getMacToNodeMap().keySet());
            topology.addNode((Object)multiOswNode);
            return true;
        }
        if (Boolean.TRUE.equals(flagNode.getVrrpMem()) && Objects.nonNull(multiOswNode = topologyDevices.getVrrpOswMap().get(flagNode.getMac()))) {
            flagMacs.addAll(multiOswNode.getMacToNodeMap().keySet());
            topology.addNode((Object)multiOswNode);
            return true;
        }
        topology.addNode((Object)flagNode);
        flagMacs.add(flagNode.getMac());
        return false;
    }

    private static void a(TopologyDevices topologyDevices, Port port, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Boolean.TRUE.equals(port.isDetected()) || CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("discover osw:{} old upperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        for (LLDPNeighborDTO neighborDTO : port.getLldpNeighbors()) {
            if (Boolean.TRUE.equals(neighborDTO.getStpLoopExcept())) {
                if (!a.isDebugEnabled()) continue;
                a.debug("osw:{} lldp neighbor:{} is excluded by stp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)neighborDTO));
                continue;
            }
            switch (neighborDTO.getType()) {
                case "switch": {
                    if (CollectionUtils.isEmpty(topologyDevices.getOswMap()) || !Objects.nonNull(topologyDevices.getOswMap().get(neighborDTO.getMac()))) break;
                    OswNode targetOsw = topologyDevices.getOswMap().get(neighborDTO.getMac());
                    b.a(oswNode, targetOsw, port, topologyDevices, topology);
                    break;
                }
                case "ap": {
                    ApNode targetAp = topologyDevices.getApMap().get(neighborDTO.getMac());
                    if (Objects.isNull(targetAp) || topology.nodes().contains(targetAp) && !CollectionUtils.isEmpty((Collection)topology.inEdges((Object)targetAp))) break;
                    b.a(port, targetAp, oswNode, topology, topologyDevices);
                    break;
                }
                case "olt": {
                    OltNode targetOlt = topologyDevices.getOltMap().get(neighborDTO.getMac());
                    if (Objects.isNull(targetOlt) || topology.nodes().contains(targetOlt) && !CollectionUtils.isEmpty((Collection)topology.inEdges((Object)targetOlt))) break;
                    b.a(port, targetOlt, oswNode, topology, topologyDevices);
                    break;
                }
                case "other": {
                    b.a(port, neighborDTO, oswNode, topology, topologyDevices);
                    break;
                }
                case "NVR": {
                    if (CollectionUtils.isEmpty(topologyDevices.getNvrMap()) || Objects.isNull(topologyDevices.getNvrMap().get(neighborDTO.getMac()))) {
                        return;
                    }
                    NvrNode nvrNode = topologyDevices.getNvrMap().get(neighborDTO.getMac());
                    if (topology.nodes().contains(nvrNode) && !CollectionUtils.isEmpty((Collection)topology.inEdges((Object)nvrNode))) {
                        return;
                    }
                    b.a(port, nvrNode, oswNode, topology, topologyDevices);
                    break;
                }
                case "IPC": {
                    if (CollectionUtils.isEmpty(topologyDevices.getIpcMap()) || Objects.isNull(topologyDevices.getIpcMap().get(neighborDTO.getMac()))) {
                        return;
                    }
                    IpcNode ipcNode = topologyDevices.getIpcMap().get(neighborDTO.getMac());
                    if (topology.nodes().contains(ipcNode) && !CollectionUtils.isEmpty((Collection)topology.inEdges((Object)ipcNode))) {
                        return;
                    }
                    b.a(port, ipcNode, oswNode, topology, topologyDevices);
                    break;
                }
            }
        }
    }

    private static void a(Port port, IpcNode ipcNode, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.b(oswNode, ipcNode.getMac(), topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.b(oswNode, ipcNode.getMac(), topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        OswIpcEdge edge = new OswIpcEdge();
        edge.setFromNodeAndToNode(oswNode.getMac(), ipcNode.getMac());
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.q.a());
        edge.setUpLink(port);
        topology.addEdge((Object)oswNode, (Object)ipcNode, (Object)edge);
        if (a.isDebugEnabled()) {
            a.debug("add oswIpcEdge:{} -> {} with oldUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        ipcNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(Port port, NvrNode nvrNode, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(oswNode, nvrNode.getMac(), topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(oswNode, nvrNode.getMac(), topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (topology.hasEdgeConnecting((Object)nvrNode, (Object)oswNode)) {
            return;
        }
        OswNvrEdge edge = new OswNvrEdge();
        edge.setFromNodeAndToNode(oswNode.getMac(), nvrNode.getMac());
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.p.a());
        edge.setUpLink(port);
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(oswNode.getMac()))) {
            Port downLink = new Port();
            downLink.setPortId(((Integer)nvrNode.getMacPortMap().get(oswNode.getMac())).intValue());
            edge.setDownLink(downLink);
        }
        topology.addEdge((Object)oswNode, (Object)nvrNode, (Object)edge);
        if (a.isDebugEnabled()) {
            a.debug("add oswNvrEdge:{} -> {} with oldUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        nvrNode.setDetected(Boolean.valueOf(true));
        b.a(nvrNode, topologyDevices, topology);
    }

    private static void a(Port port, LLDPNeighborDTO neighborDTO, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(oswNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), neighborDTO, topology, topologyDevices, port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(oswNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), neighborDTO, topology, topologyDevices, port);
            return;
        }
        Map<String, OtherNode> otherMap = topologyDevices.getOtherMap();
        String otherMac = neighborDTO.getMac();
        OtherNode otherNode = otherMap.computeIfAbsent(otherMac, k2 -> new OtherNode(otherMac, neighborDTO.getName()));
        if (!Objects.isNull(neighborDTO.getPortLabels())) {
            otherNode.setPortLabels(neighborDTO.getPortLabels());
        }
        if (topology.nodes().contains(otherNode) && !CollectionUtils.isEmpty((Collection)topology.inEdges((Object)otherNode))) {
            return;
        }
        if (topology.hasEdgeConnecting((Object)otherNode, (Object)oswNode)) {
            return;
        }
        BaseOswEdge edge = new BaseOswEdge(port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), otherMac);
        topology.addEdge((Object)oswNode, (Object)otherNode, (Object)edge);
        if (Boolean.TRUE.equals(b.a(topology, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)otherNode))) {
            topology.removeEdge((Object)edge);
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("add oswOtherEdge:{} -> {} with oldUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        otherNode.setDetected(Boolean.valueOf(true));
        b.a(topologyDevices, topology, otherNode);
    }

    private static void a(Port port, OltNode oltNode, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.d(oswNode, oltNode.getMac(), topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.d(oswNode, oltNode.getMac(), topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (topology.hasEdgeConnecting((Object)oltNode, (Object)oswNode)) {
            return;
        }
        OswOltEdge edge = new OswOltEdge(port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), oltNode.getMac());
        Map lldpPortMap = oltNode.getLldpPortMap();
        if (lldpPortMap != null && lldpPortMap.get(oswNode.getMac()) != null) {
            Port downLink = new Port();
            downLink.setStandardOswPort((String)lldpPortMap.get(oswNode.getMac()));
            edge.setDownLink(downLink);
        }
        topology.addEdge((Object)oswNode, (Object)oltNode, (Object)edge);
        if (Boolean.TRUE.equals(b.a(topology, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oltNode))) {
            topology.removeEdge((Object)edge);
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("add oswOltEdge:{} -> {} with oldUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        oltNode.setDetected(Boolean.valueOf(true));
        b.a(oltNode, topologyDevices, topology);
    }

    private static void a(Port port, ApNode apNode, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.c(oswNode, apNode.getMac(), topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.c(oswNode, apNode.getMac(), topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (topology.hasEdgeConnecting((Object)apNode, (Object)oswNode)) {
            return;
        }
        OswApEdge edge = new OswApEdge(port, b.a(oswNode.getMac(), apNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), apNode.getMac());
        topology.addEdge((Object)oswNode, (Object)apNode, (Object)edge);
        if (Boolean.TRUE.equals(b.a(topology, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)apNode))) {
            topology.removeEdge((Object)edge);
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("add oswApEdge:{} -> {} with oldUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        apNode.setDetected(Boolean.valueOf(true));
        b.a(apNode, topologyDevices, topology);
    }

    private static void a(OswNode oswNode, OswNode targetOsw, Port port, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OswStpPortInfo stpPortInfo;
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) && Boolean.TRUE.equals(targetOsw.getVrrpMem())) {
            b.a(topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topologyDevices.getVrrpOswMap().get(targetOsw.getMac()), topology, port, oswNode, targetOsw);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) && Boolean.TRUE.equals(targetOsw.getMlagMem())) {
            b.a(topologyDevices.getMlagOswMap().get(oswNode.getMac()), topologyDevices.getMlagOswMap().get(targetOsw.getMac()), topology, port, oswNode, targetOsw);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) && Boolean.TRUE.equals(targetOsw.getMlagMem())) {
            b.a(topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topologyDevices.getMlagOswMap().get(targetOsw.getMac()), topology, port, oswNode, targetOsw);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) && Boolean.TRUE.equals(targetOsw.getVrrpMem())) {
            b.a(topologyDevices.getMlagOswMap().get(oswNode.getMac()), topologyDevices.getVrrpOswMap().get(targetOsw.getMac()), topology, port, oswNode, targetOsw);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(topologyDevices.getMlagOswMap().get(oswNode.getMac()), targetOsw, topology, port, oswNode.getMac());
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(topologyDevices.getVrrpOswMap().get(oswNode.getMac()), targetOsw, topology, port, oswNode.getMac());
            return;
        }
        if (Boolean.TRUE.equals(targetOsw.getMlagMem())) {
            b.a(oswNode, topologyDevices.getMlagOswMap().get(targetOsw.getMac()), topology, port, targetOsw.getMac());
            return;
        }
        if (Boolean.TRUE.equals(targetOsw.getVrrpMem())) {
            b.a(oswNode, topologyDevices.getVrrpOswMap().get(targetOsw.getMac()), topology, port, targetOsw.getMac());
            return;
        }
        if (topology.nodes().contains(targetOsw) && !CollectionUtils.isEmpty((Collection)topology.inEdges((Object)targetOsw))) {
            return;
        }
        if (topology.hasEdgeConnecting((Object)targetOsw, (Object)oswNode) || Objects.equals(oswNode.getMac(), targetOsw.getMac())) {
            return;
        }
        OswOswEdge edge = new OswOswEdge(port, b.b(oswNode.getMac(), targetOsw));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetOsw.getMac());
        if (Optional.ofNullable(oswNode.getPartialBlockedPorts()).map(list -> list.contains(port)).orElse(false).booleanValue()) {
            stpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
            b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        if (edge.getDownLink() != null && Optional.ofNullable(targetOsw.getPartialBlockedPorts()).map(list -> list.contains(edge.getDownLink())).orElse(false).booleanValue()) {
            stpPortInfo = (OswStpPortInfo)targetOsw.getStpPortInfoMap().get(edge.getDownLink().getStandardOswPort());
            b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        topology.addEdge((Object)oswNode, (Object)targetOsw, (Object)edge);
        if (Boolean.TRUE.equals(b.a(topology, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)targetOsw))) {
            topology.removeEdge((Object)edge);
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("add oswOswEdge:{} -> {} with oldUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
        }
        targetOsw.setDetected(Boolean.valueOf(true));
    }

    private static void a(TopologyDevices topologyDevices, Map<String, OswNode> unDiscoveryOsws, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a rootNode = topologyDevices.getRootNode();
        rootNode.setDetected(Boolean.valueOf(true));
        topology.addNode((Object)rootNode);
        if (rootNode instanceof OswNode) {
            OswNode oswNode = (OswNode)rootNode;
            unDiscoveryOsws.remove(oswNode.getMac());
            Map<String, OswNode> discoveryOsws = b.a(Collections.singletonList(oswNode.getMac()), unDiscoveryOsws, false);
            b.a(oswNode, unDiscoveryOsws, discoveryOsws, topologyDevices, topology);
            if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) {
                return;
            }
            oswNode.getPorts().forEach(port -> {
                if (!CollectionUtils.isEmpty((Collection)port.getFdbMacs())) {
                    a.debug("discovery by rootOswNode, switch mac:{}, port:{}", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), () -> PIIJacksonUtil.parseToStr((Object)port)});
                    b.b(oswNode, port, topologyDevices, topology);
                }
            });
            return;
        }
        if (rootNode instanceof MultiOswNode) {
            MultiOswNode multiOswNode = (MultiOswNode)rootNode;
            multiOswNode.getMacToNodeMap().keySet().forEach(unDiscoveryOsws::remove);
            Map<String, OswNode> discoveryOsws = b.a(multiOswNode.getMacToNodeMap().keySet().stream().toList(), unDiscoveryOsws, true);
            for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
                b.a(oswNode, unDiscoveryOsws, discoveryOsws, topologyDevices, topology);
                if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) continue;
                oswNode.getPorts().forEach(port -> {
                    if (!CollectionUtils.isEmpty((Collection)port.getFdbMacs())) {
                        if (a.isDebugEnabled()) {
                            a.debug("discovery by rootMultiOswNodeMem mac:{}, port:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)port));
                        }
                        b.b(oswNode, port, topologyDevices, topology);
                    }
                });
            }
            return;
        }
        Map<String, OswNode> discoveryOsws = b.a(Collections.singletonList(rootNode.getMac()), unDiscoveryOsws, false);
        discoveryOsws.keySet().forEach(unDiscoveryOsws::remove);
        Map<String, OswNode> generateMap = b.a(topologyDevices, topology, discoveryOsws);
        if (CollectionUtils.isEmpty(generateMap) && a.isInfoEnabled()) {
            a.info("can not discover switch by <{}>", (Object)rootNode);
        }
        b.c(topologyDevices, generateMap, topology);
    }

    private static void d(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OsgNode osg = topologyDevices.getOsg();
        topology.addNode((Object)osg);
        if (CollectionUtils.isEmpty((Collection)osg.getArps())) {
            if (a.isDebugEnabled()) {
                a.debug("no arp found for <{}>", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()));
            }
            return;
        }
        b.a(osg, topologyDevices, topology);
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode = topologyDevices.getOmadacNode();
        if (omadacNode != null) {
            b.a(osg, omadacNode, topology);
        }
    }

    private static void e(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OsgNode osg = topologyDevices.getOsg();
        topology.addNode((Object)osg);
        if (CollectionUtils.isEmpty((Collection)osg.getArps())) {
            if (a.isDebugEnabled()) {
                a.debug("no arp found for <{}>", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()));
            }
            return;
        }
        b.a(osg, topologyDevices, topology);
    }

    private static void f(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.nonNull(topologyDevices.getOsg())) {
            b.e(topologyDevices, topology);
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a rootNode = topologyDevices.getRootNode();
        if (Objects.isNull(rootNode)) {
            return;
        }
        topology.addNode((Object)rootNode);
        rootNode.setDetected(Boolean.valueOf(true));
        if (Objects.equals("switch", rootNode.getType())) {
            OswNode oswNode = (OswNode)rootNode;
            if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) {
                return;
            }
            oswNode.setAsTmpRoot(Boolean.valueOf(true));
            for (Port port : oswNode.getPorts()) {
                if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) continue;
                b.b(topologyDevices, port, oswNode, topology);
            }
        } else if (Objects.equals("other", rootNode.getType())) {
            OtherNode otherNode = (OtherNode)rootNode;
            topologyDevices.getOtherMap().put(otherNode.getMac(), otherNode);
            b.a(topologyDevices, topology, otherNode);
        } else if (Objects.equals("olt", rootNode.getType())) {
            OltNode oltNode = (OltNode)rootNode;
            b.a(oltNode, topologyDevices, topology);
        } else if (Objects.equals("ap", rootNode.getType())) {
            ApNode apNode = (ApNode)rootNode;
            b.a(apNode, topologyDevices, topology);
        } else if (Objects.equals("vrrp", rootNode.getType()) || Objects.equals("mlag", rootNode.getType())) {
            MultiOswNode multiOswNode = (MultiOswNode)rootNode;
            b.a(multiOswNode, topologyDevices, topology);
        }
    }

    private static void a(MultiOswNode multiOswNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        for (OswNode oswNode : multiOswNode.getMacToNodeMap().values()) {
            if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) continue;
            oswNode.setAsTmpRoot(Boolean.valueOf(true));
            for (Port port : oswNode.getPorts()) {
                if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) continue;
                b.b(topologyDevices, port, oswNode, topology);
            }
        }
    }

    private static void g(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OsgNode osg;
        OduNode odu = topologyDevices.getOdu();
        topology.addNode((Object)odu);
        if (!CollectionUtils.isEmpty((Collection)odu.getNeighbors())) {
            for (LLDPNeighborDTO neighborDTO : odu.getNeighbors()) {
                switch (neighborDTO.getType()) {
                    case "gateway": {
                        b.a(neighborDTO.getMac(), odu, topologyDevices, topology);
                        break;
                    }
                    case "switch": {
                        break;
                    }
                }
            }
        }
        if (Objects.nonNull(osg = topologyDevices.getOsg()) && !Boolean.TRUE.equals(osg.getDetected())) {
            if (!CollectionUtils.isEmpty((Collection)odu.getArps())) {
                if (!osg.getMacList().stream().anyMatch(odu.getArps()::contains) && a.isInfoEnabled()) {
                    a.info("no osg arp found in odu, osgMac = {}, oduMac = {}", (Object)osg.getMac(), (Object)odu.getMac());
                }
            }
            OduOsgEdge oduOsgEdge = new OduOsgEdge();
            oduOsgEdge.setFromNodeAndToNode(odu.getMac(), osg.getMac());
            oduOsgEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.e.a());
            topology.addEdge((Object)odu, (Object)osg, (Object)oduOsgEdge);
            osg.setDetected(Boolean.valueOf(true));
        }
    }

    private static void a(String osgWanMac, OduNode odu, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OsgNode osg = topologyDevices.getOsg();
        if (Objects.isNull(osg) || Boolean.TRUE.equals(osg.getDetected())) {
            return;
        }
        OduOsgEdge oduOsgEdge = new OduOsgEdge(b.a(odu, osg));
        oduOsgEdge.setFromNodeAndToNode(odu.getMac(), osg.getMac());
        oduOsgEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.e.a());
        if (Objects.nonNull(odu.getLldpPortMap()) && odu.getLldpPortMap().containsKey(osgWanMac)) {
            Integer oduPortId = (Integer)odu.getLldpPortMap().get(osgWanMac);
            Port port = new Port();
            port.setPortId(oduPortId.intValue());
            oduOsgEdge.setUpLink(port);
        }
        topology.addEdge((Object)odu, (Object)osg, (Object)oduOsgEdge);
        osg.setDetected(Boolean.valueOf(true));
    }

    private static Port a(OduNode odu, OsgNode osg) {
        Map macToPortMap = osg.getMacToPortMap();
        Port port = new Port();
        odu.getNeighbors().stream().forEach(neighborDTO -> {
            if (macToPortMap.keySet().contains(neighborDTO.getMac())) {
                port.setPortId(((Integer)macToPortMap.get(neighborDTO.getMac())).intValue());
            }
        });
        return port;
    }

    private static void h(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        for (OltNode oltNode : oltMap.values()) {
            if (Boolean.TRUE.equals(oltNode.getDetected())) continue;
            topology.addNode((Object)oltNode);
            if (CollectionUtils.isEmpty((Collection)oltNode.getNeighbors())) continue;
            b.a(oltNode, topologyDevices, topology);
        }
    }

    private static void a(OltNode oltNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty((Collection)oltNode.getNeighbors())) {
            return;
        }
        for (LLDPNeighborDTO neighbor : oltNode.getNeighbors()) {
            if (Boolean.TRUE.equals(neighbor.getStpLoopExcept())) {
                if (!a.isDebugEnabled()) continue;
                a.debug("olt:{} lldp neighbor:{} is excluded by stp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)neighbor));
                continue;
            }
            switch (neighbor.getType()) {
                case "ap": {
                    b.b(oltNode, topologyDevices, topology, neighbor);
                    break;
                }
                case "switch": {
                    b.a(oltNode, topologyDevices, topology, neighbor);
                    break;
                }
            }
        }
    }

    private static void a(OltNode oltNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, LLDPNeighborDTO neighbor) {
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        if (CollectionUtils.isEmpty(oswMap) || Objects.isNull(oswMap.get(neighbor.getMac()))) {
            return;
        }
        OswNode oswNode = oswMap.get(neighbor.getMac());
        if (Boolean.TRUE.equals(oswNode.getAsTmpRoot())) {
            if (a.isInfoEnabled()) {
                a.info("olt {} try to connect tmpRoot switch {}, maybe lldp loop", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(oltNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), topology, oswNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(oltNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topology, oswNode);
            return;
        }
        if (!Boolean.TRUE.equals(oswNode.getDetected()) && !topology.hasEdgeConnecting((Object)oswNode, (Object)oltNode)) {
            OltOswEdge edge = new OltOswEdge(b.b(oltNode.getMac(), oswNode));
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.j.a());
            if (Objects.nonNull(oltNode.getLldpPortMap()) && oltNode.getLldpPortMap().containsKey(oswNode.getMac())) {
                String oltPortId = (String)oltNode.getLldpPortMap().get(oswNode.getMac());
                Port port = new Port();
                port.setStandardOswPort(oltPortId);
                edge.setUpLink(port);
            }
            edge.setFromNodeAndToNode(oltNode.getMac(), oswNode.getMac());
            topology.addEdge((Object)oltNode, (Object)oswNode, (Object)edge);
            oswNode.setDetected(Boolean.valueOf(true));
        }
    }

    private static void a(OltNode oltNode, MultiOswNode multiOswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode targetOswNode) {
        if (Objects.isNull(targetOswNode) || Boolean.TRUE.equals(targetOswNode.getDetected())) {
            if (a.isDebugEnabled()) {
                a.debug("multiOsw member osw:{} already detected, stop discovering olt:{} and osw:{}, stop discovering olt:{} and multiOsw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = null;
        if (topology.nodes().contains(multiOswNode)) {
            Set inEdges = topology.inEdges((Object)multiOswNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                MultiOswEdge inEdge = (MultiOswEdge)inEdges.iterator().next();
                if (!inEdge.getFromNodeMacs().contains(oltNode.getMac())) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw:{} already has inEdge:{} which doesn't contain olt:{}, skip", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()));
                    }
                    return;
                }
                multiOswEdge = inEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)oltNode);
                if (!Objects.isNull(optEdge)) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw:{} already connect to olt:{}, stop discovering olt to multiOswMem", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()));
                    }
                    return;
                }
            }
        }
        OltOswEdge edge = new OltOswEdge(b.b(oltNode.getMac(), targetOswNode));
        if (Objects.nonNull(oltNode.getLldpPortMap()) && oltNode.getLldpPortMap().containsKey(targetOswNode.getMac())) {
            String oltPortId = (String)oltNode.getLldpPortMap().get(targetOswNode.getMac());
            Port port = new Port();
            port.setStandardOswPort(oltPortId);
            edge.setUpLink(port);
        }
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.j.a());
        edge.setFromNodeAndToNode(oltNode.getMac(), targetOswNode.getMac());
        targetOswNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().add(oltNode.getMac());
            multiOswEdge.getToNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(oltNode.getMac());
            multiOswEdge.setToNodeMac(multiOswNode.getMac());
            topology.addEdge((Object)oltNode, (Object)multiOswNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        multiOswNode.setDetected(Boolean.valueOf(true));
    }

    private static void b(OltNode oltNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, LLDPNeighborDTO neighbor) {
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap) || Objects.isNull(apMap.get(neighbor.getMac()))) {
            return;
        }
        ApNode apNode = apMap.get(neighbor.getMac());
        if (!Boolean.TRUE.equals(apNode.getDetected()) && !topology.hasEdgeConnecting((Object)apNode, (Object)oltNode)) {
            OltApEdge edge = new OltApEdge();
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.k.a());
            edge.setFiberOptic(Boolean.valueOf(Boolean.TRUE.equals(neighbor.getIsFiberOptic())));
            apNode.setDetected(Boolean.valueOf(true));
            edge.setFromNodeAndToNode(oltNode.getMac(), apNode.getMac());
            if (Objects.nonNull(oltNode.getLldpPortMap()) && oltNode.getLldpPortMap().containsKey(apNode.getMac())) {
                String oltPortId = (String)oltNode.getLldpPortMap().get(apNode.getMac());
                Port port = new Port();
                port.setStandardOswPort(oltPortId);
                edge.setUpLink(port);
            }
            edge.setDownLink(b.a(oltNode.getMac(), apNode));
            topology.addEdge((Object)oltNode, (Object)apNode, (Object)edge);
            b.a(apNode, topologyDevices, topology);
        }
    }

    private static void i(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty(topologyDevices.getNvrMap()) || CollectionUtils.isEmpty(topologyDevices.getIpcMap())) {
            return;
        }
        Map<String, NvrNode> nvrNodeMap = topologyDevices.getNvrMap();
        Map<String, IpcNode> ipcNodeMap = topologyDevices.getIpcMap();
        Map wiredMap = Optional.ofNullable(topologyDevices.getVigiWiredMap()).orElse(new HashMap());
        Map wirelessMap = Optional.ofNullable(topologyDevices.getVigiWirelessMap()).orElse(new HashMap());
        for (Map.Entry<String, IpcNode> entry : ipcNodeMap.entrySet()) {
            boolean wireless = false;
            String nvrMac = null;
            if (wiredMap.containsKey(entry.getKey())) {
                nvrMac = (String)wiredMap.get(entry.getKey());
            } else if (wirelessMap.containsKey(entry.getKey())) {
                nvrMac = (String)wiredMap.get(entry.getKey());
                wireless = true;
            }
            if (Objects.isNull(nvrMac) || !nvrNodeMap.containsKey(nvrMac)) continue;
            NvrNode nvrNode = nvrNodeMap.get(nvrMac);
            if (wireless) {
                b.b(nvrNode, entry.getValue(), topology);
                continue;
            }
            b.a(nvrNode, entry.getValue(), topology);
        }
    }

    private static void a(NvrNode nvrNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!topology.nodes().contains(nvrNode)) {
            topology.addNode((Object)nvrNode);
        }
        if (CollectionUtils.isEmpty((Collection)nvrNode.getNeighbors())) {
            return;
        }
        for (LLDPNeighborDTO neighborDTO : nvrNode.getNeighbors()) {
            switch (neighborDTO.getType()) {
                case "switch": {
                    b.a(nvrNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "ap": {
                    b.b(nvrNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "olt": {
                    b.c(nvrNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "other": {
                    b.d(nvrNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "IPC": {
                    b.e(nvrNode, neighborDTO, topologyDevices, topology);
                    break;
                }
            }
        }
    }

    private static void a(NvrNode nvrNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty(topologyDevices.getOswMap())) {
            return;
        }
        OswNode oswNode = topologyDevices.getOswMap().get(neighborDTO.getMac());
        if (Objects.isNull(oswNode) || Boolean.TRUE.equals(oswNode.getDetected()) || topology.hasEdgeConnecting((Object)oswNode, (Object)nvrNode)) {
            return;
        }
        boolean hasUpperPortBefore = Objects.nonNull(oswNode.getUpperPort());
        Port oswUpperPort = b.b(nvrNode.getMac(), oswNode);
        if (Objects.isNull(oswUpperPort) || CollectionUtils.isEmpty((Collection)oswUpperPort.getLldpNeighbors())) {
            return;
        }
        boolean isNeighbor = oswUpperPort.getLldpNeighbors().stream().anyMatch(neighborDTO1 -> Objects.equals(nvrNode.getMac(), neighborDTO1.getMac()));
        if (!isNeighbor) {
            if (!hasUpperPortBefore) {
                oswNode.setUpperPort(null);
            }
            return;
        }
        NvrOswEdge nvrOswEdge = new NvrOswEdge();
        nvrOswEdge.setFromNodeAndToNode(nvrNode.getMac(), oswNode.getMac());
        nvrOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.D.a());
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(oswNode.getMac()))) {
            Port port = new Port();
            port.setPortId(((Integer)nvrNode.getMacPortMap().get(oswNode.getMac())).intValue());
            nvrOswEdge.setUpLink(port);
        }
        nvrOswEdge.setDownLink(oswUpperPort);
        topology.addEdge((Object)nvrNode, (Object)oswNode, (Object)nvrOswEdge);
        oswNode.setDetected(Boolean.valueOf(true));
    }

    private static void b(NvrNode nvrNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty(topologyDevices.getApMap())) {
            return;
        }
        ApNode apNode = topologyDevices.getApMap().get(neighborDTO.getMac());
        if (Objects.isNull(apNode) || Boolean.TRUE.equals(apNode.getDetected())) {
            return;
        }
        if (topology.hasEdgeConnecting((Object)apNode, (Object)nvrNode)) {
            return;
        }
        NvrApEdge nvrApEdge = new NvrApEdge();
        nvrApEdge.setFromNodeAndToNode(nvrNode.getMac(), apNode.getMac());
        nvrApEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.E.a());
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(apNode.getMac()))) {
            Port port = new Port();
            port.setPortId(((Integer)nvrNode.getMacPortMap().get(apNode.getMac())).intValue());
            nvrApEdge.setUpLink(port);
        }
        Port apPort = b.a(nvrNode.getMac(), apNode);
        nvrApEdge.setDownLink(apPort);
        topology.addEdge((Object)nvrNode, (Object)apNode, (Object)nvrApEdge);
        apNode.setDetected(Boolean.valueOf(true));
        b.a(apNode, topologyDevices, topology);
    }

    private static void c(NvrNode nvrNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty(topologyDevices.getOltMap())) {
            return;
        }
        OltNode oltNode = topologyDevices.getOltMap().get(neighborDTO.getMac());
        if (Objects.isNull(oltNode) || Boolean.TRUE.equals(oltNode.getDetected())) {
            return;
        }
        if (topology.hasEdgeConnecting((Object)oltNode, (Object)nvrNode)) {
            return;
        }
        NvrOltEdge nvrOltEdge = new NvrOltEdge();
        nvrOltEdge.setFromNodeAndToNode(nvrNode.getMac(), oltNode.getMac());
        nvrOltEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.F.a());
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(oltNode.getMac()))) {
            Port port = new Port();
            port.setPortId(((Integer)nvrNode.getMacPortMap().get(oltNode.getMac())).intValue());
            nvrOltEdge.setUpLink(port);
        }
        topology.addEdge((Object)nvrNode, (Object)oltNode, (Object)nvrOltEdge);
        oltNode.setDetected(Boolean.valueOf(true));
        b.a(oltNode, topologyDevices, topology);
    }

    private static void d(NvrNode nvrNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        String neighborMac = neighborDTO.getMac();
        OtherNode otherNode = topologyDevices.getOtherMap().computeIfAbsent(neighborMac, k2 -> new OtherNode(neighborMac, neighborDTO.getName()));
        if (!Boolean.TRUE.equals(otherNode.getDetected())) {
            NvrOtherEdge nvrOtherEdge = new NvrOtherEdge();
            nvrOtherEdge.setFromNodeAndToNode(nvrNode.getMac(), neighborMac);
            nvrOtherEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.G.a());
            if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(otherNode.getMac()))) {
                Port port = new Port();
                port.setPortId(((Integer)nvrNode.getMacPortMap().get(otherNode.getMac())).intValue());
                nvrOtherEdge.setUpLink(port);
            }
            topology.addEdge((Object)nvrNode, (Object)otherNode, (Object)nvrOtherEdge);
            otherNode.setDetected(Boolean.valueOf(true));
        }
    }

    private static void e(NvrNode nvrNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty(topologyDevices.getIpcMap())) {
            return;
        }
        IpcNode ipcNode = topologyDevices.getIpcMap().get(neighborDTO.getMac());
        if (Objects.isNull(ipcNode) || Boolean.TRUE.equals(ipcNode.getDetected()) || !Boolean.TRUE.equals(ipcNode.getManaged())) {
            return;
        }
        NvrIpcEdge nvrIpcEdge = new NvrIpcEdge();
        nvrIpcEdge.setFromNodeAndToNode(nvrNode.getMac(), ipcNode.getMac());
        nvrIpcEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.B.a());
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(ipcNode.getMac()))) {
            Port port = new Port();
            port.setPortId(((Integer)nvrNode.getMacPortMap().get(ipcNode.getMac())).intValue());
            nvrIpcEdge.setUpLink(port);
        }
        topology.addEdge((Object)nvrNode, (Object)ipcNode, (Object)nvrIpcEdge);
        ipcNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(NvrNode nvrNode, IpcNode ipcNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(nvrNode) || !Boolean.TRUE.equals(nvrNode.getDetected()) || !Boolean.TRUE.equals(nvrNode.getManaged()) || Objects.isNull(ipcNode) || Boolean.TRUE.equals(ipcNode.getDetected()) || !Boolean.TRUE.equals(ipcNode.getManaged())) {
            return;
        }
        NvrIpcEdge nvrIpcEdge = new NvrIpcEdge();
        nvrIpcEdge.setFromNodeAndToNode(nvrNode.getMac(), ipcNode.getMac());
        nvrIpcEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.B.a());
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(ipcNode.getMac()))) {
            Port port = new Port();
            port.setPortId(((Integer)nvrNode.getMacPortMap().get(ipcNode.getMac())).intValue());
            nvrIpcEdge.setUpLink(port);
        }
        topology.addEdge((Object)nvrNode, (Object)ipcNode, (Object)nvrIpcEdge);
        ipcNode.setDetected(Boolean.valueOf(true));
    }

    private static void b(NvrNode nvrNode, IpcNode ipcNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(nvrNode) || !Boolean.TRUE.equals(nvrNode.getDetected()) || !Boolean.TRUE.equals(nvrNode.getManaged()) || Objects.isNull(ipcNode) || Boolean.TRUE.equals(ipcNode.getDetected()) || !Boolean.TRUE.equals(ipcNode.getManaged())) {
            return;
        }
        NvrIpcWirelessEdge nvrIpcEdge = new NvrIpcWirelessEdge();
        nvrIpcEdge.setFromNodeAndToNode(nvrNode.getMac(), ipcNode.getMac());
        nvrIpcEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.C.a());
        topology.addEdge((Object)nvrNode, (Object)ipcNode, (Object)nvrIpcEdge);
        ipcNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(@Nonnull Map<String, OswNode> unDiscoveryOsws, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OsgNode osg = topologyDevices.getOsg();
        a.debug("start discovery osw by osg <{}>", (Object)osg.getMac());
        Map<String, OswNode> discoveryOsws = b.a(Collections.singletonList(osg.getMac()), unDiscoveryOsws, false);
        if (CollectionUtils.isEmpty(discoveryOsws)) {
            a.debug("no osw found in same subnet of <{}>", (Object)osg);
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("tagOsw by osg:{}, discoveryOsws:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)PIIJacksonUtil.parseToStr(discoveryOsws));
        }
        if (Objects.isNull(osg.getArps())) {
            osg.setArps(new HashSet(4));
        }
        discoveryOsws.keySet().forEach(oswMac -> {
            unDiscoveryOsws.remove(oswMac);
            Set arps = osg.getArps();
            arps.add(oswMac);
        });
        Map<String, OswNode> generateMap = b.a(topologyDevices, topology, discoveryOsws);
        b.c(topologyDevices, generateMap, topology);
    }

    private static void a(List<OswNode> vfSwitchNodes, TopologyDevices topologyDevices, Map<String, OswNode> unDiscoverySwitchs, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        int i2;
        do {
            if (CollectionUtils.isEmpty(unDiscoverySwitchs)) {
                return;
            }
            i2 = unDiscoverySwitchs.size();
            for (OswNode oswNode : vfSwitchNodes) {
                if (!topology.nodes().contains(oswNode) || oswNode.isLeaf()) continue;
                b.a(oswNode, topologyDevices, unDiscoverySwitchs, topology);
            }
        } while (i2 > unDiscoverySwitchs.size());
    }

    private static void b(TopologyDevices topologyDevices, Map<String, OswNode> unDiscoveryOsws, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        a.debug("start discovery osw by omada controller node");
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode = topologyDevices.getOmadacNode();
        Map<String, OswNode> discoveryOsws = b.a(omadacNode.a(), unDiscoveryOsws, false);
        if (CollectionUtils.isEmpty(discoveryOsws)) {
            a.debug("No osw found in same subnet with omada controller");
            return;
        }
        discoveryOsws.keySet().forEach(unDiscoveryOsws::remove);
        Map<String, OswNode> generateMap = b.a(topologyDevices, topology, discoveryOsws);
        if (CollectionUtils.isEmpty(generateMap)) {
            return;
        }
        if (topology.nodes().contains(omadacNode) && b.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)omadacNode, topology)) {
            if (a.isInfoEnabled()) {
                a.info("Omada Controller node already in topology while discoveryOswByOmadac");
            }
            b.b(generateMap, topologyDevices, topology);
            return;
        }
        if (generateMap.size() > 1 && a.isInfoEnabled()) {
            a.info("<{}> oswes found behind omada controller, use first one", (Object)generateMap.size());
        }
        generateMap.values().stream().findFirst().map(oswNode -> {
            if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                b.a(oswNode, omadacNode, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), oswNode.getUpperPort());
                return null;
            }
            if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                b.a(oswNode, omadacNode, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), oswNode.getUpperPort());
                return null;
            }
            BaseOswEdge edge = new BaseOswEdge(oswNode.getUpperPort());
            edge.setFromNodeAndToNode(oswNode.getMac(), omadacNode.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
            topology.addEdge(oswNode, (Object)omadacNode, (Object)edge);
            return null;
        });
        b.b(generateMap, topologyDevices, topology);
    }

    private static void a(OswNode flagNode, Map<String, OswNode> unDiscoveryOsws, Map<String, OswNode> discoveryOsws, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Set<Port> branchPorts = b.a(flagNode);
        if (CollectionUtils.isEmpty(branchPorts) && !CollectionUtils.isEmpty((Collection)flagNode.getPorts())) {
            a.debug("No branch port found in leaf osw <{}>", (Object)flagNode.getMac());
            for (Port port : flagNode.getPorts()) {
                if (CollectionUtils.isEmpty((Collection)port.getFdbMacs())) continue;
                a.debug("discoveryByOswPort, switch mac:{}, port:{}", (Object)flagNode.getMac(), (Object)port);
                b.a(flagNode, port, topologyDevices, topology);
            }
            return;
        }
        if (CollectionUtils.isEmpty(discoveryOsws)) {
            a.debug("no osw found in same subnet of <{}>", (Object)flagNode);
            return;
        }
        discoveryOsws.keySet().forEach(unDiscoveryOsws::remove);
        Map<String, OswNode> generateMap = b.a(topologyDevices, topology, discoveryOsws);
        if (CollectionUtils.isEmpty(generateMap)) {
            a.error("generateMap is null after discovery by <{}>", (Object)flagNode);
            return;
        }
        for (OswNode oswNode : generateMap.values()) {
            for (Port port : branchPorts) {
                if (!port.getFdbMacs().contains(oswNode.getMac())) continue;
                b.a(flagNode, oswNode, topology, port, topologyDevices);
            }
        }
        b.c(topologyDevices, generateMap, topology);
    }

    private static void c(TopologyDevices topologyDevices, Map<String, OswNode> topOswMap, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        for (OswNode oswNode : topOswMap.values()) {
            if (Boolean.TRUE.equals(oswNode.getDetected())) continue;
            List ports = oswNode.getPorts().stream().filter(port -> !port.isDetected()).collect(Collectors.toList());
            if (ports.size() > 1) {
                a.warn("osw {} upper port {} after osw discover", (Object)oswNode.getMac(), ports);
            }
            for (Port port2 : ports) {
                if (CollectionUtils.isEmpty((Collection)port2.getLldpNeighbors()) || !b.a(port2, oswNode, topologyDevices, topology)) continue;
                oswNode.setDetected(Boolean.valueOf(true));
                break;
            }
            if (Boolean.TRUE.equals(oswNode.getDetected())) continue;
            b.a(topologyDevices, oswNode, topology);
        }
    }

    private static void a(TopologyDevices topologyDevices, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        OltOswEdge edge;
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a rootNode = topologyDevices.getRootNode();
        if (Objects.isNull(rootNode)) {
            return;
        }
        Port upperPort = b.b(rootNode.getMac(), oswNode);
        if (Objects.isNull(upperPort)) {
            return;
        }
        Set fdbMacs = Optional.ofNullable(upperPort.getFdbMacs()).orElse(new HashSet(0));
        if (!fdbMacs.contains(rootNode.getMac())) {
            return;
        }
        if (Objects.equals(rootNode.getType(), "olt")) {
            OltNode oltNode = (OltNode)rootNode;
            if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                b.a(oltNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), topology, oswNode);
                return;
            }
            if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                b.a(oltNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topology, oswNode);
                return;
            }
            edge = new OltOswEdge(oswNode.getUpperPort());
            edge.setFromNodeAndToNode(oltNode.getMac(), oswNode.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.j.a());
            topology.addEdge((Object)oltNode, (Object)oswNode, (Object)edge);
            oswNode.setDetected(Boolean.valueOf(true));
        }
        if (Objects.equals(rootNode.getType(), "other")) {
            OtherNode otherNode = (OtherNode)rootNode;
            if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                b.a(otherNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), topology, oswNode);
                return;
            }
            if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                b.a(otherNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topology, oswNode);
                return;
            }
            edge = new BaseOswEdge(oswNode.getUpperPort());
            edge.setFromNodeAndToNode(otherNode.getMac(), oswNode.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
            topology.addEdge((Object)otherNode, (Object)oswNode, (Object)edge);
            oswNode.setDetected(Boolean.valueOf(true));
        }
    }

    private static boolean a(Port upperPort, OswNode oswNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty((Collection)upperPort.getLldpNeighbors())) {
            return false;
        }
        for (LLDPNeighborDTO lldpNeighbor : upperPort.getLldpNeighbors()) {
            if (!Objects.equals("gateway", lldpNeighbor.getType()) || !Objects.nonNull(topologyDevices.getOsg())) continue;
            b.a(oswNode.getMac(), topologyDevices.getOsg(), topologyDevices, topology);
            return true;
        }
        for (LLDPNeighborDTO neighborDTO : upperPort.getLldpNeighbors()) {
            switch (neighborDTO.getType()) {
                case "ap": {
                    ApNode apNode = topologyDevices.getApMap().get(neighborDTO.getMac());
                    if (!Objects.nonNull(apNode) || !b.a(apNode, oswNode, topology, upperPort, topologyDevices)) break;
                    return true;
                }
                case "olt": {
                    OltNode oltNode = topologyDevices.getOltMap().get(neighborDTO.getMac());
                    if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                        b.a(oltNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), topology, oswNode);
                        return true;
                    }
                    if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                        b.a(oltNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topology, oswNode);
                        return true;
                    }
                    if (!Objects.nonNull(oltNode)) break;
                    OswOltEdge edge = new OswOltEdge(upperPort);
                    edge.setFromNodeAndToNode(oltNode.getMac(), oswNode.getMac());
                    edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
                    topology.addEdge((Object)oltNode, (Object)oswNode, (Object)edge);
                    return true;
                }
                case "switch": {
                    OswNode oswNode1 = Optional.ofNullable(topologyDevices.getOswMap()).map(oswMap -> (OswNode)oswMap.get(neighborDTO.getMac())).orElse(null);
                    Port downLinkPort = b.c(oswNode.getMac(), oswNode1);
                    if (!Objects.nonNull(oswNode1) || !Objects.nonNull(downLinkPort)) break;
                    b.a(oswNode1, oswNode, topology, downLinkPort, topologyDevices);
                    break;
                }
                case "other": {
                    String neighborMac = neighborDTO.getMac();
                    OtherNode otherNode = topologyDevices.getOtherMap().computeIfAbsent(neighborMac, k2 -> new OtherNode(neighborMac, neighborDTO.getName()));
                    otherNode.setName(neighborDTO.getName());
                    if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                        b.a(otherNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), topology, oswNode);
                        return true;
                    }
                    if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                        b.a(otherNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topology, oswNode);
                        return true;
                    }
                    BaseOswEdge edge = new BaseOswEdge(upperPort);
                    edge.setFromNodeAndToNode(neighborMac, oswNode.getMac());
                    edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
                    topology.addEdge((Object)otherNode, (Object)oswNode, (Object)edge);
                    return true;
                }
            }
        }
        return false;
    }

    private static Port a(@Nullable OswNode oswNode, String mac) {
        if (Objects.isNull(oswNode)) {
            return null;
        }
        List ports = ((List)Optional.ofNullable(oswNode.getPorts()).orElse(new ArrayList())).stream().filter(port -> Objects.equals(oswNode.getUpperPort(), port) && ((Set)Optional.ofNullable(port.getLldpNeighbors()).orElse(new HashSet())).stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), mac))).collect(Collectors.toList());
        return CollectionUtils.isEmpty(ports) ? null : (Port)ports.get(0);
    }

    private static void a(OswNode flagNode, TopologyDevices topologyDevices, Map<String, OswNode> unDiscoverySwitchs, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Set<Port> branchPorts = b.a(flagNode);
        if (CollectionUtils.isEmpty(branchPorts)) {
            a.debug("No branch port found in leaf osw <{}>", (Object)flagNode.getMac());
            return;
        }
        ArrayList<String> flagMacs = new ArrayList<String>();
        boolean flagByMultiOsw = b.a(topology, topologyDevices, flagNode, flagMacs);
        unDiscoverySwitchs.remove(flagNode.getMac());
        Map<String, OswNode> discoverySwitchs = b.a(flagMacs, unDiscoverySwitchs, flagByMultiOsw);
        if (CollectionUtils.isEmpty(discoverySwitchs)) {
            a.debug("no osw found in same subnet of <{}>", (Object)flagNode);
            return;
        }
        discoverySwitchs.keySet().forEach(unDiscoverySwitchs::remove);
        Map<String, OswNode> generateMap = b.a(topologyDevices, topology, discoverySwitchs);
        if (CollectionUtils.isEmpty(generateMap)) {
            a.error("generateMap is null after discovery by <{}>", (Object)flagNode);
            return;
        }
        b.c(topologyDevices, generateMap, topology);
        for (OswNode oswNode : generateMap.values()) {
            for (Port port : branchPorts) {
                if (!port.getFdbMacs().contains(oswNode.getMac())) continue;
                b.a(flagNode, oswNode, topology, port, topologyDevices);
            }
        }
    }

    private static Set<Port> a(OswNode oswNode) {
        if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) {
            return Collections.emptySet();
        }
        HashSet<Port> result = new HashSet<Port>();
        for (Port port : oswNode.getPorts()) {
            if (port.isLeaf()) continue;
            result.add(port);
        }
        return result;
    }

    private static void a(OswNode oswNode, Port port, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) {
            oswNode.setAsTmpRoot(Boolean.valueOf(true));
            b.b(topologyDevices, port, oswNode, topology);
            oswNode.setAsTmpRoot(Boolean.valueOf(false));
        }
        Set fdbMacs = port.getFdbMacs();
        if (!port.isLeaf()) {
            b.a(oswNode, port, topologyDevices, (Set<String>)fdbMacs, topology);
        }
        b.a(oswNode, port, topologyDevices.getOltMap(), (Set<String>)fdbMacs);
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap)) {
            return;
        }
        for (ApNode apNode : apMap.values()) {
            if (Boolean.TRUE.equals(apNode.getDetected()) || !fdbMacs.contains(apNode.getMac())) continue;
            ApNode rootAp = b.a(apNode, apMap, topology);
            if (!fdbMacs.contains(rootAp.getMac())) {
                if (!a.isInfoEnabled()) continue;
                a.info("root ap <{}> of ap <{}> not in fdb of osw <{}>", (Object)rootAp.getMac(), (Object)apNode.getMac(), (Object)oswNode.getMac());
                continue;
            }
            if (b.a((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)rootAp, topology)) {
                a.debug("ap <{}> already has predecessors, cannot up link to osw <{}>", (Object)rootAp.getMac(), (Object)oswNode.getMac());
                continue;
            }
            if (Boolean.TRUE.equals(rootAp.getFdbLink())) continue;
            Map fdbAp = Optional.ofNullable(oswNode.getFdbAp()).orElse(new HashMap());
            fdbAp.computeIfAbsent(port.getStandardOswPort(), k2 -> new ArrayList()).add(rootAp);
            rootAp.setFdbLink(Boolean.valueOf(true));
            oswNode.setFdbAp(fdbAp);
        }
    }

    private static void a(OswNode oswNode, Port port, TopologyDevices topologyDevices, Set<String> fdbMacs, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        if (CollectionUtils.isEmpty(oswMap)) {
            return;
        }
        Set<String> oswMacs = topologyDevices.getOswMacs();
        b.a(oswMacs, fdbMacs, (String mac) -> {
            OswNode targetOsw = (OswNode)oswMap.get(mac);
            if (!(Boolean.TRUE.equals(targetOsw.getDetected()) || Boolean.TRUE.equals(targetOsw.getFdbLink()) || topology.hasEdgeConnecting((Object)targetOsw, (Object)oswNode))) {
                Map fdbOsw = Optional.ofNullable(oswNode.getFdbOsw()).orElse(new HashMap());
                fdbOsw.computeIfAbsent(port.getStandardOswPort(), k2 -> new ArrayList()).add(targetOsw);
                targetOsw.setFdbLink(Boolean.valueOf(true));
                oswNode.setFdbOsw(fdbOsw);
            }
        });
    }

    private static void a(OswNode oswNode, Port port, Map<String, OltNode> oltMap, Set<String> fdbMacs) {
        if (CollectionUtils.isEmpty(oltMap)) {
            return;
        }
        oltMap.values().forEach(oltNode -> {
            if (!Boolean.TRUE.equals(oltNode.getDetected()) && !Boolean.TRUE.equals(oltNode.getFdbLink()) && fdbMacs.contains(oltNode.getMac())) {
                Map fdbOlt = Optional.ofNullable(oswNode.getFdbOlt()).orElse(new HashMap());
                fdbOlt.computeIfAbsent(port.getStandardOswPort(), k2 -> new ArrayList()).add(oltNode);
                oltNode.setFdbLink(Boolean.valueOf(true));
                oswNode.setFdbOlt(fdbOlt);
            }
        });
    }

    private static void a(@Nonnull OsgNode osg, @Nonnull TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        b.b(osg, topologyDevices, topology);
        if (CollectionUtils.isEmpty((Collection)osg.getNeighbors())) {
            return;
        }
        for (LLDPNeighborDTO neighborDTO : osg.getNeighbors()) {
            if (Boolean.TRUE.equals(neighborDTO.getStpLoopExcept())) {
                if (!a.isDebugEnabled()) continue;
                a.debug("osg:{} lldp neighbor:{} is excluded by stp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)neighborDTO));
                continue;
            }
            switch (neighborDTO.getType()) {
                case "switch": {
                    b.a(neighborDTO.getMac(), osg, topologyDevices, topology);
                    break;
                }
                case "ap": {
                    b.a(neighborDTO, osg, topologyDevices, topology);
                    break;
                }
                case "olt": {
                    b.a(neighborDTO.getMac(), osg, topologyDevices.getOltMap(), topology, topologyDevices);
                    break;
                }
                case "other": {
                    b.b(neighborDTO, osg, topologyDevices, topology);
                    break;
                }
                case "NVR": {
                    b.b(neighborDTO.getMac(), osg, topologyDevices, topology);
                    break;
                }
                case "IPC": {
                    b.c(neighborDTO.getMac(), osg, topologyDevices, topology);
                    break;
                }
            }
        }
    }

    private static void b(@Nonnull OsgNode osg, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap)) {
            return;
        }
        if (osg.getGatewayMeshInfo() != null && !CollectionUtils.isEmpty((Collection)osg.getGatewayMeshInfo().getChildAps())) {
            Set childAps = osg.getGatewayMeshInfo().getChildAps();
            for (String childAp : childAps) {
                if (Objects.isNull(apMap.get(childAp))) continue;
                ApNode childNode = apMap.get(childAp);
                childNode.setDetected(Boolean.valueOf(true));
                MeshApEdge edge = new MeshApEdge();
                edge.setFromNodeAndToNode(osg.getMac(), childAp);
                edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.t.a());
                topology.addEdge((Object)osg, (Object)childNode, (Object)edge);
                b.a(childNode, topologyDevices, topology);
            }
        }
    }

    @Nonnull
    private static ApNode a(@Nonnull ApNode apNode, Map<String, ApNode> apMap, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!Objects.equals(apNode.getMeshInfo().getWireless(), true)) {
            topology.addNode((Object)apNode);
            return apNode;
        }
        ApNode rootAp = b.a(apNode.getMac(), apNode.getMeshInfo(), apMap);
        if (rootAp == null) {
            a.debug("Failed to find root ap for <{}> with mesh info <{}>", (Object)apNode.getMac(), (Object)apNode.getMeshInfo());
            rootAp = apNode;
        }
        topology.addNode((Object)rootAp);
        b.b(rootAp, apMap, topology);
        return rootAp;
    }

    private static void b(@Nonnull ApNode apNode, Map<String, ApNode> apMap, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        List childAps = apNode.getMeshInfo().getChildAps();
        if (CollectionUtils.isEmpty((Collection)childAps)) {
            return;
        }
        for (String childMac : childAps) {
            ApNode childAp = apMap.get(childMac);
            if (childAp == null) {
                a.debug("Failed to find apNode for <{}>, maybe disconnected", (Object)childMac);
                continue;
            }
            if (Boolean.TRUE.equals(childAp.getDetected())) {
                a.warn("child ap <{}> of <{}> already detected", (Object)childMac, (Object)apNode.getMac());
                continue;
            }
            childAp.setDetected(Boolean.valueOf(true));
            MeshApEdge edge = new MeshApEdge();
            edge.setFromNodeAndToNode(apNode.getMac(), childAp.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.t.a());
            topology.addEdge((Object)apNode, (Object)childAp, (Object)edge);
            b.b(childAp, apMap, topology);
        }
    }

    private static void a(@Nonnull ApNode apNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!CollectionUtils.isEmpty((Collection)apNode.getNeighbors())) {
            b.f(apNode, topologyDevices, topology);
        }
        if (apNode.getMeshInfo() != null) {
            b.e(apNode, topologyDevices, topology);
        }
    }

    private static void b(@Nonnull ApNode apNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!CollectionUtils.isEmpty((Collection)apNode.getNeighbors())) {
            b.c(apNode, topologyDevices, topology);
        }
        if (Objects.nonNull(apNode.getMeshInfo())) {
            b.d(apNode, topologyDevices, topology);
        }
    }

    private static void c(@Nonnull ApNode apNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!topology.nodes().contains(apNode)) {
            topology.addNode((Object)apNode);
        }
        ArrayList<ApNode> neighborAps = new ArrayList<ApNode>();
        for (LLDPNeighborDTO neighborDTO : apNode.getNeighbors()) {
            if (Objects.equals(neighborDTO.getMac(), apNode.getMac())) continue;
            if (Boolean.TRUE.equals(neighborDTO.getStpLoopExcept())) {
                if (!a.isDebugEnabled()) continue;
                a.debug("ap:{} lldp neighbor:{} is excluded by stp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)neighborDTO));
                continue;
            }
            switch (neighborDTO.getType()) {
                case "ap": {
                    ApNode neighborAp2 = b.a(apNode, neighborDTO, topologyDevices, topology);
                    if (!Objects.nonNull(neighborAp2)) break;
                    neighborAps.add(neighborAp2);
                    break;
                }
                case "switch": {
                    b.a(apNode, neighborDTO, topology, topologyDevices);
                    break;
                }
                case "olt": {
                    b.e(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "other": {
                    b.f(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "NVR": {
                    b.b(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "IPC": {
                    b.c(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
            }
        }
        if (!CollectionUtils.isEmpty(neighborAps)) {
            neighborAps.forEach(neighborAp -> b.b(neighborAp, topologyDevices, topology));
        }
    }

    private static ApNode a(@Nonnull ApNode apNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        ApNode neighborAp = apMap.get(neighborDTO.getMac());
        if (Objects.isNull(neighborAp)) {
            return null;
        }
        if (!Boolean.TRUE.equals(neighborAp.getDetected()) && !topology.hasEdgeConnecting((Object)neighborAp, (Object)apNode)) {
            neighborAp.setDetected(Boolean.valueOf(true));
            Port uplink = b.a(neighborAp.getMac(), apNode);
            Port downlink = b.a(apNode.getMac(), neighborAp);
            WiredApApEdge edge = new WiredApApEdge(uplink, downlink);
            edge.setFromNodeAndToNode(apNode.getMac(), neighborAp.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.x.a());
            topology.addEdge((Object)apNode, (Object)neighborAp, (Object)edge);
            return neighborAp;
        }
        return null;
    }

    private static void d(@Nonnull ApNode apNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        ArrayList wirelessNeighborAps;
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (!topology.nodes().contains(apNode)) {
            topology.addNode((Object)apNode);
        }
        ArrayList arrayList = wirelessNeighborAps = CollectionUtils.isEmpty((Collection)apNode.getMeshInfo().getChildAps()) ? new ArrayList() : Lists.newArrayList((Iterable)apNode.getMeshInfo().getChildAps());
        if (CollectionUtils.isEmpty((Collection)wirelessNeighborAps)) {
            a.debug("<{}> has no child or parent ap", (Object)apNode.getMac());
            return;
        }
        ArrayList<ApNode> neighborAps = new ArrayList<ApNode>();
        for (String wirelessNeighborApMac : wirelessNeighborAps) {
            ApNode childAp = apMap.get(wirelessNeighborApMac);
            if (childAp == null || Boolean.TRUE.equals(childAp.getDetected()) || !Boolean.TRUE.equals(childAp.getMeshInfo().getWireless())) {
                a.debug("Ap <{}>  maybe disconnected or already detected or actually wired", (Object)wirelessNeighborApMac);
                continue;
            }
            childAp.setDetected(Boolean.valueOf(true));
            neighborAps.add(childAp);
            MeshApEdge edge = new MeshApEdge();
            edge.setFromNodeAndToNode(apNode.getMac(), childAp.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.t.a());
            topology.addEdge((Object)apNode, (Object)childAp, (Object)edge);
        }
        if (!CollectionUtils.isEmpty(neighborAps)) {
            neighborAps.forEach(neighborAp -> b.b(neighborAp, topologyDevices, topology));
        }
    }

    private static void e(@Nonnull ApNode apNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        ArrayList wirelessNeighborAp;
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (apNode.getMeshInfo().getParentAp() != null) {
            String parentApMac = apNode.getMeshInfo().getParentAp();
            ApNode parentAp = apMap.get(parentApMac);
            if (!Boolean.TRUE.equals(apNode.getDetected()) && Objects.nonNull(parentAp) && Boolean.TRUE.equals(apNode.getMeshInfo().getWireless())) {
                MeshApEdge edge = new MeshApEdge();
                edge.setFromNodeAndToNode(parentApMac, apNode.getMac());
                edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.t.a());
                topology.addEdge((Object)parentAp, (Object)apNode, (Object)edge);
                apNode.setDetected(Boolean.valueOf(true));
            }
        }
        if (!topology.nodes().contains(apNode)) {
            topology.addNode((Object)apNode);
        }
        ArrayList arrayList = wirelessNeighborAp = CollectionUtils.isEmpty((Collection)apNode.getMeshInfo().getChildAps()) ? new ArrayList() : Lists.newArrayList((Iterable)apNode.getMeshInfo().getChildAps());
        if (CollectionUtils.isEmpty((Collection)wirelessNeighborAp)) {
            a.debug("<{}> has no child or parent ap", (Object)apNode.getMac());
            return;
        }
        for (String wirelessNeighborApMac : wirelessNeighborAp) {
            ApNode childAp = apMap.get(wirelessNeighborApMac);
            if (childAp == null || Boolean.TRUE.equals(childAp.getDetected()) || !Boolean.TRUE.equals(childAp.getMeshInfo().getWireless())) {
                a.debug("Ap <{}>  maybe disconnected or already detected or actually wired", (Object)wirelessNeighborApMac);
                continue;
            }
            childAp.setDetected(Boolean.valueOf(true));
            MeshApEdge edge = new MeshApEdge();
            edge.setFromNodeAndToNode(apNode.getMac(), childAp.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.t.a());
            topology.addEdge((Object)apNode, (Object)childAp, (Object)edge);
            b.a(childAp, topologyDevices, topology);
        }
    }

    private static void f(@Nonnull ApNode apNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (!topology.nodes().contains(apNode)) {
            topology.addNode((Object)apNode);
        }
        for (LLDPNeighborDTO neighborDTO : apNode.getNeighbors()) {
            if (Objects.equals(neighborDTO.getMac(), apNode.getMac())) continue;
            if (Boolean.TRUE.equals(neighborDTO.getStpLoopExcept())) {
                if (!a.isDebugEnabled()) continue;
                a.debug("ap:{} lldp neighbor:{} is excluded by stp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)neighborDTO));
                continue;
            }
            switch (neighborDTO.getType()) {
                case "ap": {
                    b.d(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "switch": {
                    b.a(apNode, neighborDTO, topology, topologyDevices);
                    break;
                }
                case "olt": {
                    b.e(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "other": {
                    b.f(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "NVR": {
                    b.b(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
                case "IPC": {
                    b.c(apNode, neighborDTO, topologyDevices, topology);
                    break;
                }
            }
        }
    }

    private static void b(ApNode apNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, NvrNode> nvrMap = topologyDevices.getNvrMap();
        if (CollectionUtils.isEmpty(nvrMap)) {
            return;
        }
        NvrNode nvrNode = nvrMap.get(neighborDTO.getMac());
        if (Objects.isNull(nvrNode) || Boolean.TRUE.equals(nvrNode.getDetected()) || !Boolean.TRUE.equals(nvrNode.getManaged())) {
            return;
        }
        nvrNode.setDetected(Boolean.valueOf(true));
        ApNvrEdge edge = new ApNvrEdge(b.a(nvrNode.getMac(), apNode), null);
        edge.setFromNodeAndToNode(apNode.getMac(), nvrNode.getMac());
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.v.a());
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(apNode.getMac()))) {
            Port downLink = new Port();
            downLink.setPortId(((Integer)nvrNode.getMacPortMap().get(apNode.getMac())).intValue());
            edge.setDownLink(downLink);
        }
        topology.addEdge((Object)apNode, (Object)nvrNode, (Object)edge);
        b.a(nvrNode, topologyDevices, topology);
    }

    private static void c(ApNode apNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, IpcNode> ipcMap = topologyDevices.getIpcMap();
        if (CollectionUtils.isEmpty(ipcMap)) {
            return;
        }
        IpcNode neighborIpc = ipcMap.get(neighborDTO.getMac());
        if (Objects.isNull(neighborIpc) || Boolean.TRUE.equals(neighborIpc.getDetected()) || !Boolean.TRUE.equals(neighborIpc.getManaged())) {
            return;
        }
        neighborIpc.setDetected(Boolean.valueOf(true));
        ApIpcEdge edge = new ApIpcEdge(b.a(neighborIpc.getMac(), apNode));
        edge.setFromNodeAndToNode(apNode.getMac(), neighborIpc.getMac());
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.z.a());
        topology.addEdge((Object)apNode, (Object)neighborIpc, (Object)edge);
    }

    private static void d(ApNode apNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        ApNode neighborAp = apMap.get(neighborDTO.getMac());
        if (Objects.isNull(neighborAp)) {
            return;
        }
        if (!(Boolean.TRUE.equals(neighborAp.getDetected()) || Boolean.TRUE.equals(neighborDTO.getDetected()) || topology.hasEdgeConnecting((Object)neighborAp, (Object)apNode))) {
            neighborAp.setDetected(Boolean.valueOf(true));
            WiredApApEdge edge = new WiredApApEdge(b.a(neighborAp.getMac(), apNode), b.a(apNode.getMac(), neighborAp));
            edge.setFromNodeAndToNode(apNode.getMac(), neighborAp.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.x.a());
            topology.addEdge((Object)apNode, (Object)neighborAp, (Object)edge);
            b.a(neighborAp, topologyDevices, topology);
            return;
        }
        if (!Boolean.TRUE.equals(apNode.getDetected()) && !topology.hasEdgeConnecting((Object)apNode, (Object)neighborAp)) {
            WiredApApEdge edge = new WiredApApEdge(b.a(apNode.getMac(), neighborAp), b.a(neighborAp.getMac(), apNode));
            edge.setFromNodeAndToNode(neighborAp.getMac(), apNode.getMac());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.x.a());
            topology.addEdge((Object)neighborAp, (Object)apNode, (Object)edge);
        }
    }

    private static void a(ApNode apNode, LLDPNeighborDTO neighborDTO, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        OswNode neighborOsw = topologyDevices.getOswMap().get(neighborDTO.getMac());
        if (neighborOsw != null && !Boolean.TRUE.equals(neighborOsw.getDetected()) && !topology.hasEdgeConnecting((Object)neighborOsw, (Object)apNode) && b.a(apNode, neighborOsw, topology, b.b(apNode.getMac(), neighborOsw), topologyDevices)) {
            neighborOsw.setDetected(Boolean.valueOf(true));
        }
    }

    private static void e(ApNode apNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        if (CollectionUtils.isEmpty(oltMap)) {
            return;
        }
        OltNode neighborOlt = oltMap.get(neighborDTO.getMac());
        if (topology.hasEdgeConnecting((Object)neighborOlt, (Object)apNode)) {
            return;
        }
        if (Boolean.TRUE.equals(neighborOlt.getDetected())) {
            BaseOltEdge edge = new BaseOltEdge();
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.h.a());
            edge.setFromNodeAndToNode(neighborOlt.getMac(), apNode.getMac());
            topology.addEdge((Object)neighborOlt, (Object)apNode, (Object)edge);
            return;
        }
        ApOltEdge edge = new ApOltEdge(b.a(neighborOlt.getMac(), apNode), null);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.y.a());
        neighborOlt.setDetected(Boolean.valueOf(true));
        edge.setFromNodeAndToNode(apNode.getMac(), neighborOlt.getMac());
        topology.addEdge((Object)apNode, (Object)neighborOlt, (Object)edge);
        b.a(neighborOlt, topologyDevices, topology);
    }

    private static void f(ApNode apNode, LLDPNeighborDTO neighborDTO, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        String neighborMac = neighborDTO.getMac();
        OtherNode otherNode = topologyDevices.getOtherMap().computeIfAbsent(neighborMac, k2 -> new OtherNode(neighborMac, neighborDTO.getName()));
        ApOtherEdge edge = new ApOtherEdge(b.a(neighborMac, apNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.u.a());
        if (Boolean.TRUE.equals(otherNode.getDetected())) {
            otherNode.setName(neighborDTO.getName());
            edge.setFromNodeAndToNode(otherNode.getMac(), apNode.getMac());
            topology.addEdge((Object)otherNode, (Object)apNode, (Object)edge);
            apNode.setDetected(Boolean.valueOf(true));
            return;
        }
        edge.setFromNodeAndToNode(apNode.getMac(), otherNode.getMac());
        topology.addEdge((Object)apNode, (Object)otherNode, (Object)edge);
        otherNode.setDetected(Boolean.valueOf(true));
        b.a(topologyDevices, topology, otherNode);
    }

    @Nullable
    private static ApNode a(String apMac, ApMeshInfoDTO wirelessInfo, Map<String, ApNode> apMap) {
        if (wirelessInfo == null || wirelessInfo.getParentAp() == null) {
            a.warn("Missing parent for wireless ap <{}> with mesh info <{}>", (Object)apMac, (Object)wirelessInfo);
            return null;
        }
        ApNode parentAp = apMap.get(wirelessInfo.getParentAp());
        if (parentAp == null) {
            a.debug("Failed to find apNode <{}> which is parent of <{}>, maybe disconnected", (Object)wirelessInfo.getParentAp(), (Object)apMac);
            return null;
        }
        if (parentAp.getMeshInfo() == null) {
            a.warn("Invalid parentAp <{}>, missing info", (Object)parentAp.getMac());
            return null;
        }
        if (!Objects.equals(parentAp.getMeshInfo().getWireless(), true)) {
            return parentAp;
        }
        ApNode grandfather = b.a(parentAp.getMac(), parentAp.getMeshInfo(), apMap);
        return grandfather == null ? parentAp : grandfather;
    }

    private static Map<String, OswNode> a(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Map<String, OswNode> discoveryOsws) {
        HashMap<String, OswNode> generateMap = new HashMap<String, OswNode>();
        HashMap<String, OswNode> detectMap = new HashMap<String, OswNode>();
        for (OswNode osw : discoveryOsws.values()) {
            if (Boolean.TRUE.equals(osw.getMlagMem())) {
                multiOswNode = topologyDevices.getMlagOswMap().get(osw.getMac());
                topology.addNode((Object)multiOswNode);
            } else if (Boolean.TRUE.equals(osw.getVrrpMem())) {
                multiOswNode = topologyDevices.getVrrpOswMap().get(osw.getMac());
                topology.addNode((Object)multiOswNode);
            } else {
                topology.addNode((Object)osw);
            }
            if (osw.isLeaf()) {
                b.a(osw, topologyDevices, topology);
                generateMap.put(osw.getMac(), osw);
                continue;
            }
            detectMap.put(osw.getMac(), osw);
        }
        int detectOswCnt = detectMap.size();
        while (detectOswCnt > 0) {
            ArrayList<String> newGenerateList = new ArrayList<String>(detectOswCnt);
            for (Map.Entry entry : detectMap.entrySet()) {
                OswNode osw = (OswNode)entry.getValue();
                if (!b.b(osw, generateMap, detectMap, topologyDevices, topology)) continue;
                newGenerateList.add(osw.getMac());
                generateMap.put(osw.getMac(), osw);
            }
            if (CollectionUtils.isEmpty(newGenerateList)) {
                a.warn("Failed to find any new generate osw in <{}>, may be loop", detectMap.keySet());
                List<OswNode> sortedDetectOsws = b.a(detectMap);
                if (a.isDebugEnabled()) {
                    a.debug("sortedDetectOsws:{}", (Object)PIIJacksonUtil.parseToStr(sortedDetectOsws.stream().map(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a::getMac).collect(Collectors.toList())));
                }
                for (OswNode detectOsw : sortedDetectOsws) {
                    b.b(detectOsw, topologyDevices, topology);
                    generateMap.put(detectOsw.getMac(), detectOsw);
                }
                return generateMap;
            }
            newGenerateList.forEach(detectMap::remove);
            detectOswCnt = detectMap.size();
        }
        return generateMap;
    }

    private static List<OswNode> a(Map<String, OswNode> detectMap) {
        ArrayList<OswNode> detectedOsws = new ArrayList<OswNode>();
        ArrayList<OswNode> multiOswMems = new ArrayList<OswNode>();
        ArrayList<OswNode> osws = new ArrayList<OswNode>();
        for (OswNode osw : detectMap.values()) {
            if (Boolean.TRUE.equals(osw.getDetected())) {
                detectedOsws.add(osw);
                continue;
            }
            if (Boolean.TRUE.equals(osw.getVrrpMem()) || Boolean.TRUE.equals(osw.getMlagMem())) {
                multiOswMems.add(osw);
                continue;
            }
            osws.add(osw);
        }
        ArrayList<OswNode> result = new ArrayList<OswNode>();
        result.addAll(detectedOsws);
        result.addAll(multiOswMems);
        result.addAll(osws);
        return result;
    }

    private static void a(@Nonnull OswNode oswNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        for (Port port : oswNode.getPorts()) {
            if (port.isUpper() || port.isDetected()) continue;
            if (!CollectionUtils.isEmpty((Collection)port.getFdbMacs())) {
                b.b(oswNode, port, topologyDevices, topology);
            }
            port.setDetected(true);
        }
    }

    private static boolean b(@Nonnull OswNode oswNode, Map<String, OswNode> generateMap, Map<String, OswNode> detectMap, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        int unDetectedCnt = 0;
        for (Port port : oswNode.getPorts()) {
            if (port.isUpper() || port.isDetected()) continue;
            Set fdbMacs = port.getFdbMacs();
            if (CollectionUtils.isEmpty((Collection)fdbMacs)) {
                port.setDetected(true);
                continue;
            }
            if (b.a(detectMap, (Set<String>)fdbMacs, oswNode.getMac(), topologyDevices)) {
                ++unDetectedCnt;
                a.debug("port <{}> fdb macs of <{}> contain not detect osw", (Object)port.getPortId(), (Object)oswNode.getMac());
                continue;
            }
            Set<String> generateMacs = generateMap.keySet();
            b.a(generateMacs, fdbMacs, (String mac) -> {
                OswNode downLink = (OswNode)generateMap.get(mac);
                b.a(oswNode, downLink, topology, port, topologyDevices);
            });
            b.b(oswNode, port, topologyDevices, topology);
            List downLinks = generateMap.values().stream().filter(osw -> Boolean.TRUE.equals(osw.getDetected())).collect(Collectors.toList());
            downLinks.stream().map(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a::getMac).forEach(generateMap::remove);
            port.setDetected(true);
        }
        return unDetectedCnt == 0;
    }

    private static void a(@Nonnull OswNode oswNode, @Nonnull OswNode targetNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull Port port, TopologyDevices topologyDevices) {
        boolean lldpExcept = ((Set)Optional.ofNullable(port.getLldpNeighbors()).orElse(new HashSet())).stream().anyMatch(dto -> {
            if (Objects.equals(dto.getMac(), targetNode.getMac()) && Boolean.TRUE.equals(dto.getStpLoopExcept())) {
                if (a.isDebugEnabled()) {
                    a.debug("osw:{} lldp neighbor:{} is excluded by stp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)dto));
                }
                return true;
            }
            return false;
        });
        if (lldpExcept) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) && Boolean.TRUE.equals(targetNode.getMlagMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(topologyDevices.getMlagOswMap().get(oswNode.getMac()), topologyDevices.getMlagOswMap().get(targetNode.getMac()), topology, port, oswNode, targetNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) && Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topologyDevices.getVrrpOswMap().get(targetNode.getMac()), topology, port, oswNode, targetNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) && Boolean.TRUE.equals(targetNode.getMlagMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topologyDevices.getMlagOswMap().get(targetNode.getMac()), topology, port, oswNode, targetNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) && Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(topologyDevices.getMlagOswMap().get(oswNode.getMac()), topologyDevices.getVrrpOswMap().get(targetNode.getMac()), topology, port, oswNode, targetNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(topologyDevices.getMlagOswMap().get(oswNode.getMac()), targetNode, topology, port, oswNode.getMac());
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(topologyDevices.getVrrpOswMap().get(oswNode.getMac()), targetNode, topology, port, oswNode.getMac());
            return;
        }
        if (Boolean.TRUE.equals(targetNode.getMlagMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(oswNode, topologyDevices.getMlagOswMap().get(targetNode.getMac()), topology, port, targetNode.getMac());
            return;
        }
        if (Boolean.TRUE.equals(targetNode.getVrrpMem())) {
            if (!b.a((Set<LLDPNeighborDTO>)port.getLldpNeighbors(), oswNode.getMac(), targetNode.getMac())) {
                return;
            }
            b.a(oswNode, topologyDevices.getVrrpOswMap().get(targetNode.getMac()), topology, port, targetNode.getMac());
            return;
        }
        if (Boolean.TRUE.equals(targetNode.getDetected())) {
            return;
        }
        if (port.getLldpNeighbors() != null && port.getLldpNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), targetNode.getMac())) && !topology.hasEdgeConnecting((Object)targetNode, (Object)oswNode) && !Objects.equals(oswNode.getMac(), targetNode.getMac())) {
            OswStpPortInfo stpPortInfo;
            OswOswEdge edge = new OswOswEdge(port, b.b(oswNode.getMac(), targetNode));
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
            if (Optional.ofNullable(oswNode.getPartialBlockedPorts()).map(list -> list.contains(port)).orElse(false).booleanValue()) {
                stpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(port.getStandardOswPort());
                b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            }
            if (edge.getDownLink() != null && Optional.ofNullable(targetNode.getPartialBlockedPorts()).map(list -> list.contains(edge.getDownLink())).orElse(false).booleanValue()) {
                stpPortInfo = (OswStpPortInfo)targetNode.getStpPortInfoMap().get(edge.getDownLink().getStandardOswPort());
                b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
            }
            topology.addEdge((Object)oswNode, (Object)targetNode, (Object)edge);
            targetNode.setDetected(Boolean.valueOf(true));
            return;
        }
        if (!Boolean.TRUE.equals(targetNode.getFdbLink()) && !topology.hasEdgeConnecting((Object)targetNode, (Object)oswNode)) {
            Map fdbOsw = Optional.ofNullable(oswNode.getFdbOsw()).orElse(new HashMap());
            fdbOsw.computeIfAbsent(port.getStandardOswPort(), k2 -> new ArrayList()).add(targetNode);
            targetNode.setFdbLink(Boolean.valueOf(true));
            oswNode.setFdbOsw(fdbOsw);
        }
    }

    private static void a(MultiOswNode multiOswNode, MultiOswNode multiTargetNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Port port, OswNode oswNode, OswNode targetNode) {
        if (Objects.isNull(multiOswNode) || Objects.isNull(multiTargetNode)) {
            return;
        }
        if (multiOswNode.getMacToNodeMap().keySet().containsAll(multiTargetNode.getMacToNodeMap().keySet())) {
            if (a.isInfoEnabled()) {
                a.info("osw1:{} and osw2:{} are in the same multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = null;
        if (topology.nodes().contains(multiTargetNode)) {
            Set inEdges = topology.inEdges((Object)multiTargetNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                MultiOswEdge inEdge = (MultiOswEdge)inEdges.iterator().next();
                if (!new HashSet(inEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw2:{} already has inEdge:{} which doesn't contain multiOsw1:{}, skip", (Object)PIIJacksonUtil.parseToStr(multiTargetNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                multiOswEdge = inEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiTargetNode, (Object)multiOswNode);
                if (!Objects.isNull(optEdge)) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw2:{} already connect to multiOsw1:{}, stop discovering multiOsw1Mem to multiOsw2", (Object)PIIJacksonUtil.parseToStr(multiTargetNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
            }
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), targetNode.getMac())) continue;
                if (a.isInfoEnabled()) {
                    a.info("osw:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        }
        OswOswEdge edge = new OswOswEdge(port, b.b(oswNode.getMac(), targetNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetNode.getMac());
        targetNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().addAll(multiTargetNode.getMacToNodeMap().keySet());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(multiTargetNode.getMac());
            topology.addEdge((Object)multiOswNode, (Object)multiTargetNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        multiTargetNode.setDetected(Boolean.valueOf(true));
    }

    private static boolean a(Set<LLDPNeighborDTO> lldpNeighbors, String mac, String targetMac) {
        if (CollectionUtils.isEmpty(lldpNeighbors)) {
            return false;
        }
        if (!lldpNeighbors.stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), targetMac))) {
            if (a.isInfoEnabled()) {
                a.info("osw1:{} and osw2:{} can't match lldp, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)mac), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetMac));
            }
            return false;
        }
        return true;
    }

    private static void a(MultiOswNode multiOswNode, OswNode targetOsw, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Port port, String oswMac) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge;
        MultiOswEdge multiOswEdge = null;
        if (Boolean.TRUE.equals(targetOsw.getDetected())) {
            Set inEdges = topology.inEdges((Object)targetOsw);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
                if (!Objects.equals(inEdge.getType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a())) {
                    if (a.isInfoEnabled()) {
                        a.info("targetOsw:{} already has inEdge:{} which is not multiOswEdge, skip:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOsw.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                MultiOswEdge multiOswInEdge = (MultiOswEdge)inEdge;
                if (!new HashSet(multiOswInEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                    if (a.isInfoEnabled()) {
                        a.info("targetOsw:{} already has multiOsw inEdge:{} which is not start from multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOsw.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)multiOswInEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                multiOswEdge = multiOswInEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetOsw, (Object)multiOswNode);
                if (!Objects.isNull(optEdge2)) {
                    if (a.isInfoEnabled()) {
                        a.info("osw:{} already connect to multiOsw:{}, stop discovering multiOswMem to osw", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOsw.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
            }
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswMac) || !Objects.equals(edge.getToNodeMac(), targetOsw.getMac())) continue;
                if (a.isInfoEnabled()) {
                    a.info("osw:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOsw.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswMac));
                }
                return;
            }
        } else if (topology.nodes().contains(targetOsw) && topology.nodes().contains(multiOswNode) && !Objects.isNull(optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)targetOsw, (Object)multiOswNode))) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2;
            MultiOswEdge multiOswEdge1 = (MultiOswEdge)optEdge;
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : multiOswEdge1.getEdges()) {
                if (!Objects.equals(edge2.getFromNodeMac(), targetOsw.getMac()) || !Objects.equals(edge2.getToNodeMac(), oswMac)) continue;
                if (a.isInfoEnabled()) {
                    a.info("osw:{} already connect to multiOsw:{}, stop discovering multiOswMem to osw", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOsw.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                }
                return;
            }
            OswNode oswNode = (OswNode)multiOswNode.getMacToNodeMap().get(oswMac);
            edge2 = new OswOswEdge(b.c(oswMac, targetOsw), b.b(targetOsw.getMac(), oswNode));
            edge2.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
            edge2.setFromNodeAndToNode(targetOsw.getMac(), oswMac);
            multiOswEdge1.getEdges().add(edge2);
            oswNode.setDetected(Boolean.valueOf(true));
            return;
        }
        OswOswEdge edge = new OswOswEdge(port, b.b(oswMac, targetOsw));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(oswMac, targetOsw.getMac());
        targetOsw.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(targetOsw.getMac());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(targetOsw.getMac());
            topology.addEdge((Object)multiOswNode, (Object)targetOsw, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
    }

    private static void a(OswNode oswNode, MultiOswNode multiOswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Port port, String targetOswMac) {
        OswNode targetOswNode = (OswNode)multiOswNode.getMacToNodeMap().get(targetOswMac);
        if (Objects.isNull(targetOswNode) || Boolean.TRUE.equals(targetOswNode.getDetected())) {
            if (a.isDebugEnabled()) {
                a.debug("multiOsw member osw:{} already detected, stop discovering osw1:{} and osw2:{}, stop discovering osw1:{} and multiOsw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOswMac), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOswMac), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = null;
        if (topology.nodes().contains(multiOswNode)) {
            Set inEdges = topology.inEdges((Object)multiOswNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                MultiOswEdge inEdge = (MultiOswEdge)inEdges.iterator().next();
                if (!inEdge.getFromNodeMacs().contains(oswNode.getMac())) {
                    com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)oswNode);
                    if (!Objects.isNull(optEdge)) {
                        MultiOswEdge multiOswEdge1 = (MultiOswEdge)optEdge;
                        if (b.a(targetOswMac, oswNode.getMac(), (List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)multiOswEdge1.getEdges())) {
                            return;
                        }
                        OswOswEdge edge = new OswOswEdge(b.c(oswNode.getMac(), targetOswNode), b.c(targetOswMac, oswNode));
                        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
                        edge.setFromNodeAndToNode(targetOswMac, oswNode.getMac());
                        multiOswEdge1.getEdges().add(edge);
                        targetOswNode.setDetected(Boolean.valueOf(true));
                        return;
                    }
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw:{} already has inEdge:{} which doesn't contain osw:{}, skip", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                    }
                    return;
                }
                if (b.a(oswNode.getMac(), targetOswMac, (List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)inEdge.getEdges())) {
                    return;
                }
                multiOswEdge = inEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)oswNode);
                if (!Objects.isNull(optEdge)) {
                    MultiOswEdge multiOswEdge1 = (MultiOswEdge)optEdge;
                    if (b.a(targetOswMac, oswNode.getMac(), (List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)multiOswEdge1.getEdges())) {
                        return;
                    }
                    OswOswEdge edge = new OswOswEdge(b.c(oswNode.getMac(), targetOswNode), b.c(targetOswMac, oswNode));
                    edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
                    edge.setFromNodeAndToNode(targetOswMac, oswNode.getMac());
                    multiOswEdge1.getEdges().add(edge);
                    targetOswNode.setDetected(Boolean.valueOf(true));
                    return;
                }
            }
        }
        OswOswEdge edge = new OswOswEdge(port, b.b(oswNode.getMac(), targetOswNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), targetOswMac);
        targetOswNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().add(oswNode.getMac());
            multiOswEdge.getToNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(oswNode.getMac());
            multiOswEdge.setToNodeMac(multiOswNode.getMac());
            topology.addEdge((Object)oswNode, (Object)multiOswNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        multiOswNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(OswStpPortInfo stpPortInfo, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge) {
        if (stpPortInfo == null || CollectionUtils.isEmpty((Collection)stpPortInfo.getStpVlan())) {
            return;
        }
        List blockedVlans = Optional.ofNullable(edge.getBlockedVlans()).orElseGet(ArrayList::new);
        blockedVlans.addAll(stpPortInfo.getStpVlan());
        edge.setBlockedVlans(blockedVlans);
    }

    private static void a(Map<String, StpLoopInfoDTO> stpLoopInfoDTOMap, OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge) {
        stpLoopInfoDTOMap.compute(oswNode.getMac(), (k2, v2) -> {
            if (v2 == null) {
                StpLoopInfoDTO loopInfo = new StpLoopInfoDTO();
                loopInfo.setMac(oswNode.getMac());
                HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> edges = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>();
                edges.add(edge);
                loopInfo.setEdges(edges);
                return loopInfo;
            }
            v2.getEdges().add(edge);
            return v2;
        });
    }

    private static Port b(String upLinkMac, OswNode oswNode) {
        if (!CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
            for (Port port : oswNode.getUpperPorts()) {
                if (!b.a(upLinkMac, port, oswNode)) continue;
                return port;
            }
        }
        if (Objects.nonNull(oswNode.getUpperPort()) && b.a(upLinkMac, oswNode.getUpperPort(), oswNode)) {
            return oswNode.getUpperPort();
        }
        for (Port port : oswNode.getPorts()) {
            if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors()) || !port.getLldpNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), upLinkMac))) continue;
            if (a.isDebugEnabled()) {
                a.debug("find osw upperPort by lldp, osw:{}, port:{}, uplinkMac:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)port), (Object)com.tplink.smb.omada.common.util.e.a.d((String)upLinkMac));
            }
            if (!Objects.isNull(oswNode.getUpperPort())) {
                oswNode.getUpperPort().setUpper(false);
                if (!CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
                    oswNode.getUpperPorts().remove(oswNode.getUpperPort());
                }
                if (a.isDebugEnabled()) {
                    a.debug("change osw upperPort, oswMac:{}, oldUpperPort:{}, newUpperPort:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswNode.getUpperPort()), (Object)PIIJacksonUtil.parseToStr((Object)port));
                }
            }
            oswNode.setUpperPort(port);
            port.setUpper(true);
            if (CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
                ArrayList<Port> upperPorts = new ArrayList<Port>();
                upperPorts.add(port);
                oswNode.setUpperPorts(upperPorts);
            } else if (!oswNode.getUpperPorts().contains(port)) {
                oswNode.getUpperPorts().add(port);
            }
            return port;
        }
        for (Port port : oswNode.getPorts()) {
            if (!port.getFdbMacs().contains(upLinkMac)) continue;
            if (!Objects.isNull(oswNode.getUpperPort())) {
                oswNode.getUpperPort().setUpper(false);
                if (!CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
                    oswNode.getUpperPorts().remove(oswNode.getUpperPort());
                }
            }
            if (a.isInfoEnabled()) {
                a.info("fail to find osw upperPort by lldp, use fdb instead, osw = {}, port = {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)port);
            }
            oswNode.setUpperPort(port);
            port.setUpper(true);
            if (CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
                ArrayList<Port> upperPorts = new ArrayList<Port>();
                upperPorts.add(port);
                oswNode.setUpperPorts(upperPorts);
            } else if (!oswNode.getUpperPorts().contains(port)) {
                oswNode.getUpperPorts().add(port);
            }
            return port;
        }
        return oswNode.getUpperPort();
    }

    private static Port a(String neighborMac, ApNode apNode) {
        return Optional.ofNullable(apNode.getLldpPortMap()).map(map -> (String)map.get(neighborMac)).map(portId -> {
            Port port = new Port();
            port.setPortId(0);
            port.setApPortId(portId);
            return port;
        }).orElse(null);
    }

    private static boolean a(String upLinkMac, Port upperPort, OswNode oswNode) {
        if (!CollectionUtils.isEmpty((Collection)upperPort.getLldpNeighbors()) && upperPort.getLldpNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), upLinkMac))) {
            return true;
        }
        if (a.isDebugEnabled()) {
            a.debug("osw:{} previous upperPort:{} lldp doesn't contain uplinkMac: {}, maybe not the directly connect port in loop condition, need to find new upperPort", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)oswNode.getUpperPort()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)upLinkMac));
        }
        return false;
    }

    private static Port c(String upLinkMac, OswNode oswNode) {
        if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) {
            return null;
        }
        for (Port port : oswNode.getPorts()) {
            if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors()) || !port.getLldpNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), upLinkMac))) continue;
            return port;
        }
        return null;
    }

    private static Port d(String upLinkMac, OswNode oswNode) {
        if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) {
            return null;
        }
        ArrayList<Port> matchPorts = new ArrayList<Port>();
        for (Port port : oswNode.getPorts()) {
            if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors()) || !port.getLldpNeighbors().stream().anyMatch(lldpNeighborDTO -> Objects.equals(lldpNeighborDTO.getMac(), upLinkMac))) continue;
            matchPorts.add(port);
        }
        if (CollectionUtils.isEmpty(matchPorts)) {
            return null;
        }
        if (matchPorts.size() == 1) {
            return (Port)matchPorts.iterator().next();
        }
        for (Port port : matchPorts) {
            if (!port.getLldpNeighbors().stream().anyMatch(dto -> Boolean.TRUE.equals(dto.getStpLoopExcept()))) continue;
            return port;
        }
        return (Port)matchPorts.iterator().next();
    }

    private static void b(TopologyDevices topologyDevices, @Nonnull Port port, @Nonnull OswNode oswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) {
            return;
        }
        for (LLDPNeighborDTO neighborDTO : port.getLldpNeighbors()) {
            switch (neighborDTO.getType()) {
                case "switch": {
                    if (CollectionUtils.isEmpty(topologyDevices.getOswMap()) || !Objects.nonNull(topologyDevices.getOswMap().get(neighborDTO.getMac()))) break;
                    b.a(oswNode, topologyDevices.getOswMap().get(neighborDTO.getMac()), topology, port, topologyDevices);
                    break;
                }
                case "ap": {
                    b.a(port, neighborDTO.getMac(), oswNode, topology, topologyDevices, neighborDTO);
                    break;
                }
                case "olt": {
                    b.c(port, neighborDTO.getMac(), oswNode, topology, topologyDevices);
                    break;
                }
                case "other": {
                    b.b(port, neighborDTO, oswNode, topology, topologyDevices);
                    break;
                }
                case "NVR": {
                    b.a(port, neighborDTO.getMac(), oswNode, topology, topologyDevices);
                    break;
                }
                case "IPC": {
                    b.b(port, neighborDTO.getMac(), oswNode, topology, topologyDevices);
                    break;
                }
            }
        }
    }

    private static void a(@Nonnull Port port, String nvrMac, @Nonnull OswNode oswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        Map<String, NvrNode> nvrMap = topologyDevices.getNvrMap();
        if (CollectionUtils.isEmpty(nvrMap)) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(oswNode, nvrMac, topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(oswNode, nvrMac, topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        NvrNode nvrNode = nvrMap.get(nvrMac);
        if (Objects.isNull(nvrNode) || Boolean.TRUE.equals(nvrNode.getDetected()) || !Boolean.TRUE.equals(nvrNode.getManaged())) {
            return;
        }
        OswNvrEdge oswNvrEdge = new OswNvrEdge();
        oswNvrEdge.setFromNodeAndToNode(oswNode.getMac(), nvrMac);
        oswNvrEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.p.a());
        oswNvrEdge.setUpLink(port);
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(oswNode.getMac()))) {
            Port downLink = new Port();
            downLink.setPortId(((Integer)nvrNode.getMacPortMap().get(oswNode.getMac())).intValue());
            oswNvrEdge.setDownLink(downLink);
        }
        topology.addEdge((Object)oswNode, (Object)nvrNode, (Object)oswNvrEdge);
        nvrNode.setDetected(Boolean.valueOf(true));
        b.a(nvrNode, topologyDevices, topology);
    }

    private static void a(OswNode oswNode, String nvrMac, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, Port port) {
        Map<String, NvrNode> nvrMap = topologyDevices.getNvrMap();
        if (CollectionUtils.isEmpty(nvrMap) || !nvrMap.containsKey(nvrMac)) {
            return;
        }
        NvrNode nvrNode = nvrMap.get(nvrMac);
        MultiOswEdge multiOswEdge = null;
        if (Boolean.TRUE.equals(nvrNode.getDetected())) {
            Set inEdges = topology.inEdges((Object)nvrNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
                if (!Objects.equals(inEdge.getType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a())) {
                    if (a.isInfoEnabled()) {
                        a.info("nvr:{} already has inEdge:{} which is not multiOswEdge, skip:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)nvrNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                MultiOswEdge multiOswInEdge = (MultiOswEdge)inEdge;
                if (!new HashSet(multiOswInEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                    if (a.isInfoEnabled()) {
                        a.info("nvr:{} already has multiOsw inEdge:{} which is not start from multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)nvrNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)multiOswInEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                multiOswEdge = multiOswInEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)nvrNode, (Object)multiOswNode);
                if (!Objects.isNull(optEdge)) {
                    if (a.isInfoEnabled()) {
                        a.info("nvr:{} already connect to multiOsw:{}, stop discovering multiOswMem to nvr", (Object)com.tplink.smb.omada.common.util.e.a.d((String)nvrNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
            }
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), nvrMac)) continue;
                if (a.isInfoEnabled()) {
                    a.info("nvr:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)nvrNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        }
        OswNvrEdge edge = new OswNvrEdge();
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.p.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), nvrNode.getMac());
        edge.setUpLink(port);
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(oswNode.getMac()))) {
            Port downLink = new Port();
            downLink.setPortId(((Integer)nvrNode.getMacPortMap().get(oswNode.getMac())).intValue());
            edge.setDownLink(downLink);
        }
        nvrNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(nvrNode.getMac());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(nvrNode.getMac());
            topology.addEdge((Object)multiOswNode, (Object)nvrNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        b.a(nvrNode, topologyDevices, topology);
    }

    private static void b(@Nonnull Port port, String ipcMac, @Nonnull OswNode oswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        Map<String, IpcNode> ipcMap = topologyDevices.getIpcMap();
        if (CollectionUtils.isEmpty(ipcMap)) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.b(oswNode, ipcMac, topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.b(oswNode, ipcMac, topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        IpcNode ipcNode = ipcMap.get(ipcMac);
        if (Objects.isNull(ipcNode) || Boolean.TRUE.equals(ipcNode.getDetected()) || !Boolean.TRUE.equals(ipcNode.getManaged())) {
            return;
        }
        OswIpcEdge oswIpcEdge = new OswIpcEdge();
        oswIpcEdge.setFromNodeAndToNode(oswNode.getMac(), ipcMac);
        oswIpcEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.q.a());
        oswIpcEdge.setUpLink(port);
        topology.addEdge((Object)oswNode, (Object)ipcNode, (Object)oswIpcEdge);
        ipcNode.setDetected(Boolean.valueOf(true));
    }

    private static void b(OswNode oswNode, String ipcMac, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, Port port) {
        Object inEdges;
        Map<String, IpcNode> ipcMap = topologyDevices.getIpcMap();
        if (CollectionUtils.isEmpty(ipcMap) || !ipcMap.containsKey(ipcMac)) {
            return;
        }
        IpcNode ipcNode = ipcMap.get(ipcMac);
        MultiOswEdge multiOswEdge = null;
        if (Boolean.TRUE.equals(ipcNode.getDetected()) && !CollectionUtils.isEmpty((Collection)(inEdges = topology.inEdges((Object)ipcNode)))) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
            if (!Objects.equals(inEdge.getType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a())) {
                if (a.isInfoEnabled()) {
                    a.info("ipc:{} already has inEdge:{} which is not multiOswEdge, skip:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)ipcNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                }
                return;
            }
            MultiOswEdge multiOswInEdge = (MultiOswEdge)inEdge;
            if (!new HashSet(multiOswInEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                if (a.isInfoEnabled()) {
                    a.info("ipc:{} already has multiOsw inEdge:{} which is not start from multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)ipcNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)multiOswInEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                }
                return;
            }
            multiOswEdge = multiOswInEdge;
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), ipcMac)) continue;
                if (a.isInfoEnabled()) {
                    a.info("ipc:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)ipcNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        }
        OswIpcEdge edge = new OswIpcEdge();
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.q.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), ipcNode.getMac());
        edge.setUpLink(port);
        ipcNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(ipcNode.getMac());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(ipcNode.getMac());
            topology.addEdge((Object)multiOswNode, (Object)ipcNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
    }

    private static void a(@Nonnull Port port, String apMac, @Nonnull OswNode oswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, LLDPNeighborDTO neighborDTO) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.c(oswNode, apMac, topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.c(oswNode, apMac, topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap)) {
            return;
        }
        ApNode apNode = apMap.get(apMac);
        if (apNode == null || Boolean.TRUE.equals(apNode.getDetected()) || Boolean.TRUE.equals(neighborDTO.getDetected())) {
            return;
        }
        OswApEdge edge = new OswApEdge(port, b.a(oswNode.getMac(), apNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), apNode.getMac());
        topology.addEdge((Object)oswNode, (Object)apNode, (Object)edge);
        apNode.setDetected(Boolean.valueOf(true));
        b.a(apNode, topologyDevices, topology);
    }

    private static void c(OswNode oswNode, String apMac, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, Port port) {
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        if (CollectionUtils.isEmpty(apMap) || !apMap.containsKey(apMac) || Objects.isNull(multiOswNode)) {
            return;
        }
        ApNode apNode = apMap.get(apMac);
        MultiOswEdge multiOswEdge = null;
        if (Boolean.TRUE.equals(apNode.getDetected())) {
            Set inEdges = topology.inEdges((Object)apNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
                if (!Objects.equals(inEdge.getType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a())) {
                    if (a.isInfoEnabled()) {
                        a.info("ap:{} already has inEdge:{} which is not multiOswEdge, skip:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                MultiOswEdge multiOswInEdge = (MultiOswEdge)inEdge;
                if (!new HashSet(multiOswInEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                    if (a.isInfoEnabled()) {
                        a.info("ap:{} already has multiOsw inEdge:{} which is not start from multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)multiOswInEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                multiOswEdge = multiOswInEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)apNode, (Object)multiOswNode);
                if (!Objects.isNull(optEdge)) {
                    if (a.isInfoEnabled()) {
                        a.info("ap:{} already connect to multiOsw:{}, stop discovering multiOswMem to ap", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
            }
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), apMac)) continue;
                if (a.isInfoEnabled()) {
                    a.info("ap:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        }
        OswApEdge edge = new OswApEdge(port, b.a(oswNode.getMac(), apNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), apNode.getMac());
        apNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(apNode.getMac());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(apNode.getMac());
            topology.addEdge((Object)multiOswNode, (Object)apNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        b.a(apNode, topologyDevices, topology);
    }

    private static void c(@Nonnull Port port, String oltMac, @Nonnull OswNode oswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.d(oswNode, oltMac, topologyDevices, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.d(oswNode, oltMac, topologyDevices, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
            return;
        }
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        if (CollectionUtils.isEmpty(oltMap)) {
            return;
        }
        OltNode oltNode = oltMap.get(oltMac);
        if (Objects.isNull(oltNode)) {
            return;
        }
        if (!Boolean.TRUE.equals(oltNode.getDetected())) {
            OswOltEdge edge = new OswOltEdge(port);
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), oltNode.getMac());
            Map lldpPortMap = oltNode.getLldpPortMap();
            if (lldpPortMap != null && lldpPortMap.get(oswNode.getMac()) != null) {
                Port downLink = new Port();
                downLink.setStandardOswPort((String)lldpPortMap.get(oswNode.getMac()));
                edge.setDownLink(downLink);
            }
            topology.addEdge((Object)oswNode, (Object)oltNode, (Object)edge);
            oltNode.setDetected(Boolean.valueOf(true));
            b.a(oltNode, topologyDevices, topology);
        }
    }

    private static void d(OswNode oswNode, String oltMac, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, Port port) {
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        if (CollectionUtils.isEmpty(oltMap) || !oltMap.containsKey(oltMac)) {
            return;
        }
        OltNode oltNode = oltMap.get(oltMac);
        MultiOswEdge multiOswEdge = null;
        if (Boolean.TRUE.equals(oltNode.getDetected())) {
            Set inEdges = topology.inEdges((Object)oltNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
                if (!Objects.equals(inEdge.getType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a())) {
                    if (a.isInfoEnabled()) {
                        a.info("olt:{} already has inEdge:{} which is not multiOswEdge, skip:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                MultiOswEdge multiOswInEdge = (MultiOswEdge)inEdge;
                if (!new HashSet(multiOswInEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                    if (a.isInfoEnabled()) {
                        a.info("olt:{} already has multiOsw inEdge:{} which is not start from multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)multiOswInEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                multiOswEdge = multiOswInEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oltNode, (Object)multiOswNode);
                if (!Objects.isNull(optEdge)) {
                    if (a.isInfoEnabled()) {
                        a.info("olt:{} already connect to multiOsw:{}, stop discovering multiOswMem to olt", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
            }
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), oltMac)) continue;
                if (a.isInfoEnabled()) {
                    a.info("olt:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        }
        OswOltEdge edge = new OswOltEdge(port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), oltNode.getMac());
        Map lldpPortMap = oltNode.getLldpPortMap();
        if (lldpPortMap != null && lldpPortMap.get(oswNode.getMac()) != null) {
            Port downLink = new Port();
            downLink.setStandardOswPort((String)lldpPortMap.get(oswNode.getMac()));
            edge.setDownLink(downLink);
        }
        oltNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(oltNode.getMac());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(oltNode.getMac());
            topology.addEdge((Object)multiOswNode, (Object)oltNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        b.a(oltNode, topologyDevices, topology);
    }

    private static void b(@Nonnull Port port, LLDPNeighborDTO neighborDTO, @Nonnull OswNode oswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(oswNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), neighborDTO, topology, topologyDevices, port);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(oswNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), neighborDTO, topology, topologyDevices, port);
            return;
        }
        Map<String, OtherNode> otherMap = topologyDevices.getOtherMap();
        String otherMac = neighborDTO.getMac();
        OtherNode otherNode = otherMap.computeIfAbsent(otherMac, k2 -> new OtherNode(otherMac, neighborDTO.getName()));
        if (!Objects.isNull(neighborDTO.getPortLabels())) {
            otherNode.setPortLabels(neighborDTO.getPortLabels());
        }
        if (!Boolean.TRUE.equals(otherNode.getDetected())) {
            BaseOswEdge edge = new BaseOswEdge(port);
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), otherMac);
            topology.addEdge((Object)oswNode, (Object)otherNode, (Object)edge);
            otherNode.setDetected(Boolean.valueOf(true));
            b.a(topologyDevices, topology, otherNode);
        }
    }

    private static void a(OswNode oswNode, MultiOswNode multiOswNode, LLDPNeighborDTO neighborDTO, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices, Port port) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge;
        Map<String, OtherNode> otherMap = topologyDevices.getOtherMap();
        String otherMac = neighborDTO.getMac();
        OtherNode otherNode = otherMap.computeIfAbsent(otherMac, k2 -> new OtherNode(otherMac, neighborDTO.getName()));
        MultiOswEdge multiOswEdge = null;
        if (Boolean.TRUE.equals(otherNode.getDetected())) {
            Set inEdges = topology.inEdges((Object)otherNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
                if (!Objects.equals(inEdge.getType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a())) {
                    if (a.isInfoEnabled()) {
                        a.info("other:{} already has inEdge:{} which is not multiOswEdge, skip:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                MultiOswEdge multiOswInEdge = (MultiOswEdge)inEdge;
                if (!new HashSet(multiOswInEdge.getFromNodeMacs()).containsAll(multiOswNode.getMacToNodeMap().keySet())) {
                    if (a.isInfoEnabled()) {
                        a.info("other:{} already has multiOsw inEdge:{} which is not start from multiOswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)multiOswInEdge), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
                multiOswEdge = multiOswInEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge2 = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)otherNode, (Object)multiOswNode);
                if (!Objects.isNull(optEdge2)) {
                    if (a.isInfoEnabled()) {
                        a.info("other:{} already connect to multiOsw:{}, stop discovering multiOswMem to other", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    }
                    return;
                }
            }
        }
        if (!Objects.isNull(multiOswEdge)) {
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : multiOswEdge.getEdges()) {
                if (!Objects.equals(edge.getFromNodeMac(), oswNode.getMac()) || !Objects.equals(edge.getToNodeMac(), otherMac)) continue;
                if (a.isInfoEnabled()) {
                    a.info("other:{} already has multiOsw inEdge:{} which is start from oswNode:{}, skip", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        } else if (topology.nodes().contains(otherNode) && !Objects.isNull(optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)otherNode, (Object)multiOswNode))) {
            if (a.isInfoEnabled()) {
                a.info("otherNode:{} already connect to multiOsw:{}, stop discovering multiOswMem to otherNode", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherMac), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        BaseOswEdge edge = new BaseOswEdge(port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
        edge.setFromNodeAndToNode(oswNode.getMac(), otherNode.getMac());
        otherNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(otherNode.getMac());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(otherNode.getMac());
            topology.addEdge((Object)multiOswNode, (Object)otherNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        b.a(topologyDevices, topology, otherNode);
    }

    private static void a(String oswMac, OsgNode osgNode, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (topologyDevices.getMlagOswMap().containsKey(oswMac)) {
            b.a(oswMac, osgNode, topologyDevices.getMlagOswMap().get(oswMac), topology);
            return;
        }
        if (topologyDevices.getVrrpOswMap().containsKey(oswMac)) {
            b.a(oswMac, osgNode, topologyDevices.getVrrpOswMap().get(oswMac), topology);
            return;
        }
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        OswNode oswNode = oswMap.get(oswMac);
        if (Objects.isNull(oswNode) || Boolean.TRUE.equals(oswNode.getDetected())) {
            return;
        }
        OsgOswEdge edge = new OsgOswEdge(b.b(osgNode.getMac(), oswNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.b.a());
        if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(oswMac)) {
            Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(oswMac);
            Port port = new Port();
            port.setPortId(osgPortId.intValue());
            edge.setUpLink(port);
        }
        if (edge.getDownLink() != null && Optional.ofNullable(oswNode.getPartialBlockedPorts()).map(list -> list.contains(edge.getDownLink())).orElse(false).booleanValue()) {
            OswStpPortInfo stpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(edge.getDownLink().getStandardOswPort());
            b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        edge.setFromNodeAndToNode(osgNode.getMac(), oswMac);
        topology.addEdge((Object)osgNode, (Object)oswNode, (Object)edge);
        oswNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(String oswMac, OsgNode osgNode, MultiOswNode multiOswNode, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(multiOswNode)) {
            return;
        }
        OswNode oswNode = (OswNode)multiOswNode.getMacToNodeMap().get(oswMac);
        if (Objects.isNull(oswNode) || Boolean.TRUE.equals(oswNode.getDetected())) {
            if (a.isDebugEnabled()) {
                a.debug("multiOsw member osw:{} already detected, stop discovering osg:{} and osw:{}, stop discovering osg:{} and multiOsw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)osgNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)osgNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        b.a(multiOswNode, topology, osgNode, oswNode);
    }

    private static void a(MultiOswNode multiOswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OsgNode osgNode, OswNode oswNode) {
        Set inEdges;
        MultiOswEdge multiOswEdge = null;
        if (topology.nodes().contains(multiOswNode) && !CollectionUtils.isEmpty((Collection)(inEdges = topology.inEdges((Object)multiOswNode)))) {
            MultiOswEdge inEdge = (MultiOswEdge)inEdges.iterator().next();
            if (!inEdge.getFromNodeMacs().contains(osgNode.getMac())) {
                if (a.isInfoEnabled()) {
                    a.info("multiOsw:{} already has inEdge:{} which doesn't contain osg:{}, skip", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)osgNode.getMac()));
                }
                return;
            }
            multiOswEdge = inEdge;
        }
        OsgOswEdge edge = new OsgOswEdge(b.b(osgNode.getMac(), oswNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.b.a());
        if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(oswNode.getMac())) {
            Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(oswNode.getMac());
            Port port = new Port();
            port.setPortId(osgPortId.intValue());
            edge.setUpLink(port);
        }
        if (edge.getDownLink() != null && Optional.ofNullable(oswNode.getPartialBlockedPorts()).map(list -> list.contains(edge.getDownLink())).orElse(false).booleanValue()) {
            OswStpPortInfo stpPortInfo = (OswStpPortInfo)oswNode.getStpPortInfoMap().get(edge.getDownLink().getStandardOswPort());
            b.a(stpPortInfo, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)edge);
        }
        edge.setFromNodeAndToNode(osgNode.getMac(), oswNode.getMac());
        oswNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().add(osgNode.getMac());
            multiOswEdge.getToNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(osgNode.getMac());
            multiOswEdge.setToNodeMac(multiOswNode.getMac());
            topology.addEdge((Object)osgNode, (Object)multiOswNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        multiOswNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(LLDPNeighborDTO neighborDTO, OsgNode osgNode, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        String apMac = neighborDTO.getMac();
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        ApNode apNode = apMap.get(apMac);
        if (Objects.isNull(apNode) || Boolean.TRUE.equals(apNode.getDetected()) || Boolean.TRUE.equals(neighborDTO.getDetected())) {
            return;
        }
        OsgApEdge edge = new OsgApEdge(null, b.a(osgNode.getMac(), apNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.g.a());
        if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(apMac)) {
            Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(apMac);
            Port port = new Port();
            port.setPortId(osgPortId.intValue());
            edge.setUpLink(port);
        }
        edge.setFromNodeAndToNode(osgNode.getMac(), apNode.getMac());
        topology.addEdge((Object)osgNode, (Object)apNode, (Object)edge);
        apNode.setDetected(Boolean.valueOf(true));
        b.a(apNode, topologyDevices, topology);
    }

    private static void b(String nvrMac, OsgNode osgNode, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, NvrNode> nvrMap = topologyDevices.getNvrMap();
        if (CollectionUtils.isEmpty(nvrMap)) {
            return;
        }
        NvrNode nvrNode = nvrMap.get(nvrMac);
        if (Objects.isNull(nvrNode) || Boolean.TRUE.equals(nvrNode.getDetected()) || !Boolean.TRUE.equals(nvrNode.getManaged())) {
            return;
        }
        OsgNvrEdge osgNvrEdge = new OsgNvrEdge();
        osgNvrEdge.setFromNodeAndToNode(osgNode.getMac(), nvrMac);
        osgNvrEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.c.a());
        if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(nvrMac)) {
            Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(nvrMac);
            Port port = new Port();
            port.setPortId(osgPortId.intValue());
            osgNvrEdge.setUpLink(port);
        }
        if (!CollectionUtils.isEmpty((Map)nvrNode.getMacPortMap()) && Objects.nonNull(nvrNode.getMacPortMap().get(osgNode.getMac()))) {
            Port downLink = new Port();
            downLink.setPortId(((Integer)nvrNode.getMacPortMap().get(osgNode.getMac())).intValue());
            osgNvrEdge.setDownLink(downLink);
        }
        topology.addEdge((Object)osgNode, (Object)nvrNode, (Object)osgNvrEdge);
        nvrNode.setDetected(Boolean.valueOf(true));
        b.a(nvrNode, topologyDevices, topology);
    }

    private static void c(String ipcMac, OsgNode osgNode, TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Map<String, IpcNode> ipcMap = topologyDevices.getIpcMap();
        if (CollectionUtils.isEmpty(ipcMap)) {
            return;
        }
        IpcNode ipcNode = ipcMap.get(ipcMac);
        if (Objects.isNull(ipcNode) || Boolean.TRUE.equals(ipcNode.getDetected()) || !Boolean.TRUE.equals(ipcNode.getManaged())) {
            return;
        }
        OsgIpcEdge osgIpcEdge = new OsgIpcEdge();
        osgIpcEdge.setFromNodeAndToNode(osgNode.getMac(), ipcMac);
        osgIpcEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.d.a());
        if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(ipcMac)) {
            Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(ipcMac);
            Port port = new Port();
            port.setPortId(osgPortId.intValue());
            osgIpcEdge.setUpLink(port);
        }
        topology.addEdge((Object)osgNode, (Object)ipcNode, (Object)osgIpcEdge);
        ipcNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(String oltMac, OsgNode osgNode, Map<String, OltNode> oltMap, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, TopologyDevices topologyDevices) {
        Port port;
        OltNode oltNode = oltMap.get(oltMac);
        if (Objects.isNull(oltNode) || Boolean.TRUE.equals(oltNode.getDetected())) {
            return;
        }
        OsgOltEdge edge = new OsgOltEdge();
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.f.a());
        if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(oltMac)) {
            Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(oltMac);
            port = new Port();
            port.setPortId(osgPortId.intValue());
            edge.setUpLink(port);
        }
        if (Objects.nonNull(oltNode.getLldpPortMap()) && oltNode.getLldpPortMap().containsKey(osgNode.getMac())) {
            String oltPortId = (String)oltNode.getLldpPortMap().get(osgNode.getMac());
            port = new Port();
            port.setStandardOswPort(oltPortId);
            edge.setDownLink(port);
        }
        edge.setFromNodeAndToNode(osgNode.getMac(), oltNode.getMac());
        topology.addEdge((Object)osgNode, (Object)oltNode, (Object)edge);
        oltNode.setDetected(Boolean.valueOf(true));
        b.a(oltNode, topologyDevices, topology);
    }

    private static void b(LLDPNeighborDTO neighborDTO, OsgNode osgNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        String neighborMac = neighborDTO.getMac();
        OtherNode otherNode = topologyDevices.getOtherMap().computeIfAbsent(neighborMac, k2 -> new OtherNode(neighborMac, neighborDTO.getName()));
        if (!Boolean.TRUE.equals(otherNode.getDetected())) {
            BaseOsgEdge edge = new BaseOsgEdge();
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.a.a());
            if (Objects.nonNull(osgNode.getLldpPortMap()) && osgNode.getLldpPortMap().containsKey(neighborMac)) {
                Integer osgPortId = (Integer)osgNode.getLldpPortMap().get(neighborMac);
                Port port = new Port();
                port.setPortId(osgPortId.intValue());
                edge.setUpLink(port);
            }
            edge.setFromNodeAndToNode(osgNode.getMac(), neighborMac);
            topology.addEdge((Object)osgNode, (Object)otherNode, (Object)edge);
            otherNode.setDetected(Boolean.valueOf(true));
            b.a(topologyDevices, topology, otherNode);
        }
    }

    private static boolean a(ApNode apNode, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Port port, TopologyDevices topologyDevices) {
        if (CollectionUtils.isEmpty((Collection)apNode.getNeighbors()) || port == null || CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) {
            return false;
        }
        if (Boolean.TRUE.equals(oswNode.getAsTmpRoot())) {
            if (a.isInfoEnabled()) {
                a.info("ap {} try to connect tmpRoot switch {}, maybe lldp loop", (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            return false;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            return b.a(apNode, oswNode, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            return b.a(apNode, oswNode, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
        }
        if (!apNode.getNeighbors().stream().map(LLDPNeighborDTO::getMac).collect(Collectors.toSet()).contains(oswNode.getMac()) || !port.getLldpNeighbors().stream().map(LLDPNeighborDTO::getMac).collect(Collectors.toSet()).contains(apNode.getMac())) {
            return false;
        }
        if (topology.hasEdgeConnecting((Object)oswNode, (Object)apNode)) {
            return false;
        }
        ApOswEdge edge = new ApOswEdge(b.a(oswNode.getMac(), apNode), port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.w.a());
        port.setDetected(true);
        edge.setFromNodeAndToNode(apNode.getMac(), oswNode.getMac());
        topology.addEdge((Object)apNode, (Object)oswNode, (Object)edge);
        return true;
    }

    private static boolean a(ApNode apNode, OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, Port port) {
        if (Objects.isNull(oswNode) || Boolean.TRUE.equals(oswNode.getDetected())) {
            if (a.isDebugEnabled()) {
                a.debug("multiOsw member osw:{} already detected, stop discovering ap:{} and osw:{}, stop discovering ap:{} and multiOsw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return false;
        }
        MultiOswEdge multiOswEdge = null;
        if (topology.nodes().contains(multiOswNode)) {
            Set inEdges = topology.inEdges((Object)multiOswNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                MultiOswEdge inEdge = (MultiOswEdge)inEdges.iterator().next();
                if (!inEdge.getFromNodeMacs().contains(apNode.getMac())) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw:{} already has inEdge:{} which doesn't contain ap:{}, skip", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()));
                    }
                    return false;
                }
                multiOswEdge = inEdge;
            } else {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)apNode);
                if (!Objects.isNull(optEdge)) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw:{} already connect to ap:{}, stop discovering ap to multiOswMem", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()));
                    }
                    return false;
                }
            }
        }
        ApOswEdge edge = new ApOswEdge(b.a(oswNode.getMac(), apNode), port);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.w.a());
        edge.setFromNodeAndToNode(apNode.getMac(), oswNode.getMac());
        oswNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().add(apNode.getMac());
            multiOswEdge.getToNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(apNode.getMac());
            multiOswEdge.setToNodeMac(multiOswNode.getMac());
            topology.addEdge((Object)apNode, (Object)multiOswNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        multiOswNode.setDetected(Boolean.valueOf(true));
        return true;
    }

    private static void b(@Nonnull OswNode oswNode, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        for (Port port : oswNode.getPorts()) {
            if (port.isUpper() || port.isDetected()) continue;
            Set fdbMacs = port.getFdbMacs();
            if (CollectionUtils.isEmpty((Collection)fdbMacs)) {
                port.setDetected(true);
                continue;
            }
            b.b(oswNode, port, topologyDevices, topology);
            port.setDetected(true);
        }
    }

    private static void b(OswNode oswNode, @Nonnull Port port, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode;
        Set fdbMacs = port.getFdbMacs();
        if (!CollectionUtils.isEmpty((Collection)fdbMacs)) {
            b.a(oswNode, port, topologyDevices, topology);
        }
        if ((omadacNode = topologyDevices.getOmadacNode()) != null) {
            if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                b.a(oswNode, omadacNode, topology, topologyDevices.getMlagOswMap().get(oswNode.getMac()), port);
                return;
            }
            if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                b.a(oswNode, omadacNode, topology, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), port);
                return;
            }
            b.a(oswNode, port, omadacNode, (Set<String>)fdbMacs, topology);
        }
    }

    private static void a(OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, Port port) {
        if (CollectionUtils.isEmpty((Collection)omadacNode.a())) {
            return;
        }
        if (topology.nodes().contains(omadacNode)) {
            a.debug("Omada Controller node already in topology while discoverMultiOswOmadac <{}> with <{}>", (Object)oswNode.getMac(), (Object)port);
            return;
        }
        Set fdbMacs = Optional.ofNullable(port).map(Port::getFdbMacs).orElse(new HashSet());
        for (String omadaMac : omadacNode.a()) {
            if (!fdbMacs.contains(omadaMac)) continue;
            MultiOswEdge multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.getToNodeMacs().add(omadaMac);
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(multiOswNode.getMac());
            multiOswEdge.setToNodeMac(omadacNode.getMac());
            BaseOswEdge edge = new BaseOswEdge(port);
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), omadacNode.getMac());
            multiOswEdge.getEdges().add(edge);
            topology.addEdge((Object)multiOswNode, (Object)omadacNode, (Object)multiOswEdge);
            return;
        }
    }

    private static void a(OswNode oswNode, Port port, @Nonnull com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode, Set<String> fdbMacs, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty((Collection)omadacNode.a())) {
            return;
        }
        if (topology.nodes().contains(omadacNode)) {
            a.debug("Omada Controller node already in topology while discoveryOmadacByOsw <{}> with <{}>", (Object)oswNode.getMac(), (Object)port.getPortId());
            return;
        }
        for (String omadaMac : omadacNode.a()) {
            if (!fdbMacs.contains(omadaMac)) continue;
            omadacNode.setMac(omadaMac);
            BaseOswEdge edge = new BaseOswEdge(port);
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), omadacNode.getMac());
            topology.addEdge((Object)oswNode, (Object)omadacNode, (Object)edge);
            return;
        }
    }

    private static void a(@Nonnull OsgNode osg, @Nonnull com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b omadacNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty((Collection)omadacNode.a()) || CollectionUtils.isEmpty((Collection)osg.getArps())) {
            return;
        }
        if (topology.nodes().contains(omadacNode)) {
            a.debug("Omada Controller node already in topology while discoveryOmadacByOsg <{}>", (Object)osg.getMac());
            return;
        }
        Set arps = osg.getArps();
        for (String omadaMac : omadacNode.a()) {
            if (!arps.contains(omadaMac)) continue;
            omadacNode.setMac(omadaMac);
            BaseOsgEdge edge = new BaseOsgEdge();
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.a.a());
            edge.setFromNodeAndToNode(osg.getMac(), omadacNode.getMac());
            topology.addEdge((Object)osg, (Object)omadacNode, (Object)edge);
            return;
        }
    }

    private static void a(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology) {
        Map<String, OswNode> oswMap = topologyDevices.getOswMap();
        if (CollectionUtils.isEmpty(oswMap)) {
            return;
        }
        for (OswNode oswNode : oswMap.values()) {
            if (!CollectionUtils.isEmpty((Map)oswNode.getFdbOsw())) {
                b.a(oswNode, topology, disconnectedTopology, topologyDevices);
            }
            if (!CollectionUtils.isEmpty((Map)oswNode.getFdbOlt())) {
                b.b(oswNode, topology, disconnectedTopology, topologyDevices);
            }
            if (CollectionUtils.isEmpty((Map)oswNode.getFdbAp())) continue;
            b.c(oswNode, topology, disconnectedTopology, topologyDevices);
        }
    }

    private static void a(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull OtherNode otherNode) {
        if (CollectionUtils.isEmpty((Collection)otherNode.getLldpNeighbors())) {
            return;
        }
        for (LLDPNeighborDTO lldpNeighborDTO : otherNode.getLldpNeighbors()) {
            switch (lldpNeighborDTO.getType()) {
                case "switch": {
                    b.a(topologyDevices, topology, otherNode, lldpNeighborDTO.getMac());
                    break;
                }
                case "olt": {
                    b.b(topologyDevices, topology, otherNode, lldpNeighborDTO.getMac());
                    break;
                }
                case "ap": {
                    b.a(topologyDevices, topology, otherNode, lldpNeighborDTO);
                    break;
                }
            }
        }
    }

    private static void a(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull OtherNode otherNode, String oswMac) {
        Port upperPort;
        if (CollectionUtils.isEmpty(topologyDevices.getOswMap())) {
            return;
        }
        OswNode oswNode = topologyDevices.getOswMap().get(oswMac);
        if (Objects.isNull(oswNode)) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
            b.a(otherNode, topologyDevices.getMlagOswMap().get(oswNode.getMac()), topology, oswNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            b.a(otherNode, topologyDevices.getVrrpOswMap().get(oswNode.getMac()), topology, oswNode);
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getDetected()) || topology.hasEdgeConnecting((Object)oswNode, (Object)otherNode) || topology.hasEdgeConnecting((Object)otherNode, (Object)oswNode)) {
            return;
        }
        if (Boolean.TRUE.equals(oswNode.getAsTmpRoot())) {
            if (a.isInfoEnabled()) {
                a.info("other {} try to connect tmpRoot switch {}, maybe lldp loop", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
            boolean contain = false;
            for (Port upperPort2 : oswNode.getUpperPorts()) {
                if (!b.a((Set<LLDPNeighborDTO>)upperPort2.getLldpNeighbors(), oswNode.getMac(), otherNode.getMac())) continue;
                contain = true;
            }
            if (!contain) {
                if (a.isInfoEnabled()) {
                    a.info("other {} try to connect switch {}, but can't match switch upperPorts lldp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
        } else if (oswNode.getUpperPort() != null && !b.a((Set<LLDPNeighborDTO>)oswNode.getUpperPort().getLldpNeighbors(), oswNode.getMac(), otherNode.getMac())) {
            if (a.isInfoEnabled()) {
                a.info("other {} try to connect switch {}, but can't match switch upperPort lldp", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            return;
        }
        if ((upperPort = b.b(otherNode.getMac(), oswNode)) == null) {
            if (a.isInfoEnabled()) {
                a.info("other {} try to connect switch {}, but can't match switch upperPort lldp and fdb", (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            return;
        }
        BaseOswEdge edge = new BaseOswEdge(upperPort);
        edge.setFromNodeAndToNode(otherNode.getMac(), oswNode.getMac());
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
        topology.addEdge((Object)otherNode, (Object)oswNode, (Object)edge);
        oswNode.setDetected(Boolean.valueOf(true));
    }

    private static void a(OtherNode otherNode, MultiOswNode multiOswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode targetOswNode) {
        if (Boolean.TRUE.equals(targetOswNode.getDetected())) {
            if (a.isDebugEnabled()) {
                a.debug("multiOsw member osw:{} already detected, stop discovering other:{} and osw:{}, stop discovering other:{} and multiOsw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return;
        }
        MultiOswEdge multiOswEdge = null;
        if (topology.nodes().contains(multiOswNode)) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge;
            Set inEdges = topology.inEdges((Object)multiOswNode);
            if (!CollectionUtils.isEmpty((Collection)inEdges)) {
                MultiOswEdge inEdge = (MultiOswEdge)inEdges.iterator().next();
                if (!inEdge.getFromNodeMacs().contains(otherNode.getMac())) {
                    if (a.isInfoEnabled()) {
                        a.info("multiOsw:{} already has inEdge:{} which doesn't contain other:{}, skip", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)inEdge), (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()));
                    }
                    return;
                }
                multiOswEdge = inEdge;
            } else if (topology.nodes().contains(otherNode) && !Objects.isNull(optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)otherNode))) {
                if (a.isInfoEnabled()) {
                    a.info("multiOsw:{} already connect to other:{}, stop discovering other to multiOswMem", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)otherNode.getMac()));
                }
                return;
            }
        }
        BaseOswEdge edge = new BaseOswEdge(b.b(otherNode.getMac(), targetOswNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.l.a());
        edge.setFromNodeAndToNode(otherNode.getMac(), targetOswNode.getMac());
        targetOswNode.setDetected(Boolean.valueOf(true));
        if (Objects.isNull(multiOswEdge)) {
            multiOswEdge = new MultiOswEdge();
            multiOswEdge.getFromNodeMacs().add(otherNode.getMac());
            multiOswEdge.getToNodeMacs().addAll(multiOswNode.getMacToNodeMap().keySet());
            multiOswEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.r.a());
            multiOswEdge.setFromNodeMac(otherNode.getMac());
            multiOswEdge.setToNodeMac(multiOswNode.getMac());
            topology.addEdge((Object)otherNode, (Object)multiOswNode, (Object)multiOswEdge);
        }
        multiOswEdge.getEdges().add(edge);
        multiOswNode.setDetected(Boolean.valueOf(true));
    }

    private static void b(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull OtherNode otherNode, String oltMac) {
        if (CollectionUtils.isEmpty(topologyDevices.getOltMap())) {
            return;
        }
        OltNode oltNode = topologyDevices.getOltMap().get(oltMac);
        if (Objects.isNull(oltNode)) {
            return;
        }
        if (Boolean.TRUE.equals(oltNode.getDetected()) || topology.hasEdgeConnecting((Object)oltNode, (Object)otherNode) || topology.hasEdgeConnecting((Object)otherNode, (Object)oltNode)) {
            return;
        }
        BaseOltEdge edge = new BaseOltEdge();
        edge.setFromNodeAndToNode(otherNode.getMac(), oltMac);
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.h.a());
        topology.addEdge((Object)otherNode, (Object)oltNode, (Object)edge);
        oltNode.setDetected(Boolean.valueOf(true));
        b.a(oltNode, topologyDevices, topology);
    }

    private static void a(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull OtherNode otherNode, LLDPNeighborDTO neighborDTO) {
        String apMac = neighborDTO.getMac();
        if (CollectionUtils.isEmpty(topologyDevices.getApMap())) {
            return;
        }
        ApNode apNode = topologyDevices.getApMap().get(apMac);
        if (Objects.isNull(apNode)) {
            return;
        }
        if (Boolean.TRUE.equals(neighborDTO.getDetected()) || Boolean.TRUE.equals(apNode.getDetected()) || topology.hasEdgeConnecting((Object)apNode, (Object)otherNode) || topology.hasEdgeConnecting((Object)otherNode, (Object)apNode)) {
            return;
        }
        ApOtherEdge edge = new ApOtherEdge(b.a(otherNode.getMac(), apNode));
        edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.u.a());
        edge.setFromNodeAndToNode(otherNode.getMac(), apMac);
        topology.addEdge((Object)otherNode, (Object)apNode, (Object)edge);
        apNode.setDetected(Boolean.valueOf(true));
        b.a(apNode, topologyDevices, topology);
    }

    private static void j(@Nonnull TopologyDevices topologyDevices, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty(topologyDevices.getApMap())) {
            return;
        }
        for (Map.Entry<String, ApNode> entry : topologyDevices.getApMap().entrySet()) {
            String apMac = entry.getKey();
            ApNode apNode = entry.getValue();
            if (Objects.isNull(apMac) || Objects.isNull(apNode) || Boolean.TRUE.equals(apNode.getDetected())) continue;
            b.a(topologyDevices, topologyDevices.getApMap(), topology, apNode);
        }
    }

    private static void a(@Nonnull TopologyDevices topologyDevices, @Nonnull Map<String, ApNode> apNodeMap, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull ApNode parentNode) {
        if (Objects.isNull(parentNode) || Objects.isNull(parentNode.getMeshInfo()) || CollectionUtils.isEmpty((Collection)parentNode.getMeshInfo().getChildAps())) {
            return;
        }
        List childApMacs = parentNode.getMeshInfo().getChildAps();
        for (String childApMac : childApMacs) {
            ApNode childApNode = apNodeMap.get(childApMac);
            if (Objects.isNull(childApNode) || Boolean.TRUE.equals(childApNode.getDetected()) || !Boolean.TRUE.equals(childApNode.getMeshInfo().getWireless())) {
                if (!a.isDebugEnabled()) continue;
                a.debug("Ap <{}>  maybe disconnected or already detected or actually wired", (Object)com.tplink.smb.omada.common.util.e.a.d((String)childApMac));
                continue;
            }
            MeshApEdge meshApEdge = new MeshApEdge();
            meshApEdge.setFromNodeAndToNode(parentNode.getMac(), childApMac);
            meshApEdge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.t.a());
            topology.addEdge((Object)parentNode, (Object)childApNode, (Object)meshApEdge);
            childApNode.setDetected(Boolean.valueOf(true));
            b.a(childApNode, topologyDevices, topology);
        }
    }

    private static void a(OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) || Boolean.TRUE.equals(oswNode.getMlagMem())) {
            return;
        }
        oswNode.getFdbOsw().forEach((standardPort, oswList) -> oswList.forEach(targetOsw -> {
            if (Boolean.TRUE.equals(targetOsw.getVrrpMem()) || Boolean.TRUE.equals(targetOsw.getMlagMem())) {
                return;
            }
            if (!Objects.isNull(disconnectedTopology) && Boolean.TRUE.equals(topology.nodes().contains(targetOsw)) && disconnectedTopology.nodes().contains(targetOsw) && !topology.hasEdgeConnecting((Object)oswNode, targetOsw)) {
                b.a(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)targetOsw);
            }
            if (Boolean.TRUE.equals(targetOsw.getDetected())) {
                return;
            }
            if (!Boolean.TRUE.equals(targetOsw.getDetected()) && !topology.hasEdgeConnecting(targetOsw, (Object)oswNode)) {
                Port port = new Port(StandardOswPortIndex.resolveStandardPortIndex(null, (String)standardPort).getPort().intValue(), standardPort);
                OswOswEdge edge = new OswOswEdge(port, targetOsw.getUpperPort());
                edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.m.a());
                edge.setFromNodeAndToNode(oswNode.getMac(), targetOsw.getMac());
                topology.addEdge((Object)oswNode, targetOsw, (Object)edge);
                if (Boolean.TRUE.equals(b.a(topology, oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)targetOsw))) {
                    topology.removeEdge((Object)edge);
                } else {
                    if (a.isDebugEnabled()) {
                        a.debug("osw1 connect osw2 by fdb, osw1:{}, osw2:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOsw.getMac()));
                    }
                    targetOsw.setDetected(Boolean.TRUE);
                }
            }
        }));
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a startNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a targetNode) {
        if (Objects.isNull(disconnectedTopology) || CollectionUtils.isEmpty((Collection)disconnectedTopology.nodes()) || !disconnectedTopology.nodes().contains(startNode)) {
            return;
        }
        List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> disconnectedPath = b.b(topology, disconnectedTopology, startNode, targetNode);
        if (!CollectionUtils.isEmpty(disconnectedPath)) {
            b.a(topology, disconnectedTopology, disconnectedPath);
            targetNode.setDetected(Boolean.valueOf(true));
        }
    }

    private static void a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> path) {
        if (CollectionUtils.isEmpty(path)) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("addDisconnectedPath={}", path);
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : path) {
            node.setDetected(Boolean.valueOf(true));
            topology.addNode((Object)node);
        }
        for (int i2 = 0; i2 < path.size() - 1; ++i2) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a from = path.get(i2);
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a to = path.get(i2 + 1);
            disconnectedTopology.edgesConnecting((Object)from, (Object)to).forEach(edge -> {
                if (edge instanceof MultiOswEdge) {
                    MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
                    b.a(multiOswEdge, topology, from, to);
                }
                if (CollectionUtils.isEmpty((Collection)topology.predecessors((Object)to)) && !topology.hasEdgeConnecting((Object)to, (Object)from)) {
                    topology.addEdge((Object)from, (Object)to, edge);
                }
            });
        }
    }

    private static void a(MultiOswEdge oldMultiOswEdge, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a from, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a to) {
        Set nodes = topology.nodes();
        if (!nodes.contains(from) || !nodes.contains(to)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)oldMultiOswEdge.getEdges()) || !topology.hasEdgeConnecting((Object)from, (Object)to)) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgesConnecting((Object)from, (Object)to).iterator().next();
        if (!(edge instanceof MultiOswEdge)) {
            return;
        }
        MultiOswEdge newMultiOswEdge = (MultiOswEdge)edge;
        List newEdges = Optional.ofNullable(newMultiOswEdge.getEdges()).orElse(new ArrayList());
        List oldEdges = oldMultiOswEdge.getEdges();
        List needAddEdges = oldEdges.stream().filter(oldEdge -> !b.a(oldEdge.getFromNodeMac(), oldEdge.getToNodeMac(), (List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)newEdges)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(needAddEdges)) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("add oldMultiOswEdgeMem to newMultiOswEdge:{}", (Object)PIIJacksonUtil.parseToStr(needAddEdges));
        }
        newEdges.addAll(needAddEdges);
    }

    private static boolean a(String fromMac, String toMac, List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> edges) {
        if (CollectionUtils.isEmpty(edges)) {
            return false;
        }
        if (edges.stream().anyMatch(newEdge -> Objects.equals(newEdge.getFromNodeMac(), fromMac) && Objects.equals(newEdge.getToNodeMac(), toMac))) {
            if (a.isInfoEnabled()) {
                a.info("edges:{} already has edge from:{} to:{}", (Object)PIIJacksonUtil.parseToStr(edges), (Object)com.tplink.smb.omada.common.util.e.a.d((String)fromMac), (Object)com.tplink.smb.omada.common.util.e.a.d((String)toMac));
            }
            return true;
        }
        return false;
    }

    private static Boolean a(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a targetOsw) {
        Traverser dfsTraverser = Traverser.forGraph(arg_0 -> topology.successors(arg_0));
        Iterable reachableNodes = dfsTraverser.depthFirstPreOrder((Object)targetOsw);
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a next : reachableNodes) {
            if (!Objects.equals(next.getMac(), oswNode.getMac())) continue;
            if (a.isInfoEnabled()) {
                a.info("exist circle, remove edge from {} to {}", (Object)oswNode.getMac(), (Object)targetOsw.getMac());
            }
            return true;
        }
        return false;
    }

    private static void b(OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) || Boolean.TRUE.equals(oswNode.getMlagMem())) {
            return;
        }
        oswNode.getFdbOlt().forEach((standardPort, oltList) -> oltList.forEach(targetOlt -> {
            if (!Objects.isNull(disconnectedTopology) && Boolean.TRUE.equals(topology.nodes().contains(targetOlt)) && disconnectedTopology.nodes().contains(targetOlt) && !topology.hasEdgeConnecting((Object)oswNode, targetOlt)) {
                b.a(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)targetOlt);
            }
            if (Boolean.TRUE.equals(targetOlt.getDetected())) {
                return;
            }
            Port port = new Port(StandardOswPortIndex.resolveStandardPortIndex(null, (String)standardPort).getPort().intValue(), standardPort);
            OswOltEdge edge = new OswOltEdge(port);
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.o.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), targetOlt.getMac());
            topology.addEdge((Object)oswNode, targetOlt, (Object)edge);
            if (a.isDebugEnabled()) {
                a.debug("osw connect olt by fdb, osw:{}, olt:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetOlt.getMac()));
            }
            targetOlt.setDetected(Boolean.TRUE);
        }));
    }

    private static void c(OswNode oswNode, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, TopologyDevices topologyDevices) {
        if (Boolean.TRUE.equals(oswNode.getVrrpMem()) || Boolean.TRUE.equals(oswNode.getMlagMem())) {
            return;
        }
        oswNode.getFdbAp().forEach((standardPort, apList) -> apList.forEach(targetAp -> {
            if (!Objects.isNull(disconnectedTopology) && Boolean.TRUE.equals(topology.nodes().contains(targetAp)) && disconnectedTopology.nodes().contains(targetAp) && !topology.hasEdgeConnecting((Object)oswNode, targetAp)) {
                b.a(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oswNode, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)targetAp);
            }
            if (Boolean.TRUE.equals(targetAp.getDetected())) {
                return;
            }
            Port port = new Port(StandardOswPortIndex.resolveStandardPortIndex(null, (String)standardPort).getPort().intValue(), standardPort);
            OswApEdge edge = new OswApEdge(port, b.a(oswNode.getMac(), targetAp));
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.n.a());
            edge.setFromNodeAndToNode(oswNode.getMac(), targetAp.getMac());
            topology.addEdge((Object)oswNode, targetAp, (Object)edge);
            if (a.isDebugEnabled()) {
                a.debug("osw connect ap by fdb, osw:{}, ap:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)targetAp.getMac()));
            }
            targetAp.setDetected(Boolean.valueOf(true));
        }));
    }

    private static void b(TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology) {
        OsgNode osg = topologyDevices.getOsg();
        Set arps = osg.getArps();
        if (CollectionUtils.isEmpty((Collection)arps)) {
            return;
        }
        Map<String, ApNode> apMap = topologyDevices.getApMap();
        for (ApNode apNode : apMap.values()) {
            if (!Objects.isNull(disconnectedTopology) && !Boolean.TRUE.equals(apNode.getDetected()) && disconnectedTopology.nodes().contains(apNode) && !topology.hasEdgeConnecting((Object)osg, (Object)apNode)) {
                b.a(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)osg, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)apNode);
            }
            if (!arps.contains(apNode.getMac()) || Boolean.TRUE.equals(apNode.getDetected())) continue;
            BaseOsgEdge edge = new BaseOsgEdge();
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.a.a());
            edge.setFromNodeAndToNode(osg.getMac(), apNode.getMac());
            if (a.isDebugEnabled()) {
                a.debug("osg connect ap by arp, osg:{}, ap:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)apNode.getMac()));
            }
            topology.addEdge((Object)osg, (Object)apNode, (Object)edge);
        }
        Map<String, OltNode> oltMap = topologyDevices.getOltMap();
        for (OltNode oltNode : oltMap.values()) {
            if (!Objects.isNull(disconnectedTopology) && !Boolean.TRUE.equals(oltNode.getDetected()) && disconnectedTopology.nodes().contains(oltNode) && !topology.hasEdgeConnecting((Object)osg, (Object)oltNode)) {
                b.a(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)osg, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oltNode);
            }
            if (!arps.contains(oltNode.getMac()) || Boolean.TRUE.equals(oltNode.getDetected())) continue;
            BaseOsgEdge edge = new BaseOsgEdge();
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.a.a());
            edge.setFromNodeAndToNode(osg.getMac(), oltNode.getMac());
            if (a.isDebugEnabled()) {
                a.debug("osg connect olt by arp, osg:{}, olt:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oltNode.getMac()));
            }
            topology.addEdge((Object)osg, (Object)oltNode, (Object)edge);
        }
        Map<String, OswNode> map = topologyDevices.getOswMap();
        for (OswNode oswNode : map.values()) {
            if (!Objects.isNull(disconnectedTopology) && !Boolean.TRUE.equals(oswNode.getDetected()) && disconnectedTopology.nodes().contains(oswNode) && !topology.hasEdgeConnecting((Object)osg, (Object)oswNode)) {
                b.a(topology, disconnectedTopology, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)osg, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)oswNode);
            }
            if (!arps.contains(oswNode.getMac()) || Boolean.TRUE.equals(oswNode.getDetected()) || Boolean.TRUE.equals(oswNode.getMlagMem()) || Boolean.TRUE.equals(oswNode.getVrrpMem())) continue;
            OsgOswEdge edge = new OsgOswEdge(oswNode.getUpperPort());
            edge.setType(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.b.a());
            edge.setFromNodeAndToNode(osg.getMac(), oswNode.getMac());
            if (a.isDebugEnabled()) {
                a.debug("osg connect osw by arp, osg:{}, osw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)osg.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
            }
            topology.addEdge((Object)osg, (Object)oswNode, (Object)edge);
        }
    }

    private static List<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> b(MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> disconnectedTopology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a startNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a endNode) {
        HashMap<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> predecessor = new HashMap<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        LinkedList<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> queue = new LinkedList<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> visited = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        queue.add(startNode);
        visited.add(startNode);
        while (!queue.isEmpty()) {
            LinkedList<Object> path;
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a current = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)queue.poll();
            if (current.equals((Object)endNode)) {
                path = new LinkedList<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
                while (current != null) {
                    path.addFirst(current);
                    current = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessor.get(current);
                }
                return path;
            }
            if (!disconnectedTopology.nodes().contains(current)) {
                Set outEdges = topology.outEdges((Object)current);
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : outEdges) {
                    queue.add((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)topology.incidentNodes((Object)edge).target());
                }
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)disconnectedTopology.outEdges((Object)current)) && Objects.isNull(endNode)) {
                path = new LinkedList();
                while (current != null) {
                    path.addFirst(current);
                    current = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessor.get(current);
                }
                return path;
            }
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : disconnectedTopology.outEdges((Object)current)) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a successor = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)disconnectedTopology.incidentNodes((Object)edge).target();
                if (visited.contains(successor)) continue;
                visited.add(successor);
                predecessor.put(successor, current);
                queue.add(successor);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static Map<String, OswNode> a(@Nullable List<String> flagNodeMacs, @Nonnull Map<String, OswNode> oswMap, boolean flagByMultiOsw) {
        HashSet<String> oswMacs = new HashSet<String>(oswMap.keySet());
        HashMap<String, OswNode> discoveryOswMap = new HashMap<String, OswNode>();
        HashMap<String, OswNode> unDiscoveryOswMap = new HashMap<String, OswNode>();
        for (Map.Entry<String, OswNode> entry : oswMap.entrySet()) {
            OswNode oswNode = entry.getValue();
            if (!Boolean.TRUE.equals(oswNode.getDetected())) {
                if (oswNode.getUpperPort() != null) {
                    oswNode.getUpperPort().setUpper(false);
                }
                if (!CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
                    oswNode.getUpperPorts().forEach(port -> port.setUpper(false));
                    oswNode.getUpperPorts().clear();
                }
                oswNode.setUpperPort(null);
            }
            oswNode.setLeaf(false);
            if (CollectionUtils.isEmpty((Collection)oswNode.getPorts())) {
                a.debug("No fdb info found for <{}>", (Object)oswNode.getMac());
                oswNode.setLeaf(true);
                continue;
            }
            int branchPortCnt = 0;
            for (Port port2 : oswNode.getPorts()) {
                if (port2.isUpper()) continue;
                b.a(flagNodeMacs, oswMacs, port2, oswNode, flagByMultiOsw);
                if (port2.isLeaf()) continue;
                ++branchPortCnt;
            }
            if (!CollectionUtils.isEmpty(flagNodeMacs) && flagNodeMacs.size() == 1 && Objects.equals(flagNodeMacs.get(0), entry.getKey())) {
                discoveryOswMap.put(entry.getKey(), oswNode);
            }
            oswNode.setLeaf(branchPortCnt < 2);
            a.debug("osw <{}> is leaf? <{}>", (Object)oswNode.getMac(), (Object)oswNode.isLeaf());
            if (oswNode.getUpperPort() != null || !CollectionUtils.isEmpty((Collection)oswNode.getUpperPorts())) {
                discoveryOswMap.put(oswNode.getMac(), oswNode);
                continue;
            }
            unDiscoveryOswMap.put(oswNode.getMac(), oswNode);
        }
        int discoveryNum = discoveryOswMap.size();
        while (unDiscoveryOswMap.size() > 0) {
            b.b(discoveryOswMap, unDiscoveryOswMap);
            if (discoveryOswMap.size() <= discoveryNum) break;
            discoveryNum = discoveryOswMap.size();
        }
        return discoveryOswMap;
    }

    private static void b(Map<String, OswNode> discoveryOswMap, Map<String, OswNode> unDiscoveryOswMap) {
        Set<String> discoveryMacs = discoveryOswMap.keySet();
        ArrayList<OswNode> newDiscoveryOsws = new ArrayList<OswNode>();
        for (Map.Entry<String, OswNode> entry : unDiscoveryOswMap.entrySet()) {
            b.a(entry, discoveryMacs, discoveryOswMap, newDiscoveryOsws);
        }
        newDiscoveryOsws.forEach(oswNode -> {
            discoveryOswMap.put(oswNode.getMac(), (OswNode)oswNode);
            unDiscoveryOswMap.remove(oswNode.getMac());
        });
    }

    private static void a(Map.Entry<String, OswNode> entry, Set<String> discoveryMacs, Map<String, OswNode> discoveryOswMap, List<OswNode> newDiscoveryOsws) {
        OswNode node1 = entry.getValue();
        for (Port port : node1.getPorts()) {
            if (CollectionUtils.isEmpty((Collection)port.getLldpNeighbors())) continue;
            for (LLDPNeighborDTO lldpNeighbor : port.getLldpNeighbors()) {
                String mac = lldpNeighbor.getMac();
                if (!discoveryMacs.contains(mac)) continue;
                OswNode node2 = discoveryOswMap.get(mac);
                if (!CollectionUtils.isEmpty((Collection)node2.getUpperPorts())) {
                    HashSet fdbMacs = new HashSet();
                    for (Port p2 : node2.getUpperPorts()) {
                        fdbMacs.addAll(p2.getFdbMacs());
                    }
                    if (CollectionUtils.isEmpty(fdbMacs) || fdbMacs.contains(entry.getKey())) continue;
                    port.setUpper(true);
                    node1.setUpperPort(port);
                    a.debug("port <{}> of osw <{}> is upper by lldp", (Object)port.getPortId(), (Object)node1.getMac());
                    continue;
                }
                Port upperPort = node2.getUpperPort();
                Set fdbMacs = upperPort.getFdbMacs();
                if (CollectionUtils.isEmpty((Collection)fdbMacs) || fdbMacs.contains(entry.getKey())) continue;
                port.setUpper(true);
                node1.setUpperPort(port);
                a.debug("port <{}> of osw <{}> is upper by lldp", (Object)port.getPortId(), (Object)node1.getMac());
            }
            if (!Objects.nonNull(node1.getUpperPort())) continue;
            newDiscoveryOsws.add(node1);
            break;
        }
    }

    private static void a(@Nullable List<String> flagNodeMacs, Set<String> oswMacs, @Nonnull Port port, OswNode oswNode, boolean flagByMultiOsw) {
        if (port.getFdbMacs() == null) {
            port.setUpper(false);
            port.setLeaf(true);
            return;
        }
        if (flagNodeMacs != null) {
            if (b.a((Set<String>)port.getFdbMacs(), flagNodeMacs)) {
                if (flagByMultiOsw) {
                    port.setUpper(true);
                    port.setLeaf(false);
                    if (Objects.isNull(oswNode.getUpperPort())) {
                        oswNode.setUpperPort(port);
                    }
                    if (Objects.isNull(oswNode.getUpperPorts())) {
                        ArrayList<Port> upperPorts = new ArrayList<Port>();
                        upperPorts.add(port);
                        oswNode.setUpperPorts(upperPorts);
                    } else {
                        oswNode.getUpperPorts().add(port);
                    }
                    if (a.isDebugEnabled()) {
                        a.debug("port <{}> of osw <{}> is upper when flagByMultiOsw:{}", (Object)port.getPortId(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr(flagNodeMacs));
                    }
                    return;
                }
                if (oswNode.getUpperPort() == null) {
                    port.setUpper(true);
                    port.setLeaf(false);
                    oswNode.setUpperPort(port);
                    a.debug("port <{}> of osw <{}> is upper", (Object)port.getPortId(), (Object)oswNode.getMac());
                    return;
                }
                a.debug("Both <{}> and <{}> of osw <{}> is upper port, use the first one", (Object)oswNode.getUpperPort().getPortId(), (Object)port.getPortId(), (Object)oswNode.getMac());
            }
            a.debug("port <{}> of osw <{}> is not upper", (Object)port.getPortId(), (Object)oswNode.getMac());
            port.setUpper(false);
        }
        port.setLeaf(true);
        String s = b.a(oswMacs, (Set<String>)port.getFdbMacs());
        if (Objects.nonNull(s) && !Objects.equals(oswNode.getMac(), s)) {
            port.setLeaf(false);
        }
    }

    private static String a(Set<String> s1, Set<String> s2) {
        if (CollectionUtils.isEmpty(s1) || CollectionUtils.isEmpty(s2)) {
            return null;
        }
        if (s1.size() < s2.size()) {
            for (String s : s1) {
                if (!s2.contains(s)) continue;
                return s;
            }
        } else {
            for (String s : s2) {
                if (!s1.contains(s)) continue;
                return s;
            }
        }
        return null;
    }

    private static void a(Set<String> s1, Set<String> s2, Consumer<String> consumer) {
        if (CollectionUtils.isEmpty(s1) || CollectionUtils.isEmpty(s2)) {
            return;
        }
        if (s1.size() < s2.size()) {
            for (String s : s1) {
                if (!s2.contains(s)) continue;
                consumer.accept(s);
            }
        } else {
            for (String s : s2) {
                if (!s1.contains(s)) continue;
                consumer.accept(s);
            }
        }
    }

    private static boolean a(Set<String> fdbMacs, @Nonnull List<String> flagNodeMacs) {
        for (String mac : flagNodeMacs) {
            if (!fdbMacs.contains(mac)) continue;
            return true;
        }
        return false;
    }

    private static boolean a(@Nonnull Map<String, OswNode> detectMap, Set<String> fdbMacs, String oswMac, TopologyDevices topologyDevices) {
        String mac = b.a(detectMap.keySet(), fdbMacs);
        if (Objects.nonNull(mac) && !Objects.equals(mac, oswMac)) {
            a.trace("fdb macs contain un detect osw <{}>", (Object)mac);
            return true;
        }
        if (CollectionUtils.isEmpty(topologyDevices.getVrrpOswMap()) && CollectionUtils.isEmpty(topologyDevices.getMlagOswMap())) {
            return false;
        }
        List detectMultiOswMems = detectMap.values().stream().filter(detectOsw -> Boolean.TRUE.equals(detectOsw.getVrrpMem()) || Boolean.TRUE.equals(detectOsw.getMlagMem())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detectMultiOswMems)) {
            return false;
        }
        for (OswNode oswNode : detectMultiOswMems) {
            MultiOswNode multiOswNode = null;
            if (Boolean.TRUE.equals(oswNode.getVrrpMem())) {
                multiOswNode = topologyDevices.getVrrpOswMap().get(oswNode.getMac());
            } else if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                multiOswNode = topologyDevices.getMlagOswMap().get(oswNode.getMac());
            }
            if (Objects.isNull(multiOswNode)) continue;
            if (!multiOswNode.getMacToNodeMap().keySet().stream().anyMatch(fdbMacs::contains)) continue;
            if (a.isDebugEnabled()) {
                a.debug("osw:{} fdbs contains un detected multiOsw:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswMac), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
            }
            return true;
        }
        return false;
    }

    private static boolean a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, @Nonnull MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (CollectionUtils.isEmpty((Collection)topology.nodes()) || !topology.nodes().contains(node)) {
            return false;
        }
        Set predecessors = topology.predecessors((Object)node);
        return !CollectionUtils.isEmpty((Collection)predecessors);
    }

    private static void b(@Nonnull Map<String, OswNode> generateMap, TopologyDevices topologyDevices, MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        boolean rooted = false;
        for (Map.Entry<String, OswNode> entry : generateMap.entrySet()) {
            OswNode oswNode = entry.getValue();
            oswNode.getUpperPort().setUpper(false);
            if (!topology.nodes().contains(oswNode)) {
                if (Boolean.TRUE.equals(oswNode.getMlagMem())) {
                    topology.addNode((Object)((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)topologyDevices.getMlagOswMap().get(oswNode.getMac())));
                } else {
                    topology.addNode((Object)oswNode);
                }
            }
            b.a(oswNode, oswNode.getUpperPort(), topologyDevices, topology);
            if (rooted) continue;
            oswNode.setDetected(Boolean.valueOf(true));
            oswNode.setUpperPort(null);
            rooted = true;
        }
    }

    private static List<OswNode> b(Map<String, OswNode> unDiscoverySwitchs) {
        return unDiscoverySwitchs.values().stream().filter(switchNode -> Boolean.TRUE.equals(switchNode.getSupportVf())).collect(Collectors.toList());
    }

    @Generated
    private b() {
    }
}

