/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.topology.b;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.omada.common.constant.M;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.OswLinkPeerDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.ApOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.BaseOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MultiOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OltOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswOltEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OswOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.c;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.d;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.MultiOswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.Port;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.StpLoopInfoDTO;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyDTO;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.n;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class b {
    @Generated
    private static final Logger f = LoggerFactory.getLogger(b.class);
    public static final Pattern a = Pattern.compile("[0-9]*");
    public static final Pattern b = Pattern.compile("(\\d+)-(\\d+)|(\\d+)");
    public static final String c = "WAN";
    public static final String d = "LAN";
    public static final List<Integer> e = Arrays.asList(0, 10, 100, 1000, 2500, 10000, 5000, 25000, 100000, 40000);

    public static Port a(OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a upLinkNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Boolean.TRUE.equals(oswNode.getMlagMem()) || Boolean.TRUE.equals(oswNode.getVrrpMem())) {
            return com.tplink.smb.omada.manager.topology.b.b.a(com.tplink.smb.omada.manager.topology.b.b.a(oswNode, topology), oswNode, topology);
        }
        if (Objects.isNull(upLinkNode)) {
            upLinkNode = com.tplink.smb.omada.manager.topology.b.b.a(topology, oswNode);
        }
        if (Objects.isNull(upLinkNode)) {
            return null;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)upLinkNode, (Object)oswNode);
        if (edge instanceof OswOswEdge) {
            return ((OswOswEdge)edge).getDownLink();
        }
        if (edge instanceof OswApEdge) {
            return ((OswApEdge)edge).getUpLink();
        }
        if (edge instanceof ApOswEdge) {
            ApOswEdge apOswEdge = (ApOswEdge)edge;
            return apOswEdge.getDownLink();
        }
        if (edge instanceof OltOswEdge) {
            OltOswEdge oltOswEdge = (OltOswEdge)edge;
            return oltOswEdge.getDownLink();
        }
        if (edge instanceof OsgOswEdge) {
            return ((OsgOswEdge)edge).getDownLink();
        }
        if (edge instanceof BaseOswEdge) {
            return ((BaseOswEdge)edge).getUpLink();
        }
        if (edge instanceof MultiOswEdge) {
            MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
            if (CollectionUtils.isEmpty((Collection)multiOswEdge.getEdges())) {
                return null;
            }
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : multiOswEdge.getEdges()) {
                if (!Objects.equals(e2.getToNodeMac(), oswNode.getMac())) continue;
                return ((OswOswEdge)e2).getDownLink();
            }
        }
        return null;
    }

    public static Port a(MultiOswNode multiOswNode, OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(multiOswNode) || !topology.nodes().contains(multiOswNode)) {
            return null;
        }
        Set inEdges = topology.inEdges((Object)multiOswNode);
        if (CollectionUtils.isEmpty((Collection)inEdges)) {
            return null;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
        if (!(inEdge instanceof MultiOswEdge)) {
            return null;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)inEdge;
        if (CollectionUtils.isEmpty((Collection)multiOswEdge.getEdges())) {
            return null;
        }
        List edges = multiOswEdge.getEdges();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : edges) {
            if (!Objects.equals(edge.getToNodeMac(), oswNode.getMac())) continue;
            if (edge instanceof OswOswEdge) {
                return ((OswOswEdge)edge).getDownLink();
            }
            if (edge instanceof OswApEdge) {
                return ((OswApEdge)edge).getUpLink();
            }
            if (edge instanceof ApOswEdge) {
                ApOswEdge apOswEdge = (ApOswEdge)edge;
                return apOswEdge.getDownLink();
            }
            if (edge instanceof OltOswEdge) {
                OltOswEdge oltOswEdge = (OltOswEdge)edge;
                return oltOswEdge.getDownLink();
            }
            if (edge instanceof OsgOswEdge) {
                return ((OsgOswEdge)edge).getDownLink();
            }
            if (!(edge instanceof BaseOswEdge)) continue;
            return ((BaseOswEdge)edge).getUpLink();
        }
        if (f.isDebugEnabled()) {
            f.debug("fail to find upperPort for multiOswMem:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
        }
        return null;
    }

    private static MultiOswNode a(OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(oswNode) || Objects.isNull(topology)) {
            return null;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : topology.nodes()) {
            MultiOswNode multiOswNode;
            if (!Objects.equals(node.getType(), "mlag") && !Objects.equals(node.getType(), "vrrp") || !(multiOswNode = (MultiOswNode)node).getMacToNodeMap().containsKey(oswNode.getMac())) continue;
            return multiOswNode;
        }
        return null;
    }

    @Nonnull
    public static Set<Integer> a(@Nonnull OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts, Map<String, List<Port>> loopCascadePortsMap) {
        HashSet<Integer> cascadePorts = new HashSet<Integer>();
        Port upperPort = oswNode.getUpperPort();
        if (Objects.nonNull(upperPort)) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a inEdge;
            Set inEdges = topology.inEdges((Object)oswNode);
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a a2 = inEdge = CollectionUtils.isEmpty((Collection)inEdges) ? null : (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)inEdges.iterator().next();
            if (Objects.nonNull(inEdge) && !Objects.equals(inEdge.getOfflineType(), com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a())) {
                cascadePorts.add(upperPort.getPortId());
                cascadeStandardPorts.add(upperPort.getStandardOswPort());
                String sendCascadeStandardPort = Objects.nonNull(upperPort.getL3LagId()) ? upperPort.getL3LagId() : upperPort.getStandardOswPort();
                sendCascadeStandardPorts.add(sendCascadeStandardPort);
            }
        }
        com.tplink.smb.omada.manager.topology.b.b.b(oswNode, topology, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        com.tplink.smb.omada.manager.topology.b.b.a(oswNode, topology, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        com.tplink.smb.omada.manager.topology.b.b.a(oswNode, loopCascadePortsMap, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        return cascadePorts;
    }

    private static void b(OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        Set predecessors = topology.predecessors((Object)oswNode);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a predecessor = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
        if (!com.tplink.smb.omada.manager.configuration.api.internal.topology.a.b.H.contains(predecessor.getType())) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)predecessor, (Object)oswNode);
        if (Objects.isNull(edge)) {
            return;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : ((MultiOswEdge)edge).getEdges()) {
            Port upPort;
            if (Objects.equals(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a(), e2.getType()) || !Objects.equals(e2.getToNodeMac(), oswNode.getMac()) || Objects.isNull(upPort = ((OswOswEdge)e2).getDownLink())) continue;
            cascadePorts.add(upPort.getPortId());
            if (!Objects.isNull(upPort.getStandardOswPort())) {
                cascadeStandardPorts.add(upPort.getStandardOswPort());
            }
            String sendCascadeStandardPort = Objects.nonNull(upPort.getL3LagId()) ? upPort.getL3LagId() : upPort.getStandardOswPort();
            sendCascadeStandardPorts.add(sendCascadeStandardPort);
            com.tplink.smb.omada.manager.topology.b.b.a(oswNode, upPort);
        }
    }

    private static void a(OswNode oswNode, Port upPort) {
        if (Objects.isNull(upPort) || Objects.isNull(oswNode)) {
            return;
        }
        if (Objects.isNull(oswNode.getNoClientPorts())) {
            ArrayList<Port> noClientPorts = new ArrayList<Port>();
            noClientPorts.add(upPort);
            oswNode.setNoClientPorts(noClientPorts);
        } else {
            oswNode.getNoClientPorts().add(upPort);
        }
    }

    @Nonnull
    public static Set<Integer> a(MultiOswNode multiOswNode, @Nonnull OswNode oswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        HashSet<Integer> cascadePorts = new HashSet<Integer>();
        com.tplink.smb.omada.manager.topology.b.b.a(oswNode, multiOswNode, topology, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        com.tplink.smb.omada.manager.topology.b.b.a(multiOswNode, oswNode, topology, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        com.tplink.smb.omada.manager.topology.b.b.a(oswNode, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        return cascadePorts;
    }

    private static void a(OswNode oswNode, MultiOswNode multiOswNode, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        Set predecessors = topology.predecessors((Object)multiOswNode);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            return;
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a predecessor = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)predecessor, (Object)multiOswNode);
        if (Objects.isNull(edge) || !(edge instanceof MultiOswEdge)) {
            return;
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : multiOswEdge.getEdges()) {
            if (!Objects.equals(e2.getToNodeMac(), oswNode.getMac()) || Objects.equals(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a(), edge.getOfflineType())) continue;
            com.tplink.smb.omada.manager.topology.b.b.a(oswNode, edge, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
        }
    }

    private static void a(OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        Port upperPort = null;
        if (edge instanceof OswOswEdge) {
            OswOswEdge oswOswEdge = (OswOswEdge)edge;
            upperPort = oswOswEdge.getDownLink();
        }
        if (edge instanceof OsgOswEdge) {
            OsgOswEdge osgOswEdge = (OsgOswEdge)edge;
            upperPort = osgOswEdge.getDownLink();
        }
        if (edge instanceof OltOswEdge) {
            OltOswEdge oltOswEdge = (OltOswEdge)edge;
            upperPort = oltOswEdge.getDownLink();
        }
        if (edge instanceof ApOswEdge) {
            ApOswEdge apOswEdge = (ApOswEdge)edge;
            upperPort = apOswEdge.getDownLink();
        }
        if (Objects.nonNull(upperPort)) {
            cascadePorts.add(upperPort.getPortId());
            cascadeStandardPorts.add(upperPort.getStandardOswPort());
            String sendCascadeStandardPort = Objects.nonNull(upperPort.getL3LagId()) ? upperPort.getL3LagId() : upperPort.getStandardOswPort();
            sendCascadeStandardPorts.add(sendCascadeStandardPort);
            com.tplink.smb.omada.manager.topology.b.b.a(oswNode, upperPort);
        }
    }

    private static void a(OswNode oswNode, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        if (!CollectionUtils.isEmpty((Collection)oswNode.getDadLinkPorts())) {
            oswNode.getDadLinkPorts().forEach(port -> {
                cascadePorts.add(port.getPortId());
                cascadeStandardPorts.add(port.getStandardOswPort());
                String sendCascadeStandardPort = Objects.nonNull(port.getL3LagId()) ? port.getL3LagId() : port.getStandardOswPort();
                sendCascadeStandardPorts.add(sendCascadeStandardPort);
                com.tplink.smb.omada.manager.topology.b.b.a(oswNode, port);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)oswNode.getPeerLinkPorts())) {
            oswNode.getPeerLinkPorts().forEach(port -> {
                cascadePorts.add(port.getPortId());
                cascadeStandardPorts.add(port.getStandardOswPort());
                String sendCascadeStandardPort = Objects.nonNull(port.getL3LagId()) ? port.getL3LagId() : port.getStandardOswPort();
                sendCascadeStandardPorts.add(sendCascadeStandardPort);
                com.tplink.smb.omada.manager.topology.b.b.a(oswNode, port);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)oswNode.getInternalLinkPorts())) {
            oswNode.getInternalLinkPorts().forEach(port -> {
                cascadePorts.add(port.getPortId());
                cascadeStandardPorts.add(port.getStandardOswPort());
                String sendCascadeStandardPort = Objects.nonNull(port.getL3LagId()) ? port.getL3LagId() : port.getStandardOswPort();
                sendCascadeStandardPorts.add(sendCascadeStandardPort);
                com.tplink.smb.omada.manager.topology.b.b.a(oswNode, port);
            });
        }
    }

    private static void a(@Nonnull OswNode oswNode, Map<String, List<Port>> loopCascadePortsMap, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        if (CollectionUtils.isEmpty(loopCascadePortsMap) || CollectionUtils.isEmpty((Collection)loopCascadePortsMap.get(oswNode.getMac()))) {
            return;
        }
        List<Port> loopBlockedPorts = loopCascadePortsMap.get(oswNode.getMac());
        for (Port port : loopBlockedPorts) {
            if (Objects.isNull(port)) continue;
            cascadePorts.add(port.getPortId());
            if (Objects.nonNull(port.getStandardOswPort())) {
                cascadeStandardPorts.add(port.getStandardOswPort());
            }
            String sendCascadeStandardPort = Objects.nonNull(port.getL3LagId()) ? port.getL3LagId() : port.getStandardOswPort();
            sendCascadeStandardPorts.add(sendCascadeStandardPort);
            com.tplink.smb.omada.manager.topology.b.b.a(oswNode, port);
        }
    }

    public static void a(@Nonnull OswNode oswNode, @Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        try {
            Set outEdges = topology.outEdges((Object)oswNode);
            if (CollectionUtils.isEmpty((Collection)outEdges)) {
                f.debug("no outEdges found for {}", (Object)oswNode.getMac());
                return;
            }
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : outEdges) {
                MultiOswEdge multiOswEdge;
                if (edge instanceof MultiOswEdge && !CollectionUtils.isEmpty((Collection)(multiOswEdge = (MultiOswEdge)edge).getEdges())) {
                    multiOswEdge.getEdges().forEach(e2 -> {
                        if (!Objects.equals(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a(), e2.getOfflineType())) {
                            com.tplink.smb.omada.manager.topology.b.b.a(e2, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
                        }
                    });
                    continue;
                }
                if (Objects.equals(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a(), edge.getOfflineType())) continue;
                com.tplink.smb.omada.manager.topology.b.b.a(edge, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
            }
        }
        catch (IllegalArgumentException e3) {
            f.warn("get device mac {}, outEdges failed, exception: {}", (Object)oswNode.getMac(), (Object)e3);
        }
    }

    private static void a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        if (edge instanceof OswOswEdge) {
            OswOswEdge oswOswEdge = (OswOswEdge)edge;
            Port upLink = oswOswEdge.getUpLink();
            if (Objects.isNull(upLink)) {
                return;
            }
            cascadePorts.add(upLink.getPortId());
            cascadeStandardPorts.add(upLink.getStandardOswPort());
            String sendCascadeStandardPort = Objects.nonNull(upLink.getL3LagId()) ? upLink.getL3LagId() : upLink.getStandardOswPort();
            sendCascadeStandardPorts.add(sendCascadeStandardPort);
            return;
        }
        if (edge instanceof OswApEdge) {
            OswApEdge oswApEdge = (OswApEdge)edge;
            Port upLink = oswApEdge.getUpLink();
            if (Objects.isNull(upLink)) {
                return;
            }
            cascadePorts.add(upLink.getPortId());
            cascadeStandardPorts.add(upLink.getStandardOswPort());
            String sendCascadeStandardPort = Objects.nonNull(upLink.getL3LagId()) ? upLink.getL3LagId() : upLink.getStandardOswPort();
            sendCascadeStandardPorts.add(sendCascadeStandardPort);
            return;
        }
        if (edge instanceof OswOltEdge) {
            OswOltEdge oswOltEdge = (OswOltEdge)edge;
            Port upLink = oswOltEdge.getUpLink();
            if (Objects.isNull(upLink)) {
                return;
            }
            cascadePorts.add(upLink.getPortId());
            cascadeStandardPorts.add(upLink.getStandardOswPort());
            String sendCascadeStandardPort = Objects.nonNull(upLink.getL3LagId()) ? upLink.getL3LagId() : upLink.getStandardOswPort();
            sendCascadeStandardPorts.add(sendCascadeStandardPort);
        }
    }

    public static void a(MultiOswNode multiOswNode, @Nonnull OswNode oswNode, @Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Set<Integer> cascadePorts, Set<String> cascadeStandardPorts, Set<String> sendCascadeStandardPorts) {
        try {
            Set outEdges = topology.outEdges((Object)multiOswNode);
            if (CollectionUtils.isEmpty((Collection)outEdges)) {
                if (f.isDebugEnabled()) {
                    f.debug("no outEdges found for multiOsw mem:{}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()));
                }
                return;
            }
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : outEdges) {
                MultiOswEdge multiOswEdge;
                if (!(edge instanceof MultiOswEdge) || CollectionUtils.isEmpty((Collection)(multiOswEdge = (MultiOswEdge)edge).getEdges())) continue;
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a e2 : multiOswEdge.getEdges()) {
                    if (!Objects.equals(e2.getFromNodeMac(), oswNode.getMac()) || Objects.equals(com.tplink.smb.omada.manager.configuration.api.internal.topology.a.a.H.a(), e2.getOfflineType())) continue;
                    com.tplink.smb.omada.manager.topology.b.b.a(e2, cascadePorts, cascadeStandardPorts, sendCascadeStandardPorts);
                }
            }
        }
        catch (IllegalArgumentException e3) {
            f.warn("get multiOsw mem:{} outEdges failed, exception: {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)e3);
        }
    }

    @Nullable
    public static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, String mac) {
        if (Objects.isNull(mac)) {
            if (f.isInfoEnabled()) {
                f.info("mac is null, failed to getNode");
            }
            return null;
        }
        Set nodes = topology.nodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            f.debug("no device in topology");
            return null;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : nodes) {
            MultiOswNode multiOswNode;
            if (!(node instanceof MultiOswNode ? (multiOswNode = (MultiOswNode)node).getMacToNodeMap().containsKey(mac) : Objects.equals(mac, node.getMac()))) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a b(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, @Nonnull String mac) {
        Set nodes = topology.nodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            return null;
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : nodes) {
            OswNode oswNode;
            if (node instanceof MultiOswNode) {
                MultiOswNode multiOswNode = (MultiOswNode)node;
                if (multiOswNode.getMacToNodeMap().containsKey(mac)) {
                    return node;
                }
                for (OswNode oswNode2 : multiOswNode.getMacToNodeMap().values()) {
                    if (CollectionUtils.isEmpty((Collection)oswNode2.getStackMacs()) || !oswNode2.getStackMacs().contains(mac)) continue;
                    return node;
                }
                continue;
            }
            if (mac.equals(node.getMac())) {
                return node;
            }
            if (!(node instanceof OswNode) || CollectionUtils.isEmpty((Collection)(oswNode = (OswNode)node).getStackMacs()) || !oswNode.getStackMacs().contains(mac)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public static Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, Collection<String> macs) {
        if (CollectionUtils.isEmpty(macs)) {
            return new HashMap<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        Set nodes = topology.nodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            f.debug("no device in topology");
            return new HashMap<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        Map nodeMap = nodes.stream().filter(node -> node.getMac() != null).collect(Collectors.toMap(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a::getMac, node -> node, (existing, replacement) -> existing, HashMap::new));
        return macs.stream().distinct().filter(nodeMap::containsKey).collect(Collectors.toMap(mac -> mac, nodeMap::get, (existing, replacement) -> existing, HashMap::new));
    }

    @Nullable
    public static Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        Set nodes = topology.nodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            f.debug("no device in topology");
            return new HashMap<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        }
        HashMap<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> result = new HashMap<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : nodes) {
            if (node instanceof MultiOswNode) {
                MultiOswNode multiOswNode = (MultiOswNode)node;
                multiOswNode.getMacToNodeMap().keySet().forEach(mac -> result.put((String)mac, (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)multiOswNode));
                continue;
            }
            result.put(node.getMac(), node);
        }
        return result;
    }

    @Nullable
    public static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode) {
        Set predecessors = topology.predecessors((Object)oswNode);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            f.debug("no upLink device found for osw {}", (Object)oswNode.getMac());
            return null;
        }
        f.debug("predecessors of {} is {}", (Object)oswNode.getMac(), (Object)predecessors);
        if (predecessors.size() > 1) {
            f.warn("{} upLink devices found for osw {}", (Object)predecessors.size(), (Object)oswNode.getMac());
        }
        return (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
    }

    @Nullable
    public static com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a abstractNode) {
        Set predecessors = topology.predecessors((Object)abstractNode);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            f.debug("no upLink device found for node {}", (Object)abstractNode.getMac());
            return null;
        }
        f.debug("predecessors of {} is {}", (Object)abstractNode.getMac(), (Object)predecessors);
        if (predecessors.size() > 1) {
            f.warn("{} upLink devices found for node {}", (Object)predecessors.size(), (Object)abstractNode.getMac());
        }
        return (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
    }

    @Nonnull
    public static Map<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> b(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode) {
        Set successors = topology.successors((Object)oswNode);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> nodeMap = new HashMap<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : successors) {
            Port upLinkPort = com.tplink.smb.omada.manager.topology.b.b.a(topology, oswNode, node);
            if (upLinkPort == null) {
                f.error("no upLink port found in edge from {} to {}", (Object)oswNode.getMac(), (Object)node.getMac());
                continue;
            }
            HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> nodeSet = (HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>)nodeMap.get(upLinkPort.getPortId());
            if (nodeSet == null) {
                nodeSet = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
            }
            nodeSet.add(node);
            nodeMap.put(upLinkPort.getPortId(), nodeSet);
        }
        return nodeMap;
    }

    @Nonnull
    public static Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode, Map<String, Port> downLinkPeerPortMap, Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> stpLinks) {
        Set successors = topology.successors((Object)oswNode);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> nodeMap = new HashMap<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : successors) {
            Port upLinkPort;
            if (node instanceof MultiOswNode) {
                Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> edges;
                MultiOswNode multiOswNode = (MultiOswNode)node;
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)multiOswNode);
                if (Objects.isNull(optEdge) || !(optEdge instanceof MultiOswEdge)) {
                    if (!f.isInfoEnabled()) continue;
                    f.info("fail to find edge between osw:{} and MultiOsw:{} when findOswDownLinkNodes", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()));
                    continue;
                }
                MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
                if (CollectionUtils.isEmpty((Collection)multiOswEdge.getEdges()) || CollectionUtils.isEmpty(edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getFromNodeMac(), oswNode.getMac())).collect(Collectors.toSet()))) continue;
                com.tplink.smb.omada.manager.topology.b.b.a(edges, node, nodeMap, stpLinks);
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : edges) {
                    if (!(edge2 instanceof OswOswEdge)) continue;
                    downLinkPeerPortMap.put(edge2.getToNodeMac(), ((OswOswEdge)edge2).getDownLink());
                }
                continue;
            }
            if (node instanceof OswNode) {
                OswNode downOswNode = (OswNode)node;
                Port downLinkPort = com.tplink.smb.omada.manager.topology.b.b.a(topology, oswNode, downOswNode);
                downLinkPeerPortMap.put(downOswNode.getMac(), downLinkPort);
            }
            if ((upLinkPort = com.tplink.smb.omada.manager.topology.b.b.a(topology, oswNode, node)) == null) {
                f.error("no upLink port found in edge from {} to {}", (Object)oswNode.getMac(), (Object)node.getMac());
                continue;
            }
            HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> nodeSet = (HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>)nodeMap.get(upLinkPort.getStandardOswPort());
            if (nodeSet == null) {
                nodeSet = new HashSet<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>();
            }
            nodeSet.add(node);
            nodeMap.put(upLinkPort.getStandardOswPort(), nodeSet);
        }
        return nodeMap;
    }

    private static Port a(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode, OswNode downOswNode) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)downOswNode);
        if (edge == null) {
            if (f.isInfoEnabled()) {
                f.info("no edge found from {} to {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)downOswNode.getMac()));
            }
            return null;
        }
        if (!(edge instanceof OswOswEdge)) {
            if (f.isInfoEnabled()) {
                f.info("Invalid edge type {} found from {} to {}", new Object[]{edge.getClass(), com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), com.tplink.smb.omada.common.util.e.a.d((String)downOswNode.getMac())});
            }
            return null;
        }
        return ((OswOswEdge)edge).getDownLink();
    }

    public static List<String> a(String capabilities) {
        if (Objects.isNull(capabilities)) {
            return Collections.emptyList();
        }
        int lldpCapabilitiesLen = 8;
        if (capabilities.length() < 8) {
            StringBuilder builder = new StringBuilder(capabilities);
            while (builder.length() < 8) {
                builder.append("0");
            }
            capabilities = builder.toString();
        }
        String finalStr = capabilities;
        return IntStream.range(0, 8).filter(i2 -> Objects.equals(Character.valueOf(finalStr.charAt(i2)), Character.valueOf('1'))).mapToObj(M::a).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nonnull
    public static Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> a(@Nonnull Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, MultiOswNode multiOswNode, OswNode oswNode, Map<String, Port> downLinkPeerPortMap, Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> stpLinks) {
        Set successors = topology.successors((Object)multiOswNode);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> nodeMap = new HashMap<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : successors) {
            Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> edges;
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)node);
            if (Objects.isNull(optEdge) || !(optEdge instanceof MultiOswEdge)) {
                if (!f.isInfoEnabled()) continue;
                f.info("fail to find edge between multiOsw:{} and node:{} when findMultiOswMemDownLinkNodes", (Object)PIIJacksonUtil.parseToStr(multiOswNode.getMacToNodeMap().keySet()), (Object)PIIJacksonUtil.parseToStr((Object)node));
                continue;
            }
            MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
            if (CollectionUtils.isEmpty((Collection)multiOswEdge.getEdges()) || CollectionUtils.isEmpty(edges = multiOswEdge.getEdges().stream().filter(edge -> Objects.equals(edge.getFromNodeMac(), oswNode.getMac())).collect(Collectors.toSet()))) continue;
            com.tplink.smb.omada.manager.topology.b.b.a(edges, node, nodeMap, stpLinks);
            for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : edges) {
                if (!(edge2 instanceof OswOswEdge)) continue;
                downLinkPeerPortMap.put(edge2.getToNodeMac(), ((OswOswEdge)edge2).getDownLink());
            }
        }
        return nodeMap;
    }

    private static void a(Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> edges, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> nodeMap, Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> stpLinks) {
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : edges) {
            if (!(edge instanceof BaseOswEdge)) continue;
            BaseOswEdge baseOswEdge = (BaseOswEdge)edge;
            Port upLinkPort = baseOswEdge.getUpLink();
            if (Objects.isNull(upLinkPort) || Objects.isNull(upLinkPort.getStandardOswPort())) {
                if (!f.isInfoEnabled()) continue;
                f.info("no upLink port found in edge from {} to {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getFromNodeMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)edge.getToNodeMac()));
                continue;
            }
            String standardOswPort = upLinkPort.getStandardOswPort();
            if (node instanceof MultiOswNode) {
                MultiOswNode downMultiOswNode = (MultiOswNode)node;
                OswNode downOswNode = (OswNode)downMultiOswNode.getMacToNodeMap().get(edge.getToNodeMac());
                if (Objects.isNull(downOswNode)) {
                    if (!f.isInfoEnabled()) continue;
                    f.info("fail to find downMultiOswMem for edge:{}, downMultiOsw:{}", (Object)PIIJacksonUtil.parseToStr((Object)edge), (Object)PIIJacksonUtil.parseToStr(downMultiOswNode.getMacToNodeMap().keySet()));
                    continue;
                }
                nodeMap.computeIfAbsent(standardOswPort, k2 -> new HashSet()).add(downOswNode);
                if (CollectionUtils.isEmpty((Collection)edge.getBlockedVlans())) continue;
                stpLinks.computeIfAbsent(standardOswPort, k2 -> new HashSet()).add(downOswNode);
                continue;
            }
            nodeMap.computeIfAbsent(standardOswPort, k2 -> new HashSet()).add(node);
            if (CollectionUtils.isEmpty((Collection)edge.getBlockedVlans())) continue;
            stpLinks.computeIfAbsent(standardOswPort, k2 -> new HashSet()).add(node);
        }
    }

    private static Port a(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)node);
        if (edge == null) {
            f.error("no edge found from {} to {}", (Object)oswNode.getMac(), (Object)node.getMac());
            return null;
        }
        if (!(edge instanceof BaseOswEdge)) {
            f.error("Invalid edge type {} found from {} to {}", new Object[]{edge.getClass(), oswNode.getMac(), node.getMac()});
            return null;
        }
        return ((BaseOswEdge)edge).getUpLink();
    }

    public static List<Integer> b(String vlanIdPool) {
        if (vlanIdPool == null || vlanIdPool.isEmpty()) {
            return new ArrayList<Integer>();
        }
        Matcher matcher = b.matcher(vlanIdPool);
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (matcher.find()) {
            String start = matcher.group(1);
            String end = matcher.group(2);
            String single = matcher.group(3);
            if (start != null && end != null) {
                for (int i2 = Integer.parseInt(start); i2 <= Integer.parseInt(end); ++i2) {
                    result.add(i2);
                }
                continue;
            }
            if (single == null) continue;
            result.add(Integer.parseInt(single));
        }
        return result;
    }

    public static String a(List<Integer> vlanIds) {
        if (CollectionUtils.isEmpty(vlanIds)) {
            return null;
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>(vlanIds);
        StringBuilder sb = new StringBuilder();
        Integer rangeStart = null;
        Integer prev = null;
        for (Integer vlan : sorted) {
            if (rangeStart == null) {
                rangeStart = vlan;
                prev = vlan;
                continue;
            }
            if (vlan == prev + 1) {
                prev = vlan;
                continue;
            }
            com.tplink.smb.omada.manager.topology.b.b.a(sb, rangeStart, prev);
            rangeStart = vlan;
            prev = vlan;
        }
        com.tplink.smb.omada.manager.topology.b.b.a(sb, rangeStart, prev);
        return sb.toString();
    }

    private static void a(StringBuilder sb, int start, int end) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        if (start == end) {
            sb.append(start);
        } else {
            sb.append(start).append("-").append(end);
        }
    }

    public static Map<String, OswLinkPeerDTO> c(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode) {
        if (oswNode == null) {
            return Collections.emptyMap();
        }
        Set predecessors = topology.predecessors((Object)oswNode);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            f.debug("no upLink device found for osw {}", (Object)oswNode.getMac());
            return Collections.emptyMap();
        }
        if (predecessors.size() > 1) {
            f.warn("{} upLink devices found for osw {}", (Object)predecessors.size(), (Object)oswNode.getMac());
        }
        HashMap<String, OswLinkPeerDTO> oswDownLinkPeers = new HashMap<String, OswLinkPeerDTO>();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a upLinkNode = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
        if (upLinkNode == null) {
            return Collections.emptyMap();
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)upLinkNode, (Object)oswNode);
        Port upLinkPort = null;
        Port donwLinkPort = null;
        if (edge == null) {
            f.error("no edge found from {} to {}", (Object)upLinkNode.getMac(), (Object)oswNode.getMac());
            return Collections.emptyMap();
        }
        if (edge instanceof d) {
            d wiredUpLinkEdge = (d)edge;
            upLinkPort = wiredUpLinkEdge.getUpLink();
        }
        if (edge instanceof c) {
            c wiredDownLinkEdge = (c)edge;
            donwLinkPort = wiredDownLinkEdge.getDownLink();
        }
        if (edge instanceof MultiOswEdge) {
            MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
            if (upLinkNode instanceof MultiOswNode) {
                MultiOswNode multiOswNode = (MultiOswNode)upLinkNode;
                multiOswEdge.getEdges().stream().filter(e2 -> Objects.equals(e2.getToNodeMac(), oswNode.getMac())).forEach(e2 -> {
                    if (e2 instanceof OswOswEdge) {
                        OswOswEdge oswOswEdge = (OswOswEdge)e2;
                        OswNode upOswMem = (OswNode)multiOswNode.getMacToNodeMap().get(oswOswEdge.getFromNodeMac());
                        OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
                        oswLinkPeerDTO.setNode((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)upOswMem);
                        oswLinkPeerDTO.setPort(oswOswEdge.getUpLink());
                        String downLinkStdPort = Optional.ofNullable(oswOswEdge.getDownLink()).map(Port::getStandardOswPort).orElse(null);
                        if (!Objects.isNull(downLinkStdPort)) {
                            oswDownLinkPeers.put(downLinkStdPort, oswLinkPeerDTO);
                        }
                    }
                });
            }
        }
        OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
        oswLinkPeerDTO.setNode(upLinkNode);
        oswLinkPeerDTO.setPort(upLinkPort);
        if (donwLinkPort == null) {
            return oswDownLinkPeers;
        }
        oswDownLinkPeers.put(donwLinkPort.getStandardOswPort(), oswLinkPeerDTO);
        return oswDownLinkPeers;
    }

    public static Map<String, OswLinkPeerDTO> a(TopologyDTO topologyDTO, MultiOswNode multiOswNode, OswNode oswNode) {
        Network topology = topologyDTO.getTopology();
        Set predecessors = topology.predecessors((Object)multiOswNode);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            f.debug("no upLink device found for osw {}", (Object)oswNode.getMac());
            return Collections.emptyMap();
        }
        if (predecessors.size() > 1) {
            f.warn("{} upLink devices found for osw {}", (Object)predecessors.size(), (Object)oswNode.getMac());
        }
        HashMap<String, OswLinkPeerDTO> oswUpLinkPeers = new HashMap<String, OswLinkPeerDTO>();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a upLinkNode = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
        if (upLinkNode == null) {
            return Collections.emptyMap();
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)upLinkNode, (Object)multiOswNode);
        if (!(edge instanceof MultiOswEdge)) {
            return Collections.emptyMap();
        }
        MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
        multiOswEdge.getEdges().stream().filter(e2 -> Objects.equals(e2.getToNodeMac(), oswNode.getMac())).forEach(e2 -> {
            if (upLinkNode instanceof MultiOswNode) {
                MultiOswNode upMultiOswNode = (MultiOswNode)upLinkNode;
                if (e2 instanceof OswOswEdge) {
                    OswOswEdge oswOswEdge = (OswOswEdge)e2;
                    String downLinkStdPort = Optional.ofNullable(oswOswEdge.getDownLink()).map(Port::getStandardOswPort).orElse(null);
                    if (!Objects.isNull(downLinkStdPort)) {
                        OswNode upOswMem = (OswNode)upMultiOswNode.getMacToNodeMap().get(oswOswEdge.getFromNodeMac());
                        OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
                        oswLinkPeerDTO.setNode((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)upOswMem);
                        oswLinkPeerDTO.setPort(oswOswEdge.getUpLink());
                        oswUpLinkPeers.put(downLinkStdPort, oswLinkPeerDTO);
                    }
                    return;
                }
            }
            com.tplink.smb.omada.manager.topology.b.b.a(upLinkNode, e2, oswUpLinkPeers);
        });
        return oswUpLinkPeers;
    }

    private static void a(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a upLinkNode, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge, Map<String, OswLinkPeerDTO> oswUpLinkPeers) {
        String downLinkStdPort;
        Port donwLinkPort = null;
        Port upLinkPort = null;
        if (edge instanceof d) {
            d wiredUpLinkEdge = (d)edge;
            upLinkPort = wiredUpLinkEdge.getUpLink();
        }
        if (edge instanceof c) {
            c wiredDownLinkEdge = (c)edge;
            donwLinkPort = wiredDownLinkEdge.getDownLink();
        }
        if (!Objects.isNull(downLinkStdPort = (String)Optional.ofNullable(donwLinkPort).map(Port::getStandardOswPort).orElse(null))) {
            OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
            oswLinkPeerDTO.setNode(upLinkNode);
            oswLinkPeerDTO.setPort(upLinkPort);
            oswUpLinkPeers.put(downLinkStdPort, oswLinkPeerDTO);
        }
    }

    public static Map<String, OswLinkPeerDTO> d(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, OswNode oswNode) {
        if (oswNode == null) {
            return Collections.emptyMap();
        }
        Set successors = topology.successors((Object)oswNode);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return Collections.emptyMap();
        }
        HashMap<String, OswLinkPeerDTO> oswDownLinkPeers = new HashMap<String, OswLinkPeerDTO>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : successors) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)oswNode, (Object)node);
            if (edge == null) {
                f.error("no edge found from {} to {}", (Object)oswNode.getMac(), (Object)node.getMac());
                continue;
            }
            if (edge instanceof MultiOswEdge) {
                MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
                if (node instanceof MultiOswNode) {
                    MultiOswNode multiOswNode = (MultiOswNode)node;
                    multiOswEdge.getEdges().stream().filter(e2 -> Objects.equals(e2.getFromNodeMac(), oswNode.getMac())).forEach(e2 -> {
                        if (e2 instanceof OswOswEdge) {
                            OswOswEdge oswOswEdge = (OswOswEdge)e2;
                            OswNode downOswMem = (OswNode)multiOswNode.getMacToNodeMap().get(oswOswEdge.getToNodeMac());
                            OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
                            oswLinkPeerDTO.setNode((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)downOswMem);
                            oswLinkPeerDTO.setPort(oswOswEdge.getDownLink());
                            String stdPort = Optional.ofNullable(oswOswEdge.getUpLink()).map(Port::getStandardOswPort).orElse(null);
                            if (!Objects.isNull(stdPort)) {
                                oswDownLinkPeers.put(stdPort, oswLinkPeerDTO);
                            }
                        }
                    });
                    continue;
                }
            }
            if (!(edge instanceof BaseOswEdge)) {
                f.error("Invalid edge type {} found from {} to {}", new Object[]{edge.getClass(), oswNode.getMac(), node.getMac()});
                continue;
            }
            Port upLinkPort = ((BaseOswEdge)edge).getUpLink();
            if (upLinkPort == null) {
                f.error("no upLink port found in edge from {} to {}", (Object)oswNode.getMac(), (Object)node.getMac());
                continue;
            }
            OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
            oswLinkPeerDTO.setNode(node);
            Port downLinkPort = null;
            if (edge instanceof OswOswEdge) {
                downLinkPort = ((OswOswEdge)edge).getDownLink();
            }
            oswLinkPeerDTO.setPort(downLinkPort);
            oswDownLinkPeers.put(upLinkPort.getStandardOswPort(), oswLinkPeerDTO);
        }
        return oswDownLinkPeers;
    }

    public static Map<String, OswLinkPeerDTO> b(TopologyDTO topologyDTO, MultiOswNode multiOswNode, OswNode oswNode) {
        Network topology = topologyDTO.getTopology();
        Set successors = topology.successors((Object)multiOswNode);
        if (CollectionUtils.isEmpty((Collection)successors)) {
            return Collections.emptyMap();
        }
        HashMap<String, OswLinkPeerDTO> oswDownLinkPeers = new HashMap<String, OswLinkPeerDTO>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : successors) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)multiOswNode, (Object)node);
            if (edge == null) {
                f.error("no edge found from {} to {}", (Object)oswNode.getMac(), (Object)node.getMac());
                continue;
            }
            if (!(edge instanceof MultiOswEdge)) {
                if (!f.isInfoEnabled()) continue;
                f.info("abnormal edge found from {} to {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)oswNode.getMac()), (Object)com.tplink.smb.omada.common.util.e.a.d((String)node.getMac()));
                continue;
            }
            MultiOswEdge multiOswEdge = (MultiOswEdge)edge;
            multiOswEdge.getEdges().stream().filter(e2 -> Objects.equals(e2.getFromNodeMac(), oswNode.getMac())).forEach(e2 -> {
                if (node instanceof MultiOswNode) {
                    MultiOswNode downMultiOswNode = (MultiOswNode)node;
                    if (e2 instanceof OswOswEdge) {
                        OswOswEdge oswOswEdge = (OswOswEdge)e2;
                        String upLinkStdPort = Optional.ofNullable(oswOswEdge.getUpLink()).map(Port::getStandardOswPort).orElse(null);
                        if (!Objects.isNull(upLinkStdPort)) {
                            OswNode downOswMem = (OswNode)downMultiOswNode.getMacToNodeMap().get(oswOswEdge.getToNodeMac());
                            OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
                            oswLinkPeerDTO.setNode((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)downOswMem);
                            oswLinkPeerDTO.setPort(oswOswEdge.getDownLink());
                            oswDownLinkPeers.put(upLinkStdPort, oswLinkPeerDTO);
                        }
                        return;
                    }
                }
                com.tplink.smb.omada.manager.topology.b.b.b(node, e2, oswDownLinkPeers);
            });
        }
        return oswDownLinkPeers;
    }

    private static void b(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge, Map<String, OswLinkPeerDTO> oswDownLinkPeers) {
        String upLinkStdPort;
        Port upLinkPort = null;
        Port downLinkPort = null;
        if (edge instanceof d) {
            d wiredUpLinkEdge = (d)edge;
            upLinkPort = wiredUpLinkEdge.getUpLink();
        }
        if (edge instanceof c) {
            c wiredDownLinkEdge = (c)edge;
            downLinkPort = wiredDownLinkEdge.getDownLink();
        }
        if (!Objects.isNull(upLinkStdPort = (String)Optional.ofNullable(upLinkPort).map(Port::getStandardOswPort).orElse(null))) {
            OswLinkPeerDTO oswLinkPeerDTO = new OswLinkPeerDTO();
            oswLinkPeerDTO.setNode(node);
            oswLinkPeerDTO.setPort(downLinkPort);
            oswDownLinkPeers.put(upLinkStdPort, oswLinkPeerDTO);
        }
    }

    public static Map<String, OswLinkPeerDTO> a(TopologyDTO topologyDTO, OswNode oswNode) {
        if (CollectionUtils.isEmpty((Collection)topologyDTO.getStpLoopInfos())) {
            return Collections.emptyMap();
        }
        HashMap stpLoopInfoMap = new HashMap();
        for (StpLoopInfoDTO stpLoopInfoDTO : topologyDTO.getStpLoopInfos()) {
            stpLoopInfoDTO.getEdges().stream().forEach(edge -> {
                stpLoopInfoMap.computeIfAbsent(edge.getFromNodeMac(), k2 -> new HashSet()).add(edge);
                stpLoopInfoMap.computeIfAbsent(edge.getToNodeMac(), k2 -> new HashSet()).add(edge);
            });
        }
        if (!stpLoopInfoMap.containsKey(oswNode.getMac())) {
            return Collections.emptyMap();
        }
        HashMap<String, OswLinkPeerDTO> oswStpLinkPeers = new HashMap<String, OswLinkPeerDTO>();
        Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a> macNodeMap = com.tplink.smb.omada.manager.topology.b.b.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topologyDTO.getTopology(), stpLoopInfoMap.keySet());
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge2 : (Set)stpLoopInfoMap.get(oswNode.getMac())) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a fromNode;
            if (Objects.equals(edge2.getFromNodeMac(), oswNode.getMac())) {
                com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a toNode = macNodeMap.get(edge2.getToNodeMac());
                if (Objects.isNull(toNode)) continue;
                com.tplink.smb.omada.manager.topology.b.b.b(toNode, edge2, oswStpLinkPeers);
                continue;
            }
            if (!Objects.equals(edge2.getToNodeMac(), oswNode.getMac()) || Objects.isNull(fromNode = macNodeMap.get(edge2.getFromNodeMac()))) continue;
            com.tplink.smb.omada.manager.topology.b.b.a(fromNode, edge2, oswStpLinkPeers);
        }
        return oswStpLinkPeers;
    }

    public static MutableNetwork<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> b(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(topology)) {
            return null;
        }
        MutableNetwork newNetwork = NetworkBuilder.from(topology).build();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : topology.nodes()) {
            newNetwork.addNode((Object)node);
        }
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge : topology.edges()) {
            EndpointPair abstractNodes = topology.incidentNodes((Object)edge);
            newNetwork.addEdge((Object)((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)abstractNodes.source()), (Object)((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)abstractNodes.target()), (Object)edge);
        }
        return newNetwork;
    }

    public static String c(String name) {
        if (name == null || !name.contains(c)) {
            return name;
        }
        int wanIndex = name.indexOf(c);
        if (wanIndex == -1) {
            return name;
        }
        StringBuilder numberBuilder = new StringBuilder();
        for (int i2 = wanIndex + 3; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (!Character.isDigit(c2)) continue;
            numberBuilder.append(c2);
        }
        return name.substring(wanIndex, wanIndex + 3) + numberBuilder;
    }

    public static String d(String name) {
        if (name == null || !name.contains(d)) {
            return name;
        }
        int lanIndex = name.indexOf(d);
        if (lanIndex == -1) {
            return name;
        }
        StringBuilder numberBuilder = new StringBuilder();
        for (int i2 = lanIndex + 3; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (!Character.isDigit(c2)) continue;
            numberBuilder.append(c2);
        }
        return name.substring(lanIndex, lanIndex + 3) + numberBuilder;
    }

    public static Integer a(Integer linkSpeed) {
        if (linkSpeed == null) {
            return 0;
        }
        int i2 = e.indexOf(linkSpeed);
        return i2 == -1 ? 0 : i2;
    }

    public static Map<String, Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> c(Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology) {
        if (Objects.isNull(topology) || CollectionUtils.isEmpty((Collection)topology.nodes())) {
            return new HashMap<String, Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>();
        }
        HashMap<String, Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> result = new HashMap<String, Map<String, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>();
        for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node : topology.nodes()) {
            String type;
            switch (type = node.getType()) {
                case "switch": {
                    result.computeIfAbsent("switch", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
                case "ap": {
                    result.computeIfAbsent("ap", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
                case "olt": {
                    result.computeIfAbsent("olt", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
                case "gateway": {
                    result.computeIfAbsent("gateway", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
                case "other": {
                    result.computeIfAbsent("other", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
                case "NVR": {
                    result.computeIfAbsent("NVR", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
                case "IPC": {
                    result.computeIfAbsent("IPC", k2 -> new HashMap()).put(node.getMac(), node);
                    break;
                }
            }
        }
        return result;
    }

    public static String e(String port) {
        if (Objects.isNull(port)) {
            return null;
        }
        String regex = "\\d+/\\d+/\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(port);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    @SafeVarargs
    public static <T> Set<T> a(Collection<T> ... sets) {
        HashSet<T> result = new HashSet<T>();
        if (sets == null) {
            return result;
        }
        for (Collection<T> set : sets) {
            if (CollectionUtils.isEmpty(set)) continue;
            result.addAll(set);
        }
        return result;
    }

    @Nullable
    public static String a(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Map<String, Set<String>> a(Map<String, List<n>> vrrpMacToInfoMap) {
        HashMap<String, Set<String>> mergedVrrpGroupMap = new HashMap<String, Set<String>>();
        if (CollectionUtils.isEmpty(vrrpMacToInfoMap)) {
            return mergedVrrpGroupMap;
        }
        HashMap<Integer, Set> vrrpEntryIdToMemMap = new HashMap<Integer, Set>();
        for (Map.Entry<String, List<n>> entry : vrrpMacToInfoMap.entrySet()) {
            for (n vrrpImageInfo : entry.getValue()) {
                vrrpEntryIdToMemMap.computeIfAbsent(vrrpImageInfo.b(), k2 -> new HashSet()).add(entry.getKey());
            }
        }
        HashMap<String, String> parent = new HashMap<String, String>();
        HashMap<String, Integer> rank = new HashMap<String, Integer>();
        for (Set macs : vrrpEntryIdToMemMap.values()) {
            if (CollectionUtils.isEmpty((Collection)macs)) continue;
            for (String mac : macs) {
                com.tplink.smb.omada.manager.topology.b.b.a(parent, rank, mac);
            }
            Iterator iterator = macs.iterator();
            String firstMac = (String)iterator.next();
            while (iterator.hasNext()) {
                com.tplink.smb.omada.manager.topology.b.b.a(parent, rank, firstMac, (String)iterator.next());
            }
        }
        HashMap<String, Set> groups = new HashMap<String, Set>();
        for (String mac : parent.keySet()) {
            String root = com.tplink.smb.omada.manager.topology.b.b.a(parent, mac);
            groups.computeIfAbsent(root, k2 -> new HashSet()).add(mac);
        }
        for (Set group : groups.values()) {
            HashSet shared = new HashSet(group);
            for (String mac : group) {
                mergedVrrpGroupMap.put(mac, shared);
            }
        }
        if (f.isDebugEnabled()) {
            f.debug("mergeVrrpEntryToGroup result:{}", (Object)PIIJacksonUtil.parseToStr(mergedVrrpGroupMap));
        }
        return mergedVrrpGroupMap;
    }

    public static List<String> a(TopologyDTO topologyDTO) {
        return Optional.ofNullable(topologyDTO).map(TopologyDTO::getTopology).flatMap(topo -> topo.nodes().stream().filter(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b.class::isInstance).map(node -> (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b)node).findFirst()).map(com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.b::a).orElse(Collections.emptyList());
    }

    private static void a(Map<String, String> parent, Map<String, Integer> rank, String mac) {
        if (!parent.containsKey(mac)) {
            parent.put(mac, mac);
            rank.put(mac, 0);
        }
    }

    private static void a(Map<String, String> parent, Map<String, Integer> rank, String mac1, String mac2) {
        int rB;
        com.tplink.smb.omada.manager.topology.b.b.a(parent, rank, mac1);
        com.tplink.smb.omada.manager.topology.b.b.a(parent, rank, mac2);
        String ra = com.tplink.smb.omada.manager.topology.b.b.a(parent, mac1);
        String rb = com.tplink.smb.omada.manager.topology.b.b.a(parent, mac2);
        if (Objects.equals(ra, rb)) {
            return;
        }
        int rA = rank.getOrDefault(ra, 0);
        if (rA < (rB = rank.getOrDefault(rb, 0).intValue())) {
            parent.put(ra, rb);
        } else if (rA > rB) {
            parent.put(rb, ra);
        } else {
            parent.put(rb, ra);
            rank.put(ra, rA + 1);
        }
    }

    private static String a(Map<String, String> parent, String mac) {
        String p2 = parent.get(mac);
        if (p2 == null) {
            return null;
        }
        if (p2.equals(mac)) {
            return mac;
        }
        String root = com.tplink.smb.omada.manager.topology.b.b.a(parent, p2);
        parent.put(mac, root);
        return root;
    }

    @Generated
    private b() {
    }
}

