/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.topology.a;

import com.google.common.collect.Sets;
import com.google.common.graph.Network;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.util.G;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApLLDPInfo;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApLLDPPortInfo;
import com.tplink.smb.omada.device.manage.message.inform.osg.OsgLLDPInfo;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.OswNodeWithUpAndDownLinkDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.OswPortLinkWithOmadaDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MeshApEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.MultiOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.OsgOswEdge;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.d;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.ApNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.MultiOswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OsgNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.OswNode;
import com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.Port;
import com.tplink.smb.omada.manager.configuration.api.web.topology.dto.TopologyDTO;
import com.tplink.smb.omada.manager.topology.port.cache.b;
import com.tplink.smb.omada.manager.topology.port.cache.f;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private b b;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.g.d.b c;
    @Autowired
    private f d;
    private static final Integer e = -1;

    public OswNodeWithUpAndDownLinkDTO a(String omadacId, String siteId, String mac) {
        TopologyDTO topologyDTO = this.c.a(omadacId, siteId);
        if (Objects.isNull(topologyDTO)) {
            a.debug("no topology found for {} while get oswNode with UpAndDownLink, omadacId={}, siteId={}", new Object[]{mac, omadacId, siteId});
            return null;
        }
        Network topology = topologyDTO.getTopology();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a node = com.tplink.smb.omada.manager.topology.b.b.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, mac);
        if (!(node instanceof OswNode)) {
            a.debug("no osw found for {} in site topology , omadacId={}, siteId={}", new Object[]{mac, omadacId, siteId});
            return null;
        }
        OswNodeWithUpAndDownLinkDTO dto = new OswNodeWithUpAndDownLinkDTO();
        dto.setOswNode((OswNode)node);
        if (((OswNode)node).getUpperPort() != null) {
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a oswUpLinkNode = com.tplink.smb.omada.manager.topology.b.b.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, (OswNode)node);
            dto.setUpLink(oswUpLinkNode);
        }
        Map<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> downLinkMap = com.tplink.smb.omada.manager.topology.b.b.b((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, (OswNode)node);
        dto.setDownLinkMap(downLinkMap);
        return dto;
    }

    public OperationResponse<Map<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>> b(String omadacId, String siteId, String osgMac) {
        TopologyDTO topologyDTO = this.c.a(omadacId, siteId);
        HashMap<Integer, Set> result = new HashMap<Integer, Set>(12);
        if (Objects.isNull(topologyDTO)) {
            a.debug("no topology found for {} while get node, omadacId={}, siteId={}", new Object[]{osgMac, omadacId, siteId});
            return OperationResponse.success(result);
        }
        Network topology = topologyDTO.getTopology();
        if (topology == null) {
            a.debug("no topology found for {} while get gateway downlink node, omadacId={}, siteId={}", new Object[]{osgMac, omadacId, siteId});
            return OperationResponse.success(result);
        }
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a gatewayNode = com.tplink.smb.omada.manager.topology.b.b.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, osgMac);
        if (!(gatewayNode instanceof OsgNode)) {
            a.debug("no gateway found for {} in site topology , omadacId={}, siteId={}", new Object[]{osgMac, omadacId, siteId});
            return OperationResponse.success(result);
        }
        OsgLLDPInfo lldpInfo = this.d.c(omadacId, siteId, osgMac);
        if (lldpInfo == null || CollectionUtils.isEmpty((Collection)lldpInfo.getLldps())) {
            Set successors;
            if (a.isDebugEnabled()) {
                a.debug("no lldp info found for {} in site topology , omadacId={}, siteId={}", new Object[]{osgMac, omadacId, siteId});
            }
            if (!CollectionUtils.isEmpty((Collection)(successors = topology.successors((Object)gatewayNode)))) {
                for (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a suc : successors) {
                    com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)gatewayNode, (Object)suc);
                    if (!Objects.isNull(edge) && edge instanceof MeshApEdge) {
                        Set port2Set = result.getOrDefault(e, new HashSet());
                        port2Set.add(suc);
                        result.put(e, port2Set);
                        continue;
                    }
                    if (!(edge instanceof d)) continue;
                    d wiredUplinkEdge = (d)edge;
                    int portId = Optional.ofNullable(wiredUplinkEdge.getUpLink()).map(Port::getPortId).orElse(e);
                    result.computeIfAbsent(portId, key -> new HashSet()).add(suc);
                }
            }
            return OperationResponse.success(result);
        }
        a.debug("osg lldp {}, osg <{}>, omadac {}", new Object[]{lldpInfo, osgMac, omadacId});
        HashMap lldpPortMap = new HashMap();
        lldpInfo.getLldps().forEach(lldpPortInfo -> {
            Integer portId = lldpPortInfo.getPortId();
            if (!CollectionUtils.isEmpty((Collection)lldpPortInfo.getNeighbors())) {
                lldpPortInfo.getNeighbors().forEach(lldpNeighbor -> lldpPortMap.put(G.b((String)lldpNeighbor.getChassisId()), portId));
            }
        });
        topology.successors((Object)gatewayNode).forEach(v2 -> {
            ApNode apNode;
            com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a edge;
            OsgNode osgNode;
            Integer port = e;
            if (v2 instanceof OsgNode && !CollectionUtils.isEmpty((Collection)(osgNode = (OsgNode)v2).getMacList())) {
                Set allOduLldpMacs = lldpPortMap.keySet();
                for (String mac : osgNode.getMacList()) {
                    if (!allOduLldpMacs.contains(mac)) continue;
                    port = (Integer)lldpPortMap.get(mac);
                    break;
                }
            } else {
                if (v2 instanceof MultiOswNode) {
                    MultiOswNode multiOswNode = (MultiOswNode)v2;
                    this.a((Map<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>)result, (Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, gatewayNode, multiOswNode, lldpPortMap);
                    return;
                }
                port = lldpPortMap.getOrDefault(v2.getMac(), e);
            }
            if (v2 instanceof ApNode && (edge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)gatewayNode, (Object)(apNode = (ApNode)v2))) instanceof MeshApEdge) {
                apNode.setWireless(Boolean.valueOf(true));
            }
            Set port2set = result.getOrDefault(port, new HashSet());
            port2set.add(v2);
            result.put(port, port2set);
        });
        return OperationResponse.success(result);
    }

    private void a(Map<Integer, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> result, Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a> topology, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a gatewayNode, MultiOswNode multiOswNode, Map<String, Integer> lldpPortMap) {
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a optEdge = (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a)topology.edgeConnectingOrNull((Object)gatewayNode, (Object)multiOswNode);
        if (Objects.isNull(optEdge) || !(optEdge instanceof MultiOswEdge)) {
            return;
        }
        Map macToNodeMap = multiOswNode.getMacToNodeMap();
        MultiOswEdge multiOswEdge = (MultiOswEdge)optEdge;
        List edges = multiOswEdge.getEdges();
        if (CollectionUtils.isEmpty((Collection)edges)) {
            return;
        }
        edges.forEach(edge -> {
            if (edge instanceof OsgOswEdge) {
                OsgOswEdge osgOswEdge = (OsgOswEdge)edge;
                Integer port = lldpPortMap.getOrDefault(osgOswEdge.getToNodeMac(), e);
                Set port2set = result.getOrDefault(port, new HashSet());
                port2set.add((com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)macToNodeMap.get(edge.getToNodeMac()));
                result.put(port, port2set);
            }
        });
    }

    public com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a c(String omadacId, String siteId, String apMac) {
        TopologyDTO topologyDTO = this.c.a(omadacId, siteId);
        if (Objects.isNull(topologyDTO)) {
            a.debug("no topology found for {} while get ap upLink node, omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
            return null;
        }
        Network topology = topologyDTO.getTopology();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a apNode = com.tplink.smb.omada.manager.topology.b.b.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, apMac);
        if (!(apNode instanceof ApNode)) {
            a.debug("no ap found for {} in site topology , omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
            return null;
        }
        Set predecessors = topology.predecessors((Object)apNode);
        if (predecessors.size() > 1) {
            a.warn("multiple predecessors found for ap <{}>, omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
        }
        if (predecessors.iterator().hasNext()) {
            return (com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a)predecessors.iterator().next();
        }
        return null;
    }

    public Map<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> d(String omadacId, String siteId, String apMac) {
        ApLLDPInfo lldpInfo;
        TopologyDTO topologyDTO = this.c.a(omadacId, siteId);
        HashMap<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>> result = new HashMap<String, Set<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a>>(4);
        if (Objects.isNull(topologyDTO)) {
            a.debug("no topology found for {} while get ap upLink node, omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
            return result;
        }
        Network topology = topologyDTO.getTopology();
        com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a apNode = com.tplink.smb.omada.manager.topology.b.b.a((Network<com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a, com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.edge.a>)topology, apMac);
        if (!(apNode instanceof ApNode)) {
            a.debug("no ap found for {} in site topology , omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
            return result;
        }
        Set successors = topology.successors((Object)apNode);
        if (successors.size() > 1) {
            a.warn("multiple predecessors found for ap <{}>, omadacId={}, siteId={}", new Object[]{apMac, omadacId, siteId});
        }
        if ((lldpInfo = this.b.a(omadacId, siteId, apMac)) == null) {
            return result;
        }
        successors.forEach(successor -> {
            for (ApLLDPPortInfo apLLDPPortInfo : lldpInfo.getLldps()) {
                if (!apLLDPPortInfo.getNeighbors().stream().anyMatch(neighbor -> Objects.equals(neighbor.getChassisId(), successor.getMac()))) continue;
                if (result.containsKey(apLLDPPortInfo.getPortId())) {
                    ((Set)result.get(apLLDPPortInfo.getPortId())).add(successor);
                    continue;
                }
                result.put(apLLDPPortInfo.getPortId(), Sets.newHashSet((Object[])new com.tplink.smb.omada.manager.configuration.api.internal.topology.dto.node.a[]{successor}));
            }
        });
        return result;
    }

    public OperationResponse<OswPortLinkWithOmadaDTO> a(String omadacId, String siteId, Collection<String> oswMacs) {
        OswPortLinkWithOmadaDTO dto = new OswPortLinkWithOmadaDTO();
        dto.setOswPortMap(this.c.e(omadacId, siteId));
        return OperationResponse.success((Object)dto);
    }
}

