/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.sst;

import com.monitorjbl.xlsx.sst.LRUCache;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class FileBackedList
implements AutoCloseable {
    private final List<Long> pointers = new ArrayList<Long>();
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final LRUCache cache;
    private long filesize;

    public FileBackedList(File file, int cacheSizeBytes) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        this.filesize = this.raf.length();
        this.cache = new LRUCache(cacheSizeBytes);
    }

    public void add(String str) {
        try {
            this.writeToFile(str);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAt(int index) {
        String s = this.cache.getIfPresent(index);
        if (s != null) {
            return s;
        }
        try {
            String val = this.readFromFile(this.pointers.get(index));
            this.cache.store(index, val);
            return val;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String str) throws IOException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            ByteBuffer bytes = ByteBuffer.wrap(str.getBytes(StandardCharsets.UTF_8));
            ByteBuffer length = ByteBuffer.allocate(4).putInt(bytes.array().length);
            this.channel.position(this.filesize);
            this.pointers.add(this.channel.position());
            length.flip();
            this.channel.write(length);
            this.channel.write(bytes);
            this.filesize += (long)(4 + bytes.array().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromFile(long pointer) throws IOException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            FileChannel fc = this.channel.position(pointer);
            ByteBuffer buffer = ByteBuffer.wrap(new byte[4]);
            fc.read(buffer);
            buffer.flip();
            int length = buffer.getInt();
            buffer = ByteBuffer.wrap(new byte[length]);
            fc.read(buffer);
            buffer.flip();
            return new String(buffer.array(), StandardCharsets.UTF_8);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

