/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.rxjava;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWithDelay
implements Function<Observable<? extends Throwable>, ObservableSource<?>> {
    private static final Logger log = LoggerFactory.getLogger(RetryWithDelay.class);
    public static final int DEFAULT_MAX_RETRY_COUNT = -1;
    public static final int DEFAULT_RETRY_DELAY = 10000;
    private final int maxRetryCount;
    private final int retryDelayMillis;
    private final boolean retryWithoutCount;
    private int retryCount = 0;

    public RetryWithDelay() {
        this(-1, 10000);
    }

    public RetryWithDelay(int maxRetryCount, int retryDelayMillis) {
        this.maxRetryCount = maxRetryCount;
        this.retryDelayMillis = retryDelayMillis;
        this.retryWithoutCount = maxRetryCount < 0;
    }

    public Observable<?> apply(Observable<? extends Throwable> observable) {
        return observable.flatMap(throwable -> {
            if (this.retryWithoutCount) {
                log.info("RetryWithDelay: get error {}, it will always try after {} millisecond", throwable, (Object)this.retryDelayMillis);
                return Observable.timer((long)this.retryDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            if (++this.retryCount <= this.maxRetryCount) {
                log.info("RetryWithDelay: get error {}, it will try after {} millisecond, retry count {}", new Object[]{throwable, this.retryDelayMillis, this.retryCount});
                return Observable.timer((long)this.retryDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            return Observable.error((Throwable)throwable);
        });
    }
}

