/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class UpgradeExecutorServiceFactory {
    @Lazy
    @Bean(name={"upgradeWorkGroup"})
    @ConditionalOnMissingBean(name={"upgradeWorkGroup"})
    public ExecutorService upgradeMessageWorkGroup() {
        int coreSize = 2 * Runtime.getRuntime().availableProcessors() - 1;
        return new ThreadPoolExecutor(coreSize, coreSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("upgrade-group-%d").build(), new CallerRunsPolicyWithReport("upgrade-group"));
    }

    public static ExecutorService getSendRequestThreadPool() {
        int requestSendingPoolThreadCount = 16;
        return new ThreadPoolExecutor(requestSendingPoolThreadCount, requestSendingPoolThreadCount, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("send-request-group-%d").build());
    }

    public static ExecutorService getEventThreadPool() {
        int eventPoolThreadCount = 16;
        return new ThreadPoolExecutor(eventPoolThreadCount, eventPoolThreadCount, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadFactoryBuilder().setNameFormat("event-center-group-%d").build());
    }

    public static class CallerRunsPolicyWithReport
    extends ThreadPoolExecutor.CallerRunsPolicy {
        private static final Logger log = LoggerFactory.getLogger(CallerRunsPolicyWithReport.class);
        private final String executorName;

        public CallerRunsPolicyWithReport(String executorName) {
            this.executorName = executorName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            String msg = String.format("Thread pool is EXHAUSTED! Thread Name: %s, Pool Size: %d (active: %d, core: %d, max: %d, largest: %d), Task: %d (completed: %d), Executor status: (isShutdown:%s, isTerminated:%s, isTerminating:%s)!", this.executorName, e.getPoolSize(), e.getActiveCount(), e.getCorePoolSize(), e.getMaximumPoolSize(), e.getLargestPoolSize(), e.getTaskCount(), e.getCompletedTaskCount(), e.isShutdown(), e.isTerminated(), e.isTerminating());
            log.warn(msg);
            super.rejectedExecution(r, e);
        }
    }
}

