/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.dto.device.upgrade;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tplink.smb.device.firmware.upgrade.common.dto.UpgradeRequestDTO;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseUpgradeRequest;
import org.springframework.util.CollectionUtils;

public class DeviceUpgradeRequestDTO
extends BaseUpgradeRequest {
    @JsonProperty(value="rebootAfterUpgrade")
    private Boolean rebootAfterUpgrade;
    @JsonProperty(value="downloadLink")
    private String downloadLink;
    @JsonProperty(value="maxDownloadTime")
    private Integer maxDownloadTime;
    @JsonProperty(value="upgradeSceneCode")
    private Integer upgradeSceneCode;

    public static DeviceUpgradeRequestDTO construct(UpgradeRequestDTO upgradeRequest) {
        DeviceUpgradeRequestDTO deviceUpgradeRequestDTO = DeviceUpgradeRequestDTO.builder().rebootAfterUpgrade(upgradeRequest.getRebootAfterUpgrade()).maxDownloadTime(upgradeRequest.getMaxDownloadTime()).downloadLink(upgradeRequest.getDownloadLink()).build();
        if (!CollectionUtils.isEmpty(upgradeRequest.getAdditionalInfo()) && upgradeRequest.getAdditionalInfo().containsKey("upgradeSceneCode")) {
            deviceUpgradeRequestDTO.setUpgradeSceneCode(Integer.parseInt(upgradeRequest.getAdditionalInfo().get("upgradeSceneCode")));
        }
        return deviceUpgradeRequestDTO;
    }

    DeviceUpgradeRequestDTO(Boolean rebootAfterUpgrade, String downloadLink, Integer maxDownloadTime, Integer upgradeSceneCode) {
        this.rebootAfterUpgrade = rebootAfterUpgrade;
        this.downloadLink = downloadLink;
        this.maxDownloadTime = maxDownloadTime;
        this.upgradeSceneCode = upgradeSceneCode;
    }

    public static DeviceUpgradeRequestDTOBuilder builder() {
        return new DeviceUpgradeRequestDTOBuilder();
    }

    public String toString() {
        return "DeviceUpgradeRequestDTO(rebootAfterUpgrade=" + this.rebootAfterUpgrade + ", downloadLink=" + this.downloadLink + ", maxDownloadTime=" + this.maxDownloadTime + ", upgradeSceneCode=" + this.upgradeSceneCode + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceUpgradeRequestDTO)) {
            return false;
        }
        DeviceUpgradeRequestDTO other = (DeviceUpgradeRequestDTO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$rebootAfterUpgrade = this.rebootAfterUpgrade;
        Boolean other$rebootAfterUpgrade = other.rebootAfterUpgrade;
        if (this$rebootAfterUpgrade == null ? other$rebootAfterUpgrade != null : !((Object)this$rebootAfterUpgrade).equals(other$rebootAfterUpgrade)) {
            return false;
        }
        Integer this$maxDownloadTime = this.maxDownloadTime;
        Integer other$maxDownloadTime = other.maxDownloadTime;
        if (this$maxDownloadTime == null ? other$maxDownloadTime != null : !((Object)this$maxDownloadTime).equals(other$maxDownloadTime)) {
            return false;
        }
        Integer this$upgradeSceneCode = this.upgradeSceneCode;
        Integer other$upgradeSceneCode = other.upgradeSceneCode;
        if (this$upgradeSceneCode == null ? other$upgradeSceneCode != null : !((Object)this$upgradeSceneCode).equals(other$upgradeSceneCode)) {
            return false;
        }
        String this$downloadLink = this.downloadLink;
        String other$downloadLink = other.downloadLink;
        return !(this$downloadLink == null ? other$downloadLink != null : !this$downloadLink.equals(other$downloadLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceUpgradeRequestDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $rebootAfterUpgrade = this.rebootAfterUpgrade;
        result = result * 59 + ($rebootAfterUpgrade == null ? 43 : ((Object)$rebootAfterUpgrade).hashCode());
        Integer $maxDownloadTime = this.maxDownloadTime;
        result = result * 59 + ($maxDownloadTime == null ? 43 : ((Object)$maxDownloadTime).hashCode());
        Integer $upgradeSceneCode = this.upgradeSceneCode;
        result = result * 59 + ($upgradeSceneCode == null ? 43 : ((Object)$upgradeSceneCode).hashCode());
        String $downloadLink = this.downloadLink;
        result = result * 59 + ($downloadLink == null ? 43 : $downloadLink.hashCode());
        return result;
    }

    @JsonProperty(value="upgradeSceneCode")
    public void setUpgradeSceneCode(Integer upgradeSceneCode) {
        this.upgradeSceneCode = upgradeSceneCode;
    }

    public static class DeviceUpgradeRequestDTOBuilder {
        private Boolean rebootAfterUpgrade;
        private String downloadLink;
        private Integer maxDownloadTime;
        private Integer upgradeSceneCode;

        DeviceUpgradeRequestDTOBuilder() {
        }

        @JsonProperty(value="rebootAfterUpgrade")
        public DeviceUpgradeRequestDTOBuilder rebootAfterUpgrade(Boolean rebootAfterUpgrade) {
            this.rebootAfterUpgrade = rebootAfterUpgrade;
            return this;
        }

        @JsonProperty(value="downloadLink")
        public DeviceUpgradeRequestDTOBuilder downloadLink(String downloadLink) {
            this.downloadLink = downloadLink;
            return this;
        }

        @JsonProperty(value="maxDownloadTime")
        public DeviceUpgradeRequestDTOBuilder maxDownloadTime(Integer maxDownloadTime) {
            this.maxDownloadTime = maxDownloadTime;
            return this;
        }

        @JsonProperty(value="upgradeSceneCode")
        public DeviceUpgradeRequestDTOBuilder upgradeSceneCode(Integer upgradeSceneCode) {
            this.upgradeSceneCode = upgradeSceneCode;
            return this;
        }

        public DeviceUpgradeRequestDTO build() {
            return new DeviceUpgradeRequestDTO(this.rebootAfterUpgrade, this.downloadLink, this.maxDownloadTime, this.upgradeSceneCode);
        }

        public String toString() {
            return "DeviceUpgradeRequestDTO.DeviceUpgradeRequestDTOBuilder(rebootAfterUpgrade=" + this.rebootAfterUpgrade + ", downloadLink=" + this.downloadLink + ", maxDownloadTime=" + this.maxDownloadTime + ", upgradeSceneCode=" + this.upgradeSceneCode + ")";
        }
    }
}

