/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.dto.device.notify;

import com.tplink.smb.device.firmware.upgrade.common.dto.device.notify.DeviceUpgradeNotifyContent;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DeviceUpgradeNotifyDTO
implements MessageBody {
    String deviceMac;
    String sysId;
    private String subject;
    private Boolean needReply;
    private DeviceUpgradeNotifyContent content;

    public static DeviceUpgradeNotifyDTO transFromEcspMessage(@Nonnull EcspMessage message) {
        if (Objects.isNull(message.getHeader()) || Objects.isNull(message.getBody())) {
            return null;
        }
        String deviceMac = message.getHeader().getMac();
        String sysId = message.getHeader().getDest();
        if (Objects.isNull(deviceMac) || Objects.isNull(sysId)) {
            return null;
        }
        String messageBodyStr = JacksonUtils.pojo2Json((Object)message.getBody());
        DeviceUpgradeNotifyDTO upgradeNotifyDTO = (DeviceUpgradeNotifyDTO)JacksonUtils.json2Pojo((String)messageBodyStr, DeviceUpgradeNotifyDTO.class);
        upgradeNotifyDTO.setDeviceMac(deviceMac);
        upgradeNotifyDTO.setSysId(sysId);
        return upgradeNotifyDTO;
    }

    public String getDeviceMac() {
        return this.deviceMac;
    }

    public String getSysId() {
        return this.sysId;
    }

    public String getSubject() {
        return this.subject;
    }

    public Boolean getNeedReply() {
        return this.needReply;
    }

    public DeviceUpgradeNotifyContent getContent() {
        return this.content;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setNeedReply(Boolean needReply) {
        this.needReply = needReply;
    }

    public void setContent(DeviceUpgradeNotifyContent content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceUpgradeNotifyDTO)) {
            return false;
        }
        DeviceUpgradeNotifyDTO other = (DeviceUpgradeNotifyDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$needReply = this.getNeedReply();
        Boolean other$needReply = other.getNeedReply();
        if (this$needReply == null ? other$needReply != null : !((Object)this$needReply).equals(other$needReply)) {
            return false;
        }
        String this$deviceMac = this.getDeviceMac();
        String other$deviceMac = other.getDeviceMac();
        if (this$deviceMac == null ? other$deviceMac != null : !this$deviceMac.equals(other$deviceMac)) {
            return false;
        }
        String this$sysId = this.getSysId();
        String other$sysId = other.getSysId();
        if (this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        DeviceUpgradeNotifyContent this$content = this.getContent();
        DeviceUpgradeNotifyContent other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceUpgradeNotifyDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $needReply = this.getNeedReply();
        result = result * 59 + ($needReply == null ? 43 : ((Object)$needReply).hashCode());
        String $deviceMac = this.getDeviceMac();
        result = result * 59 + ($deviceMac == null ? 43 : $deviceMac.hashCode());
        String $sysId = this.getSysId();
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        DeviceUpgradeNotifyContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceUpgradeNotifyDTO(deviceMac=" + this.getDeviceMac() + ", sysId=" + this.getSysId() + ", subject=" + this.getSubject() + ", needReply=" + this.getNeedReply() + ", content=" + this.getContent() + ")";
    }

    public DeviceUpgradeNotifyDTO(String deviceMac, String sysId, String subject, Boolean needReply, DeviceUpgradeNotifyContent content) {
        this.deviceMac = deviceMac;
        this.sysId = sysId;
        this.subject = subject;
        this.needReply = needReply;
        this.content = content;
    }

    public DeviceUpgradeNotifyDTO() {
    }
}

