/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.dto.device;

import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeStageEnum;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.MonitorStageTimeoutSetting;
import java.util.concurrent.TimeUnit;

public class MonitorTimeoutSetting {
    private MonitorStageTimeoutSetting context;
    private MonitorStageTimeoutSetting requestStage;
    private MonitorStageTimeoutSetting downValStage;
    private MonitorStageTimeoutSetting upgradeStage;
    private MonitorStageTimeoutSetting rebootStage;

    public MonitorTimeoutSetting() {
        this.context = new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.CONTEXT);
        this.requestStage = new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.REQUEST);
        this.downValStage = new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.DOWNVAL);
        this.upgradeStage = new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.UPGRADE);
        this.rebootStage = new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.REBOOT);
    }

    public void setContext(long timeout, TimeUnit timeUnit) {
        this.context.updateTimeout(timeout, timeUnit);
    }

    public void setRequestTimeout(long timeout, TimeUnit timeUnit) {
        this.requestStage.updateTimeout(timeout, timeUnit);
    }

    public void setDownValTimeout(long timeout, TimeUnit timeUnit) {
        this.downValStage.updateTimeout(timeout, timeUnit);
    }

    public void setUpgradeTimeout(long timeout, TimeUnit timeUnit) {
        this.upgradeStage.updateTimeout(timeout, timeUnit);
    }

    public void setRebootTimeout(long timeout, TimeUnit timeUnit) {
        this.rebootStage.updateTimeout(timeout, timeUnit);
    }

    public static MonitorTimeoutSetting createDefault() {
        return ((MonitorTimeoutSettingBuilder)((MonitorTimeoutSettingBuilder)((MonitorTimeoutSettingBuilder)((MonitorTimeoutSettingBuilder)((MonitorTimeoutSettingBuilder)MonitorTimeoutSetting.builder().context(new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.CONTEXT))).requestStage(new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.REQUEST))).downValStage(new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.DOWNVAL))).upgradeStage(new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.UPGRADE))).rebootStage(new MonitorStageTimeoutSetting(DeviceFirmwareUpgradeStageEnum.REBOOT))).build();
    }

    protected MonitorTimeoutSetting(MonitorTimeoutSettingBuilder<?, ?> b) {
        this.context = ((MonitorTimeoutSettingBuilder)b).context;
        this.requestStage = ((MonitorTimeoutSettingBuilder)b).requestStage;
        this.downValStage = ((MonitorTimeoutSettingBuilder)b).downValStage;
        this.upgradeStage = ((MonitorTimeoutSettingBuilder)b).upgradeStage;
        this.rebootStage = ((MonitorTimeoutSettingBuilder)b).rebootStage;
    }

    public static MonitorTimeoutSettingBuilder<?, ?> builder() {
        return new MonitorTimeoutSettingBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitorTimeoutSetting)) {
            return false;
        }
        MonitorTimeoutSetting other = (MonitorTimeoutSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MonitorStageTimeoutSetting this$context = this.getContext();
        MonitorStageTimeoutSetting other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        MonitorStageTimeoutSetting this$requestStage = this.getRequestStage();
        MonitorStageTimeoutSetting other$requestStage = other.getRequestStage();
        if (this$requestStage == null ? other$requestStage != null : !((Object)this$requestStage).equals(other$requestStage)) {
            return false;
        }
        MonitorStageTimeoutSetting this$downValStage = this.getDownValStage();
        MonitorStageTimeoutSetting other$downValStage = other.getDownValStage();
        if (this$downValStage == null ? other$downValStage != null : !((Object)this$downValStage).equals(other$downValStage)) {
            return false;
        }
        MonitorStageTimeoutSetting this$upgradeStage = this.getUpgradeStage();
        MonitorStageTimeoutSetting other$upgradeStage = other.getUpgradeStage();
        if (this$upgradeStage == null ? other$upgradeStage != null : !((Object)this$upgradeStage).equals(other$upgradeStage)) {
            return false;
        }
        MonitorStageTimeoutSetting this$rebootStage = this.getRebootStage();
        MonitorStageTimeoutSetting other$rebootStage = other.getRebootStage();
        return !(this$rebootStage == null ? other$rebootStage != null : !((Object)this$rebootStage).equals(other$rebootStage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitorTimeoutSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MonitorStageTimeoutSetting $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        MonitorStageTimeoutSetting $requestStage = this.getRequestStage();
        result = result * 59 + ($requestStage == null ? 43 : ((Object)$requestStage).hashCode());
        MonitorStageTimeoutSetting $downValStage = this.getDownValStage();
        result = result * 59 + ($downValStage == null ? 43 : ((Object)$downValStage).hashCode());
        MonitorStageTimeoutSetting $upgradeStage = this.getUpgradeStage();
        result = result * 59 + ($upgradeStage == null ? 43 : ((Object)$upgradeStage).hashCode());
        MonitorStageTimeoutSetting $rebootStage = this.getRebootStage();
        result = result * 59 + ($rebootStage == null ? 43 : ((Object)$rebootStage).hashCode());
        return result;
    }

    public MonitorStageTimeoutSetting getContext() {
        return this.context;
    }

    public MonitorStageTimeoutSetting getRequestStage() {
        return this.requestStage;
    }

    public MonitorStageTimeoutSetting getDownValStage() {
        return this.downValStage;
    }

    public MonitorStageTimeoutSetting getUpgradeStage() {
        return this.upgradeStage;
    }

    public MonitorStageTimeoutSetting getRebootStage() {
        return this.rebootStage;
    }

    private static final class MonitorTimeoutSettingBuilderImpl
    extends MonitorTimeoutSettingBuilder<MonitorTimeoutSetting, MonitorTimeoutSettingBuilderImpl> {
        private MonitorTimeoutSettingBuilderImpl() {
        }

        @Override
        protected MonitorTimeoutSettingBuilderImpl self() {
            return this;
        }

        @Override
        public MonitorTimeoutSetting build() {
            return new MonitorTimeoutSetting(this);
        }
    }

    public static abstract class MonitorTimeoutSettingBuilder<C extends MonitorTimeoutSetting, B extends MonitorTimeoutSettingBuilder<C, B>> {
        private MonitorStageTimeoutSetting context;
        private MonitorStageTimeoutSetting requestStage;
        private MonitorStageTimeoutSetting downValStage;
        private MonitorStageTimeoutSetting upgradeStage;
        private MonitorStageTimeoutSetting rebootStage;

        protected abstract B self();

        public abstract C build();

        public B context(MonitorStageTimeoutSetting context) {
            this.context = context;
            return this.self();
        }

        public B requestStage(MonitorStageTimeoutSetting requestStage) {
            this.requestStage = requestStage;
            return this.self();
        }

        public B downValStage(MonitorStageTimeoutSetting downValStage) {
            this.downValStage = downValStage;
            return this.self();
        }

        public B upgradeStage(MonitorStageTimeoutSetting upgradeStage) {
            this.upgradeStage = upgradeStage;
            return this.self();
        }

        public B rebootStage(MonitorStageTimeoutSetting rebootStage) {
            this.rebootStage = rebootStage;
            return this.self();
        }

        public String toString() {
            return "MonitorTimeoutSetting.MonitorTimeoutSettingBuilder(context=" + this.context + ", requestStage=" + this.requestStage + ", downValStage=" + this.downValStage + ", upgradeStage=" + this.upgradeStage + ", rebootStage=" + this.rebootStage + ")";
        }
    }
}

