/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.constants.device;

import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeStageEnum;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.CodeStagePair;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DeviceFirmwareUpgradeError {
    REQUEST_REJECTED(-1, -10000, DeviceFirmwareUpgradeStageEnum.REQUEST, "device rejected the firmware upgrade request"),
    REQUEST_ACCEPTED(0, 0, DeviceFirmwareUpgradeStageEnum.REQUEST, "device rejected the firmware upgrade request"),
    DOWNVAL_OK(1, 0, DeviceFirmwareUpgradeStageEnum.DOWNVAL, "the firmware has been successfully downloaded and validated"),
    FIRMWARE_DOWNLOAD_FAILED(2, -1, DeviceFirmwareUpgradeStageEnum.DOWNVAL, "firmware download failed"),
    FIRMWARE_VALIDATION_FAILED(3, -2, DeviceFirmwareUpgradeStageEnum.DOWNVAL, "firmware validation failed"),
    FIRMWARE_SAME_VERSION(4, 50002, DeviceFirmwareUpgradeStageEnum.DOWNVAL, "firmware version same as current"),
    FIRMWARE_DOWNLOAD_NOT_VALID(5, 1, DeviceFirmwareUpgradeStageEnum.DOWNVAL, "firmware downloaded, no need to valid"),
    FIRMWARE_UPGRADE_OK(6, 0, DeviceFirmwareUpgradeStageEnum.UPGRADE, "device firmware upgrade ok"),
    FIRMWARE_RECONNECTED_OK(7, 0, DeviceFirmwareUpgradeStageEnum.REBOOT, "device reconnected ok"),
    FIRMWARE_UPGRADE_FAILED(8, 314, DeviceFirmwareUpgradeStageEnum.UPGRADE, "device firmware upgrade failed"),
    FIRMWARE_UPGRADE_FAILED_VALIDATION(9, -2, DeviceFirmwareUpgradeStageEnum.UPGRADE, "device firmware upgrade validation failed(switch)"),
    STAGE_REQUEST_TIMEOUT(10, -10001, DeviceFirmwareUpgradeStageEnum.REQUEST, "device firmware upgrade request sent timeout error"),
    STAGE_DOWNVAL_TIMEOUT(11, -10002, DeviceFirmwareUpgradeStageEnum.DOWNVAL, "device firmware download/validation timeout error"),
    STAGE_UPGRADE_TIMEOUT(12, -10003, DeviceFirmwareUpgradeStageEnum.UPGRADE, "device firmware upgrade timeout error"),
    STAGE_REBOOT_TIMEOUT(13, -10004, DeviceFirmwareUpgradeStageEnum.REBOOT, "device reboot timeout error"),
    GENERAL_ERROR(14, -10005, DeviceFirmwareUpgradeStageEnum.GENERAL, "device firmware upgrade general error");

    private static final Logger log;
    private static final Map<Integer, DeviceFirmwareUpgradeError> ERROR_MAP;
    private static final Map<CodeStagePair, DeviceFirmwareUpgradeError> CODE_STAGE_MAP;
    int index;
    int code;
    DeviceFirmwareUpgradeStageEnum stage;
    String desc;

    private DeviceFirmwareUpgradeError(int index, int code, DeviceFirmwareUpgradeStageEnum stage, String desc) {
        this.index = index;
        this.code = code;
        this.stage = stage;
        this.desc = desc;
    }

    public static DeviceFirmwareUpgradeError fromUpgradeNotify(int code, DeviceFirmwareUpgradeStageEnum stage) {
        DeviceFirmwareUpgradeError upgradeError = CODE_STAGE_MAP.get(new CodeStagePair(code, stage));
        if (Objects.isNull((Object)upgradeError)) {
            log.error("upgrade error code: {}, upgrade stage: {}", (Object)code, (Object)stage);
            return GENERAL_ERROR;
        }
        return CODE_STAGE_MAP.get(new CodeStagePair(code, stage));
    }

    public static DeviceFirmwareUpgradeError resolve(int errorIdx) {
        return ERROR_MAP.get(errorIdx);
    }

    public int getCode() {
        return this.code;
    }

    public int getIndex() {
        return this.index;
    }

    public DeviceFirmwareUpgradeStageEnum getStage() {
        return this.stage;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(DeviceFirmwareUpgradeError.class);
        ERROR_MAP = new HashMap<Integer, DeviceFirmwareUpgradeError>(16);
        CODE_STAGE_MAP = new HashMap<CodeStagePair, DeviceFirmwareUpgradeError>(16);
        for (DeviceFirmwareUpgradeError upgradeError : DeviceFirmwareUpgradeError.values()) {
            ERROR_MAP.putIfAbsent(upgradeError.index, upgradeError);
            CODE_STAGE_MAP.putIfAbsent(new CodeStagePair(upgradeError.code, upgradeError.stage), upgradeError);
        }
    }
}

