/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.device.firmware.upgrade.common.constants.device;

import com.tplink.smb.device.firmware.upgrade.common.constants.device.DeviceFirmwareUpgradeStageEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public enum DeviceFirmwareUpgradeDefaultTimeoutEnum {
    CONTEXT(DeviceFirmwareUpgradeStageEnum.CONTEXT, 30L, TimeUnit.SECONDS),
    STAGE_REQUEST(DeviceFirmwareUpgradeStageEnum.REQUEST, 60L, TimeUnit.SECONDS),
    STAGE_DOWNVAL(DeviceFirmwareUpgradeStageEnum.DOWNVAL, 60L, TimeUnit.SECONDS),
    STAGE_UPGRADE(DeviceFirmwareUpgradeStageEnum.UPGRADE, 60L, TimeUnit.SECONDS),
    STAGE_REBOOT(DeviceFirmwareUpgradeStageEnum.REBOOT, 60L, TimeUnit.SECONDS);

    DeviceFirmwareUpgradeStageEnum stage;
    long timeout;
    TimeUnit timeUnit;
    private static final Map<DeviceFirmwareUpgradeStageEnum, DeviceFirmwareUpgradeDefaultTimeoutEnum> STAGE_MAP;

    private DeviceFirmwareUpgradeDefaultTimeoutEnum(DeviceFirmwareUpgradeStageEnum stage, long timeout, TimeUnit timeUnit) {
        this.stage = stage;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public static DeviceFirmwareUpgradeDefaultTimeoutEnum resolve(DeviceFirmwareUpgradeStageEnum stage) {
        return STAGE_MAP.get((Object)stage);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    static {
        STAGE_MAP = new HashMap<DeviceFirmwareUpgradeStageEnum, DeviceFirmwareUpgradeDefaultTimeoutEnum>(16);
        for (DeviceFirmwareUpgradeDefaultTimeoutEnum timeoutEnum : DeviceFirmwareUpgradeDefaultTimeoutEnum.values()) {
            STAGE_MAP.putIfAbsent(timeoutEnum.stage, timeoutEnum);
        }
    }
}

