/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.openapi.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;

public class ModifyUserVO {
    @Schema(name="roleId", description="This field represents Role ID. Role can be created using 'Create new role' interface, and Role ID can be obtained from 'Get role list' interface.")
    @NotNull(message="user role id should not be null")
    private @NotNull(message="user role id should not be null") String roleId;
    @Schema(name="name", description="User name should contain 1 to 128 characters and start with letters, numbers, and underscores. When creating cloud user, you should set TP-LINK ID.")
    @NotNull(message="user name should not be null")
    @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="user name should not be null") @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") String name;
    @Schema(name="password", description="Password of local user should contain 8 to 128 characters. And password must be a combination of uppercase letters, lowercase letters, numbers, and special symbols. Symbols such as ! # $ % & * @ ^ are supported.")
    @Pattern(regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~])(?!.*[\\00-\\040\\042\\077\\0177]).{8,128}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~])(?!.*[\\00-\\040\\042\\077\\0177]).{8,128}$", message="Invalid password.") String password;
    @Schema(name="email", description="Email of user")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    @Schema(name="alert", description="Alert email")
    private Boolean alert;
    @Schema(name="forceModify", description="Force modify")
    private Boolean forceModify;
    @Schema(name="incidentNotification", description="Incident notification")
    private Boolean incidentNotification;
    @Schema(name="sites", description="User site privilege list")
    private Set<String> sites;
    @Schema(name="allSite", description="Whether user has all site permission, including new created site.")
    @NotNull(message="allSite should not be null")
    private @NotNull(message="allSite should not be null") Boolean allSite;
    @Schema(name="temporaryEnable", description="Whether the user wants to enable the temporary worker permission")
    private Boolean temporaryEnable;
    @Schema(name="startTime", description="The start time of the user's validity period. time range: start timestamp (Millisecond).")
    private Long startTime;
    @Schema(name="endTime", description="The end time of the user's validity period. time range: end timestamp (Millisecond).")
    private Long endTime;

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public Boolean getForceModify() {
        return this.forceModify;
    }

    @Generated
    public Boolean getIncidentNotification() {
        return this.incidentNotification;
    }

    @Generated
    public Set<String> getSites() {
        return this.sites;
    }

    @Generated
    public Boolean getAllSite() {
        return this.allSite;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public ModifyUserVO setRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Generated
    public ModifyUserVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ModifyUserVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public ModifyUserVO setEmail(String email) {
        this.email = email;
        return this;
    }

    @Generated
    public ModifyUserVO setAlert(Boolean alert) {
        this.alert = alert;
        return this;
    }

    @Generated
    public ModifyUserVO setForceModify(Boolean forceModify) {
        this.forceModify = forceModify;
        return this;
    }

    @Generated
    public ModifyUserVO setIncidentNotification(Boolean incidentNotification) {
        this.incidentNotification = incidentNotification;
        return this;
    }

    @Generated
    public ModifyUserVO setSites(Set<String> sites) {
        this.sites = sites;
        return this;
    }

    @Generated
    public ModifyUserVO setAllSite(Boolean allSite) {
        this.allSite = allSite;
        return this;
    }

    @Generated
    public ModifyUserVO setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
        return this;
    }

    @Generated
    public ModifyUserVO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public ModifyUserVO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public ModifyUserVO() {
    }

    @Generated
    public String toString() {
        return "ModifyUserVO(roleId=" + this.getRoleId() + ", name=" + this.getName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", alert=" + this.getAlert() + ", forceModify=" + this.getForceModify() + ", incidentNotification=" + this.getIncidentNotification() + ", sites=" + this.getSites() + ", allSite=" + this.getAllSite() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

