/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.openapi.vo;

import com.tplink.nbu.common.pii.annotation.PII;
import com.tplink.nbu.common.pii.constant.PIIMaskStrategy;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;

public class ModifyMspUserVO {
    @Schema(name="name", description="User name. When creating cloud user, you should set TP-LINK ID. It should contain 1 to 128 ASCII characters and start with letters, numbers, and underscores.")
    @NotNull(message="user name should not be null")
    @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @PII(strategy=PIIMaskStrategy.HASH)
    private @NotNull(message="user name should not be null") @Pattern(regexp="^(?![+=@-])[\\041-\\0176]$|^(?![+=@-])[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") String name;
    @Schema(name="password", description="Password of local user. User can only modify his child local user's password. It should contain 8 to 128 ASCII characters.And password must be a combination of uppercase letters, lowercase letters, numbers, and special symbols. Symbols such as ! # $ % & * @ ^ are supported.")
    @Pattern(regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~])(?!.*[\\00-\\040\\042\\077\\0177]).{8,128}$", message="Invalid password.")
    @PII(strategy=PIIMaskStrategy.MASK)
    private @Pattern(regexp="^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~])(?!.*[\\00-\\040\\042\\077\\0177]).{8,128}$", message="Invalid password.") String password;
    @Schema(name="email", description="Email of user")
    @PII(strategy=PIIMaskStrategy.HASH)
    private String email;
    @Schema(name="customerRoleId", description="Customer role ID of msp user")
    @NotNull(message="user customer role id should not be null")
    private @NotNull(message="user customer role id should not be null") String customerRoleId;
    @Schema(name="allCustomer", description="All customers including new created customer")
    @NotNull(message="allCustomer should not be null")
    private @NotNull(message="allCustomer should not be null") Boolean allCustomer;
    @Schema(name="customers", description="Customer ID list of msp user")
    private Set<String> customers;
    @Schema(name="alert", description="Alert email")
    private Boolean alert;
    @Schema(name="roleId", description="Role ID of user")
    @NotNull(message="user role id should not be null")
    private @NotNull(message="user role id should not be null") String roleId;
    @Schema(name="forceModify", description="Force modify")
    private Boolean forceModify;
    @Schema(name="temporaryEnable", description="Whether the user wants to enable the temporary worker permission")
    private Boolean temporaryEnable;
    @Schema(name="startTime", description="The start time of the user's validity period. time range: start timestamp (Millisecond).")
    private Long startTime;
    @Schema(name="endTime", description="The end time of the user's validity period. time range: end timestamp (Millisecond).")
    private Long endTime;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getCustomerRoleId() {
        return this.customerRoleId;
    }

    @Generated
    public Boolean getAllCustomer() {
        return this.allCustomer;
    }

    @Generated
    public Set<String> getCustomers() {
        return this.customers;
    }

    @Generated
    public Boolean getAlert() {
        return this.alert;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public Boolean getForceModify() {
        return this.forceModify;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public ModifyMspUserVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ModifyMspUserVO setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public ModifyMspUserVO setEmail(String email) {
        this.email = email;
        return this;
    }

    @Generated
    public ModifyMspUserVO setCustomerRoleId(String customerRoleId) {
        this.customerRoleId = customerRoleId;
        return this;
    }

    @Generated
    public ModifyMspUserVO setAllCustomer(Boolean allCustomer) {
        this.allCustomer = allCustomer;
        return this;
    }

    @Generated
    public ModifyMspUserVO setCustomers(Set<String> customers) {
        this.customers = customers;
        return this;
    }

    @Generated
    public ModifyMspUserVO setAlert(Boolean alert) {
        this.alert = alert;
        return this;
    }

    @Generated
    public ModifyMspUserVO setRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Generated
    public ModifyMspUserVO setForceModify(Boolean forceModify) {
        this.forceModify = forceModify;
        return this;
    }

    @Generated
    public ModifyMspUserVO setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
        return this;
    }

    @Generated
    public ModifyMspUserVO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public ModifyMspUserVO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public ModifyMspUserVO() {
    }

    @Generated
    public String toString() {
        return "ModifyMspUserVO(name=" + this.getName() + ", password=" + this.getPassword() + ", email=" + this.getEmail() + ", customerRoleId=" + this.getCustomerRoleId() + ", allCustomer=" + this.getAllCustomer() + ", customers=" + this.getCustomers() + ", alert=" + this.getAlert() + ", roleId=" + this.getRoleId() + ", forceModify=" + this.getForceModify() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

