/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.openapi.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="Hotspot Operator")
public class HotspotOperatorOpenApiVO {
    @Schema(name="name", description="Operator name should contain 1 to 128 ASCII characters.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @NotNull(message="Operator parameter [name] should not be null.")
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") @NotNull(message="Operator parameter [name] should not be null.") String name;
    @Schema(name="password", description="Operator password should contain 1 to 128 ASCII characters.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$")
    @NotNull(message="Operator parameter [password] should not be null.")
    private @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$") @NotNull(message="Operator parameter [password] should not be null.") String password;
    @Schema(name="note", description="Operator note should contain 1 to 256 ASCII characters.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,254}[^ ]$")
    private @Pattern(regexp="^[^ ]$|^[^ ].{0,254}[^ ]$") String note;
    @Schema(name="operatorRoleType", description="Operator role type should be a value as follows: 0: Administrator; 1: Viewer.")
    private Integer operatorRoleType;
    @Schema(name="lastSite", description="Last Site ID")
    private String lastSite;
    @Schema(name="selectedSites", description="Selected site ID list should contain at least one site for each operator.")
    @NotNull(message="Operator parameter [selectedSites] should not be null.")
    @Size(min=1, message="Please select at least one site for this operator.")
    private @NotNull(message="Operator parameter [selectedSites] should not be null.") @Size(min=1, message="Please select at least one site for this operator.") List<String> selectedSites;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getNote() {
        return this.note;
    }

    @Generated
    public Integer getOperatorRoleType() {
        return this.operatorRoleType;
    }

    @Generated
    public String getLastSite() {
        return this.lastSite;
    }

    @Generated
    public List<String> getSelectedSites() {
        return this.selectedSites;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setNote(String note) {
        this.note = note;
    }

    @Generated
    public void setOperatorRoleType(Integer operatorRoleType) {
        this.operatorRoleType = operatorRoleType;
    }

    @Generated
    public void setLastSite(String lastSite) {
        this.lastSite = lastSite;
    }

    @Generated
    public void setSelectedSites(List<String> selectedSites) {
        this.selectedSites = selectedSites;
    }

    @Generated
    public String toString() {
        return "HotspotOperatorOpenApiVO(name=" + this.getName() + ", password=" + this.getPassword() + ", note=" + this.getNote() + ", operatorRoleType=" + this.getOperatorRoleType() + ", lastSite=" + this.getLastSite() + ", selectedSites=" + this.getSelectedSites() + ")";
    }

    @Generated
    public HotspotOperatorOpenApiVO() {
    }

    @Generated
    public HotspotOperatorOpenApiVO(String name, String password, String note, Integer operatorRoleType, String lastSite, List<String> selectedSites) {
        this.name = name;
        this.password = password;
        this.note = note;
        this.operatorRoleType = operatorRoleType;
        this.lastSite = lastSite;
        this.selectedSites = selectedSites;
    }
}

