/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.openapi.sso.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Set;
import lombok.Generated;

public class MspExternalUserGroupOpenApiVO {
    @Schema(name="name", description="Msp external user group name should contain 1 to 128 characters.")
    @NotNull(message="Parameter [name] can not be null.")
    @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [name] can only be 1 to 128 characters, with no spaces at the beginning and end.")
    private @NotNull(message="Parameter [name] can not be null.") @Pattern(regexp="^[\\041-\\0176]$|^[\\041-\\0176][\\040-\\0176]{0,126}[\\041-\\0176]$", message="Parameter [name] can only be 1 to 128 characters, with no spaces at the beginning and end.") String name;
    @Schema(name="roleId", description="Msp role ID which can be obtained from 'Get msp role list' interface.")
    @NotNull(message="Parameter [roleId] can not be null.")
    private @NotNull(message="Parameter [roleId] can not be null.") String roleId;
    @Schema(name="customerRoleId", description="Customer role ID which can be obtained from 'Get customer list' interface.")
    @NotNull(message="Parameter [customerRoleId] can not be null.")
    private @NotNull(message="Parameter [customerRoleId] can not be null.") String customerRoleId;
    @Schema(name="allCustomer", description="Whether having all customer permissions.")
    @NotNull(message="Parameter [allCustomer] can not be null.")
    private @NotNull(message="Parameter [allCustomer] can not be null.") Boolean allCustomer;
    @Schema(name="customers", description="The customer IDs that can be accessed. Effective when allCustomer is false.")
    private Set<String> customers;
    @Schema(name="temporaryEnable", description="Whether the user wants to enable the temporary worker permission")
    private Boolean temporaryEnable;
    @Schema(name="startTime", description="The start time of the user's validity period. time range: start timestamp (Millisecond).")
    private Long startTime;
    @Schema(name="endTime", description="The end time of the user's validity period. time range: end timestamp (Millisecond).")
    private Long endTime;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getRoleId() {
        return this.roleId;
    }

    @Generated
    public String getCustomerRoleId() {
        return this.customerRoleId;
    }

    @Generated
    public Boolean getAllCustomer() {
        return this.allCustomer;
    }

    @Generated
    public Set<String> getCustomers() {
        return this.customers;
    }

    @Generated
    public Boolean getTemporaryEnable() {
        return this.temporaryEnable;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setCustomerRoleId(String customerRoleId) {
        this.customerRoleId = customerRoleId;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setAllCustomer(Boolean allCustomer) {
        this.allCustomer = allCustomer;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setCustomers(Set<String> customers) {
        this.customers = customers;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setTemporaryEnable(Boolean temporaryEnable) {
        this.temporaryEnable = temporaryEnable;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Generated
    public MspExternalUserGroupOpenApiVO() {
    }

    @Generated
    public MspExternalUserGroupOpenApiVO(String name, String roleId, String customerRoleId, Boolean allCustomer, Set<String> customers, Boolean temporaryEnable, Long startTime, Long endTime) {
        this.name = name;
        this.roleId = roleId;
        this.customerRoleId = customerRoleId;
        this.allCustomer = allCustomer;
        this.customers = customers;
        this.temporaryEnable = temporaryEnable;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Generated
    public String toString() {
        return "MspExternalUserGroupOpenApiVO(name=" + this.getName() + ", roleId=" + this.getRoleId() + ", customerRoleId=" + this.getCustomerRoleId() + ", allCustomer=" + this.getAllCustomer() + ", customers=" + this.getCustomers() + ", temporaryEnable=" + this.getTemporaryEnable() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }
}

