/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.identityaccess.api.openapi.sso.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Base64;
import lombok.Generated;

public class IdpMetadataOpenApiVO {
    @Schema(name="name", description="IdP name should contain 1 to 32 characters.")
    @NotNull(message="Parameter [name] can not be null.")
    @Pattern(regexp="^[^ ]$|^[^ ].{0,30}[^ ]$", message="Parameter [name] can only be 1 to 32 characters, with no spaces at the beginning and end.")
    private @NotNull(message="Parameter [name] can not be null.") @Pattern(regexp="^[^ ]$|^[^ ].{0,30}[^ ]$", message="Parameter [name] can only be 1 to 32 characters, with no spaces at the beginning and end.") String name;
    @Schema(name="description", description="IdP description should contain 0 to 128 characters.")
    @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [description] can not exceed 128 characters.")
    private @Pattern(regexp="^$|^[^ ]$|^[^ ].{0,126}[^ ]$", message="Parameter [description] can not exceed 128 characters.") String description;
    @Schema(name="entityId", description="The IdP entity id which must be unique in same Omadac.")
    @NotNull(message="Parameter [entityId] can not be null.")
    @Pattern(regexp="^(?=^.{3,255}$)(http(s)?:\\/\\/)(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/[\\w-]*(\\.[\\w-]+)?)*([\\?&][\\w-]+=[\\w-]*)*$", message="Parameter [entityId] can only be valid URL format.")
    private @NotNull(message="Parameter [entityId] can not be null.") @Pattern(regexp="^(?=^.{3,255}$)(http(s)?:\\/\\/)(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/[\\w-]*(\\.[\\w-]+)?)*([\\?&][\\w-]+=[\\w-]*)*$", message="Parameter [entityId] can only be valid URL format.") String entityId;
    @Schema(name="loginUrl", description="Login url")
    @NotNull(message="Parameter [loginUrl] can not be null.")
    @Pattern(regexp="^(?=^.{3,255}$)(http(s)?:\\/\\/)(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/[\\w-]*(\\.[\\w-]+)?)*([\\?&][\\w-]+=[\\w-]*)*$", message="Parameter [loginUrl] can only be valid URL format.")
    private @NotNull(message="Parameter [loginUrl] can not be null.") @Pattern(regexp="^(?=^.{3,255}$)(http(s)?:\\/\\/)(www\\.)?[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+(:\\d+)*(\\/[\\w-]*(\\.[\\w-]+)?)*([\\?&][\\w-]+=[\\w-]*)*$", message="Parameter [loginUrl] can only be valid URL format.") String loginUrl;
    @Schema(name="x509Certificate", description="BASE64 encoded string of x509 certificate.")
    @NotNull(message="Parameter [x509Certificate] can not be null.")
    private @NotNull(message="Parameter [x509Certificate] can not be null.") String x509Certificate;

    public boolean validate() {
        try {
            return new String(Base64.getDecoder().decode(this.x509Certificate)).startsWith("-----BEGIN CERTIFICATE-----");
        }
        catch (Exception e2) {
            return false;
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getLoginUrl() {
        return this.loginUrl;
    }

    @Generated
    public String getX509Certificate() {
        return this.x509Certificate;
    }

    @Generated
    public IdpMetadataOpenApiVO setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public IdpMetadataOpenApiVO setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public IdpMetadataOpenApiVO setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @Generated
    public IdpMetadataOpenApiVO setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    @Generated
    public IdpMetadataOpenApiVO setX509Certificate(String x509Certificate) {
        this.x509Certificate = x509Certificate;
        return this;
    }

    @Generated
    public IdpMetadataOpenApiVO() {
    }

    @Generated
    public IdpMetadataOpenApiVO(String name, String description, String entityId, String loginUrl, String x509Certificate) {
        this.name = name;
        this.description = description;
        this.entityId = entityId;
        this.loginUrl = loginUrl;
        this.x509Certificate = x509Certificate;
    }

    @Generated
    public String toString() {
        return "IdpMetadataOpenApiVO(name=" + this.getName() + ", description=" + this.getDescription() + ", entityId=" + this.getEntityId() + ", loginUrl=" + this.getLoginUrl() + ", x509Certificate=" + this.getX509Certificate() + ")";
    }
}

