type AES256Callback = (key: Buffer, iv: Buffer, input: Buffer, output: Buffer) => number | Error;
declare function randomHook(buffer: Buffer, count: number): number | Error;
declare function sha256Hook(input: Buffer, output: Buffer): number | Error;
type HMACHook = (key: Buffer, input: Buffer, output: Buffer) => number | Error;
export declare function makeHmacHook(algorithm: 'sha512' | 'sha256'): HMACHook;
declare function signRsaSha256Hook(key: Buffer, input: Buffer, output: Buffer): number | Error;
/**
 * @public
 *
 * A JS implementation of crypto callbacks used for encryption.
 * These are only necessary on versions of Node.js that do not bundle OpenSSL 3.x
 */
export declare const cryptoCallbacks: {
    randomHook: typeof randomHook;
    sha256Hook: typeof sha256Hook;
    signRsaSha256Hook: typeof signRsaSha256Hook;
    aes256CbcEncryptHook: AES256Callback;
    aes256CbcDecryptHook: AES256Callback;
    aes256CtrEncryptHook: AES256Callback;
    aes256CtrDecryptHook: AES256Callback;
    hmacSha512Hook: HMACHook;
    hmacSha256Hook: HMACHook;
};
export {};
//# sourceMappingURL=crypto_callbacks.d.ts.map