/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class HexDumper {
    public static final int BYTE_PER_ROW = 16;
    private PrintStream printStream;
    private int currentLineLength;
    private int currentByte;
    private int offset;
    private byte[] thisLine = new byte[16];

    public String dump(byte[] inputBytes) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBytes);
        try {
            this.dump(inputStream, outputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not read input stream. ");
        }
        return outputStream.toString();
    }

    public void dump(InputStream inputBytes, OutputStream outputStream) throws IOException {
        int lineLength;
        byte[] lineBytes = new byte[16];
        this.reset(outputStream);
        while ((lineLength = this.readFully(inputBytes, lineBytes)) != 0) {
            this.writeMemoryOffset(lineLength);
            for (int i = 0; i < lineLength; ++i) {
                this.writeHexBytes(lineBytes, i);
            }
            this.writeASCIISummary();
            if (lineLength >= 16) continue;
        }
    }

    private int readFully(InputStream inputBytes, byte[] lineBytes) throws IOException {
        for (int i = 0; i < lineBytes.length; ++i) {
            int j = inputBytes.read();
            if (j == -1) {
                return i;
            }
            lineBytes[i] = (byte)j;
        }
        return lineBytes.length;
    }

    private void reset(OutputStream var1) throws IOException {
        this.offset = 0;
        this.printStream = new PrintStream(var1);
    }

    protected void writeMemoryOffset(int offsetLength) throws IOException {
        this.convertByteToHex(this.printStream, (byte)(this.offset >>> 8 & 0xFF));
        this.convertByteToHex(this.printStream, (byte)(this.offset & 0xFF));
        this.printStream.print(": ");
        this.currentByte = 0;
        this.currentLineLength = offsetLength;
    }

    private void writeHexBytes(byte[] byteArray, int length) throws IOException {
        this.thisLine[this.currentByte] = byteArray[length];
        this.convertByteToHex(this.printStream, byteArray[length]);
        this.printStream.print(" ");
        ++this.currentByte;
        if (this.currentByte == 8) {
            this.printStream.print("  ");
        }
    }

    private void writeASCIISummary() throws IOException {
        int i;
        if (this.currentLineLength < 16) {
            for (i = this.currentLineLength; i < 16; ++i) {
                this.printStream.print("   ");
                if (i != 7) continue;
                this.printStream.print("  ");
            }
        }
        this.printStream.print(" ");
        for (i = 0; i < this.currentLineLength; ++i) {
            if (this.thisLine[i] >= 32 && this.thisLine[i] <= 122) {
                this.printStream.write(this.thisLine[i]);
                continue;
            }
            this.printStream.print(".");
        }
        this.printStream.println();
        this.offset += this.currentLineLength;
    }

    private void convertByteToHex(PrintStream printStream, byte byteValue) {
        char hexChar = (char)(byteValue >> 4 & 0xF);
        hexChar = hexChar > '\t' ? (char)(hexChar - 10 + 65) : (char)(hexChar + 48);
        printStream.write(hexChar);
        hexChar = (char)(byteValue & 0xF);
        hexChar = hexChar > '\t' ? (char)(hexChar - 10 + 65) : (char)(hexChar + 48);
        printStream.write(hexChar);
    }
}

