/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.util.Library;

public abstract class ShadingMeshPattern
extends ShadingPattern
implements Pattern {
    private static final Logger logger = Logger.getLogger(ShadingMeshPattern.class.toString());
    public static final Name BITS_PER_FLAG_KEY = new Name("BitsPerFlag");
    public static final Name BITS_PER_COORDINATE_KEY = new Name("BitsPerCoordinate");
    protected static final int DECODE_X_MIN = 0;
    protected static final int DECODE_X_MAX = 1;
    protected static final int DECODE_Y_MIN = 2;
    protected static final int DECODE_Y_MAX = 3;
    protected int bitsPerFlag;
    protected int bitsPerCoordinate;
    protected int bitsPerComponent;
    protected int colorSpaceCompCount;
    protected BitStream vertexBitStream;
    protected Stream meshDataStream;
    protected float[] decode;

    public ShadingMeshPattern(Library l, HashMap h, Stream meshDataStream) {
        super(l, h);
        this.meshDataStream = meshDataStream;
        this.shadingDictionary = meshDataStream.getEntries();
        this.bitsPerFlag = this.library.getInt(this.shadingDictionary, BITS_PER_FLAG_KEY);
        this.bitsPerCoordinate = this.library.getInt(this.shadingDictionary, BITS_PER_COORDINATE_KEY);
        this.bitsPerComponent = this.library.getInt(this.shadingDictionary, ImageStream.BITSPERCOMPONENT_KEY);
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shadingDictionary, COLORSPACE_KEY));
        this.colorSpaceCompCount = this.colorSpace.getNumComponents();
        Object tmp = this.library.getObject(this.shadingDictionary, FUNCTION_KEY);
        if (tmp != null) {
            if (!(tmp instanceof List)) {
                this.function = new Function[]{Function.getFunction(this.library, tmp)};
            } else {
                List functionTemp = (List)tmp;
                this.function = new Function[functionTemp.size()];
                for (int i = 0; i < functionTemp.size(); ++i) {
                    this.function[i] = Function.getFunction(this.library, functionTemp.get(i));
                }
            }
        }
        this.decode = this.processDecode();
        this.vertexBitStream = new BitStream(meshDataStream.getDecodedByteArrayInputStream());
    }

    public abstract Paint getPaint() throws InterruptedException;

    protected float[] processDecode() {
        float Dmax;
        float Dmin;
        float[] decode = new float[6];
        if (this.function == null) {
            decode = new float[4 + 2 * this.colorSpaceCompCount];
        }
        List decodeVec = (List)this.library.getObject(this.shadingDictionary, ImageStream.DECODE_KEY);
        float maxValue = this.bitsPerCoordinate < 32 ? (float)((1 << this.bitsPerCoordinate) - 1) : 2.3283064E-10f;
        int i = 0;
        while (i <= 3) {
            Dmin = ((Number)decodeVec.get(i)).floatValue();
            Dmax = ((Number)decodeVec.get(i + 1)).floatValue();
            decode[i++] = Dmin;
            decode[i++] = (Dmax - Dmin) / maxValue;
        }
        maxValue = (int)Math.pow(2.0, this.bitsPerComponent) - 1;
        i = 4;
        while (i < decode.length) {
            Dmin = ((Number)decodeVec.get(i)).floatValue();
            Dmax = ((Number)decodeVec.get(i + 1)).floatValue();
            decode[i++] = Dmin;
            decode[i++] = (Dmax - Dmin) / maxValue;
        }
        return decode;
    }

    protected int readFlag() throws IOException {
        return this.vertexBitStream.getBits(this.bitsPerFlag);
    }

    protected Point2D.Float readCoord() throws IOException {
        float x = this.vertexBitStream.getBits(this.bitsPerCoordinate);
        float y = this.vertexBitStream.getBits(this.bitsPerCoordinate);
        return new Point2D.Float(x *= this.decode[1] - this.decode[0] + this.decode[0], y *= this.decode[3] - this.decode[2] + this.decode[2]);
    }

    protected Color readColor() throws IOException {
        if (this.function == null) {
            float[] primitives = new float[this.colorSpaceCompCount];
            int i = 0;
            int j = 4;
            while (i < this.colorSpaceCompCount) {
                primitives[i] = this.vertexBitStream.getBits(this.bitsPerComponent);
                int n = i++;
                primitives[n] = primitives[n] * (this.decode[j + 1] - this.decode[j] + this.decode[j]);
                j += 2;
            }
            primitives = PColorSpace.reverse(primitives);
            return this.colorSpace.getColor(primitives, true);
        }
        float value = this.vertexBitStream.getBits(this.bitsPerComponent);
        float[] primitives = new float[]{value *= this.decode[5] - this.decode[4] + this.decode[4]};
        float[] output = this.calculateValues(primitives);
        if (output != null) {
            output = PColorSpace.reverse(output);
            return this.colorSpace.getColor(output, true);
        }
        return null;
    }
}

