/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.acroform.ChoiceFieldDictionary;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceWidgetAnnotation
extends AbstractWidgetAnnotation<ChoiceFieldDictionary> {
    private ChoiceFieldDictionary fieldDictionary;

    public ChoiceWidgetAnnotation(Library l, HashMap h) {
        super(l, h);
        this.fieldDictionary = new ChoiceFieldDictionary(this.library, this.entries);
    }

    public ArrayList<ChoiceFieldDictionary.ChoiceOption> generateChoices() {
        Shapes shapes = this.getShapes();
        if (shapes != null) {
            ArrayList<ChoiceFieldDictionary.ChoiceOption> options = new ArrayList<ChoiceFieldDictionary.ChoiceOption>();
            ArrayList<LineText> pageLines = shapes.getPageText().getPageLines();
            for (LineText lines : pageLines) {
                for (WordText word : lines.getWords()) {
                    String tmp = word.toString();
                    if (tmp.equals("") || tmp.equals(" ")) continue;
                    options.add(this.fieldDictionary.buildChoiceOption(tmp, tmp));
                }
            }
            return options;
        }
        return new ArrayList<ChoiceFieldDictionary.ChoiceOption>();
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        Form appearanceStream;
        ChoiceFieldDictionary.ChoiceFieldType choiceFieldType = this.fieldDictionary.getChoiceFieldType();
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Rectangle2D bbox = appearanceState.getBbox();
        AffineTransform matrix = appearanceState.getMatrix();
        String currentContentStream = appearanceState.getOriginalContentStream();
        currentContentStream = choiceFieldType == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_COMBO || choiceFieldType == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_EDITABLE_COMBO ? (currentContentStream != null ? this.buildChoiceComboContents(currentContentStream) : "") : (currentContentStream != null ? this.buildChoiceListContents(currentContentStream) : "");
        if (currentContentStream != null) {
            appearanceState.setContentStream(currentContentStream.getBytes());
        }
        if ((appearanceStream = this.getOrGenerateAppearanceForm()) != null) {
            appearanceStream.setRawBytes(currentContentStream.getBytes());
            StateManager stateManager = this.library.getStateManager();
            stateManager.addChange(new PObject(appearanceStream, appearanceStream.getPObjectReference()));
            HashMap<Name, Reference> appearanceRefs = new HashMap<Name, Reference>();
            appearanceRefs.put(APPEARANCE_STREAM_NORMAL_KEY, appearanceStream.getPObjectReference());
            this.entries.put(APPEARANCE_STREAM_KEY, appearanceRefs);
            Rectangle2D.Float formBbox = new Rectangle2D.Float(0.0f, 0.0f, (float)bbox.getWidth(), (float)bbox.getHeight());
            appearanceStream.setAppearance(null, matrix, formBbox);
            if (this.library.getResources(appearanceStream.getEntries(), Form.RESOURCES_KEY) == null) {
                appearanceStream.getEntries().put(Form.RESOURCES_KEY, this.library.getCatalog().getInteractiveForm().getResources().getEntries());
            }
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
            appearanceStream.getEntries().remove(Stream.FILTER_KEY);
            appearanceStream.init();
        }
    }

    @Override
    public void reset() {
        FieldDictionary parentFieldDictionary;
        Object oldValue = this.fieldDictionary.getFieldValue();
        Object tmp = this.fieldDictionary.getDefaultFieldValue();
        if (tmp == null && (parentFieldDictionary = this.fieldDictionary.getParent()) != null) {
            tmp = parentFieldDictionary.getDefaultFieldValue();
        }
        if (tmp != null) {
            this.fieldDictionary.setFieldValue(tmp, this.getPObjectReference());
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, tmp);
        } else {
            this.fieldDictionary.getEntries().remove(FieldDictionary.V_KEY);
            this.fieldDictionary.setIndexes(null);
            parentFieldDictionary = this.fieldDictionary.getParent();
            if (parentFieldDictionary != null) {
                parentFieldDictionary.getEntries().remove(FieldDictionary.V_KEY);
                if (parentFieldDictionary instanceof ChoiceFieldDictionary) {
                    ((ChoiceFieldDictionary)parentFieldDictionary).setIndexes(null);
                }
            }
            this.changeSupport.firePropertyChange("valueFieldReset", oldValue, null);
        }
    }

    @Override
    public ChoiceFieldDictionary getFieldDictionary() {
        return this.fieldDictionary;
    }

    public String buildChoiceComboContents(String currentContentStream) {
        ArrayList<ChoiceFieldDictionary.ChoiceOption> choices = this.fieldDictionary.getOptions();
        if (choices == null) {
            choices = this.generateChoices();
            this.fieldDictionary.setOptions(choices);
        }
        String selectedField = (String)this.fieldDictionary.getFieldValue();
        int btStart = currentContentStream.indexOf("BT");
        int btEnd = currentContentStream.lastIndexOf("ET");
        int bmcStart = currentContentStream.indexOf("BMC");
        int bmcEnd = currentContentStream.lastIndexOf("EMC");
        String preBmc = btStart >= 0 ? currentContentStream.substring(0, btStart + 2) : currentContentStream.substring(0, bmcStart + 3);
        String postEmc = btEnd >= 0 ? currentContentStream.substring(btEnd) : currentContentStream.substring(0, bmcEnd + 3);
        StringBuilder content = new StringBuilder();
        if (this.fieldDictionary.getDefaultAppearance() != null) {
            String markedContent = this.fieldDictionary.getDefaultAppearance();
            Page page = this.getPage();
            markedContent = this.fieldDictionary.generateDefaultAppearance(markedContent, page != null ? page.getResources() : null);
            content.append(markedContent).append(' ');
        } else {
            content.append("/Helv 12 Tf 0 g ");
        }
        content.append(4).append(' ').append(4).append(" Td ");
        content = this.encodeHexString(content, selectedField).append(" Tj ");
        currentContentStream = btStart >= 0 ? preBmc + "\n" + content + "\n" + postEmc : preBmc + " BT\n" + content + "\n ET EMC";
        return currentContentStream;
    }

    public String buildChoiceListContents(String currentContentStream) {
        ArrayList<ChoiceFieldDictionary.ChoiceOption> choices = this.fieldDictionary.getOptions();
        if (choices == null) {
            choices = this.generateChoices();
            this.fieldDictionary.setOptions(choices);
        }
        ArrayList<Integer> selections = this.fieldDictionary.getIndexes();
        int bmcStart = currentContentStream.indexOf("BMC") + 3;
        int bmcEnd = currentContentStream.indexOf("EMC");
        String preBmc = currentContentStream.substring(0, bmcStart);
        String postEmc = currentContentStream.substring(bmcEnd);
        String markedContent = currentContentStream.substring(bmcStart, bmcEnd);
        Rectangle2D.Float bounds = this.findBoundRectangle(markedContent);
        float[] selectionColor = this.findSelectionColour(markedContent);
        Rectangle2D.Float selectionRectangle = this.findSelectionRectangle(markedContent);
        float lineHeight = 13.87f;
        if (selectionRectangle != null) {
            lineHeight = selectionRectangle.height;
        }
        boolean isSelection = false;
        if (selections != null) {
            int max = choices.size();
            for (int i = 0; i < max; ++i) {
                for (int selection : selections) {
                    if (selection == i) {
                        choices.get(i).setIsSelected(true);
                        isSelection = true;
                        continue;
                    }
                    choices.get(i).setIsSelected(false);
                }
            }
        }
        int startIndex = 0;
        int endIndex = choices.size();
        if (selections != null && selections.size() == 1) {
            int numberLines = (int)Math.floor(bounds.height / lineHeight);
            int selectedIndex = selections.get(0);
            if (choices.size() >= numberLines) {
                if (selectedIndex < numberLines) {
                    endIndex = numberLines + 1;
                } else if (endIndex - selectedIndex <= numberLines) {
                    startIndex = endIndex - numberLines;
                } else {
                    startIndex = selectedIndex;
                    endIndex = numberLines + 1;
                }
            }
            if (startIndex > endIndex) {
                endIndex = startIndex + 1;
            }
        }
        StringBuilder content = new StringBuilder();
        content.append("q ").append(this.generateRectangle(bounds)).append("W n ");
        if (isSelection) {
            content.append(selectionColor[0]).append(' ').append(selectionColor[1]).append(' ').append(selectionColor[2]).append(" rg ");
            Rectangle2D.Float firstSelection = selectionRectangle == null ? new Rectangle2D.Float(bounds.x, bounds.y + bounds.height - lineHeight, bounds.width, lineHeight) : new Rectangle2D.Float(selectionRectangle.x, bounds.y + bounds.height - lineHeight, selectionRectangle.width, lineHeight);
            for (int i = startIndex; i < endIndex; ++i) {
                ChoiceFieldDictionary.ChoiceOption choice = choices.get(i);
                if (choice.isSelected() && selectionRectangle != null) {
                    content.append(this.generateRectangle(firstSelection)).append("f ");
                }
                firstSelection.y -= lineHeight;
            }
        }
        content.append("BT ");
        if (this.fieldDictionary.getDefaultAppearance() != null) {
            content.append(this.fieldDictionary.getDefaultAppearance());
        } else {
            content.append("/Helv 12 Tf 0 g ");
        }
        content.append(lineHeight).append(" TL ");
        content.append(4).append(' ').append(bounds.height + 4.0f).append(" Td ");
        for (int i = startIndex; i < endIndex; ++i) {
            ChoiceFieldDictionary.ChoiceOption choice = choices.get(i);
            if (choice.isSelected() && selectionRectangle != null) {
                content.append("1 g ");
            } else {
                content.append("0 g ");
            }
            content.append('(').append(choice.getLabel()).append(")' ");
        }
        content.append("ET Q");
        currentContentStream = preBmc + "\n" + content + "\n" + postEmc;
        return currentContentStream;
    }

    private float[] findSelectionColour(String markedContent) {
        int selectionEnd;
        int selectionStart = markedContent.indexOf("n") + 1;
        if (selectionStart < (selectionEnd = markedContent.lastIndexOf("rg")) && selectionEnd > 0) {
            String potentialNumbers = markedContent.substring(selectionStart, selectionEnd);
            StringTokenizer toker = new StringTokenizer(potentialNumbers);
            float[] points = new float[3];
            int i = 0;
            while (toker.hasMoreTokens()) {
                try {
                    float tmp;
                    points[i] = tmp = Float.parseFloat(toker.nextToken());
                    ++i;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                    break;
                }
            }
            if (i == 3) {
                return points;
            }
        }
        return new float[]{0.03922f, 0.14118f, 0.41569f};
    }
}

