/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.InteractiveForm;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWidgetAnnotation<T extends FieldDictionary>
extends Annotation {
    public static final Name HIGHLIGHT_NONE;
    protected static final Logger logger;
    protected static float highlightAlpha;
    protected static Color highlightColor;
    private boolean enableHighlightedWidget;
    protected Name highlightMode;

    public AbstractWidgetAnnotation(Library l, HashMap h) {
        super(l, h);
        Object possibleName = this.getObject(LinkAnnotation.HIGHLIGHT_MODE_KEY);
        if (possibleName instanceof Name) {
            Name name = (Name)possibleName;
            if (HIGHLIGHT_NONE.equals(name.getName())) {
                this.highlightMode = HIGHLIGHT_NONE;
            } else if (LinkAnnotation.HIGHLIGHT_OUTLINE.equals(name.getName())) {
                this.highlightMode = LinkAnnotation.HIGHLIGHT_OUTLINE;
            } else if (LinkAnnotation.HIGHLIGHT_PUSH.equals(name.getName())) {
                this.highlightMode = LinkAnnotation.HIGHLIGHT_PUSH;
            }
        } else {
            this.highlightMode = LinkAnnotation.HIGHLIGHT_INVERT;
        }
    }

    @Override
    public void init() throws InterruptedException {
        super.init();
        InteractiveForm interactiveForm = this.library.getCatalog().getInteractiveForm();
        if (interactiveForm != null && interactiveForm.needAppearances()) {
            this.resetAppearanceStream(new AffineTransform());
        }
    }

    public abstract void reset();

    @Override
    public abstract void resetAppearanceStream(double var1, double var3, AffineTransform var5);

    @Override
    protected void renderAppearanceStream(Graphics2D g) {
        AppearanceState appearanceState;
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        if (appearance != null && (appearanceState = appearance.getSelectedAppearanceState()) != null && appearanceState.getShapes() != null) {
            super.renderAppearanceStream(g);
        }
        if (this.enableHighlightedWidget) {
            AffineTransform preHighLightTransform = g.getTransform();
            g.setColor(highlightColor);
            g.setComposite(AlphaComposite.getInstance(3, highlightAlpha));
            g.fill(this.getBbox() != null ? this.getBbox() : this.getRectangle());
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.setTransform(preHighLightTransform);
        }
    }

    private Rectangle2D getRectangle() {
        Rectangle2D origRect = this.getBbox() != null ? this.getBbox() : this.getUserSpaceRectangle();
        Rectangle2D.Float jrect = new Rectangle2D.Float(0.0f, 0.0f, (float)origRect.getWidth(), (float)origRect.getHeight());
        return jrect;
    }

    public abstract T getFieldDictionary();

    protected Rectangle2D.Float findBoundRectangle(String markedContent) {
        String potentialNumbers;
        float[] points;
        int selectionEnd;
        int selectionStart = markedContent.indexOf("q") + 1;
        if (selectionStart < (selectionEnd = markedContent.indexOf("re")) && selectionEnd > 0 && (points = this.parseRectanglePoints(potentialNumbers = markedContent.substring(selectionStart, selectionEnd))) != null) {
            return new Rectangle2D.Float(points[0], points[1], points[2], points[3]);
        }
        Rectangle2D bbox = this.getBbox();
        return new Rectangle2D.Float(1.0f, 1.0f, (float)bbox.getWidth(), (float)bbox.getHeight());
    }

    protected Rectangle2D.Float findRectangle(String markedContent) {
        int selectionEnd = markedContent.indexOf("re");
        if (selectionEnd >= 0) {
            String potentialNumbers = markedContent.substring(0, selectionEnd);
            float[] points = this.parseRectanglePoints(potentialNumbers);
            if (points != null) {
                return new Rectangle2D.Float(points[0], points[1], points[2], points[3]);
            }
            Rectangle2D bbox = this.getBbox();
            return new Rectangle2D.Float(1.0f, 1.0f, (float)bbox.getWidth(), (float)bbox.getHeight());
        }
        return null;
    }

    protected double getLineHeight(String defaultAppearance) {
        if (defaultAppearance != null && this.checkAppearance(defaultAppearance)) {
            String sub = defaultAppearance.substring(0, defaultAppearance.indexOf("Tf"));
            StringTokenizer toker = new StringTokenizer(sub);
            while (toker.hasMoreTokens()) {
                Object obj = toker.nextElement();
                if (!(obj instanceof String)) continue;
                try {
                    double tmp = Double.parseDouble((String)obj);
                    if (!((tmp *= 1.15) > 0.0)) continue;
                    return tmp;
                }
                catch (NumberFormatException e) {
                }
            }
        }
        return 13.87;
    }

    protected double getFontSize(String content) {
        Pattern pattern;
        Matcher matcher;
        double size = 12.0;
        if (content != null && (matcher = (pattern = Pattern.compile("\\d+(\\.\\d+)?\\s+Tf")).matcher(content)).find()) {
            String fontDef = content.substring(matcher.start(), matcher.end());
            fontDef = fontDef.split(" ")[0];
            try {
                size = Double.parseDouble(fontDef);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (size < 2.0) {
                size = 12.0;
            }
        }
        return size;
    }

    protected StringBuilder encodeLiteralString(StringBuilder content, String contents) {
        String[] lines;
        for (String line : lines = contents.split("\n|\r|\f")) {
            content.append('(').append(line.replaceAll("(?=[()\\\\])", "\\\\").replaceAll("\u00c3\u00bf", "")).append(")' ");
        }
        return content;
    }

    protected StringBuilder encodeHexString(StringBuilder content, String contents) {
        String[] lines;
        for (String line : lines = contents.split("\n|\r|\f")) {
            char[] chars = line.toCharArray();
            StringBuffer hex = new StringBuffer();
            for (int i = 0; i < chars.length; ++i) {
                hex.append(Integer.toHexString(chars[i]));
            }
            content.append('<').append(hex).append(">' ");
        }
        return content;
    }

    protected boolean checkAppearance(String appearance) {
        StringTokenizer toker = new StringTokenizer(appearance);
        if (toker.hasMoreTokens()) {
            String fontName = toker.nextToken().substring(1);
            String fontSize = toker.nextToken();
            Appearance appearance1 = (Appearance)this.appearances.get(this.currentAppearance);
            AppearanceState appearanceState = appearance1.getSelectedAppearanceState();
            Font font = null;
            Resources resources = appearanceState.getResources();
            if (resources != null) {
                font = resources.getFont(new Name(fontName));
            }
            return font != null && this.library.getInteractiveFormFont(fontName) != null && !fontSize.equals("0");
        }
        return false;
    }

    protected Rectangle2D.Float findSelectionRectangle(String markedContent) {
        String potentialNumbers;
        float[] points;
        int selectionEnd;
        int selectionStart = markedContent.indexOf("rg") + 2;
        if (selectionStart < (selectionEnd = markedContent.lastIndexOf("re")) && selectionEnd > 0 && (points = this.parseRectanglePoints(potentialNumbers = markedContent.substring(selectionStart, selectionEnd))) != null) {
            return new Rectangle2D.Float(points[0], points[1], points[2], points[3]);
        }
        return null;
    }

    protected String generateRectangle(Rectangle2D.Float rect) {
        return rect.x + " " + rect.y + " " + rect.width + " " + rect.height + " re ";
    }

    protected float[] parseRectanglePoints(String potentialNumbers) {
        StringTokenizer toker = new StringTokenizer(potentialNumbers);
        float[] points = new float[4];
        int max = toker.countTokens();
        Object[] tokens = new Object[max];
        for (int i = 0; i < max; ++i) {
            tokens[i] = toker.nextElement();
        }
        boolean notFound = false;
        int i = 3;
        int j = 0;
        while (j < 4) {
            try {
                points[j] = Float.parseFloat((String)tokens[max - i - 1]);
            }
            catch (NumberFormatException e) {
                notFound = true;
            }
            ++j;
            --i;
        }
        if (!notFound) {
            return points;
        }
        return null;
    }

    public static void setHighlightColor(Color highlightColor) {
        AbstractWidgetAnnotation.highlightColor = highlightColor;
    }

    public void setEnableHighlightedWidget(boolean enableHighlightedWidget) {
        this.enableHighlightedWidget = enableHighlightedWidget;
    }

    public static void setHighlightAlpha(float highlightAlpha) {
        AbstractWidgetAnnotation.highlightAlpha = highlightAlpha;
    }

    public boolean isEnableHighlightedWidget() {
        return this.enableHighlightedWidget;
    }

    static {
        block5: {
            block4: {
                HIGHLIGHT_NONE = new Name("N");
                logger = Logger.getLogger(AbstractWidgetAnnotation.class.toString());
                highlightAlpha = 0.1f;
                try {
                    String color = Defs.sysProperty("org.icepdf.core.views.page.annotation.widget.highlight.color", "#CC00FF");
                    int colorValue = ColorUtil.convertColor(color);
                    highlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("0077FF", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading widget highlight colour.");
                }
            }
            try {
                highlightAlpha = (float)Defs.doubleProperty("org.icepdf.core.views.page.annotation.widget.highlight.alpha", 0.1f);
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading widget highlight alpha.");
            }
        }
    }
}

