/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.acroform.VariableTextFieldDictionary;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceFieldDictionary
extends VariableTextFieldDictionary {
    public static final Name OPT_KEY = new Name("Opt");
    public static final Name TI_KEY = new Name("TI");
    public static final Name I_KEY = new Name("I");
    public static final int COMBO_BIT_FLAG = 131072;
    public static final int EDIT_BIT_FLAG = 262144;
    public static final int SORT_BIT_FLAG = 524288;
    public static final int MULTI_SELECT_BIT_FLAG = 0x200000;
    public static final int CHOICE_DO_NOT_SPELL_CHECK_BIT_FLAG = 0x400000;
    public static final int COMMIT_ON_SEL_CHANGE_BIT_FLAG = 0x4000000;
    protected ChoiceFieldType choiceFieldType;
    protected ArrayList<ChoiceOption> options;
    protected int topIndex;
    protected ArrayList<Integer> indexes;

    public ChoiceFieldDictionary(Library library, HashMap entries) {
        super(library, entries);
        int flags;
        SecurityManager securityManager = library.getSecurityManager();
        Object value = library.getArray(entries, OPT_KEY);
        if (value == null) {
            FieldDictionary parent = this.getParent();
            value = library.getArray(parent.getEntries(), OPT_KEY);
        }
        if (value != null) {
            ArrayList opts = (ArrayList)value;
            this.options = new ArrayList(opts.size());
            for (Object opt : opts) {
                Object tmp;
                if (opt instanceof StringObject) {
                    tmp = (StringObject)opt;
                    String tmpString = tmp.getDecryptedLiteralString(securityManager);
                    this.options.add(new ChoiceOption(tmpString, tmpString));
                    continue;
                }
                if (!(opt instanceof List)) continue;
                tmp = (List)opt;
                StringObject tmp1StingObject = (StringObject)tmp.get(0);
                String tmpString1 = tmp1StingObject.getDecryptedLiteralString(securityManager);
                StringObject tmp2StingObject = (StringObject)tmp.get(1);
                String tmpString2 = tmp2StingObject.getDecryptedLiteralString(securityManager);
                this.options.add(new ChoiceOption(tmpString1, tmpString2));
            }
        } else {
            this.options = null;
        }
        this.choiceFieldType = ((flags = this.getFlags()) & 0x20000) == 131072 ? ((flags & 0x40000) == 262144 ? ChoiceFieldType.CHOICE_EDITABLE_COMBO : ChoiceFieldType.CHOICE_COMBO) : ((flags & 0x200000) == 0x200000 ? ChoiceFieldType.CHOICE_LIST_MULTIPLE_SELECT : ChoiceFieldType.CHOICE_LIST_SINGLE_SELECT);
        if (this.choiceFieldType == ChoiceFieldType.CHOICE_LIST_SINGLE_SELECT && (value = library.getObject(entries, TI_KEY)) instanceof Number) {
            this.topIndex = ((Number)value).intValue();
        }
        if ((value = library.getObject(entries, I_KEY)) instanceof ArrayList) {
            ArrayList tmp = (ArrayList)value;
            this.indexes = new ArrayList(tmp.size());
            for (Number aTmp : tmp) {
                this.indexes.add(aTmp.intValue());
            }
        }
        if (this.indexes == null && this.options != null) {
            this.indexes = new ArrayList(1);
            int j = 0;
            int max = this.options.size();
            for (int i = 0; i < max; ++i) {
                if (!this.options.get(i).getLabel().equals(value)) continue;
                this.indexes.set(j, i);
                ++j;
            }
        }
    }

    @Override
    public void setFieldValue(Object fieldValue, Reference parentReference) {
        Object tmp;
        String selectedValue = null;
        if (fieldValue instanceof String) {
            selectedValue = (String)fieldValue;
            super.setFieldValue(selectedValue, parentReference);
        } else if (fieldValue instanceof StringObject) {
            tmp = (StringObject)fieldValue;
            selectedValue = tmp.getDecryptedLiteralString(this.library.getSecurityManager());
            super.setFieldValue(selectedValue, parentReference);
        } else if (fieldValue instanceof ChoiceOption) {
            tmp = (ChoiceOption)fieldValue;
            selectedValue = ((ChoiceOption)tmp).getValue();
            super.setFieldValue(selectedValue, parentReference);
        }
        if (this.indexes != null) {
            this.indexes.clear();
        } else {
            this.indexes = new ArrayList();
        }
        int j = 0;
        int max = this.options.size();
        for (int i = 0; i < max; ++i) {
            if (!this.options.get(i).getLabel().equals(selectedValue)) continue;
            this.indexes.add(j, i);
        }
        this.indexes.trimToSize();
        this.entries.put(I_KEY, this.indexes);
    }

    public ChoiceOption buildChoiceOption(String label, String value) {
        return new ChoiceOption(label, value);
    }

    public ChoiceFieldType getChoiceFieldType() {
        return this.choiceFieldType;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public void setTopIndex(int topIndex) {
        this.topIndex = topIndex;
    }

    public ArrayList<Integer> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(ArrayList<Integer> indexes) {
        this.indexes = indexes;
    }

    public ArrayList<ChoiceOption> getOptions() {
        return this.options;
    }

    public void setOptions(ArrayList<ChoiceOption> options) {
        this.options = options;
    }

    public boolean isSortFields() {
        return (this.getFlags() & 0x80000) == 524288;
    }

    public boolean isMultiSelect() {
        return (this.getFlags() & 0x200000) == 0x200000;
    }

    public boolean isCommitOnSetChange() {
        return (this.getFlags() & 0x4000000) == 0x4000000;
    }

    public class ChoiceOption {
        private String label;
        private String value;
        private boolean isSelected;

        public ChoiceOption(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.label;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setIsSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChoiceFieldType {
        CHOICE_COMBO,
        CHOICE_EDITABLE_COMBO,
        CHOICE_LIST_SINGLE_SELECT,
        CHOICE_LIST_MULTIPLE_SELECT;

    }
}

