/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceInputStream
extends InputStream {
    private Iterator<InputStream> m_itInputStreams;
    private InputStream m_isCurrent;

    public SequenceInputStream(InputStream ... in) {
        this(Arrays.asList(in));
    }

    public SequenceInputStream(List<InputStream> inputStreams) {
        this(inputStreams, -1);
    }

    public SequenceInputStream(List<InputStream> inputStreams, int streamSwitchValue) {
        ArrayList<InputStream> in = new ArrayList<InputStream>();
        for (int i = 0; i < inputStreams.size(); ++i) {
            if (i > 0 && streamSwitchValue != -1) {
                in.add(new ByteArrayInputStream(new byte[]{(byte)streamSwitchValue}));
            }
            in.add(inputStreams.get(i));
        }
        this.m_itInputStreams = in.iterator();
        try {
            this.useNextInputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not use first InputStream in SequenceInputStream(List) : " + e);
        }
    }

    private InputStream getCurrentInputStream() {
        return this.m_isCurrent;
    }

    private void useNextInputStream() throws IOException {
        this.closeCurrentInputStream();
        this.m_isCurrent = null;
        while (this.m_itInputStreams.hasNext()) {
            InputStream in = this.m_itInputStreams.next();
            if (in == null) continue;
            this.m_isCurrent = in;
            break;
        }
    }

    private void closeCurrentInputStream() throws IOException {
        InputStream in = this.getCurrentInputStream();
        if (in != null) {
            in.close();
        }
    }

    @Override
    public int available() throws IOException {
        InputStream in = this.getCurrentInputStream();
        if (in != null) {
            return in.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        while (true) {
            int readByte;
            InputStream in;
            if ((in = this.getCurrentInputStream()) == null) {
                this.useNextInputStream();
                in = this.getCurrentInputStream();
                if (in == null) {
                    return -1;
                }
            }
            if ((readByte = in.read()) >= 0) {
                return readByte;
            }
            this.useNextInputStream();
        }
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off >= buffer.length || len < 0 || off + len > buffer.length || off + len < 0) {
            throw new IndexOutOfBoundsException("Offset: " + off + ", Length: " + len + ", Buffer length: " + buffer.length);
        }
        if (len == 0) {
            return 0;
        }
        int totalRead = 0;
        while (totalRead < len) {
            int currRead;
            InputStream in = this.getCurrentInputStream();
            if (in == null) {
                this.useNextInputStream();
                in = this.getCurrentInputStream();
                if (in == null) {
                    if (totalRead > 0) break;
                    return -1;
                }
            }
            if ((currRead = in.read(buffer, off + totalRead, len - totalRead)) > 0) {
                totalRead += currRead;
                continue;
            }
            this.useNextInputStream();
        }
        return totalRead;
    }

    @Override
    public void close() throws IOException {
        do {
            this.useNextInputStream();
        } while (this.getCurrentInputStream() != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(": ");
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        while (this.m_itInputStreams.hasNext()) {
            InputStream in = this.m_itInputStreams.next();
            sb.append("\n  ");
            sb.append(in.toString());
            sb.append(",");
            inputStreams.add(in);
        }
        this.m_itInputStreams = inputStreams.iterator();
        sb.append('\n');
        return sb.toString();
    }
}

