/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.sqladaj;

import br.gov.serpro.sqladaj.Connection;
import br.gov.serpro.sqladaj.SQLAda;
import br.gov.serpro.sqladaj.SQLAdaErrorEnum;
import br.gov.serpro.sqladaj.SQLAdaException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLAdaSocketImpl
implements SQLAda {
    Logger log = Logger.getLogger((String)SQLAdaSocketImpl.class.getName());
    protected Connection connection;
    private static final String charset = "ISO-8859-1";
    private static Set<String> instrucoesPermitidas = new HashSet<String>(10);
    private static final String tabComp = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int[] asciiToEbcdic;
    private static final int[] tbIda;
    private static final byte[] ssaeob;
    private String record;

    protected String encriptar(String mensagem) throws SQLAdaException {
        int i;
        StringBuilder resultado = new StringBuilder(240);
        StringBuilder codificado = new StringBuilder(111);
        if (mensagem == null || mensagem.length() <= 11) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "O tamanho da mensagem a ser encriptada deve ter maior que 11");
        }
        resultado.append(mensagem.substring(0, 11));
        for (i = 11; i < mensagem.length(); ++i) {
            char caracter = Character.toUpperCase(mensagem.charAt(i));
            if (caracter >= asciiToEbcdic.length) {
                throw new SQLAdaException(SQLAdaErrorEnum.SSA614, "Caracter " + mensagem.charAt(i) + " inv\u00e1lido. Somente caracteres ASCII s\u00e3o aceitos");
            }
            resultado.append(Integer.toHexString(asciiToEbcdic[caracter]));
        }
        codificado.setLength(111);
        for (i = 1; i < 111; ++i) {
            codificado.append(' ');
        }
        codificado.setCharAt(0, '0');
        i = 0;
        int j = i + 109;
        int s = 0;
        while (i < j) {
            codificado.setCharAt(tbIda[i], resultado.charAt(s));
            ++i;
            ++s;
        }
        codificado.insert(0, codificado.toString().toUpperCase(Locale.US));
        codificado.setLength(110);
        return codificado.toString();
    }

    protected String compactar(String comando) {
        int contadorBuffer = 0;
        int tamRepeticao = 1;
        int tamanhoBuffer = comando.length();
        StringBuilder buffer = new StringBuilder();
        buffer.setLength(tamanhoBuffer);
        for (int i = 0; i < comando.length(); ++i) {
            if (comando.charAt(i) == '@') {
                buffer.setCharAt(contadorBuffer, '@');
                buffer.setLength(++tamanhoBuffer);
                buffer.setCharAt(++contadorBuffer, '@');
                ++contadorBuffer;
                continue;
            }
            if (comando.charAt(i) == '\'' || comando.charAt(i) == '\"' || comando.charAt(i) == '>' || comando.charAt(i) == '<' || comando.charAt(i) == '(' || comando.charAt(i) == ')' || comando.charAt(i) == '=') {
                buffer.setCharAt(contadorBuffer, comando.charAt(i));
                ++contadorBuffer;
                continue;
            }
            if (i + 1 < comando.length() && comando.charAt(i) == comando.charAt(i + 1) && tamRepeticao < 36) {
                ++tamRepeticao;
                continue;
            }
            if (tamRepeticao > 3) {
                buffer.setCharAt(contadorBuffer, '@');
                buffer.setCharAt(++contadorBuffer, tabComp.charAt(tamRepeticao - 1));
                buffer.setCharAt(++contadorBuffer, comando.charAt(i));
                buffer.setLength(tamanhoBuffer -= tamRepeticao - 3);
                ++contadorBuffer;
                tamRepeticao = 1;
                continue;
            }
            int k = 0;
            while (k < tamRepeticao) {
                buffer.setCharAt(contadorBuffer, comando.charAt(i));
                ++k;
                ++contadorBuffer;
            }
            tamRepeticao = 1;
        }
        return buffer.toString();
    }

    protected void descompactar(StringBuilder sbRegistro) throws SQLAdaException {
        if (sbRegistro == null || sbRegistro.length() != this.getConnection().getTamanhoRegistro()) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "O registro em que o conte\u00fado descompactado ser\u00e1 guardado deve ter o mesmo tamanho do registro.");
        }
        if (this.getConnection().getReceivedArea() == null || this.getConnection().getReceivedArea().length() == 0) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "N\u00e3o existe conte\u00fado para ser descompactado.");
        }
        int posRegistro = this.getConnection().getInicioProximoRegistro() - 1;
        int tamanhoTotalRegistro = this.getConnection().getReceivedArea().length();
        for (int i = 0; i < this.getConnection().getTamanhoRegistro(); ++i) {
            if (++posRegistro >= tamanhoTotalRegistro) {
                throw new SQLAdaException(SQLAdaErrorEnum.SSA602, "Retorno do servidor SQLAda menor do que o esperado. N\u00e3o foi poss\u00edvel ler o registro.");
            }
            if (this.getConnection().getReceivedArea().charAt(posRegistro) == '@') {
                if (this.getConnection().getReceivedArea().charAt(posRegistro + 1) == '@') {
                    sbRegistro.setCharAt(i, '@');
                    ++posRegistro;
                    continue;
                }
                int tamcompr = 36 * tabComp.indexOf(this.getConnection().getReceivedArea().charAt(++posRegistro));
                tamcompr += tabComp.indexOf(this.getConnection().getReceivedArea().charAt(++posRegistro));
                char charRepeticao = this.getConnection().getReceivedArea().charAt(++posRegistro);
                for (int k = 0; k < tamcompr; ++k) {
                    sbRegistro.setCharAt(i + k, charRepeticao);
                }
                i = i + tamcompr - 1;
                continue;
            }
            sbRegistro.setCharAt(i, this.getConnection().getReceivedArea().charAt(posRegistro));
        }
        this.getConnection().setInicioProximoRegistro(posRegistro + 1);
    }

    protected void enviar(String comando) throws SQLAdaException {
        try {
            OutputStream output = this.getConnection().getSocket().getOutputStream();
            String sMsgOut = !comando.startsWith("ID ") ? comando + "SSAEOB" : comando;
            byte[] caracteres = sMsgOut.getBytes(charset);
            this.validarCaracteres(caracteres);
            output.write(caracteres);
            output.flush();
        }
        catch (IOException e) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA601, (Throwable)e);
        }
    }

    protected void validarCaracteres(byte[] caracteres) throws SQLAdaException {
        for (int i = 0; i < caracteres.length; ++i) {
            if (caracteres[i] >> 5 != 0) continue;
            throw new SQLAdaException(SQLAdaErrorEnum.SSA612, "O comando cont\u00e9m um caractere inv\u00e1lido. O valor hexadecimal do caractere \u00e9: " + Integer.toHexString(caracteres[i]) + ". A posi\u00e7\u00e3o do caractere no comando \u00e9: " + i + ".");
        }
    }

    protected String receber() throws SQLAdaException {
        String msgRecebida = null;
        byte[] buffer = new byte[this.getConnection().getTamanhoMaximoResposta()];
        byte[] bufferPart = new byte[this.getConnection().getTamanhoMaximoResposta()];
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(this.getConnection().getSocket().getInputStream(), this.getConnection().getTamanhoMaximoResposta());
            int quantidade = inputStream.read(bufferPart);
            if (quantidade == -1) {
                this.getConnection().reset();
                throw new SQLAdaException(SQLAdaErrorEnum.SSA608, "O servidor SQLAda retornou uma resposta vazia. O servidor SQLAda terminou a conex\u00e3o possivelmente devido a um timeout. A conex\u00e3o foi finalizada para voc\u00ea.");
            }
            int pos = 0;
            int total = 0;
            boolean finalMsg = true;
            while (quantidade > 0) {
                pos = total;
                System.arraycopy(bufferPart, 0, buffer, pos, quantidade);
                finalMsg = true;
                int i = 0;
                for (int j = (total += quantidade) - 6; j < total; ++j) {
                    if (ssaeob[i] != buffer[j]) {
                        finalMsg = false;
                        break;
                    }
                    ++i;
                }
                if (finalMsg) break;
                quantidade = inputStream.read(bufferPart);
            }
            if (!(msgRecebida = new String(buffer, 0, total, charset)).startsWith("SSA") || !msgRecebida.endsWith("SSAEOB")) {
                throw new SQLAdaException(SQLAdaErrorEnum.SSA608, "Formato da mensagem recebida do servidor SQLAda inv\u00e1lida(" + msgRecebida + ").");
            }
            return msgRecebida;
        }
        catch (IOException e) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA602, (Throwable)e);
        }
    }

    protected void atualizarTamanhoMemoria(String mensagem) {
        int pos = mensagem.indexOf(",ML=");
        if (pos != -1) {
            this.getConnection().setTamanhoMaximoResposta(Integer.parseInt(mensagem.substring(pos + 4, pos + 9)));
        }
    }

    protected void armazenarInfoServidor(String mensagem) throws SQLAdaException {
        StringBuilder infoServidor = new StringBuilder();
        if (mensagem == null || mensagem.length() == 0) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "A mensagem n\u00e3o pode ser nula nem vazia");
        }
        int pos = mensagem.indexOf(",SV=");
        if (pos > 0) {
            infoServidor.append("Versao " + mensagem.substring(pos + 4, pos + 9));
        } else {
            infoServidor.append("Versao 0.0.0");
        }
        pos = mensagem.indexOf(",OS=");
        if (pos > 0) {
            if (mensagem.substring(pos + 4, pos + 7).startsWith("MVS")) {
                if (mensagem.charAt(pos + 7) == 'E') {
                    infoServidor.append(", Sistema Operacional MVS-ESA");
                } else {
                    infoServidor.append(", Sistema Operacional MVS-XA");
                }
            } else {
                infoServidor.append(", Sistema Operacional ").append(mensagem.substring(pos + 4, pos + 8));
            }
        } else {
            infoServidor.append(", Sistema Operacional");
        }
        pos = mensagem.indexOf(",MR=");
        if (pos > 0) {
            infoServidor.append(", Monitor de Teleprocessamento ").append(mensagem.substring(pos += 4, pos + 4)).append(" ").append(mensagem.substring(pos + 4, pos + 9));
        } else {
            infoServidor.append(", Monitor de Teleprocessamento 0.0.0");
        }
        pos = mensagem.indexOf(",BD=");
        if (pos > 0) {
            infoServidor.append(", Adabas ").append(mensagem.substring(pos + 4, pos + 9));
        } else {
            infoServidor.append(", Adabas 0.0.0");
        }
        pos = mensagem.indexOf(",SK=");
        if (pos > 0) {
            if (mensagem.substring(pos + 4, pos + 7).startsWith("SNA")) {
                infoServidor.append(", Comunicacao SNA 0.0.0");
            } else if (mensagem.substring(pos + 4, pos + 7).startsWith("ILK")) {
                infoServidor.append(", Comunicacao TCP/IP INTERLINK ").append(mensagem.substring(pos + 8, pos + 13));
            } else {
                infoServidor.append(", Comunicacao TCP/IP IBM ").append(mensagem.substring(pos + 4, pos + 9));
            }
        } else {
            infoServidor.append(", Comunicacao 0.0.0");
        }
        this.getConnection().setServerInfo(infoServidor.toString());
    }

    protected void validarDadosUsuario(String usuario, String senha, String aplicacao) throws SQLAdaException {
        if (usuario == null || senha == null || aplicacao == null || usuario.length() > 11 || usuario.length() == 0 || senha.length() > 24 || senha.length() == 0 || aplicacao.length() > 25 || aplicacao.length() == 0) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA614);
        }
    }

    protected String validarComando(String comando) throws SQLAdaException {
        if (comando == null) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "O comando recebido n\u00e3o pode ser nulo.");
        }
        int pos = comando.indexOf(" ");
        String instrucao = pos == -1 ? comando : comando.substring(0, pos);
        if (!instrucoesPermitidas.contains(instrucao)) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA612, "Instru\u00e7\u00e3o do comando n\u00e3o permitida: " + instrucao);
        }
        return instrucao;
    }

    protected void validarRetorno(String mensagemRecebida, String retornoEsperado, int inicioRegiao, int tamanhoRecebido) throws SQLAdaException {
        if (!mensagemRecebida.regionMatches(inicioRegiao, retornoEsperado, 0, retornoEsperado.length())) {
            int returnCode;
            String msgErro = mensagemRecebida.substring(10, tamanhoRecebido - 6);
            try {
                returnCode = -Integer.parseInt(mensagemRecebida.substring(6, 10));
            }
            catch (NumberFormatException e) {
                throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "C\u00f3digo do retorno recebido do servidor SQLAda inv\u00e1lido.", e);
            }
            throw new SQLAdaException(SQLAdaErrorEnum.generateSSASERVER(returnCode, msgErro));
        }
    }

    protected void criarSocket(Connection conexao, int timeout) throws SQLAdaException {
        try {
            if (timeout <= 0) {
                throw new SQLAdaException(SQLAdaErrorEnum.SSA614, "Timeout do socket deve ser maior que zero.");
            }
            Socket socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(conexao.getHost(), conexao.getPortNumber());
            socket.setSoTimeout(timeout);
            socket.connect(inetSocketAddress, timeout);
            conexao.setSocket(socket);
        }
        catch (UnknownHostException e) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA604, (Throwable)e);
        }
        catch (IOException e) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA607, (Throwable)e);
        }
    }

    protected String criarMensagemConexao(String user, String password, String profile) throws SQLAdaException {
        StringBuilder commandID = new StringBuilder(63);
        for (int i = 1; i < 64; ++i) {
            commandID.append(' ');
        }
        commandID.insert(0, user);
        commandID.insert(11, password);
        commandID.insert(35, profile);
        return "ID \"" + this.encriptar(commandID.toString()) + "2.5\"";
    }

    public void connect(String user, String password, String profile, String host) throws SQLAdaException {
        this.connect(user, password, profile, host, 60000);
    }

    public void connect(String user, String password, String profile, String host, int timeout) throws SQLAdaException {
        if (this.getConnection() != null && this.getConnection().isActive()) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, "Conex\u00e3o ainda est\u00e1 ativa. Para criar uma nova, favor fechar e abrir novamente.");
        }
        try {
            if (this.getConnection() == null) {
                this.setConnection(new Connection());
            } else {
                this.getConnection().reset();
            }
            this.validarDadosUsuario(user, password, profile);
            this.getConnection().setHost(host);
            this.criarSocket(this.getConnection(), timeout);
            this.enviar("SQLT");
            this.receber();
            String comandoConexao = this.criarMensagemConexao(user, password, profile);
            this.enviar(comandoConexao);
            String msg = this.receber();
            int tamanhoRecebido = msg.length();
            this.validarRetorno(msg, "0000", 6, tamanhoRecebido);
            this.armazenarInfoServidor(msg);
            this.atualizarTamanhoMemoria(msg);
            this.setRecord(msg.substring(10, tamanhoRecebido - 6));
        }
        catch (Exception e) {
            try {
                this.disconnect();
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (e instanceof SQLAdaException) {
                throw (SQLAdaException)e;
            }
            throw new SQLAdaException(SQLAdaErrorEnum.SSA616, (Throwable)e);
        }
    }

    public int command(String comando) throws SQLAdaException {
        if (this.getConnection() == null || !this.getConnection().isActive()) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA613, "A conex\u00e3o n\u00e3o est\u00e1 ativa.");
        }
        this.setRecord("");
        String instrucao = this.validarComando(comando);
        this.getConnection().resetCommand();
        if (instrucao.equals("GETSET")) {
            if (comando.contains("CLIENTID")) {
                try {
                    this.setRecord(InetAddress.getLocalHost().getHostAddress());
                }
                catch (UnknownHostException e) {
                    throw new SQLAdaException(SQLAdaErrorEnum.SSA616, (Throwable)e);
                }
                return this.getRecord().length();
            }
            if (comando.contains("SERVERINFO")) {
                this.setRecord(this.getConnection().getServerInfo());
                return this.getRecord().length();
            }
        }
        if (instrucao.equals("SELECT") || instrucao.equals("INSERT") || instrucao.equals("UPDATE")) {
            comando = this.compactar(comando);
        }
        this.enviar(comando);
        String msg = this.receber();
        this.validarRetorno(msg, "0000", 6, msg.length());
        int rc = 0;
        if (instrucao.equals("SELECT")) {
            int fim = msg.indexOf(46);
            this.getConnection().setQuantidadeRegistros(Integer.parseInt(msg.substring(10, 18)));
            this.getConnection().setQuantidadeRegistrosRestantes(this.getConnection().getQuantidadeRegistros());
            rc = this.getConnection().getQuantidadeRegistros();
            this.getConnection().setTamanhoRegistro(Integer.parseInt(msg.substring(18, 23)));
            this.getConnection().setReceivedArea(msg.substring(18, fim));
            this.setRecord(this.getConnection().getReceivedArea());
            if (msg.regionMatches(fim + 1, "SSAEOB", 0, 6)) {
                this.getConnection().setFinalBlocoLido(true);
            } else {
                this.getConnection().setInicioProximoRegistro(fim + 1);
                this.getConnection().setFinalBlocoLido(false);
            }
        } else {
            this.setRecord(msg.substring(10, msg.length() - 6));
            if (instrucao.equals("EXEC") || instrucao.equals("GETSET")) {
                rc = msg.length() - 16;
            } else if (instrucao.equals("SET")) {
                this.atualizarTamanhoMemoria(msg);
            }
        }
        return rc;
    }

    public boolean hasNext() throws SQLAdaException {
        if (this.getConnection() == null || !this.getConnection().isActive()) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA613, "A conex\u00e3o n\u00e3o est\u00e1 ativa.");
        }
        String CmdCont = "CONT=001";
        String SeqAnt = "SSA001";
        this.setRecord("");
        if (this.getConnection().getQuantidadeRegistrosRestantes() == 0) {
            return false;
        }
        StringBuilder sbRegistro = new StringBuilder("");
        sbRegistro.setLength(this.getConnection().getTamanhoRegistro());
        if (this.getConnection().isFinalBlocoLido()) {
            this.enviar(CmdCont);
            String msg = this.receber();
            this.validarRetorno(msg, SeqAnt, 0, msg.length());
            this.getConnection().setInicioProximoRegistro(6);
            this.getConnection().setFinalBlocoLido(false);
            this.getConnection().setReceivedArea(msg);
        }
        this.descompactar(sbRegistro);
        this.setRecord(sbRegistro.toString());
        this.getConnection().setQuantidadeRegistrosRestantes(this.getConnection().getQuantidadeRegistrosRestantes() - 1);
        if (this.getConnection().getReceivedArea().regionMatches(this.getConnection().getInicioProximoRegistro(), "SSAEOB", 0, 6)) {
            this.getConnection().setFinalBlocoLido(true);
        }
        if (this.getConnection().getQuantidadeRegistrosRestantes() == 0 && !this.getConnection().isFinalBlocoLido()) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA602, "Mensagem n\u00e3o finalizada corretamente ap\u00f3s \u00faltimo registro.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws SQLAdaException {
        try {
            if (this.getConnection() != null && this.getConnection().isActive()) {
                this.enviar("FIM,SQLAda");
                String msg = this.receber();
                this.setRecord(msg.substring(10, msg.length() - 6));
            }
        }
        finally {
            if (this.getConnection() != null) {
                this.getConnection().reset();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.isActive()) {
            this.log.warn((Object)"ATEN\u00c7\u00c3O: Encontrada conex\u00e3o n\u00e3o finalizada corretamente. Verifique a aplica\u00e7\u00e3o! Tentando fechar...");
            try {
                this.disconnect();
                this.log.warn((Object)"ATEN\u00c7\u00c2O: Conex\u00e3o fechada pelo driver. Verifique a aplica\u00e7\u00e3o para o correto tratamento.");
            }
            catch (Exception e) {
                this.log.warn((Object)("ATEN\u00c7\u00c2O: Erro ao fechar a conex\u00e3o: " + e.getMessage() + "."));
            }
        }
        super.finalize();
    }

    public String getRecord() {
        return this.record;
    }

    protected void setRecord(String record) {
        this.record = record;
    }

    public boolean isActive() {
        return this.getConnection().isActive();
    }

    protected int getTamanhoRegistro() {
        return this.getConnection().getTamanhoRegistro();
    }

    protected void reset() {
        this.getConnection().reset();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    static {
        instrucoesPermitidas.add("COMMIT");
        instrucoesPermitidas.add("DELETE");
        instrucoesPermitidas.add("EXEC");
        instrucoesPermitidas.add("INSERT");
        instrucoesPermitidas.add("ROLLBACK");
        instrucoesPermitidas.add("SELECT");
        instrucoesPermitidas.add("UPDATE");
        instrucoesPermitidas.add("SET");
        instrucoesPermitidas.add("GETSET");
        asciiToEbcdic = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 122, 94, 76, 126, 110, 111, 124, 193, 194, 195, 196, 197, 198, 199, 200, 201, 209, 210, 211, 212, 213, 214, 215, 216, 217, 226, 227, 228, 229, 230, 231, 232, 233, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        tbIda = new int[]{1, 109, 36, 3, 38, 23, 58, 21, 76, 103, 29, 48, 11, 61, 4, 18, 88, 74, 83, 90, 104, 46, 91, 100, 49, 65, 72, 59, 78, 12, 44, 13, 73, 51, 53, 37, 94, 28, 19, 75, 17, 70, 67, 85, 50, 42, 41, 63, 30, 87, 32, 26, 45, 5, 107, 7, 8, 27, 106, 82, 96, 98, 80, 57, 14, 52, 95, 60, 55, 84, 25, 66, 68, 77, 79, 62, 89, 108, 31, 69, 15, 71, 102, 86, 47, 24, 33, 97, 92, 99, 35, 16, 10, 9, 56, 6, 39, 2, 22, 81, 93, 105, 64, 20, 101, 43, 40, 54, 34, 1, 109, 36, 3, 38, 23, 58, 21, 76, 103};
        ssaeob = new byte[]{83, 83, 65, 69, 79, 66};
    }
}

