/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.sqladaj;

import br.gov.serpro.sqladaj.SQLAdaErrorEnum;
import br.gov.serpro.sqladaj.SQLAdaException;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Connection {
    Logger log = Logger.getLogger((String)Connection.class.getName());
    public static final int INIT_MAX_RESP = 2001;
    public static final int DEFAULT_PORT_NUMBER = 3001;
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final String regexHOST_PORT = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]).)*(([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9-]*[A-Za-z0-9])(:[0-9]{1,5})?)$";
    private int portNumber;
    private String host;
    private int quantidadeRegistros;
    private int quantidadeRegistrosRestantes;
    private int tamanhoRegistro;
    private int tamanhoMaximoResposta;
    private Socket socket;
    private boolean finalBlocoLido;
    private int inicioProximoRegistro;
    private String receivedArea;
    private String serverInfo;
    private boolean active;

    public Connection() {
        this.reset();
    }

    public void reset() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.getSocket().close();
            }
            catch (IOException e) {
                this.log.error((Object)"Erro tentando fechar o socket", (Throwable)e);
            }
        }
        this.setSocket(null);
        this.setTamanhoMaximoResposta(2001);
        this.setActive(false);
        this.setPortNumber(3001);
        this.host = null;
        this.setReceivedArea(null);
        this.setServerInfo(null);
        this.resetCommand();
    }

    public void resetCommand() {
        this.setQuantidadeRegistros(0);
        this.setFinalBlocoLido(false);
        this.setTamanhoRegistro(0);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) throws SQLAdaException {
        if (host == null) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA604);
        }
        if (!host.matches(regexHOST_PORT)) {
            throw new SQLAdaException(SQLAdaErrorEnum.SSA604);
        }
        int pos = host.indexOf(58);
        if (pos > 0) {
            this.host = host.substring(0, pos);
            this.setPortNumber(Integer.parseInt(host.substring(pos + 1)));
        } else {
            this.host = host;
        }
    }

    public int getQuantidadeRegistros() {
        return this.quantidadeRegistros;
    }

    public void setQuantidadeRegistros(int quantidadeRegistros) {
        this.quantidadeRegistros = quantidadeRegistros;
    }

    public int getQuantidadeRegistrosRestantes() {
        return this.quantidadeRegistrosRestantes;
    }

    public void setQuantidadeRegistrosRestantes(int quantidadeRegistrosRestantes) {
        this.quantidadeRegistrosRestantes = quantidadeRegistrosRestantes;
    }

    public int getTamanhoRegistro() {
        return this.tamanhoRegistro;
    }

    public void setTamanhoRegistro(int tamanhoRegistro) {
        this.tamanhoRegistro = tamanhoRegistro;
    }

    public int getTamanhoMaximoResposta() {
        return this.tamanhoMaximoResposta;
    }

    public void setTamanhoMaximoResposta(int tamanhoMaximoResposta) {
        this.tamanhoMaximoResposta = tamanhoMaximoResposta;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.setActive(true);
    }

    public boolean isFinalBlocoLido() {
        return this.finalBlocoLido;
    }

    public void setFinalBlocoLido(boolean finalBlocoLido) {
        this.finalBlocoLido = finalBlocoLido;
    }

    public int getInicioProximoRegistro() {
        return this.inicioProximoRegistro;
    }

    public void setInicioProximoRegistro(int inicioProximoRegistro) {
        this.inicioProximoRegistro = inicioProximoRegistro;
    }

    public String getReceivedArea() {
        return this.receivedArea;
    }

    public void setReceivedArea(String receivedArea) {
        this.receivedArea = receivedArea;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

