/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util.tabs;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.util.tabs.ButtonTabComponent;

public class JTaskTabs
extends JPanel
implements ChangeListener {
    private ArrayList<DadosAba> listAbas;
    private JPanel contentPane;
    private boolean changeListenerDesabilitado;
    private final String SEM_TITULO = "Sem T\u00edtulo";
    public static final String TITULO_ABA_DASHBOARD = "In\u00edcio";
    private JTabbedPane tabbedPane;

    public JTaskTabs() {
        this.initComponents();
        this.tabbedPane.addChangeListener(this);
        this.listAbas = new ArrayList();
        this.setChangeListenerDesabilitado(true);
        this.criaNovaAba("Sem T\u00edtulo", null);
        this.atualizaVisibilidade();
        this.setChangeListenerDesabilitado(false);
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(JPanel contentPane) {
        this.setChangeListenerDesabilitado(true);
        this.tabbedPane.removeAll();
        this.criaNovaAba("Sem T\u00edtulo", null);
        this.contentPane = contentPane;
        this.atualizaVisibilidade();
        this.setChangeListenerDesabilitado(false);
    }

    public boolean changeListenerDesabilitado() {
        return this.changeListenerDesabilitado;
    }

    public void setChangeListenerDesabilitado(boolean desabilitaChangeListener) {
        this.changeListenerDesabilitado = desabilitaChangeListener;
    }

    public int indexDaAba(String tituloNovaAba) {
        int index = -1;
        for (int i = 0; i < this.listAbas.size(); ++i) {
            DadosAba aba = this.listAbas.get(i);
            if (!aba.titulo.equals(tituloNovaAba)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void atualizaAbas(JTaskAction taskAction, boolean novaAba) {
        this.setFicha(taskAction.getName(), taskAction, novaAba);
    }

    public void setFicha(String tituloNovaAba, JTaskAction actionNovaAba, boolean novaAba) {
        DadosAba fichaAtual = this.getFicha();
        if (fichaAtual.titulo.equals(tituloNovaAba)) {
            return;
        }
        this.setChangeListenerDesabilitado(true);
        int index = this.indexDaAba(tituloNovaAba);
        if (index > -1) {
            this.tabbedPane.setSelectedIndex(index);
        } else {
            boolean exibindoSomenteDashboard;
            boolean bl = exibindoSomenteDashboard = this.listAbas.size() == 1 && this.listAbas.get((int)0).titulo.equals(TITULO_ABA_DASHBOARD);
            if (novaAba || exibindoSomenteDashboard) {
                this.criaNovaAba(tituloNovaAba, actionNovaAba);
            } else {
                if (this.listAbas.get((int)0).titulo.equals(TITULO_ABA_DASHBOARD)) {
                    this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
                }
                this.atualizaAbaAtiva(tituloNovaAba, actionNovaAba);
            }
        }
        this.setChangeListenerDesabilitado(false);
    }

    public DadosAba getFicha() {
        int indexAbaAtiva = this.tabbedPane.getSelectedIndex();
        return this.listAbas.get(indexAbaAtiva);
    }

    private void atualizaAbaAtiva(String tituloNovaAba, JTaskAction actionNovaAba) {
        int indexAbaAtiva = this.tabbedPane.getSelectedIndex();
        this.listAbas.set(indexAbaAtiva, new DadosAba(tituloNovaAba, actionNovaAba));
        this.tabbedPane.setTitleAt(indexAbaAtiva, tituloNovaAba);
        if (this.tabbedPane.getTabCount() > 1) {
            this.tabbedPane.updateUI();
        }
    }

    private void criaNovaAba(String tituloNovaAba, JTaskAction actionNovaAba) {
        boolean abaFixa = actionNovaAba != null ? actionNovaAba.isAbaFixa() : true;
        this.tabbedPane.updateUI();
        this.listAbas.add(new DadosAba(tituloNovaAba, actionNovaAba));
        this.tabbedPane.addTab(tituloNovaAba, null);
        this.tabbedPane.setTabComponentAt(this.tabbedPane.getTabCount() - 1, new ButtonTabComponent(this, abaFixa));
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        this.atualizaVisibilidade();
    }

    public void removeAbas() {
        this.setChangeListenerDesabilitado(true);
        while (this.getTabbedPane().getTabCount() > 1) {
            this.removeAba(this.getTabbedPane().getTabCount() - 1);
        }
        this.setChangeListenerDesabilitado(false);
    }

    public void removeAba(int i) {
        this.listAbas.remove(i);
        this.getTabbedPane().remove(i);
        this.atualizaVisibilidade();
    }

    private void atualizaVisibilidade() {
        this.tabbedPane.setVisible(this.tabbedPane.getTabCount() > 1);
        this.tabbedPane.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changeListenerDesabilitado()) {
            int sel = this.tabbedPane.getSelectedIndex();
            DadosAba aba = this.listAbas.get(sel);
            if (aba.action != null) {
                aba.action.doClick(false);
            }
        }
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -2, 35, -2));
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void atualizarTituloAbaAtiva(String novoTitulo) {
        int indexAbaAtiva = this.tabbedPane.getSelectedIndex();
        this.tabbedPane.setTitleAt(indexAbaAtiva, novoTitulo);
        this.tabbedPane.repaint();
        this.tabbedPane.updateUI();
    }

    class DadosAba {
        private String titulo;
        private JTaskAction action;
        private boolean abaFixa = false;

        public DadosAba(String titulo, JTaskAction action) {
            this.titulo = titulo;
            this.action = action;
        }

        public DadosAba(String titulo, JTaskAction action, boolean aAbaFixa) {
            this.titulo = titulo;
            this.action = action;
            this.abaFixa = aAbaFixa;
        }
    }
}

