/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.pendencias;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.pendencia.LinhaPendencia;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.PainelAbaAb;
import serpro.ppgd.irpf.gui.PainelComAbasAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosLista;
import serpro.ppgd.irpf.gui.bens.PainelBensLista;
import serpro.ppgd.irpf.gui.componente.DashedBorder;
import serpro.ppgd.irpf.gui.gcap.bensimoveis.PainelListaBemImovel;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.rendIsentos.PainelAbaRendIsentosLista;
import serpro.ppgd.irpf.gui.rendIsentos.PainelDadosRendIsentos;
import serpro.ppgd.irpf.gui.rendIsentos.TableModelRendIsentos;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelAbaRendTributExclusivaLista;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.PainelDadosRendTributExclusiva;
import serpro.ppgd.irpf.gui.rendTributacaoExclusiva.TableModelRendTributExclusiva;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaLancamentosEscrituracaoDependentes;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaLancamentosEscrituracaoTitular;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosDependentesLista;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoMensalDependentes;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoTitular;
import serpro.ppgd.irpf.gui.rendpf.TableModelRendPFDependentes;
import serpro.ppgd.irpf.gui.resumo.PainelCalculoImposto;
import serpro.ppgd.irpf.gui.resumo.SubPainelParcelamentoInfoBancarias;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.UtilitariosString;

public class PainelPendencias
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Verificar Avisos e Erros";
    public static final int RETORNO_FECHAR = 1;
    private ImageIcon imagemTitulo;
    private int totalErros = 0;
    private int totalAvisos = 0;
    private int retorno = 1;
    private List<Pendencia> listaPendencias;
    private Action pendenciasComAcessibilidadeAction;
    private JTextField edtTotalAvisos;
    private JTextField edtTotalErros;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList<LinhaPendencia> jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JLabel lblTotalAvisos;
    private JLabel lblTotalErros;

    public PainelPendencias(List<Pendencia> listaPendencias) {
        this.initComponents();
        this.listaPendencias = listaPendencias;
        this.jList1.setCellRenderer(new PendenciasCellRenderer());
        this.jList1.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                int index = PainelPendencias.this.jList1.locationToIndex(p);
                if (index != ((PendenciasCellRenderer)PainelPendencias.this.jList1.getCellRenderer()).getItemSublinhado()) {
                    ((PendenciasCellRenderer)PainelPendencias.this.jList1.getCellRenderer()).setItemSublinhado(index);
                    PainelPendencias.this.jList1.repaint();
                }
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point p = new Point(me.getX(), me.getY());
                int index = PainelPendencias.this.jList1.locationToIndex(p);
                Pendencia pendencia = PainelPendencias.this.jList1.getModel().getElementAt(index).getPendencia();
                if (pendencia != null) {
                    PainelPendencias.this.selecionaPendencia(pendencia);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((PendenciasCellRenderer)PainelPendencias.this.jList1.getCellRenderer()).setItemSublinhado(-1);
                PainelPendencias.this.jList1.repaint();
            }
        });
        this.jList1.getActionMap().remove(this.jList1.getInputMap(0).get(KeyStroke.getKeyStroke("SPACE")));
        this.jList1.getInputMap(0).put(KeyStroke.getKeyStroke("SPACE"), "selecionaPendencia");
        this.jList1.getActionMap().put("selecionaPendencia", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Pendencia pendencia;
                int index = PainelPendencias.this.jList1.getSelectedIndex();
                if (index >= 0 && (pendencia = PainelPendencias.this.jList1.getModel().getElementAt(index).getPendencia()) != null) {
                    PainelPendencias.this.selecionaPendencia(pendencia);
                }
            }
        });
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.imagemTitulo = GuiUtil.getImage("/icones/png40px/DE_verificar_pendencias.png");
    }

    public void bindKeys(JComponent c) {
        InputMap inputMap = c.getInputMap(2);
        ActionMap actionMap = c.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(123, 0), "pendenciasComAcessibilidadeAction");
        actionMap.put("pendenciasComAcessibilidadeAction", this.pendenciasComAcessibilidadeAction);
    }

    protected String getTotalErros() {
        return "" + this.totalErros;
    }

    public int getQtdTotalErros() {
        return this.totalErros;
    }

    protected String getTotalAvisos() {
        return "" + this.totalAvisos;
    }

    public int getQtdTotalAvisos() {
        return this.totalAvisos;
    }

    public void selecionaPendencia(Pendencia pPendencia) {
        if (pPendencia != null) {
            JEditCampo edit;
            DeclaracaoIRPF dec = IRPFFacade.getInstancia().getDeclaracao();
            String ficha = pPendencia.getCampoInformacao().getFicha();
            if (dec != null) {
                String classe = pPendencia.getClassePainel();
                if (classe != null) {
                    this.selecionarNodoArvore(classe, pPendencia);
                } else {
                    System.err.println("Aten\u00e7\u00e3o: n\u00e3o \u00e9 poss\u00edvel selecionar a pend\u00eancia porque classe est\u00e1 null. O ObjetoNegocio precisa implementar ObjetoFicha.");
                }
            }
            if ((edit = (JEditCampo)MapeamentoInformacaoEditCampo.getEditAssociado((Informacao)pPendencia.getCampoInformacao())) != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        edit.aplicaFocoPendencia();
                    }
                });
            }
        }
        IRPFUtil.setEstadoSistema((int)0);
    }

    protected void selecionarNodoArvore(String classePainerlFicha, Pendencia pendencia) {
        PainelDemonstrativoIf panel;
        IRPFUtil.setEstadoSistema((int)1);
        ControladorGui.getJanelaPrincipal().getTaskActionDoPainel(classePainerlFicha).doClick(true);
        String aba = pendencia.getNomeAba();
        if (aba == null) {
            aba = pendencia.getCampoInformacao().getAba();
        }
        if (aba != null) {
            PainelDemonstrativoIf panel2;
            String[] abas = aba.split(";");
            String nomeAba = abas[0];
            String nomeSubAba = null;
            if (abas.length > 1) {
                nomeSubAba = abas[1];
            }
            if ((panel2 = ControladorGui.getPainelAtualmenteExibido()) instanceof PainelComAbasAb) {
                ((PainelComAbasAb)panel2).acionarAba(nomeAba, true);
                if (pendencia.getNumItem() > -1 && !pendencia.getClassePainel().equals(PainelDadosEscrituracao.class.getName())) {
                    if (((PainelComAbasAb)panel2).getTabbedPane().getSelectedComponent() instanceof PainelListaAb) {
                        if (panel2 instanceof PainelDadosRendIsentos && pendencia.getCampoInformacao().getOwner() instanceof ItemQuadroAuxiliarAb) {
                            IRPFTableAb tabela = ((PainelAbaRendIsentosLista)((PainelDadosRendIsentos)panel2).getAbas()[0]).getTabela();
                            TableModelRendIsentos model = (TableModelRendIsentos)tabela.getModel();
                            ItemQuadroAuxiliarAb item = (ItemQuadroAuxiliarAb)pendencia.getCampoInformacao().getOwner();
                            int indiceModel = model.obterPosicaoCorretaPendencia(item);
                            int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
                            tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
                            ((PainelListaAb)((PainelComAbasAb)panel2).getTabbedPane().getSelectedComponent()).onBtnAbrirClick(null);
                        } else if (panel2 instanceof PainelDadosRendTributExclusiva && pendencia.getCampoInformacao().getOwner() instanceof ItemQuadroAuxiliarAb) {
                            IRPFTableAb tabela = ((PainelAbaRendTributExclusivaLista)((PainelDadosRendTributExclusiva)panel2).getAbas()[0]).getTabela();
                            TableModelRendTributExclusiva model = (TableModelRendTributExclusiva)tabela.getModel();
                            ItemQuadroAuxiliarAb item = (ItemQuadroAuxiliarAb)pendencia.getCampoInformacao().getOwner();
                            int indiceModel = model.obterPosicaoCorretaPendencia(item);
                            int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
                            tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
                            ((PainelListaAb)((PainelComAbasAb)panel2).getTabbedPane().getSelectedComponent()).onBtnAbrirClick(null);
                        } else {
                            this.tratarTelaLista(pendencia, (PainelListaAb)((PainelComAbasAb)panel2).getTabbedPane().getSelectedComponent());
                            panel2 = ControladorGui.getPainelAtualmenteExibido();
                            if (panel2 instanceof PainelDemonstrativoAb && ((PainelDemonstrativoAb)panel2).getTabbedPane() != null && nomeSubAba != null) {
                                ((PainelDemonstrativoAb)panel2).acionarAba(nomeSubAba, true);
                            }
                        }
                    }
                } else if (pendencia.getCampoInformacao().getFicha().startsWith("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade")) {
                    int comeco = pendencia.getCampoInformacao().getFicha().lastIndexOf(" ") + 1;
                    String mes = pendencia.getCampoInformacao().getFicha().substring(comeco, pendencia.getCampoInformacao().getFicha().length());
                    mes = mes.substring(0, 3).toUpperCase();
                    ((PainelDemonstrativoIf)((Object)panel2.getAbas()[panel2.getTabbedPane().getSelectedIndex()])).acionarAba(mes, true);
                } else if (pendencia.getClassePainel().equals(PainelDadosEscrituracao.class.getName())) {
                    if (pendencia.getCampoInformacao().getOwner() instanceof RendPF || pendencia.getCampoInformacao().getOwner() instanceof MesRendPF) {
                        if (pendencia.getNumItem() == -1) {
                            panel2.acionarAba("Titular", true);
                            PainelDadosEscrituracaoTitular paineldadosTitular = (PainelDadosEscrituracaoTitular)panel2.getAbas()[0];
                            paineldadosTitular.acionarAba("Outras Informa\u00e7\u00f5es", true);
                        } else {
                            panel2.acionarAba("Dependentes", true);
                            PainelDadosDependentesLista paineldadosDependente = (PainelDadosDependentesLista)panel2.getAbas()[1];
                            this.tratarTelaLista(pendencia, (PainelDemonstrativoIf)paineldadosDependente);
                            PainelAbaEscrituracaoDependente panelDependente = (PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido();
                            panelDependente.getPainelDadosEscrituracaoDependente().acionarAba("Outras Informa\u00e7\u00f5es", true);
                        }
                    } else if (pendencia.getCampoInformacao().getOwner() instanceof ItemRendPFDependente) {
                        panel2.acionarAba("Dependentes", true);
                        PainelDadosDependentesLista paineldadosDependente = (PainelDadosDependentesLista)panel2.getAbas()[1];
                        this.tratarTelaLista(pendencia, (PainelDemonstrativoIf)paineldadosDependente);
                        PainelAbaEscrituracaoDependente panelDependente = (PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido();
                        panelDependente.getPainelDadosEscrituracaoDependente().acionarAba("Outras Informa\u00e7\u00f5es", false);
                    } else if (pendencia.getCampoInformacao().getOwner() instanceof Conta) {
                        Conta conta = (Conta)pendencia.getCampoInformacao().getOwner();
                        int indiceMes = Integer.valueOf(conta.getDataMesAno().naoFormatado().substring(0, 2));
                        String siglaMes = ContasMes.obterSiglaMes((int)indiceMes);
                        if (conta.getCpfContribuinte().naoFormatado().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado())) {
                            PainelDemonstrativoIf paineldadosTitular = (PainelDemonstrativoIf)((Object)panel2.getAbas()[0]);
                            PainelDemonstrativoIf painelTitular = (PainelDemonstrativoIf)((Object)paineldadosTitular.getAbas()[0]);
                            painelTitular.acionarAba(siglaMes, true);
                            PainelAbaLancamentosEscrituracaoTitular painelAbaMesSelecionado = (PainelAbaLancamentosEscrituracaoTitular)painelTitular.getAbas()[indiceMes - 1];
                            this.selecionarLinhaPainelComAbas(pendencia, (PainelAbaAb)painelAbaMesSelecionado);
                        } else {
                            panel2.acionarAba("Dependentes", true);
                            PainelDadosDependentesLista painelDependente = (PainelDadosDependentesLista)panel2.getAbas()[1];
                            TableModelRendPFDependentes lModel = (TableModelRendPFDependentes)painelDependente.getTabela().getModel();
                            int nLinha = 0;
                            int indiceVetor = 0;
                            boolean achouDependente = false;
                            int i = 0;
                            while (i < lModel.getRowCount()) {
                                nLinha = i++;
                                indiceVetor = ((TableRowSorter)painelDependente.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
                                ColecaoRendPFDependente colecao = (ColecaoRendPFDependente)lModel.getObjetoNegocio();
                                ItemRendPFDependente rendPf = (ItemRendPFDependente)colecao.itens().get(indiceVetor);
                                if (!rendPf.getCpf().naoFormatado().equals(conta.getCpfContribuinte().naoFormatado())) continue;
                                achouDependente = true;
                                break;
                            }
                            if (achouDependente) {
                                painelDependente.getTabela().selecionaCelula(0, nLinha);
                                painelDependente.onBtnAbrirClick(null);
                                PainelDadosEscrituracaoDependente painelDadosEscrituracaoDependente = ((PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido()).getPainelDadosEscrituracaoDependente();
                                PainelDadosEscrituracaoMensalDependentes painelMesesDependente = (PainelDadosEscrituracaoMensalDependentes)painelDadosEscrituracaoDependente.getAbas()[0];
                                painelMesesDependente.acionarAba(siglaMes, false);
                                PainelAbaLancamentosEscrituracaoDependentes painelAbaMesLancamento = (PainelAbaLancamentosEscrituracaoDependentes)painelMesesDependente.getAbas()[indiceMes - 1];
                                IRPFTableAb tabela = painelAbaMesLancamento.getTabela();
                                int indiceModel = pendencia.getNumItem() - 1;
                                int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
                                tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
                                painelAbaMesLancamento.onBtnAbrirClick(null);
                            }
                        }
                    }
                }
            } else if (panel2 instanceof PainelCalculoImposto) {
                JComponent componente = ((PainelCalculoImposto)panel2).getFlipParcelamentoInfoBancarias().getAtivo();
                if (componente instanceof SubPainelParcelamentoInfoBancarias) {
                    ((PainelComAbasAb)componente).acionarAba(nomeAba, true);
                }
            } else if ((panel2 instanceof PainelListaAb || panel2 instanceof PainelAlimentandosLista || panel2 instanceof PainelBensLista) && pendencia.getNumItem() > -1) {
                this.tratarTelaLista(pendencia, panel2);
                panel2 = ControladorGui.getPainelAtualmenteExibido();
                if (panel2 instanceof PainelDemonstrativoAb) {
                    ((PainelDemonstrativoAb)panel2).acionarAba(nomeAba, true);
                }
            } else if (panel2 instanceof PainelDemonstrativoAb) {
                ((PainelDemonstrativoAb)panel2).acionarAba(nomeAba, true);
            }
        } else if (pendencia.getNumItem() > -1 && ((panel = ControladorGui.getPainelAtualmenteExibido()) instanceof PainelListaAb || panel instanceof PainelBensLista || panel instanceof PainelAlimentandosLista) && !(panel instanceof PainelListaBemImovel)) {
            this.tratarTelaLista(pendencia, panel);
        }
    }

    private void tratarTelaLista(Pendencia pendencia, PainelDemonstrativoIf panel) {
        IRPFTableAb tabela = ((PainelPrincipalAb)panel).getTabela();
        int indiceModel = pendencia.getNumItem() - 1;
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        ((PainelPrincipalAb)panel).onBtnAbrirClick(null);
    }

    private void selecionarLinhaPainelComAbas(Pendencia pendencia, PainelAbaAb panel) {
        IRPFTableAb tabela = panel.getTabela();
        int indiceModel = pendencia.getNumItem() - 1;
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(indiceModel);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        ((ToolBarListener)((Object)panel)).onBtnAbrirClick(null);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblTotalErros = new JLabel();
        this.edtTotalErros = new JTextField();
        this.jPanel3 = new JPanel();
        this.lblTotalAvisos = new JLabel();
        this.edtTotalAvisos = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.jPanel2.setLayout(new GridLayout(1, 0));
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setForeground(new Color(0, 74, 106));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/erro.png")));
        this.jLabel4.setText(" Impede a grava\u00e7\u00e3o da declara\u00e7\u00e3o para entrega \u00e0 RFB.");
        this.jPanel2.add(this.jLabel4);
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setForeground(new Color(0, 74, 106));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png14px/atencao.png")));
        this.jLabel5.setText(" N\u00e3o impede a grava\u00e7\u00e3o da declara\u00e7\u00e3o para entrega \u00e0 RFB.");
        this.jPanel2.add(this.jLabel5);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(204, 204, 255)), BorderFactory.createEmptyBorder(1, 10, 1, 1)));
        this.jPanel1.setPreferredSize(new Dimension(636, 35));
        this.jPanel1.setLayout(new FlowLayout(0));
        this.lblTotalErros.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTotalErros.setForeground(new Color(0, 74, 106));
        this.lblTotalErros.setText("Total de Erros ");
        this.jPanel1.add(this.lblTotalErros);
        this.edtTotalErros.setEditable(false);
        this.edtTotalErros.setHorizontalAlignment(0);
        this.edtTotalErros.setEnabled(false);
        this.edtTotalErros.setPreferredSize(new Dimension(45, 23));
        this.jPanel1.add(this.edtTotalErros);
        this.jPanel3.setMinimumSize(new Dimension(5, 100));
        this.jPanel3.setOpaque(false);
        this.jPanel3.setPreferredSize(new Dimension(40, 4));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 40, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.jPanel1.add(this.jPanel3);
        this.lblTotalAvisos.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTotalAvisos.setForeground(new Color(0, 74, 106));
        this.lblTotalAvisos.setText("Total de Avisos");
        this.jPanel1.add(this.lblTotalAvisos);
        this.edtTotalAvisos.setEditable(false);
        this.edtTotalAvisos.setHorizontalAlignment(0);
        this.edtTotalAvisos.setEnabled(false);
        this.edtTotalAvisos.setPreferredSize(new Dimension(45, 23));
        this.jPanel1.add(this.edtTotalAvisos);
        this.jPanel4.add((Component)this.jPanel1, "South");
        this.jList1.setModel(new PendenciasListModel());
        this.jList1.setSelectionMode(0);
        this.jList1.setCursor(new Cursor(12));
        this.jScrollPane2.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleName("Avisos e Erros");
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, 730, Short.MAX_VALUE).add((Component)this.jPanel4, -1, 730, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -1, 395, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    public int getRetorno() {
        return this.retorno;
    }

    @Override
    public String getTituloPainel() {
        return "Avisos e Erros de Preenchimento";
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return this.imagemTitulo;
    }

    @Override
    public void preExibir() {
        PendenciasListModel model = (PendenciasListModel)this.jList1.getModel();
        model.atualizarListaPendencias(this.getListaPendencias());
        this.edtTotalErros.setText(this.getTotalErros());
        this.edtTotalAvisos.setText(this.getTotalAvisos());
        this.jList1.getAccessibleContext().setAccessibleDescription(this.obterDescricaoAcessivelListaPendencias());
    }

    public String obterDescricaoAcessivelListaPendencias() {
        return "Total de avisos: \"" + this.getTotalAvisos() + "\". Total de Erros: \"" + this.getTotalErros() + "\".";
    }

    @Override
    public String getMensagemTela() {
        return "<html>Para corrigir erro ou aviso, clique na respectiva descri\u00e7\u00e3o. O programa mostrar\u00e1 o campo a ser corrigido.</html>";
    }

    @Override
    public boolean isTelaComMensagem() {
        return true;
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    @Override
    public boolean isTelaComFavoritos() {
        return false;
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.jList1;
    }

    public List<Pendencia> getListaPendencias() {
        return this.listaPendencias;
    }

    public List<LinhaPendencia> montaTableListaPendencia(List<Pendencia> lstPendencia) {
        this.totalErros = 0;
        this.totalAvisos = 0;
        ArrayList<LinhaPendencia> listaPendencia = new ArrayList<LinhaPendencia>(lstPendencia.size());
        int contaLinhasTitulo = 0;
        String tituloFichaAnterior = "";
        Object item = "";
        Object itemPendente = "";
        for (int i = 0; i < lstPendencia.size(); ++i) {
            if (lstPendencia.get(i) == null) continue;
            Pendencia pendencia = lstPendencia.get(i);
            String tituloFichaAtual = pendencia.getCampoInformacao() != null ? pendencia.getCampoInformacao().getFicha() : pendencia.getColecao().getFicha();
            byte severidade = pendencia.getSeveridade();
            if (!tituloFichaAtual.equals(tituloFichaAnterior)) {
                if (severidade == 2 || severidade == 3 || severidade == 5) {
                    listaPendencia.add(new LinhaPendencia(0, tituloFichaAtual, null));
                }
                tituloFichaAnterior = tituloFichaAtual;
                ++contaLinhasTitulo;
            }
            if (i != 0 && !tituloFichaAtual.equals(tituloFichaAnterior) || i > 0 && pendencia.getCampoInformacao() == lstPendencia.get(i - 1).getCampoInformacao() && pendencia.getSeveridade() == lstPendencia.get(i - 1).getSeveridade() && pendencia.getNumItem() == lstPendencia.get(i - 1).getNumItem()) continue;
            item = "";
            if (pendencia.getNumItem() >= 1) {
                item = " - Item n\u00ba " + pendencia.getNumItem();
            }
            if (((String)item).equals("")) {
                itemPendente = pendencia.getMsg();
            } else {
                String msgPendencia = pendencia.getMsg();
                if (msgPendencia.endsWith(".")) {
                    msgPendencia = msgPendencia.substring(0, msgPendencia.length() - 1);
                }
                itemPendente = msgPendencia + (String)item;
            }
            if (((String)itemPendente).equals("")) continue;
            switch (severidade) {
                case 2: {
                    ++this.totalAvisos;
                    break;
                }
                case 3: {
                    ++this.totalErros;
                    break;
                }
                case 5: {
                    ++this.totalErros;
                }
            }
            if (severidade != 2 && severidade != 3 && severidade != 5) continue;
            listaPendencia.add(new LinhaPendencia(severidade, (String)itemPendente, pendencia));
        }
        return listaPendencia;
    }

    public class PendenciasListModel
    extends AbstractListModel<LinhaPendencia> {
        private List<LinhaPendencia> listaPendencias = new ArrayList<LinhaPendencia>();

        public void atualizarListaPendencias(List<Pendencia> listaPendencias) {
            this.listaPendencias = PainelPendencias.this.montaTableListaPendencia(listaPendencias);
        }

        @Override
        public int getSize() {
            return this.listaPendencias.size();
        }

        @Override
        public LinhaPendencia getElementAt(int index) {
            return this.listaPendencias.get(index);
        }
    }

    class PendenciasCellRenderer
    extends JLabel
    implements ListCellRenderer<LinhaPendencia> {
        int itemSublinhado = -1;

        public PendenciasCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LinhaPendencia> list, LinhaPendencia value, int index, boolean isSelected, boolean cellHasFocus) {
            StringBuilder sbTagInicial = new StringBuilder("<html><p>");
            StringBuilder sbTagFinal = new StringBuilder("</p></html>");
            StringBuilder sbNomeAcessivel = new StringBuilder();
            this.setIconTextGap(10);
            if (value.getPendencia() == null) {
                this.setIcon(null);
                this.setBackground(new Color(229, 238, 243));
                sbTagInicial.append("<b>");
                sbTagFinal.insert(0, "</b>");
                sbNomeAcessivel.append("Ficha: ");
            } else {
                this.setIcon(value.getTipo());
                this.setBackground(Color.WHITE);
                if (value.getSeveridade() == 2) {
                    sbNomeAcessivel.append("Pend\u00eancia do tipo Aviso: ");
                } else if (value.getSeveridade() == 3) {
                    sbNomeAcessivel.append("Pend\u00eancia do tipo Erro: ");
                }
                if (index == this.getItemSublinhado()) {
                    sbTagInicial.append("<u>");
                    sbTagFinal.insert(0, "</u>");
                }
            }
            Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            if (isSelected) {
                border = BorderFactory.createCompoundBorder(new DashedBorder(new Color(0, 0, 0), 5, 5, 1), border);
            }
            this.setBorder(border);
            String texto = value.getCampo().replaceAll("\\<[^\\>]+\\>", " ");
            texto = UtilitariosString.insereQuebraDeLinha((String)texto, (int)150, (String)"<br>");
            this.setText(sbTagInicial.toString() + texto + sbTagFinal.toString());
            sbNomeAcessivel.append(value.getCampo());
            this.getAccessibleContext().setAccessibleName(sbNomeAcessivel.toString());
            return this;
        }

        public int getItemSublinhado() {
            return this.itemSublinhado;
        }

        public void setItemSublinhado(int itemSublinhado) {
            this.itemSublinhado = itemSublinhado;
        }
    }
}

