/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import br.gov.serpro.updater.DialogoOcupado;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.PreenchedorFichasImpressao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFBemVindos;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.impressao.Relatorio;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.txt.util.ConversorMidas;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelSelecaoTipoImpressaoNova
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Declara\u00e7\u00e3o";
    public static final int IMPRESSAO_POR_PARTES = 1;
    public static final int IMPRESSAO_TODA_DECLARACAO = 0;
    private int tipoImpressao = 0;
    private boolean primeiroRelatorio = true;
    private IdentificadorDeclaracao identificadorDec = null;
    private boolean cancelou = false;
    private ButtonGroup btgItensDeclaracao;
    private ButtonGroup btgTipoOperacao;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    public JCheckBox chkARBrasil;
    public JCheckBox chkARExterior;
    public JCheckBox chkAlimentandos;
    public JCheckBox chkBens;
    public JCheckBox chkConjuge;
    public JCheckBox chkContribuinte;
    public JCheckBox chkDependentes;
    public JCheckBox chkDividas;
    public JCheckBox chkDoacaoDiretamenteDeclaracao;
    public JCheckBox chkDoacoes;
    public JCheckBox chkDoacoesCampanha;
    public JCheckBox chkEspolio;
    public JCheckBox chkFundoInvestDependentes;
    public JCheckBox chkFundoInvestTitular;
    public JCheckBox chkGCAP;
    public JCheckBox chkHerdeiros;
    public JCheckBox chkImpostoPago;
    public JCheckBox chkPagamentos;
    public JCheckBox chkRendAcmDependentes;
    public JCheckBox chkRendAcmTitular;
    public JCheckBox chkRendIsentos;
    public JCheckBox chkRendPFDep;
    public JCheckBox chkRendPFTitular;
    public JCheckBox chkRendPJDep;
    public JCheckBox chkRendPJExigSuspDependente;
    public JCheckBox chkRendPJExigSuspTitular;
    public JCheckBox chkRendPJTitular;
    public JCheckBox chkRendSujTributExcl;
    public JCheckBox chkRendaVariavelDependentes;
    public JCheckBox chkRendaVariavelTitular;
    public JCheckBox chkResumoDeclaracao;
    public JCheckBox chkSaida;
    public JCheckBox chkTodos;
    private JEditCPF edtCPF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JPanel pPartesDeclaracao;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    public JRadioButton rdPartes;
    public JRadioButton rdTodaDeclaracao;

    public PainelSelecaoTipoImpressaoNova() {
        this.initComponents();
    }

    public PainelSelecaoTipoImpressaoNova(IdentificadorDeclaracao id) {
        this.identificadorDec = id;
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.edtCPF.setInformacao((Informacao)this.identificadorDec.getCpf());
        this.edtCPF.getComponenteFoco().setEnabled(false);
        this.habilitarSelecaoPartesDeclaracao(false);
        this.rdTodaDeclaracao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PainelSelecaoTipoImpressaoNova.this.rdTodaDeclaracao.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PainelSelecaoTipoImpressaoNova.this.setTipoImpressao(0);
                            PainelSelecaoTipoImpressaoNova.this.habilitarSelecaoPartesDeclaracao(false);
                            PainelSelecaoTipoImpressaoNova.this.btnOk.setEnabled(true);
                        }
                    });
                }
            }
        });
        this.rdPartes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PainelSelecaoTipoImpressaoNova.this.rdPartes.isSelected()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PainelSelecaoTipoImpressaoNova.this.setTipoImpressao(1);
                            PainelSelecaoTipoImpressaoNova.this.habilitarSelecaoPartesDeclaracao(true);
                            PainelSelecaoTipoImpressaoNova.this.btnOk.setEnabled(true);
                        }
                    });
                }
            }
        });
        this.chkTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = PainelSelecaoTipoImpressaoNova.this.chkTodos.isSelected();
                int totalComp = PainelSelecaoTipoImpressaoNova.this.pPartesDeclaracao.getComponentCount();
                for (int i = 0; i < totalComp; ++i) {
                    Component comp = PainelSelecaoTipoImpressaoNova.this.pPartesDeclaracao.getComponent(i);
                    if (!(comp instanceof JCheckBox) || comp.equals(PainelSelecaoTipoImpressaoNova.this.chkTodos)) continue;
                    ((JCheckBox)comp).setSelected(isSelected);
                }
            }
        });
    }

    private void habilitarSelecaoPartesDeclaracao(boolean habilitar) {
        for (int i = 0; i < this.pPartesDeclaracao.getComponentCount(); ++i) {
            if (!(this.pPartesDeclaracao.getComponent(i) instanceof JCheckBox)) continue;
            ((JCheckBox)this.pPartesDeclaracao.getComponent(i)).setEnabled(habilitar);
        }
        this.chkHerdeiros.setVisible(this.identificadorDec.isEspolio());
        this.chkSaida.setVisible(this.identificadorDec.isSaida());
        this.chkConjuge.setVisible(false);
    }

    public PainelSelecaoTipoImpressaoNova(IdentificadorDeclaracao id, boolean salvarImagem) {
        this(id);
        if (salvarImagem) {
            this.rbImprimir.setVisible(false);
        }
    }

    public void processa(int tipoOperacao) {
        try {
            String pathDados = this.identificadorDec.getPathArquivoAsURL().toString();
        }
        catch (MalformedURLException e) {
            Object pathDados = null;
            LogPPGD.erro((String)e.getMessage());
        }
        IdentificadorDeclaracao idDec = this.identificadorDec;
        DeclaracaoIRPF dec = null;
        GuiUtil.fecharDialog(this);
        try {
            if (!idDec.getNumReciboTransmitido().naoFormatado().equals("0000000000")) {
                boolean existe = IRPFFacade.existeDeclaracaoEmPreenchimento((String)idDec.getCpf().naoFormatado());
                DeclaracaoIRPF decModelo = new ImportadorTxt().restaurarDeclaracao(new File(IRPFUtil.obterNomeCompletoArquivoTransmitido((IdentificadorDeclaracao)idDec)), false);
                IRPFFacade.abreDeclaracao((IdentificadorDeclaracao)idDec);
                IRPFFacade.getInstancia().getBens().corrigirCorrupcaoRenavam(IRPFFacade.getInstancia().getDeclaracao(), decModelo);
                if (!existe) {
                    IRPFFacade.excluirDeclaracao((String)idDec.getCpf().naoFormatado(), (String)"0000000000");
                }
            } else {
                IRPFFacade.abreDeclaracao((IdentificadorDeclaracao)idDec);
            }
        }
        catch (IOException | GeracaoTxtException | HashInvalidoException e) {
            ControladorGui.tratarException((Exception)e);
        }
        dec = IRPFFacade.getInstancia().getDeclaracao();
        dec.excluirRegistrosEmBrancoTodasColecoes();
        dec.getPagamentos().verificarLegadoPagamentos();
        IRPFFacade.getInstancia().salvarDeclaracaoAberta();
        String retifOrigi = "origi";
        if (idDec.getDeclaracaoRetificadora().naoFormatado().equals(Logico.SIM)) {
            retifOrigi = "retif";
        }
        String nomePdf = IRPFUtil.obterNomeArquivoPDF((String)idDec.getCpf().naoFormatado(), (String)retifOrigi, (String)"declaracao", null);
        String pathDec = null;
        if (this.getTipoImpressao() == 0) {
            try {
                DialogoOcupado diaOcupado = DialogoOcupado.exibeDialogo((int)0, (int)4, (String)"Gerando impress\u00e3o...");
                ConversorMidas midas = new ConversorMidas();
                diaOcupado.atualiza();
                pathDec = midas.gerarDeclaracaoMidas(this.identificadorDec);
                diaOcupado.atualiza();
                String exercicio = ConstantesGlobais.EXERCICIO;
                Relatorio novaImpressao = new Relatorio("Declara\u00e7\u00e3o", "DIRPF" + exercicio + ".jasper", pathDec, "/result", tipoOperacao, nomePdf, true);
                novaImpressao.addParametro("PATH", "");
                if ("0000000000".equals(idDec.getNumReciboTransmitido().naoFormatado())) {
                    novaImpressao.addParametro("emPreenchimento", (Object)true);
                } else {
                    novaImpressao.addParametro("oficial", (Object)true);
                }
                diaOcupado.atualiza();
                novaImpressao.visualizar();
                diaOcupado.finaliza();
            }
            catch (IOException | GeracaoTxtException e) {
                LogPPGD.erro((String)e.getMessage());
            }
        } else if (this.getTipoImpressao() == 1) {
            DialogoOcupado diaOcupado = DialogoOcupado.exibeDialogo((int)0, (int)4, (String)"Gerando impress\u00e3o...");
            diaOcupado.atualiza();
            ConversorMidas midas = new ConversorMidas();
            diaOcupado.atualiza();
            try {
                pathDec = midas.gerarDeclaracaoMidas(this.identificadorDec);
            }
            catch (IOException | GeracaoTxtException e) {
                LogPPGD.erro((String)e.getMessage());
            }
            if (pathDec == null) {
                return;
            }
            String exercicio = ConstantesGlobais.EXERCICIO;
            diaOcupado.atualiza();
            Relatorio novaImpressao = new Relatorio("Declara\u00e7\u00e3o", "DIRPF" + exercicio + ".jasper", pathDec, "/result", tipoOperacao, nomePdf, true);
            diaOcupado.finaliza();
            if ("0000000000".equals(idDec.getNumReciboTransmitido().naoFormatado())) {
                novaImpressao.addParametro("emPreenchimento", (Object)true);
            } else {
                novaImpressao.addParametro("oficial", (Object)true);
            }
            novaImpressao.addParametro("PATH", "");
            if (idDec.isCompleta()) {
                novaImpressao.addParametro("decCompleta", "0");
            } else {
                novaImpressao.addParametro("decCompleta", "1");
            }
            if (this.chkContribuinte.isSelected()) {
                PreenchedorFichasImpressao.preencheContribuinte((Relatorio)novaImpressao, (DeclaracaoIRPF)dec, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaContribuinte", "true");
            } else {
                novaImpressao.addParametro("fichaContribuinte", "false");
            }
            if (this.chkDependentes.isSelected()) {
                PreenchedorFichasImpressao.preencheDependentes((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaDependentes", "true");
            } else {
                novaImpressao.addParametro("fichaDependentes", "false");
            }
            if (this.chkAlimentandos.isSelected()) {
                PreenchedorFichasImpressao.preencheAlimentandos((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaAlimentandos", "true");
            } else {
                novaImpressao.addParametro("fichaAlimentandos", "false");
            }
            if (this.chkHerdeiros.isSelected()) {
                PreenchedorFichasImpressao.preencheHerdeiros((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaHerdeiros", "true");
            } else {
                novaImpressao.addParametro("fichaHerdeiros", "false");
            }
            if (this.chkRendPJTitular.isSelected()) {
                PreenchedorFichasImpressao.preencheRendPJTitular((Relatorio)novaImpressao, (DeclaracaoIRPF)dec, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosTributaveisPJTitular", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosTributaveisPJTitular", "false");
            }
            if (this.chkRendPJDep.isSelected()) {
                PreenchedorFichasImpressao.preencheRendPJDependente((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosTributaveisPJDependente", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosTributaveisPJDependente", "false");
            }
            if (this.chkRendPFTitular.isSelected()) {
                PreenchedorFichasImpressao.preencheRendPFTitular((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaRendimentosTributaveisPFTitularVazia", Boolean.toString(dec.getRendPFTitular().isVazio()));
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosTributaveisPFTitular", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosTributaveisPFTitular", "false");
            }
            if (this.chkRendPFDep.isSelected()) {
                PreenchedorFichasImpressao.preencheRendPFDependente((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                if (!dec.getRendPFDependente().todosCpfsPreenchidos()) {
                    novaImpressao.addParametro("fichaRendimentosTributaveisPFDependente", "false");
                    novaImpressao.addParametro("fichaRendimentosTributaveisPFDependenteSemCPF", "true");
                    novaImpressao.addParametro("fichaRendimentosTributaveisPFDependenteVazia", Boolean.toString(dec.getRendPFDependente().isVazio()));
                } else {
                    novaImpressao.addParametro("fichaRendimentosTributaveisPFDependente", "true");
                    novaImpressao.addParametro("fichaRendimentosTributaveisPFDependenteSemCPF", "false");
                    novaImpressao.addParametro("fichaRendimentosTributaveisPFDependenteVazia", Boolean.toString(dec.getRendPFDependente().isVazio()));
                }
            } else {
                novaImpressao.addParametro("fichaRendimentosTributaveisPFDependente", "false");
                novaImpressao.addParametro("fichaRendimentosTributaveisPFDependenteSemCPF", "false");
            }
            if (this.chkRendIsentos.isSelected()) {
                novaImpressao.addParametro("fichaRendimentosIsentosNaoTributaveis", "true");
                novaImpressao.addParametro("fichaRendIsentosVazia", Boolean.toString(dec.getRendIsentos().isVazio()));
                PreenchedorFichasImpressao.preencheRendIsentos((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
            } else {
                novaImpressao.addParametro("fichaRendimentosIsentosNaoTributaveis", "false");
            }
            if (this.chkRendSujTributExcl.isSelected()) {
                PreenchedorFichasImpressao.preencheRendTribExcl((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosSujTribExclusiva", "true");
                novaImpressao.addParametro("fichaRendTribVazia", Boolean.toString(dec.getRendTributacaoExclusiva().isVazio()));
            } else {
                novaImpressao.addParametro("fichaRendimentosSujTribExclusiva", "false");
            }
            if (this.chkRendPJExigSuspTitular.isSelected()) {
                PreenchedorFichasImpressao.preencheRendPJComExigibilidadeTitular((Relatorio)novaImpressao, (DeclaracaoIRPF)dec, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosPJComExigibilidadeTitular", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosPJComExigibilidadeTitular", "false");
            }
            if (this.chkRendPJExigSuspDependente.isSelected()) {
                PreenchedorFichasImpressao.preencheRendPJComExigibilidadeDependente((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosPJComExigibilidadeDependente", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosPJComExigibilidadeDependente", "false");
            }
            if (this.chkRendAcmTitular.isSelected()) {
                PreenchedorFichasImpressao.preencheRendAcumuladamenteTitular((Relatorio)novaImpressao, (DeclaracaoIRPF)dec, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosAcmTitular", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosAcmTitular", "false");
            }
            if (this.chkRendAcmDependentes.isSelected()) {
                PreenchedorFichasImpressao.preencheRendAcumuladamenteDependente((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendimentosAcmDependente", "true");
            } else {
                novaImpressao.addParametro("fichaRendimentosAcmDependente", "false");
            }
            if (this.chkImpostoPago.isSelected()) {
                PreenchedorFichasImpressao.preencheImpostoPago((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaImpostoPago", "true");
                novaImpressao.addParametro("fichaImpostoPagoVazia", Boolean.toString(dec.getImpostoPago().isVazio()));
            } else {
                novaImpressao.addParametro("fichaImpostoPago", "false");
            }
            if (this.chkPagamentos.isSelected()) {
                PreenchedorFichasImpressao.preenchePagamentos((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaPagamentos", "true");
            } else {
                novaImpressao.addParametro("fichaPagamentos", "false");
            }
            if (this.chkDoacoes.isSelected()) {
                PreenchedorFichasImpressao.preencheDoacoes((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaDoacoes", "true");
            } else {
                novaImpressao.addParametro("fichaDoacoes", "false");
            }
            if (this.chkBens.isSelected()) {
                PreenchedorFichasImpressao.preencheBensDireitos((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaBensDireitos", "true");
            } else {
                novaImpressao.addParametro("fichaBensDireitos", "false");
            }
            if (this.chkDividas.isSelected()) {
                PreenchedorFichasImpressao.preencheDividasOnus((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaDividasOnusReais", "true");
            } else {
                novaImpressao.addParametro("fichaDividasOnusReais", "false");
            }
            novaImpressao.addParametro("fichaConjuge", "false");
            if (this.chkEspolio.isSelected()) {
                PreenchedorFichasImpressao.preencheInventariante((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaEspolioVazia", Boolean.toString(dec.getEspolio().isVazio()));
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaInventariante", "true");
            } else {
                novaImpressao.addParametro("fichaInventariante", "false");
            }
            if (this.chkSaida.isSelected()) {
                PreenchedorFichasImpressao.preencheSaida((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaSaidaVazia", Boolean.toString(dec.getSaida().isVazio()));
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaSaida", "true");
            } else {
                novaImpressao.addParametro("fichaSaida", "false");
            }
            if (this.chkDoacoesCampanha.isSelected()) {
                PreenchedorFichasImpressao.preencheDoacoesCampanha((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaDoacoesEleitorais", "true");
            } else {
                novaImpressao.addParametro("fichaDoacoesEleitorais", "false");
            }
            if (this.chkARBrasil.isSelected()) {
                PreenchedorFichasImpressao.preencheARBrasil((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                PreenchedorFichasImpressao.preencheARApuracaoBrasil((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)false);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaARBrasil", "true");
                novaImpressao.addParametro("fichaARBrasilReceitasDespesasVazia", Boolean.toString(dec.getAtividadeRural().getBrasil().getReceitasDespesas().isVazio()));
                novaImpressao.addParametro("fichaARBrasilApuracaoResultadoVazia", Boolean.toString(dec.getAtividadeRural().getBrasil().getApuracaoResultado().isVazio()));
                novaImpressao.addParametro("fichaARBrasilMovimentacaoRebanhoVazia", Boolean.toString(dec.getAtividadeRural().getBrasil().getMovimentacaoRebanho().isVazio()));
            } else {
                novaImpressao.addParametro("fichaARBrasil", "false");
            }
            if (this.chkARExterior.isSelected()) {
                PreenchedorFichasImpressao.preencheARExterior((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                PreenchedorFichasImpressao.preencheARApuracaoExterior((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)false);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaARExterior", "true");
                novaImpressao.addParametro("fichaARExteriorApuracaoResultadoVazia", Boolean.toString(dec.getAtividadeRural().getExterior().getApuracaoResultado().isVazio()));
                novaImpressao.addParametro("fichaARExteriorMovimentacaoRebanhoVazia", Boolean.toString(dec.getAtividadeRural().getExterior().getMovimentacaoRebanho().isVazio()));
            } else {
                novaImpressao.addParametro("fichaARExterior", "false");
            }
            if (this.chkGCAP.isSelected()) {
                PreenchedorFichasImpressao.preencheGCAP((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaGCAP", "true");
                this.primeiroRelatorio = false;
            } else {
                novaImpressao.addParametro("fichaGCAP", "false");
            }
            if (this.chkRendaVariavelTitular.isSelected()) {
                PreenchedorFichasImpressao.preencheRendaVariavel((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendaVariavelTitular", "true");
            } else {
                novaImpressao.addParametro("fichaRendaVariavelTitular", "false");
            }
            if (this.chkRendaVariavelDependentes.isSelected()) {
                PreenchedorFichasImpressao.preencheRendaVariavel((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendaVariavelDependente", "true");
            } else {
                novaImpressao.addParametro("fichaRendaVariavelDependente", "false");
            }
            if (this.chkFundoInvestTitular.isSelected()) {
                PreenchedorFichasImpressao.preencheRendaVariavel((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendaVariavelFundoInvestimentoTitular", "true");
            } else {
                PreenchedorFichasImpressao.preencheRendaVariavel((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaRendaVariavelFundoInvestimentoTitular", "false");
            }
            if (this.chkFundoInvestDependentes.isSelected()) {
                PreenchedorFichasImpressao.preencheRendaVariavel((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaRendaVariavelFundoInvestimentoDependente", "true");
            } else {
                PreenchedorFichasImpressao.preencheRendaVariavel((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaRendaVariavelFundoInvestimentoDependente", "false");
            }
            if (this.chkDoacaoDiretamenteDeclaracao.isSelected()) {
                PreenchedorFichasImpressao.preencheResumo((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaDoacoesDiretamenteDeclaracao", "true");
            } else {
                PreenchedorFichasImpressao.preencheResumo((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaDoacoesDiretamenteDeclaracao", "false");
            }
            if (this.chkResumoDeclaracao.isSelected()) {
                PreenchedorFichasImpressao.preencheResumo((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                this.primeiroRelatorio = false;
                novaImpressao.addParametro("fichaResumo", "true");
            } else {
                PreenchedorFichasImpressao.preencheResumo((DeclaracaoIRPF)dec, (Relatorio)novaImpressao, (boolean)this.primeiroRelatorio);
                novaImpressao.addParametro("fichaResumo", "false");
            }
            if (!this.primeiroRelatorio) {
                novaImpressao.visualizar();
            }
        }
        if (ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
            IRPFFacade.limpaCacheDeclaracoes();
        }
    }

    public void setCancelou(boolean cancelou) {
        this.cancelou = cancelou;
    }

    public boolean isCancelou() {
        return this.cancelou;
    }

    public void setTipoImpressao(int tipoImpressao) {
        this.tipoImpressao = tipoImpressao;
    }

    public int getTipoImpressao() {
        return this.tipoImpressao;
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    private void initComponents() {
        this.btgTipoOperacao = new ButtonGroup();
        this.btgItensDeclaracao = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.edtCPF = new JEditCPF();
        this.jLabel2 = new JLabel();
        this.rbVisualizar = new JRadioButton();
        this.rbImprimir = new JRadioButton();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.rdTodaDeclaracao = new JRadioButton();
        this.rdPartes = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.pPartesDeclaracao = new JPanel();
        this.chkTodos = new JCheckBox();
        this.chkContribuinte = new JCheckBox();
        this.chkSaida = new JCheckBox();
        this.chkDependentes = new JCheckBox();
        this.chkAlimentandos = new JCheckBox();
        this.chkHerdeiros = new JCheckBox();
        this.chkRendPJTitular = new JCheckBox();
        this.chkRendPJDep = new JCheckBox();
        this.chkRendPFTitular = new JCheckBox();
        this.chkRendPFDep = new JCheckBox();
        this.chkRendIsentos = new JCheckBox();
        this.chkRendSujTributExcl = new JCheckBox();
        this.chkRendPJExigSuspTitular = new JCheckBox();
        this.chkRendPJExigSuspDependente = new JCheckBox();
        this.chkRendAcmTitular = new JCheckBox();
        this.chkRendAcmDependentes = new JCheckBox();
        this.chkImpostoPago = new JCheckBox();
        this.chkPagamentos = new JCheckBox();
        this.chkDoacoes = new JCheckBox();
        this.chkBens = new JCheckBox();
        this.chkDividas = new JCheckBox();
        this.chkConjuge = new JCheckBox();
        this.chkEspolio = new JCheckBox();
        this.chkDoacoesCampanha = new JCheckBox();
        this.chkARBrasil = new JCheckBox();
        this.chkARExterior = new JCheckBox();
        this.chkGCAP = new JCheckBox();
        this.chkRendaVariavelTitular = new JCheckBox();
        this.chkRendaVariavelDependentes = new JCheckBox();
        this.chkFundoInvestTitular = new JCheckBox();
        this.chkFundoInvestDependentes = new JCheckBox();
        this.chkDoacaoDiretamenteDeclaracao = new JCheckBox();
        this.chkResumoDeclaracao = new JCheckBox();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("CPF selecionado:");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(new Color(0, 74, 106));
        this.jLabel2.setText("Selecione a op\u00e7\u00e3o desejada:");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.btgTipoOperacao.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.btgTipoOperacao.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecaoTipoImpressaoNova.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecaoTipoImpressaoNova.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sele\u00e7\u00e3o de Impress\u00e3o", 0, 0, FontesUtil.FONTE_TITULO_NORMAL, new Color(0, 74, 106)));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.jLabel3.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel3.setForeground(new Color(0, 74, 106));
        this.jLabel3.setText("Selecione o que voc\u00ea deseja imprimir:");
        this.rdTodaDeclaracao.setBackground(new Color(241, 245, 249));
        this.btgItensDeclaracao.add(this.rdTodaDeclaracao);
        this.rdTodaDeclaracao.setFont(FontesUtil.FONTE_NORMAL);
        this.rdTodaDeclaracao.setSelected(true);
        this.rdTodaDeclaracao.setText("Toda a declara\u00e7\u00e3o");
        this.rdTodaDeclaracao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdPartes.setBackground(new Color(241, 245, 249));
        this.btgItensDeclaracao.add(this.rdPartes);
        this.rdPartes.setFont(FontesUtil.FONTE_NORMAL);
        this.rdPartes.setText("Partes da declara\u00e7\u00e3o");
        this.rdPartes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(175, 196, 214)));
        this.pPartesDeclaracao.setBackground(new Color(241, 245, 249));
        this.pPartesDeclaracao.setLayout(new GridBagLayout());
        this.chkTodos.setBackground(new Color(241, 245, 249));
        this.chkTodos.setFont(FontesUtil.FONTE_NORMAL);
        this.chkTodos.setForeground(ConstantesGlobaisGUI.COR_AZUL_ESCURO);
        this.chkTodos.setText("Marcar/desmarcar todos os quadros");
        this.chkTodos.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkTodos, gridBagConstraints);
        this.chkContribuinte.setBackground(new Color(241, 245, 249));
        this.chkContribuinte.setFont(FontesUtil.FONTE_NORMAL);
        this.chkContribuinte.setText("Identifica\u00e7\u00e3o do Contribuinte");
        this.chkContribuinte.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkContribuinte, gridBagConstraints);
        this.chkSaida.setBackground(new Color(241, 245, 249));
        this.chkSaida.setFont(FontesUtil.FONTE_NORMAL);
        this.chkSaida.setText("Sa\u00edda");
        this.chkSaida.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkSaida, gridBagConstraints);
        this.chkDependentes.setBackground(new Color(241, 245, 249));
        this.chkDependentes.setFont(FontesUtil.FONTE_NORMAL);
        this.chkDependentes.setText("Dependentes");
        this.chkDependentes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkDependentes, gridBagConstraints);
        this.chkAlimentandos.setBackground(new Color(241, 245, 249));
        this.chkAlimentandos.setFont(FontesUtil.FONTE_NORMAL);
        this.chkAlimentandos.setText("Alimentandos");
        this.chkAlimentandos.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkAlimentandos, gridBagConstraints);
        this.chkHerdeiros.setBackground(new Color(241, 245, 249));
        this.chkHerdeiros.setFont(FontesUtil.FONTE_NORMAL);
        this.chkHerdeiros.setText("Herdeiros / Meeiro");
        this.chkHerdeiros.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkHerdeiros, gridBagConstraints);
        this.chkRendPJTitular.setBackground(new Color(241, 245, 249));
        this.chkRendPJTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendPJTitular.setText("Rendimentos tribut\u00e1veis recebidos de PJ pelo titular");
        this.chkRendPJTitular.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendPJTitular, gridBagConstraints);
        this.chkRendPJDep.setBackground(new Color(241, 245, 249));
        this.chkRendPJDep.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendPJDep.setText("Rendimentos tribut\u00e1veis recebidos de PJ pelos dependentes");
        this.chkRendPJDep.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendPJDep, gridBagConstraints);
        this.chkRendPFTitular.setBackground(new Color(241, 245, 249));
        this.chkRendPFTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendPFTitular.setText("Rendimentos tribut\u00e1veis recebidos de PF e do exterior pelo titular");
        this.chkRendPFTitular.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendPFTitular, gridBagConstraints);
        this.chkRendPFDep.setBackground(new Color(241, 245, 249));
        this.chkRendPFDep.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendPFDep.setText("Rendimentos tribut\u00e1veis recebidos de PF e do exterior pelos dependentes");
        this.chkRendPFDep.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendPFDep, gridBagConstraints);
        this.chkRendIsentos.setBackground(new Color(241, 245, 249));
        this.chkRendIsentos.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendIsentos.setText("Rendimentos isentos e n\u00e3o tribut\u00e1veis");
        this.chkRendIsentos.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendIsentos, gridBagConstraints);
        this.chkRendSujTributExcl.setBackground(new Color(241, 245, 249));
        this.chkRendSujTributExcl.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendSujTributExcl.setText("Rendimentos sujeitos a tributa\u00e7\u00e3o exclusiva");
        this.chkRendSujTributExcl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendSujTributExcl, gridBagConstraints);
        this.chkRendPJExigSuspTitular.setBackground(new Color(241, 245, 249));
        this.chkRendPJExigSuspTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendPJExigSuspTitular.setText("Rendimentos tribut\u00e1veis recebidos de PJ pelo titular (Imposto com exigibilidade suspensa)");
        this.chkRendPJExigSuspTitular.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendPJExigSuspTitular, gridBagConstraints);
        this.chkRendPJExigSuspDependente.setBackground(new Color(241, 245, 249));
        this.chkRendPJExigSuspDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendPJExigSuspDependente.setText("Rendimentos tribut\u00e1veis recebidos de PJ pelos dependentes (Imposto com exigibilidade suspensa)");
        this.chkRendPJExigSuspDependente.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendPJExigSuspDependente, gridBagConstraints);
        this.chkRendAcmTitular.setBackground(new Color(241, 245, 249));
        this.chkRendAcmTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendAcmTitular.setText("Rendimentos tribut\u00e1veis de PJ recebidos acumuladamente pelo titular");
        this.chkRendAcmTitular.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendAcmTitular, gridBagConstraints);
        this.chkRendAcmDependentes.setBackground(new Color(241, 245, 249));
        this.chkRendAcmDependentes.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendAcmDependentes.setText("Rendimentos tribut\u00e1veis de PJ recebidos acumuladamente pelos dependentes");
        this.chkRendAcmDependentes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendAcmDependentes, gridBagConstraints);
        this.chkImpostoPago.setBackground(new Color(241, 245, 249));
        this.chkImpostoPago.setFont(FontesUtil.FONTE_NORMAL);
        this.chkImpostoPago.setText("Imposto pago / retido");
        this.chkImpostoPago.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkImpostoPago, gridBagConstraints);
        this.chkPagamentos.setBackground(new Color(241, 245, 249));
        this.chkPagamentos.setFont(FontesUtil.FONTE_NORMAL);
        this.chkPagamentos.setText("Pagamentos efetuados");
        this.chkPagamentos.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkPagamentos, gridBagConstraints);
        this.chkDoacoes.setBackground(new Color(241, 245, 249));
        this.chkDoacoes.setFont(FontesUtil.FONTE_NORMAL);
        this.chkDoacoes.setText("Doa\u00e7\u00f5es efetuadas");
        this.chkDoacoes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkDoacoes, gridBagConstraints);
        this.chkBens.setBackground(new Color(241, 245, 249));
        this.chkBens.setFont(FontesUtil.FONTE_NORMAL);
        this.chkBens.setText("Bens e direitos");
        this.chkBens.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkBens, gridBagConstraints);
        this.chkDividas.setBackground(new Color(241, 245, 249));
        this.chkDividas.setFont(FontesUtil.FONTE_NORMAL);
        this.chkDividas.setText("D\u00edvidas e \u00f4nus reais");
        this.chkDividas.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkDividas, gridBagConstraints);
        this.chkConjuge.setBackground(new Color(241, 245, 249));
        this.chkConjuge.setFont(FontesUtil.FONTE_NORMAL);
        this.chkConjuge.setText("Informa\u00e7\u00f5es do c\u00f4njuge ou companheiro(a)");
        this.chkConjuge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkConjuge, gridBagConstraints);
        this.chkEspolio.setBackground(new Color(241, 245, 249));
        this.chkEspolio.setFont(FontesUtil.FONTE_NORMAL);
        this.chkEspolio.setText("Esp\u00f3lio");
        this.chkEspolio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkEspolio, gridBagConstraints);
        this.chkDoacoesCampanha.setBackground(new Color(241, 245, 249));
        this.chkDoacoesCampanha.setFont(FontesUtil.FONTE_NORMAL);
        this.chkDoacoesCampanha.setText("Doa\u00e7\u00f5es a Partidos Pol\u00edticos e Candidatos");
        this.chkDoacoesCampanha.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkDoacoesCampanha, gridBagConstraints);
        this.chkARBrasil.setBackground(new Color(241, 245, 249));
        this.chkARBrasil.setFont(FontesUtil.FONTE_NORMAL);
        this.chkARBrasil.setText("Atividade Rural (Brasil)");
        this.chkARBrasil.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 24;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkARBrasil, gridBagConstraints);
        this.chkARExterior.setBackground(new Color(241, 245, 249));
        this.chkARExterior.setFont(FontesUtil.FONTE_NORMAL);
        this.chkARExterior.setText("Atividade Rural (Exterior)");
        this.chkARExterior.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkARExterior, gridBagConstraints);
        this.chkGCAP.setBackground(new Color(241, 245, 249));
        this.chkGCAP.setFont(FontesUtil.FONTE_NORMAL);
        this.chkGCAP.setText("Ganhos de Capital");
        this.chkGCAP.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 26;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkGCAP, gridBagConstraints);
        this.chkRendaVariavelTitular.setBackground(new Color(241, 245, 249));
        this.chkRendaVariavelTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendaVariavelTitular.setText("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade (Titular)");
        this.chkRendaVariavelTitular.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 28;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendaVariavelTitular, gridBagConstraints);
        this.chkRendaVariavelDependentes.setBackground(new Color(241, 245, 249));
        this.chkRendaVariavelDependentes.setFont(FontesUtil.FONTE_NORMAL);
        this.chkRendaVariavelDependentes.setText("Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade (Dependentes)");
        this.chkRendaVariavelDependentes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 29;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkRendaVariavelDependentes, gridBagConstraints);
        this.chkFundoInvestTitular.setBackground(new Color(241, 245, 249));
        this.chkFundoInvestTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.chkFundoInvestTitular.setText("Fundos de Investimento Imobili\u00e1rio ou nas Cadeias Produtivas Agroindustriais (Titular)");
        this.chkFundoInvestTitular.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 30;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkFundoInvestTitular, gridBagConstraints);
        this.chkFundoInvestDependentes.setBackground(new Color(241, 245, 249));
        this.chkFundoInvestDependentes.setFont(FontesUtil.FONTE_NORMAL);
        this.chkFundoInvestDependentes.setText("Fundos de Investimento Imobili\u00e1rio ou nas Cadeias Produtivas Agroindustriais (Dependentes)");
        this.chkFundoInvestDependentes.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 31;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkFundoInvestDependentes, gridBagConstraints);
        this.chkDoacaoDiretamenteDeclaracao.setBackground(new Color(241, 245, 249));
        this.chkDoacaoDiretamenteDeclaracao.setFont(FontesUtil.FONTE_NORMAL);
        this.chkDoacaoDiretamenteDeclaracao.setText("Doa\u00e7\u00f5es diretamente na declara\u00e7\u00e3o");
        this.chkDoacaoDiretamenteDeclaracao.setToolTipText("");
        this.chkDoacaoDiretamenteDeclaracao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 32;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkDoacaoDiretamenteDeclaracao, gridBagConstraints);
        this.chkResumoDeclaracao.setBackground(new Color(241, 245, 249));
        this.chkResumoDeclaracao.setFont(FontesUtil.FONTE_NORMAL);
        this.chkResumoDeclaracao.setText("Resumo da declara\u00e7\u00e3o");
        this.chkResumoDeclaracao.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 33;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.pPartesDeclaracao.add((Component)this.chkResumoDeclaracao, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.pPartesDeclaracao);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 363, Short.MAX_VALUE).add((Component)this.rdTodaDeclaracao).add((Component)this.rdPartes).add((Component)this.jLabel3, -2, 238, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.rdTodaDeclaracao).addPreferredGap(0).add((Component)this.rdPartes).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 271, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1, -2, 106, -2).addPreferredGap(0).add((Component)this.edtCPF, -2, 134, -2)).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(14, 14, 14).add((Component)this.jLabel2, -2, 191, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.btnCancelar, -1, -1, Short.MAX_VALUE).add((Component)this.btnOk, -2, 99, -2).add((Component)this.btnAjuda).add((Component)this.rbImprimir).add((Component)this.rbVisualizar))))));
        layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.edtCPF, -2, 21, Short.MAX_VALUE).add((Component)this.jLabel1, -2, 20, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(16, 16, 16).add((Component)this.jLabel2, -2, 20, -2).addPreferredGap(0).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).add(42, 42, 42).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2))).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.temFichaSelecionada()) {
            this.processa(this.getTipoOperacao());
        } else {
            GuiUtil.mostrarErro("impressao_fichas_nao_selecionadas");
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private boolean temFichaSelecionada() {
        return this.tipoImpressao == 0 || this.chkARBrasil.isSelected() || this.chkARExterior.isSelected() || this.chkAlimentandos.isSelected() || this.chkBens.isSelected() || this.chkConjuge.isSelected() || this.chkContribuinte.isSelected() || this.chkDependentes.isSelected() || this.chkDividas.isSelected() || this.chkDoacoes.isSelected() || this.chkDoacoesCampanha.isSelected() || this.chkEspolio.isSelected() || this.chkDoacaoDiretamenteDeclaracao.isSelected() || this.chkFundoInvestDependentes.isSelected() || this.chkFundoInvestTitular.isSelected() || this.chkGCAP.isSelected() || this.chkHerdeiros.isSelected() || this.chkImpostoPago.isSelected() || this.chkPagamentos.isSelected() || this.chkRendAcmDependentes.isSelected() || this.chkRendAcmTitular.isSelected() || this.chkRendIsentos.isSelected() || this.chkRendPFDep.isSelected() || this.chkRendPFTitular.isSelected() || this.chkRendPJDep.isSelected() || this.chkRendPJExigSuspDependente.isSelected() || this.chkRendPJExigSuspTitular.isSelected() || this.chkRendPJTitular.isSelected() || this.chkRendSujTributExcl.isSelected() || this.chkRendaVariavelDependentes.isSelected() || this.chkRendaVariavelTitular.isSelected() || this.chkResumoDeclaracao.isSelected() || this.chkSaida.isSelected() || this.chkTodos.isSelected();
    }
}

