/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.impressao.Relatorio;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Valor;

public class PainelImprimirRendimentosRecebidosPF
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Rendimentos Recebidos de PF";
    private boolean salvarImagem = false;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;
    private ButtonGroup bgTipoOperacao;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JPanel jPanel2;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    private JTabbedPane tabPaneDeclaracoes;

    public PainelImprimirRendimentosRecebidosPF() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.subpainelDeclaracoesPreenchimento.setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.subpainelDeclaracoesTransmitidas.setSelectionMode(0);
        this.tabPaneDeclaracoes.addTab("Em Preenchimento", new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.subpainelDeclaracoesPreenchimento);
        this.tabPaneDeclaracoes.addTab("Transmitidas", new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")), this.subpainelDeclaracoesTransmitidas);
        this.tabPaneDeclaracoes.setMnemonicAt(0, 69);
        this.tabPaneDeclaracoes.setMnemonicAt(1, 82);
        this.configurarBotaoOK();
        this.configurarPainelComAbas();
    }

    private void configurarPainelComAbas() {
        this.tabPaneDeclaracoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelImprimirRendimentosRecebidosPF.this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
                    PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectionModel().clearSelection();
                    if (PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                        PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(true);
                    } else {
                        PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(false);
                    }
                } else {
                    PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectionModel().clearSelection();
                    if (PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                        PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(true);
                    } else {
                        PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(false);
                    }
                }
            }
        });
    }

    private void configurarBotaoOK() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirRendimentosRecebidosPF.this.tabPaneDeclaracoes.getSelectedIndex() == 0 && PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(true);
                } else {
                    PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirRendimentosRecebidosPF.this.btnOkActionPerformed(null);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirRendimentosRecebidosPF.this.tabPaneDeclaracoes.getSelectedIndex() == 1 && PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(true);
                } else {
                    PainelImprimirRendimentosRecebidosPF.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirRendimentosRecebidosPF.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirRendimentosRecebidosPF.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    public PainelImprimirRendimentosRecebidosPF(boolean salvarImagem) {
        this();
        this.salvarImagem = salvarImagem;
        if (salvarImagem) {
            this.jLabel1.setText("Selecione a declara\u00e7\u00e3o que deseja salvar:");
        }
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    private void initComponents() {
        this.bgTipoOperacao = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.rbImprimir = new JRadioButton();
        this.tabPaneDeclaracoes = new JTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a declara\u00e7\u00e3o que deseja imprimir:");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRendimentosRecebidosPF.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRendimentosRecebidosPF.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.bgTipoOperacao.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel10.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel10.setForeground(new Color(0, 74, 106));
        this.jLabel10.setText("Selecione a op\u00e7\u00e3o desejada:");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.bgTipoOperacao.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnOk, -2, 90, -2).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.jLabel10, -1, -1, Short.MAX_VALUE).add((Component)this.rbVisualizar).add((Component)this.rbImprimir)).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel10, -2, 28, -2).add(18, 18, 18).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).add(48, 48, 48).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 579, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tabPaneDeclaracoes).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.tabPaneDeclaracoes, -1, 259, Short.MAX_VALUE)).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione a declara\u00e7\u00e3o que deseja imprimir. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        Valor valorPF = new Valor();
        valorPF.append('+', "0,00");
        if (this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
            IdentificadorDeclaracao id = this.subpainelDeclaracoesPreenchimento.getTabela().getIdentificadorDeclaracao(((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRow()));
            String pathDados = id.getPathArquivo();
            DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
            if (dec.getRendPFTitular().getTotalPessoaFisica().comparacao(">", valorPF) || dec.getRendPFDependente().getTotalPessoaFisica().comparacao(">", valorPF)) {
                int tipoOperacao = this.getTipoOperacao();
                Relatorio novaImpressao = new Relatorio("Rendimentos Recebidos de PF", "relDeclaracaoRendimentosTributaveisPFMeses.jasper", pathDados, "/classe", tipoOperacao, IRPFUtil.obterNomeArquivoPDF((String)dec.getIdentificadorDeclaracao().getCpf().naoFormatado(), (String)(dec.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1") ? "retif" : "origi"), (String)"trabalho-nao-assalariado", null), false);
                novaImpressao.addParametro("PATH", "");
                novaImpressao.addParametro("nomeContribuinte", id.getNome().formatado());
                novaImpressao.addParametro("cpfContribuinte", id.getCpf().formatado());
                novaImpressao.addParametro("exercicio", AplicacaoPropertiesUtil.getExercicio());
                novaImpressao.addParametro("ANO_BASE", String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1));
                novaImpressao.addParametro("tipoDeclaracaoAES", id.getTipoDeclaracaoAES().naoFormatado());
                novaImpressao.visualizar();
            } else {
                GuiUtil.mostrarInfo("impressao.sem.info");
            }
        } else {
            IdentificadorDeclaracao id = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRow()));
            String pathDados = id.getPathArquivo();
            DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
            if (dec.getRendPFTitular().getTotalPessoaFisica().comparacao(">", valorPF) || dec.getRendPFDependente().getTotalPessoaFisica().comparacao(">", valorPF)) {
                int tipoOperacao = this.getTipoOperacao();
                Relatorio novaImpressao = new Relatorio("Rendimentos Recebidos de PF", "relDeclaracaoRendimentosTributaveisPFMeses.jasper", pathDados, "/classe", tipoOperacao, IRPFUtil.obterNomeArquivoPDF((String)dec.getIdentificadorDeclaracao().getCpf().naoFormatado(), (String)(dec.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1") ? "retif" : "origi"), (String)"trabalho-nao-assalariado", null), false);
                novaImpressao.addParametro("PATH", "");
                novaImpressao.addParametro("nomeContribuinte", id.getNome().formatado());
                novaImpressao.addParametro("cpfContribuinte", id.getCpf().formatado());
                novaImpressao.addParametro("exercicio", AplicacaoPropertiesUtil.getExercicio());
                novaImpressao.addParametro("ANO_BASE", String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1));
                novaImpressao.addParametro("tipoDeclaracaoAES", id.getTipoDeclaracaoAES().naoFormatado());
                novaImpressao.visualizar();
            } else {
                GuiUtil.mostrarInfo("impressao.sem.info");
            }
        }
    }
}

