/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.impressao.ImpressaoDarfAuxilioEmergencial;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.Validador;

public class PainelImprimirDarfAuxilioEmergencial
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Darf de Aux\u00edlio Emergencial";
    private File dirSelecionado = new File(UtilitariosArquivo.getPathTransmitidas());
    private List<RepositorioDeclaracaoCentralTxt> repositorios;
    private boolean cancelou;
    private JButton btnAjuda;
    private JButton btnImprimir;
    private JButton btnSair;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;

    public PainelImprimirDarfAuxilioEmergencial() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesTransmitidas.getTabela().setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirDarfAuxilioEmergencial.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDarfAuxilioEmergencial.this.btnImprimir.setEnabled(true);
                } else {
                    PainelImprimirDarfAuxilioEmergencial.this.btnImprimir.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirDarfAuxilioEmergencial.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDarfAuxilioEmergencial.this.btnImprimirActionPerformed(null);
                }
            }
        });
    }

    public PainelImprimirDarfAuxilioEmergencial(boolean salvarImagem) {
        this();
        if (salvarImagem) {
            this.jLabel1.setText("Selecione a declara\u00e7\u00e3o para salvar o recibo:");
            this.rbImprimir.setVisible(false);
            this.rbVisualizar.setSelected(true);
        }
    }

    private File getArquivoDec(String path, File dir, String nomeFileRec) {
        String nomeFileDec = null;
        File retorno = null;
        if (nomeFileRec.length() > 12) {
            nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
            retorno = new File(path + File.separator + nomeFileDec);
        } else {
            FilenameFilter filterDEC = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean retorno = Validador.validarString((String)name, (String)ConstantesGlobaisIRPF.PADRAO_NOME_ARQ_DECLARACAO);
                    return retorno;
                }
            };
            File[] files = dir.listFiles(filterDEC);
            File fileDecMaisAtual = null;
            for (int i = 0; i < files.length; ++i) {
                String nomeArqDecAtual = files[i].getName();
                if (fileDecMaisAtual != null && fileDecMaisAtual.lastModified() > files[i].lastModified() || !nomeArqDecAtual.substring(0, 8).equals(nomeFileRec.subSequence(0, 8))) continue;
                fileDecMaisAtual = files[i];
            }
            retorno = fileDecMaisAtual;
            if (retorno == null) {
                nomeFileDec = nomeFileRec.substring(0, nomeFileRec.length() - 4) + ".DEC";
                retorno = new File(path + File.separator + nomeFileDec);
            }
        }
        return retorno;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnImprimir = new JButton();
        this.btnSair = new JButton();
        this.btnAjuda = new JButton();
        this.rbImprimir = new JRadioButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a declara\u00e7\u00e3o para imprimir o Darf de Devolu\u00e7\u00e3o do Aux\u00edlio Emergencial:");
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnImprimir.setMnemonic('o');
        this.btnImprimir.setText("Ok");
        this.btnImprimir.setEnabled(false);
        this.btnImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarfAuxilioEmergencial.this.btnImprimirActionPerformed(evt);
            }
        });
        this.btnSair.setMnemonic('c');
        this.btnSair.setText("Cancelar");
        this.btnSair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarfAuxilioEmergencial.this.btnSairActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(new Color(0, 74, 106));
        this.jLabel2.setText("Selecione a op\u00e7\u00e3o desejada:");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.rbVisualizar).add((Component)this.rbImprimir).add((Component)this.jLabel2))).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnSair).add((Component)this.btnAjuda).add(2, (Component)this.btnImprimir, -2, 97, -2)).add(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnImprimir, this.btnSair}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(1).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).addPreferredGap(0, 41, Short.MAX_VALUE).add((Component)this.btnImprimir).addPreferredGap(0).add((Component)this.btnSair).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnImprimir, this.btnSair}, 2);
        this.btnImprimir.getAccessibleContext().setAccessibleName("OK");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesTransmitidas, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.subpainelDeclaracoesTransmitidas, -1, 408, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione os declara\u00e7\u00f5es para imprimir o recibo. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnImprimirActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        int[] linhasSelecionadas = this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
        int[] rows = new int[linhasSelecionadas.length];
        for (int a = 0; a < rows.length; ++a) {
            rows[a] = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
        }
        for (int i = 0; i < rows.length; ++i) {
            int linha = rows[i];
            if (linha == -1) continue;
            this.imprimirDarf(linha);
        }
    }

    private void btnSairActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void imprimirDarf(int linhaSelecionada) {
        IdentificadorDeclaracao id = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(linhaSelecionada);
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
        File decGeradaEntrega = IRPFTxtUtil.montaPathTXTDeclaracao((String)UtilitariosArquivo.getPathTransmitidas(), (IdentificadorDeclaracao)id, (boolean)true);
        File fileRec = UtilitariosArquivo.getRECCorrespondente((File)decGeradaEntrega);
        try {
            RepositorioDeclaracaoCentralTxt repositorioDeclaracaoCentralTxt = new RepositorioDeclaracaoCentralTxt("ARQ_COMPLRECIBO", fileRec);
            Map mapAuxilio = repositorioDeclaracaoCentralTxt.recuperarValoresAuxilioEmergencial();
            String pathDados = id.getPathArquivo().toString();
            String tipo = dec.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1") ? "retif" : "origi";
            IRPFUtil.setNomeArquivo((String)IRPFUtil.obterNomeArquivoPDF((String)id.getCpf().naoFormatado(), (String)tipo, (String)"darfauxilio", null));
            String cpf = id.getCpf().formatado();
            String nome = id.getNome().formatado();
            if (!mapAuxilio.isEmpty()) {
                ImpressaoDarfAuxilioEmergencial imp = new ImpressaoDarfAuxilioEmergencial("Darf", "relDarfAuxilio.jasper", pathDados, "/classe", cpf, nome, this.getTipoOperacao(), mapAuxilio, null, dec);
                imp.vizualizarDarf(mapAuxilio);
            } else {
                GuiUtil.mostrarInfo("darf_sem_info");
            }
        }
        catch (BarramentoException ex) {
            LogPPGD.erro((String)ex.getMessage());
            GuiUtil.mostrarErro("nuvem.erro.servico_indisponivel");
        }
        catch (Exception ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

