/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.gui.xbeans.JEditInteiro;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class PainelImpostoPagarAcessivel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DeclaracaoIRPF declaracaoIRPF = null;
    private Inteiro numQuotas = new Inteiro();
    private JButton btnOk;
    private JEditInteiro edtNumQuotas;
    private JEditValor edtSaldoIAP;
    private JEditValor edtValorQuota;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel lblAliquotaEfetiva;
    private JLabel lblAtencao;
    private JLabel lblAtencaoComplemento;
    private JLabel lblCPFContribuinte;
    private JLabel lblNomeContribuinte;

    public PainelImpostoPagarAcessivel(final DeclaracaoIRPF dec) {
        this.initComponents();
        this.declaracaoIRPF = dec;
        if (!this.declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora()) {
            this.lblAtencaoComplemento.setVisible(false);
        }
        this.edtSaldoIAP.setInformacao((Informacao)this.declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar());
        this.edtNumQuotas.setInformacao((Informacao)this.numQuotas);
        this.edtValorQuota.setInformacao((Informacao)this.declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota());
        this.lblAliquotaEfetiva.setText("Al\u00edquota Efetiva: " + dec.getResumo().getCalculoImposto().getAliquotaEfetiva().formatado() + "%");
        this.lblCPFContribuinte.setText("<html><b>CPF:</b> " + dec.getIdentificadorDeclaracao().getCpf().formatado() + "</html>");
        this.lblNomeContribuinte.setText("<html><b>Nome:</b> " + dec.getIdentificadorDeclaracao().getNome().formatado() + "</html>");
        this.numQuotas.setLimiteMinimo(this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().getLimiteMinimo());
        this.numQuotas.setLimiteMaximo(this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().getLimiteMaximo());
        this.numQuotas.setHabilitado(this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().isHabilitado());
        int auxNumQuotas = this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger();
        this.numQuotas.setConteudo(auxNumQuotas);
        if (auxNumQuotas > this.numQuotas.getLimiteMaximo()) {
            this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().setConteudo(this.numQuotas.naoFormatado());
        }
        this.numQuotas.addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PainelImpostoPagarAcessivel.this.numQuotas.getConteudoAntigo().equals("1") && PainelImpostoPagarAcessivel.this.numQuotas.asInteger() > 1) {
                            String[] params = new String[]{TabelaDatasIRPF.obterDataReaberturaEntregaFormatada((boolean)dec.getEmCalamidade())};
                            GuiUtil.mostrarInfo((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"info_quotas", (String[])params));
                        } else if (!PainelImpostoPagarAcessivel.this.numQuotas.getConteudoAntigo().equals("1") && PainelImpostoPagarAcessivel.this.numQuotas.asInteger() == 1) {
                            PainelImpostoPagarAcessivel.this.declaracaoIRPF.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().setConteudo("1");
                        }
                        if (PainelImpostoPagarAcessivel.this.declaracaoIRPF != null) {
                            PainelImpostoPagarAcessivel.this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().setConteudo(PainelImpostoPagarAcessivel.this.numQuotas.naoFormatado());
                        }
                    }
                });
            }
        });
        UtilitariosGUI.aumentaFonte((JComponent)this.lblAtencao, (int)2);
        UtilitariosGUI.aumentaFonte((JComponent)this.jLabel2, (int)2);
        UtilitariosGUI.aumentaFonte((JComponent)this.jLabel3, (int)2);
        UtilitariosGUI.aumentaFonte((JComponent)this.jLabel4, (int)2);
        UtilitariosGUI.aumentaFonte((JComponent)this.jLabel5, (int)2);
        ((JSpinner.DefaultEditor)((JSpinner)this.edtNumQuotas.getComponenteEditor()).getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || e.getKeyCode() >= 37 && e.getKeyCode() <= 40 || e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    super.keyPressed(e);
                } else {
                    e.consume();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isDigit(e.getKeyChar())) {
                    super.keyTyped(e);
                } else {
                    e.consume();
                }
                JFormattedTextField formatText = ((JSpinner.DefaultEditor)((JSpinner)PainelImpostoPagarAcessivel.this.edtNumQuotas.getComponenteEditor()).getEditor()).getTextField();
                if (formatText != null && formatText.getText() != null && formatText.getText().length() >= 1) {
                    e.setKeyChar('\f');
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() >= 48 && e.getKeyCode() <= 57 || e.getKeyCode() >= 37 && e.getKeyCode() <= 40 || e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    super.keyReleased(e);
                } else {
                    e.consume();
                }
            }
        });
        ((JSpinner)this.edtNumQuotas.getComponenteFoco()).getEditor().getAccessibleContext().setAccessibleName("N\u00famero de quotas at\u00e9 " + TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado());
    }

    public String obterMensagemQuotas() {
        int qtdMaxQuotas = Integer.parseInt(TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().formatado());
        Valor valorMinimoImpostoQuotas = new Valor();
        valorMinimoImpostoQuotas.setConteudo("2,00");
        valorMinimoImpostoQuotas.append('*', TabelaAliquotasIRPF.ConstantesAliquotas.valorMinQuota.getValor());
        StringBuilder mensagem = new StringBuilder("<html>O imposto de valor igual ou superior a R$ ").append(valorMinimoImpostoQuotas.formatado()).append(" poder\u00e1 ser pago em at\u00e9 ").append(qtdMaxQuotas).append(" quotas, desde que cada uma n\u00e3o seja inferior a R$ ").append(TabelaAliquotasIRPF.ConstantesAliquotas.valorMinQuota.getValor().formatado()).append(".");
        if (this.exibirInfoQuotas()) {
            mensagem.append("<br>A quantidade m\u00e1xima de quotas para o parcelamento do imposto a pagar foi alterada de 8 para <font color=#FF0000><b>").append(qtdMaxQuotas).append(" quotas</b></font>. Observe as novas datas de vencimento.");
        }
        mensagem.append("</html>");
        return mensagem.toString();
    }

    public String obterMensagemInfoQuotas() {
        StringBuilder texto = new StringBuilder("<html>");
        int qtdMaxQuotas = TabelaDatasIRPF.getQuantidadeMaxQuotas();
        texto.append("Caso tenha selecionado originalmente mais de ").append(qtdMaxQuotas).append(" quotas e j\u00e1 tenha feito<br>o pagamento de alguma quota, os novos Darfs devem ser emitidos<br>exclusivamente por meio do Portal e-CAC.<br><br>").append("Para isso, acesse o Portal e-CAC no site da RFB<br>https://www.gov.br/receitafederal/, clique em \"Declara\u00e7\u00f5es e Demonstrativos\" e<br>selecione o servi\u00e7o \"Meu Imposto de Renda (Extrato da Dirpf)\". Na lista de<br>servi\u00e7os clique em Pagamento - Consultar D\u00e9bitos, Emitir Darf e Alterar Quotas.");
        return texto.toString();
    }

    public boolean exibirInfoQuotas() {
        return TabelaDatasIRPF.getQuantidadeMaxQuotas() != 8;
    }

    private void initComponents() {
        this.lblCPFContribuinte = new JLabel();
        this.lblNomeContribuinte = new JLabel();
        this.jLabel1 = new JLabel();
        this.lblAtencao = new JLabel();
        this.lblAtencaoComplemento = new JLabel();
        this.jLabel2 = new JLabel();
        this.edtSaldoIAP = new JEditValor();
        this.lblAliquotaEfetiva = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.edtNumQuotas = new JEditInteiro();
        this.jLabel5 = new JLabel();
        this.edtValorQuota = new JEditValor();
        this.btnOk = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(Color.white);
        this.setPreferredSize(new Dimension(700, 440));
        this.lblCPFContribuinte.setText("CPF: 999.999.999-99");
        this.lblNomeContribuinte.setText("Nome: Contribuinte de Testes Com Sobrenomes Grande Demais da Comta");
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setIcon(GuiUtil.getImage("/icones/png10px/info.png"));
        this.jLabel1.setText(this.obterMensagemQuotas());
        this.lblAtencao.setBackground(new Color(241, 245, 249));
        this.lblAtencao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAtencao.setHorizontalAlignment(2);
        this.lblAtencao.setText("Confirme o n\u00famero de quotas para pagamento do imposto:");
        this.lblAtencao.setVerticalAlignment(3);
        this.lblAtencaoComplemento.setBackground(new Color(241, 245, 249));
        this.lblAtencaoComplemento.setHorizontalAlignment(2);
        this.lblAtencaoComplemento.setText("<HTML>ATEN\u00c7\u00c3O: o n\u00famero de quotas informado nesta declara\u00e7\u00e3o substituir\u00e1 a quantidade de quotas indicadas na declara\u00e7\u00e3o anterior.<br>Caso tenha feito op\u00e7\u00e3o pelo d\u00e9bito autom\u00e1tico ou realizado algum pagamento, \u00e9 aconselh\u00e1vel utilizar o mesmo n\u00famero de quotas da declara\u00e7\u00e3o anterior ou a m\u00e1xima permitida.</HTML>");
        this.lblAtencaoComplemento.setVerticalAlignment(3);
        this.jLabel2.setBackground(new Color(241, 245, 249));
        this.jLabel2.setText("SALDO DE IMPOSTO A PAGAR");
        this.lblAliquotaEfetiva.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAliquotaEfetiva.setText("Al\u00edquota Efetiva: 100%");
        this.jLabel3.setBackground(new Color(241, 245, 249));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("PARCELAMENTO");
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setText("N\u00famero de quotas (at\u00e9 " + TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado() + "):");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setText("Valor da quota:");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setPreferredSize(new Dimension(80, 29));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImpostoPagarAcessivel.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.btnOk, -2, -1, -2).add(306, 306, 306)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(259, 259, 259).add((Component)this.jLabel2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblCPFContribuinte).add(18, 18, 18).add((Component)this.lblNomeContribuinte)).add((Component)this.jLabel1, -2, 664, -2).add((Component)this.lblAtencao).add((Component)this.lblAtencaoComplemento, -2, 669, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add(282, 282, 282).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.edtSaldoIAP, -2, 160, -2).add((Component)this.lblAliquotaEfetiva).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.jLabel3)))).add((GroupLayout.Group)layout.createSequentialGroup().add(192, 192, 192).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4, -2, 217, -2).addPreferredGap(0).add((Component)this.edtNumQuotas, -2, 78, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.edtValorQuota, -2, 144, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblCPFContribuinte).add((Component)this.lblNomeContribuinte)).addPreferredGap(1).add((Component)this.jLabel1).addPreferredGap(1).add((Component)this.lblAtencao).addPreferredGap(0).add((Component)this.lblAtencaoComplemento, -2, 66, -2).add(29, 29, 29).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.edtSaldoIAP, -2, -1, -2).addPreferredGap(0).add((Component)this.lblAliquotaEfetiva).addPreferredGap(1).add((Component)this.jLabel3).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.edtNumQuotas, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.edtValorQuota, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel5, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.btnOk, -2, -1, -2).addContainerGap(74, Short.MAX_VALUE)));
        this.edtSaldoIAP.getAccessibleContext().setAccessibleName("Saldo de imposto a pagar");
        this.edtNumQuotas.getAccessibleContext().setAccessibleName("N\u00famero de quotas (at\u00e9 " + TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado() + ")");
        this.edtValorQuota.getAccessibleContext().setAccessibleName("Valor da quota");
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        this.declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().setConteudo(this.numQuotas.asInteger());
    }
}

