/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.acoes.SairAction;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFBemVindos;
import serpro.ppgd.irpf.gui.NavegadorHtml;
import serpro.ppgd.irpf.gui.TableModelSelecionaDeclaracaoPreenchimento;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.dialogs.PainelAvisoAvaliacao;
import serpro.ppgd.irpf.gui.dialogs.PainelDadosDebitoAutomatico;
import serpro.ppgd.irpf.gui.dialogs.PainelDadosRestituicao;
import serpro.ppgd.irpf.gui.dialogs.PainelGravacaoEntregaModeloMelhor;
import serpro.ppgd.irpf.gui.dialogs.PainelGravarTransmitirPendenciasNaoImpeditivas;
import serpro.ppgd.irpf.gui.dialogs.PainelImpostoPagarAcessivel;
import serpro.ppgd.irpf.gui.dialogs.PainelImprimirRecibo;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.pendencias.PainelPendencias;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProcessoSwing;
import serpro.ppgd.irpf.gui.util.Tarefa;
import serpro.ppgd.irpf.gui.util.tabs.JTaskTabs;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.HTMLUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.update.IRPFUpdater;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.receitanet.ControleReceitanet;
import serpro.receitanet.Receitanet;

public class PainelGravarTransmitir
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Entregar Declara\u00e7\u00e3o";
    private static Receitanet recnet = null;
    private File dirSelecionado = new File(UtilitariosArquivo.getPathGravadas());
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnGravar;
    private JCheckBox chkCertificacaoDigital;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;

    public PainelGravarTransmitir() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.dirSelecionado.mkdirs();
        this.configurarPainelDeclaracoes();
    }

    public PainelGravarTransmitir(boolean comCertificado) {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        if (comCertificado) {
            this.chkCertificacaoDigital.setSelected(true);
        }
        this.dirSelecionado.mkdirs();
        this.configurarPainelDeclaracoes();
    }

    public PainelGravarTransmitir(String cpfSelecionado, boolean usarCertificado) {
        this();
        boolean selecionouDeclaracao = this.selecionarDeclaracao(cpfSelecionado);
        if (selecionouDeclaracao) {
            this.chkCertificacaoDigital.setSelected(usarCertificado);
            this.transmitir();
        }
    }

    private boolean selecionarDeclaracao(String cpfSelecionado) {
        boolean selecionouDeclaracao = false;
        TableModelSelecionaDeclaracaoPreenchimento tableModel = (TableModelSelecionaDeclaracaoPreenchimento)this.subpainelDeclaracoesPreenchimento.getTabela().getModel();
        int selIndice = -1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            IdentificadorDeclaracao idAtual = tableModel.getIdentificadorDeclaracao(i);
            if (!idAtual.getCpf().naoFormatado().equals(cpfSelecionado)) continue;
            selIndice = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToView(i);
            break;
        }
        if (selIndice > -1) {
            this.subpainelDeclaracoesPreenchimento.getTabela().setRowSelectionInterval(selIndice, selIndice);
            selecionouDeclaracao = true;
        }
        return selecionouDeclaracao;
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelGravarTransmitir.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarTransmitir.this.btnGravar.setEnabled(true);
                } else {
                    PainelGravarTransmitir.this.btnGravar.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelGravarTransmitir.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarTransmitir.this.btnGravarActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnGravar = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.jPanel4 = new JPanel();
        this.chkCertificacaoDigital = new JCheckBox();
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione o CPF da Declara\u00e7\u00e3o a ser entregue:");
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnGravar.setMnemonic('o');
        this.btnGravar.setText("Ok");
        this.btnGravar.setEnabled(false);
        this.btnGravar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarTransmitir.this.btnGravarActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarTransmitir.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnGravar, -2, 96, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnGravar}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.btnGravar).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(168, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnGravar}, 2);
        this.btnGravar.getAccessibleContext().setAccessibleName("OK");
        this.jPanel4.setBackground(new Color(241, 245, 249));
        this.jPanel4.setForeground(new Color(255, 255, 255));
        this.chkCertificacaoDigital.setBackground(new Color(241, 245, 249));
        this.chkCertificacaoDigital.setFont(FontesUtil.FONTE_NORMAL);
        this.chkCertificacaoDigital.setText("Transmitir com certifica\u00e7\u00e3o Digital");
        this.chkCertificacaoDigital.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanel4.add(this.chkCertificacaoDigital);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((Component)this.subpainelDeclaracoesPreenchimento, -1, 628, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.subpainelDeclaracoesPreenchimento, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2)));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione o CPF da Declara\u00e7\u00e3o a ser entregue. ");
    }

    private void btnGravarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        this.transmitir();
    }

    private void transmitir() {
        ExecutarGravarIdDeclaracao executarGravarIdDeclaracao = new ExecutarGravarIdDeclaracao(this.dirSelecionado);
        executarGravarIdDeclaracao.gravar();
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void setarSeCertificavel(DeclaracaoIRPF decAtual, boolean usarCertificado) {
        if (usarCertificado) {
            decAtual.getIdentificadorDeclaracao().getInCertificavel().setConteudo(Logico.SIM);
        } else {
            decAtual.getIdentificadorDeclaracao().getInCertificavel().setConteudo(Logico.NAO);
        }
    }

    private void setarConfiabilidade(DeclaracaoIRPF decAtual) {
        UsuarioLogado usuarioGovBr = BarramentoIRPFService.getUsuarioLogado();
        int confiabilidade = usuarioGovBr != null ? usuarioGovBr.getIntNivelAcessoGov() : 0;
        decAtual.getIdentificadorDeclaracao().getInConfiabilidade().setConteudo(String.valueOf(confiabilidade));
    }

    private void setarCpfEPerfilCpfTransmissao(DeclaracaoIRPF decAtual) {
        String cpfLogado = null;
        String espacoEmBranco = "           ";
        String naoDefinido = "0";
        String proprio = "1";
        String procurador = "2";
        UsuarioLogado usuarioGovBr = BarramentoIRPFService.getUsuarioLogado();
        String cpfDeclaracao = decAtual.getIdentificadorDeclaracao().getCpf().naoFormatado();
        if (usuarioGovBr != null) {
            cpfLogado = usuarioGovBr.getCpf();
            if (!cpfLogado.equals(cpfDeclaracao)) {
                decAtual.getIdentificadorDeclaracao().getCpfTransmissao().setConteudo(cpfLogado);
                decAtual.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().setConteudo(procurador);
            } else {
                decAtual.getIdentificadorDeclaracao().getCpfTransmissao().setConteudo(espacoEmBranco);
                decAtual.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().setConteudo(proprio);
            }
        } else {
            decAtual.getIdentificadorDeclaracao().getCpfTransmissao().setConteudo(espacoEmBranco);
            decAtual.getIdentificadorDeclaracao().getInPerfilCpfTransmissao().setConteudo(naoDefinido);
        }
    }

    public static void exibeMsgReceitanetNaoInstalado() {
        GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"mensagem_transmitir_declaracao", (String[])new String[]{ConstantesGlobais.EXERCICIO, ConstantesGlobais.EXERCICIO}));
    }

    private void exibeMsgReceitanetVersaoErrada() {
        GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"versa_minima_recnet", (String[])new String[]{ConstantesGlobais.EXERCICIO}));
    }

    public static boolean verificaReceitanetOk() {
        try {
            if (recnet == null) {
                recnet = new ControleReceitanet();
            }
            return true;
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            recnet = null;
            return false;
        }
    }

    public boolean possuiErroMSCAPI(boolean comCertificado) {
        if (comCertificado && FabricaUtilitarios.isWindows()) {
            String java = IRPFUpdater.getInstance().getJavaCommand();
            try {
                Process process = new ProcessBuilder(new String[0]).command(java, "--list-modules").start();
                String response = new String(process.getInputStream().readAllBytes());
                process.waitFor();
                return response.indexOf("mscapi") < 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String transmitirDeclaracao(RepositorioDeclaracaoCentralTxt repDecl, IdentificadorDeclaracao idTransm) {
        StringBuffer msg = new StringBuffer();
        String nrRecibo = null;
        try {
            if (repDecl != null) {
                boolean comCertif = this.chkCertificacaoDigital.isSelected();
                if (recnet == null) {
                    PainelGravarTransmitir.exibeMsgReceitanetNaoInstalado();
                } else {
                    int retornoReceitaNet = recnet.enviarDeclaracao((Window)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new File(repDecl.getPath()), comCertif, msg);
                    if (retornoReceitaNet == 0 || retornoReceitaNet == 2) {
                        String path;
                        if (ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
                            ((IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido()).atualizarListaDeclaracoesRecentes();
                        }
                        nrRecibo = repDecl.recuperarNroRecibo();
                        repDecl.atualizarNroReciboTransmitida(nrRecibo);
                        idTransm.getNumReciboDecRetif().setConteudo(nrRecibo);
                        idTransm.getNumReciboTransmitido().setConteudo(nrRecibo);
                        IRPFFacade.criarDeclaracao((IdentificadorDeclaracao)idTransm);
                        idTransm.getNumReciboTransmitido().setConteudo("0000000000");
                        DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idTransm.getCpf().naoFormatado(), "0000000000");
                        dec.getIdentificadorDeclaracao().getNumReciboTransmitido().setConteudo(nrRecibo);
                        ControladorGui.salvarDemonstrativo(dec);
                        IdentificadorDeclaracao idExcluir = new IdentificadorDeclaracao(idTransm.getCpf().naoFormatado(), "0000000000");
                        ArrayList<IdentificadorDeclaracao> ids = new ArrayList<IdentificadorDeclaracao>();
                        ids.add(idExcluir);
                        ControladorGui.excluirDemonstrativo(ids);
                        if (IRPFFacade.existeDeclaracao((String)idTransm.getCpf().naoFormatado(), (String)"0000000000")) {
                            IdentificadorDeclaracao idPersistido = IRPFFacade.getInstancia().recuperarIdDeclaracao(idTransm.getCpf().naoFormatado(), "0000000000");
                            idPersistido.getNumReciboDecRetif().setConteudo(nrRecibo);
                            idPersistido.getNumReciboTransmitido().setConteudo(nrRecibo);
                            dec.getIdentificadorDeclaracao().getNumReciboTransmitido().setConteudo(nrRecibo);
                            IRPFFacade.getInstancia().salvarDeclaracao(dec);
                        }
                        String nomeFileDEC = path = repDecl.getPath();
                        String nomeFileREC = path.substring(0, path.length() - 4) + ".REC";
                        path = UtilitariosArquivo.getPathTransmitidas();
                        IRPFTxtUtil.copiaBinariaArquivo((String)nomeFileDEC, (String)path);
                        IRPFTxtUtil.copiaBinariaArquivo((String)nomeFileREC, (String)path);
                        String mensagemDialog = null;
                        mensagemDialog = UtilitariosString.insereQuebraDeLinha((String)msg.toString().replaceAll("\\n", " "), (int)100, (String)"<BR>");
                        IRPFFacade.limpaCacheDeclaracoes();
                        ColecaoIdDeclaracao decsTransmitidos = IRPFFacade.getListaIdDeclaracoesTransmitidas();
                        ArrayList<IdentificadorDeclaracao> idsExcluir = new ArrayList<IdentificadorDeclaracao>();
                        ArrayList<IdentificadorDeclaracao> idsExcluirOriginal = new ArrayList<IdentificadorDeclaracao>();
                        for (IdentificadorDeclaracao idSelecionado : decsTransmitidos.itens()) {
                            if (!idSelecionado.getCpf().naoFormatado().equals(idTransm.getCpf().naoFormatado()) || idSelecionado.getNumReciboTransmitido().naoFormatado().equals("0000000000") || idSelecionado.getNumReciboTransmitido().naoFormatado().equals(nrRecibo)) continue;
                            if (idSelecionado.isRetificadora()) {
                                idsExcluir.add(idSelecionado);
                                continue;
                            }
                            if (idTransm.isRetificadora()) {
                                idsExcluirOriginal.add(idSelecionado);
                                continue;
                            }
                            idsExcluir.add(idSelecionado);
                        }
                        ControladorGui.excluirDemonstrativo(idsExcluir);
                        ControladorGui.excluirDemonstrativo(idsExcluirOriginal, true);
                        boolean sim = GuiUtil.mostrarConfirma(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>" + mensagemDialog + "<BR><BR>" + MensagemUtil.getMensagem((String)"confirmarTransmissao") + "</HTML>");
                        if (sim) {
                            PainelImprimirRecibo impRec = new PainelImprimirRecibo();
                            impRec.imprimirDec(nomeFileDEC);
                        }
                    } else if (retornoReceitaNet == 1) {
                        GuiUtil.mostrarErroHTML(HTMLUtil.obterMensagemHTMLComQuebraDeLinhas((String)msg.toString(), (int)100));
                    }
                }
            }
        }
        catch (Exception e) {
            if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
                e.printStackTrace();
            } else {
                LogPPGD.erro((String)e.getMessage());
            }
            GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "<HTML>" + UtilitariosString.insereQuebraDeLinha((String)msg.toString(), (int)100, (String)"<BR>") + "</HTML>");
        }
        return nrRecibo;
    }

    class ExecutarGravarIdDeclaracao {
        private File dir = null;

        public ExecutarGravarIdDeclaracao(File _dir) {
            this.dir = _dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gravar() {
            block42: {
                boolean confirma;
                if (PainelGravarTransmitir.this.possuiErroMSCAPI(PainelGravarTransmitir.this.chkCertificacaoDigital.isSelected()) && (confirma = GuiUtil.mostrarConfirma(GuiUtil.getParent(), "<html><body style='width:400px; height:80px;'><p>Para a transmiss\u00e3o com o certificado digital \u00e9 necess\u00e1rio realizar o download da vers\u00e3o mais recente do IRPF " + ConstantesGlobais.EXERCICIO + ", dispon\u00edvel no site da RFB, e executar a reinstala\u00e7\u00e3o do programa para substituir a vers\u00e3o atual.</p><p>Deseja fechar o programa IRPF" + ConstantesGlobais.EXERCICIO + " e acessar o s\u00edtio da RFB para download da insta\u00e7\u00e3o mais recente?</p></body></html>"))) {
                    SairAction fecharAction = new SairAction(){

                        @Override
                        protected void onExitPgd() {
                            NavegadorHtml.executarNavegadorComMsgErro("https://www.gov.br/receitafederal/pt-br/centrais-de-conteudo/download/pgd/dirpf");
                        }
                    };
                    fecharAction.setMostrarConfirmacaoFecharPrograma(false);
                    fecharAction.actionPerformed(null);
                    return;
                }
                ControladorGui.iniciarGravacaoDemonstrativo();
                String path = "";
                TableModelSelecionaDeclaracaoPreenchimento tableModel = (TableModelSelecionaDeclaracaoPreenchimento)PainelGravarTransmitir.this.subpainelDeclaracoesPreenchimento.getTabela().getModel();
                int[] linhasSelecionadas = PainelGravarTransmitir.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRows();
                int[] rows = new int[linhasSelecionadas.length];
                for (int a = 0; a < rows.length; ++a) {
                    rows[a] = ((TableRowSorter)PainelGravarTransmitir.this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
                }
                try {
                    if (rows.length <= 0) break block42;
                    path = this.dir.getPath();
                    boolean emiteMsgSucesso = false;
                    for (int i = 0; i < rows.length; ++i) {
                        boolean exibirAvaliacao;
                        UsuarioLogado usuarioGovBr;
                        final IdentificadorDeclaracao idAtual = tableModel.getIdentificadorDeclaracao(rows[i]);
                        if (path.trim().isEmpty()) continue;
                        final DeclaracaoIRPF decAtual = (DeclaracaoIRPF)ProcessoSwing.executarTarefa(new Tarefa(){

                            @Override
                            public Object definirTarefa() {
                                return IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idAtual.getCpf().naoFormatado(), "0000000000");
                            }
                        });
                        decAtual.limparTrabalhoNaoAssalariadoSemLancamento();
                        decAtual.atribuirFichaLancamentosTrabalhoNaoAssalariado();
                        PainelGravarTransmitir.this.setarSeCertificavel(decAtual, PainelGravarTransmitir.this.chkCertificacaoDigital.isSelected());
                        PainelGravarTransmitir.this.setarConfiabilidade(decAtual);
                        PainelGravarTransmitir.this.setarCpfEPerfilCpfTransmissao(decAtual);
                        IRPFFacade.getInstancia().setDeclaracaoEmGravacao(decAtual);
                        boolean simplesIgualCompleta = decAtual.simplesIgualCompleta();
                        boolean simplesEhMelhor = decAtual.simplesEhMelhor();
                        if (!simplesIgualCompleta && idAtual.isAjuste() && (idAtual.isCompleta() && simplesEhMelhor || !idAtual.isCompleta() && !simplesEhMelhor)) {
                            PainelGravacaoEntregaModeloMelhor painelGravacaoEntregaModeloMelhor = new PainelGravacaoEntregaModeloMelhor(decAtual, simplesEhMelhor);
                            GuiUtil.exibeDialog(painelGravacaoEntregaModeloMelhor, true, "Confirma\u00e7\u00e3o", false);
                        }
                        if (idAtual.isAjuste() && decAtual.getModelo().getSaldoImpostoPagar().comparacao(">=", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor())) {
                            PainelImpostoPagarAcessivel painelImpostoPagar = new PainelImpostoPagarAcessivel(decAtual);
                            GuiUtil.exibeDialog(painelImpostoPagar, true, "Quotas do Imposto a Pagar", false);
                            if (decAtual.getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado().equals("autorizado")) {
                                PainelDadosDebitoAutomatico painelDadosBancarios = new PainelDadosDebitoAutomatico(decAtual);
                                GuiUtil.exibeDialog(painelDadosBancarios, true, "Dados do d\u00e9bito autom\u00e1tico", false);
                                if (painelDadosBancarios.opcao == -1) {
                                    IRPFFacade.limpaCacheDeclaracoes();
                                    continue;
                                }
                            }
                            ControladorGui.salvarDemonstrativo(decAtual);
                        } else if (decAtual.getModelo().getImpostoRestituir().comparacao(">", "0,00")) {
                            decAtual.getResumo().getCalculoImposto().getDebitoAutomatico().setConteudo("N");
                            PainelDadosRestituicao painelDadosBancarios = new PainelDadosRestituicao(decAtual);
                            GuiUtil.exibeDialog(painelDadosBancarios, true, "Dados da Restitui\u00e7\u00e3o", false);
                            if (painelDadosBancarios.opcao == -1) {
                                IRPFFacade.limpaCacheDeclaracoes();
                                continue;
                            }
                            ProcessoSwing.executarTarefa(new Tarefa(){

                                @Override
                                public Object definirTarefa() {
                                    try {
                                        ControladorGui.salvarDemonstrativo(decAtual);
                                    }
                                    catch (Exception ex) {
                                        LogPPGD.erro((String)ex.getMessage());
                                        ControladorGui.tratarException(ex);
                                    }
                                    return null;
                                }
                            });
                        }
                        decAtual.getBens().limparReferenciasInvalidasDependente(decAtual);
                        decAtual.getBens().limparReferenciasInvalidasParticipacaoInventario(decAtual);
                        ControladorGui.salvarDemonstrativo(decAtual);
                        List listaPendencias = FabricaUtilitarios.verificarPendencias((Object)decAtual);
                        PainelPendencias painelPendencias = new PainelPendencias(listaPendencias);
                        painelPendencias.preExibir();
                        if (painelPendencias.getQtdTotalErros() > 0) {
                            if (GuiUtil.mostrarConfirma(PainelGravarTransmitir.this.getParent(), MensagemUtil.getMensagem((String)"gravar_transmitir_erros_impeditivos", (String[])new String[]{idAtual.getCpf().formatado(), path}))) {
                                IRPFFacade.limpaCacheDeclaracoes();
                                ControladorGui.abrirDemonstrativo(decAtual, true);
                                ControladorGui.acionarPainel(painelPendencias);
                                JTaskAction taskAction = ControladorGui.getJanelaPrincipal().getTaskActionDoPainel(PainelPendencias.class.getName());
                                if (taskAction != null) {
                                    JTaskTabs tabs = ControladorGui.getJanelaPrincipal().getAbas();
                                    tabs.atualizaAbas(taskAction, true);
                                }
                                return;
                            }
                            IRPFFacade.limpaCacheDeclaracoes();
                            continue;
                        }
                        if (painelPendencias.getQtdTotalAvisos() > 0) {
                            PainelGravarTransmitirPendenciasNaoImpeditivas painel = new PainelGravarTransmitirPendenciasNaoImpeditivas();
                            GuiUtil.exibeDialog(painel, true, "Entregar Declara\u00e7\u00e3o", true);
                            int opcao = PainelGravarTransmitirPendenciasNaoImpeditivas.OPCAO_SELECIONADA;
                            if (opcao == 2) {
                                IRPFFacade.limpaCacheDeclaracoes();
                                ControladorGui.abrirDemonstrativo(decAtual, true);
                                ControladorGui.acionarPainel(painelPendencias);
                                JTaskAction taskAction = ControladorGui.getJanelaPrincipal().getTaskActionDoPainel(PainelPendencias.class.getName());
                                if (taskAction != null) {
                                    JTaskTabs tabs = ControladorGui.getJanelaPrincipal().getAbas();
                                    tabs.atualizaAbas(taskAction, true);
                                }
                                return;
                            }
                            if (opcao == 0) {
                                IRPFFacade.limpaCacheDeclaracoes();
                                continue;
                            }
                        }
                        if ((usuarioGovBr = BarramentoIRPFService.getUsuarioLogado()) != null) {
                            decAtual.getUtlimoCPFAutenticado().setConteudo(usuarioGovBr.getCpf());
                            ControladorGui.salvarDemonstrativo(decAtual);
                        }
                        String nomeDec = GravadorTXT.montaNome((byte)0, (String)path, (IdentificadorDeclaracao)idAtual);
                        File decFile = new File(nomeDec);
                        File bakFile = new File(nomeDec.replaceFirst("\\.DEC", ".BAK"));
                        File recFile = new File(nomeDec.replaceFirst("\\.DEC", ".REC"));
                        File rakFile = new File(nomeDec.replaceFirst("\\.DEC", ".RAK"));
                        if (decFile.exists()) {
                            if (bakFile.exists() && !bakFile.delete()) {
                                throw new IOException("N\u00e3o foi poss\u00edvel apagar arquivo: " + bakFile.getPath());
                            }
                            if (!decFile.renameTo(bakFile)) {
                                throw new IOException("N\u00e3o foi poss\u00edvel renomear arquivo: " + decFile.getPath());
                            }
                        }
                        if (recFile.exists()) {
                            if (rakFile.exists() && !rakFile.delete()) {
                                throw new IOException("N\u00e3o foi poss\u00edvel apagar arquivo: " + rakFile.getPath());
                            }
                            if (!recFile.renameTo(rakFile)) {
                                throw new IOException("N\u00e3o foi poss\u00edvel renomear arquivo: " + recFile.getPath());
                            }
                        }
                        GravadorTXT.gravarDeclaracao((IdentificadorDeclaracao)idAtual, (String)path);
                        RepositorioDeclaracaoCentralTxt repDeclaracao = null;
                        try {
                            repDeclaracao = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", new File(nomeDec));
                            repDeclaracao.validarDeclaracaoNaoPersistido();
                        }
                        catch (IOException e) {
                            LogPPGD.erro((String)e.getMessage());
                            GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), e.getMessage());
                            continue;
                        }
                        catch (Exception e) {
                            LogPPGD.erro((String)e.getMessage());
                            GuiUtil.mostrarErroHTML("erro_inesperado_gravar_transmitir", new String[]{AplicacaoPropertiesUtil.getVersao(), AplicacaoPropertiesUtil.getNomeAplicacao() + " " + AplicacaoPropertiesUtil.getExercicio()});
                            continue;
                        }
                        emiteMsgSucesso = true;
                        String recibo = PainelGravarTransmitir.this.transmitirDeclaracao(repDeclaracao, idAtual);
                        boolean bl = exibirAvaliacao = !ControladorGui.getIRPFPreferences().getBoolean(ControladorGui.NAO_EXIBIR_AVALIACAO, false);
                        if (!exibirAvaliacao || recibo == null) continue;
                        GuiUtil.exibeDialog(new PainelAvisoAvaliacao(recibo, usuarioGovBr != null, false), true, "Avalia\u00e7\u00e3o do IRPF" + ConstantesGlobais.EXERCICIO, false);
                    }
                    if (emiteMsgSucesso) {
                        if (ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
                            ((IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido()).atualizarListaDeclaracoesRecentes();
                        }
                    } else {
                        GuiUtil.mostrarInfo((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Entrega cancelada pelo usu\u00e1rio.");
                    }
                    if (ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
                        IRPFBemVindos bemVindos = (IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido();
                        int abaSelecionada = bemVindos.getTabbedPane().getSelectedIndex();
                        bemVindos.montarTabPane(abaSelecionada);
                        bemVindos.preExibir();
                    }
                }
                catch (GeracaoTxtException ev) {
                    LogPPGD.erro((String)ev.getMessage());
                    GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ev.getMessage());
                    return;
                }
                catch (IOException ev) {
                    LogPPGD.erro((String)ev.getMessage());
                    GuiUtil.mostrarErro(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"gravar_pasta_sem_permissao"));
                    return;
                }
                catch (Exception e) {
                    LogPPGD.erro((String)e.getMessage());
                    GuiUtil.mostrarErroHTML("erro_inesperado_gravar_transmitir", new String[]{AplicacaoPropertiesUtil.getVersao(), AplicacaoPropertiesUtil.getNomeAplicacao() + " " + AplicacaoPropertiesUtil.getExercicio()});
                }
                finally {
                    IRPFFacade.getInstancia().setDeclaracaoEmGravacao(null);
                    ControladorGui.terminarGravacaoDemonstrativo();
                }
            }
        }
    }
}

