/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileChooserSelectionMode;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFBemVindos;
import serpro.ppgd.irpf.gui.TableModelSelecionaDeclaracaoPreenchimento;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.dialogs.PainelDadosDebitoAutomatico;
import serpro.ppgd.irpf.gui.dialogs.PainelDadosRestituicao;
import serpro.ppgd.irpf.gui.dialogs.PainelGravacaoEntregaModeloMelhor;
import serpro.ppgd.irpf.gui.dialogs.PainelGravacaoEntregaPendenciasNaoImpeditivas;
import serpro.ppgd.irpf.gui.dialogs.PainelImpostoPagarAcessivel;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.pendencias.PainelPendencias;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProcessoSwing;
import serpro.ppgd.irpf.gui.util.Tarefa;
import serpro.ppgd.irpf.gui.util.tabs.JTaskTabs;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelGravarEntrega
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Gravar a declara\u00e7\u00e3o para entrega \u00e0 RFB";
    private File dirSelecionado = null;
    private IdentificadorDeclaracao idSelecionado = null;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnGravar;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;

    public PainelGravarEntrega() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelGravarEntrega.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarEntrega.this.btnGravar.setEnabled(true);
                } else {
                    PainelGravarEntrega.this.btnGravar.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelGravarEntrega.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarEntrega.this.btnGravarActionPerformed(null);
                }
            }
        });
    }

    public PainelGravarEntrega(IdentificadorDeclaracao idSelecionado) {
        this();
        this.idSelecionado = idSelecionado;
        if (idSelecionado != null) {
            this.selecionarDeclaracao(idSelecionado);
            this.gravar();
            JDialog jd = (JDialog)SwingUtilities.getRoot(this);
            if (jd != null) {
                jd.setVisible(false);
            }
        }
    }

    private void selecionarDeclaracao(IdentificadorDeclaracao idSelecionado) {
        TableModelSelecionaDeclaracaoPreenchimento tableModel = (TableModelSelecionaDeclaracaoPreenchimento)this.subpainelDeclaracoesPreenchimento.getTabela().getModel();
        int selIndice = -1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            IdentificadorDeclaracao idAtual = tableModel.getIdentificadorDeclaracao(i);
            if (!idAtual.getCpf().naoFormatado().equals(idSelecionado.getCpf().naoFormatado())) continue;
            selIndice = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToView(i);
            break;
        }
        if (selIndice > -1) {
            this.subpainelDeclaracoesPreenchimento.getTabela().setRowSelectionInterval(selIndice, selIndice);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.btnGravar = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione o CPF da Declara\u00e7\u00e3o a ser gravada:");
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setForeground(new Color(255, 255, 255));
        this.btnGravar.setMnemonic('o');
        this.btnGravar.setText("Ok");
        this.btnGravar.setEnabled(false);
        this.btnGravar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarEntrega.this.btnGravarActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarEntrega.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnGravar, -2, 96, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnGravar}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.btnGravar).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnGravar}, 2);
        this.btnGravar.getAccessibleContext().setAccessibleName("OK");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 600, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesPreenchimento, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesPreenchimento, -1, 295, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(135, 135, 135)))));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione o CPF da Declara\u00e7\u00e3o a ser gravada. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnGravarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        this.gravar();
    }

    private void gravar() {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Grava\u00e7\u00e3o de Declara\u00e7\u00e3o para Entrega \u00e0 RFB");
        fc.setApproveButtonText("Salvar");
        fc.setApproveButtonToolTipText("Grava\u00e7\u00e3o de Declara\u00e7\u00e3o para Entrega \u00e0 RFB");
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(FileChooserSelectionMode.DIRECTORIES_ONLY);
        FileChooserResponse retorno = fc.showOpenDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
        if (retorno == FileChooserResponse.APPROVE_OPTION) {
            this.dirSelecionado = fc.getSelectedFile();
        }
        ExecutarGravarIdDeclaracao executarGravarIdDeclaracao = new ExecutarGravarIdDeclaracao(this.dirSelecionado);
        executarGravarIdDeclaracao.gravar();
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    class ExecutarGravarIdDeclaracao {
        private File dir = null;

        public ExecutarGravarIdDeclaracao(File _dir) {
            this.dir = _dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gravar() {
            ControladorGui.iniciarGravacaoDemonstrativo();
            String path = "";
            TableModelSelecionaDeclaracaoPreenchimento tableModel = (TableModelSelecionaDeclaracaoPreenchimento)PainelGravarEntrega.this.subpainelDeclaracoesPreenchimento.getTabela().getModel();
            int[] linhasSelecionadas = PainelGravarEntrega.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRows();
            int[] rows = new int[linhasSelecionadas.length];
            for (int a = 0; a < rows.length; ++a) {
                rows[a] = ((TableRowSorter)PainelGravarEntrega.this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            try {
                if (rows.length > 0) {
                    boolean emiteMsgSucesso = false;
                    if (this.dir != null) {
                        path = this.dir.getPath();
                        for (int i = 0; i < rows.length; ++i) {
                            File bkpRec;
                            int ret;
                            UsuarioLogado usuarioGovBr;
                            final IdentificadorDeclaracao idAtual = tableModel.getIdentificadorDeclaracao(rows[i]);
                            if (path.trim().isEmpty()) continue;
                            final DeclaracaoIRPF decAtual = (DeclaracaoIRPF)ProcessoSwing.executarTarefa(new Tarefa(){

                                @Override
                                public Object definirTarefa() {
                                    return IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idAtual.getCpf().naoFormatado(), "0000000000");
                                }
                            });
                            decAtual.limparTrabalhoNaoAssalariadoSemLancamento();
                            decAtual.atribuirFichaLancamentosTrabalhoNaoAssalariado();
                            decAtual.getPagamentos().verificarLegadoPagamentos();
                            IRPFFacade.getInstancia().setDeclaracaoEmGravacao(decAtual);
                            boolean simplesIgualCompleta = decAtual.simplesIgualCompleta();
                            boolean simplesEhMelhor = decAtual.simplesEhMelhor();
                            if (!simplesIgualCompleta && idAtual.isAjuste() && (idAtual.isCompleta() && simplesEhMelhor || !idAtual.isCompleta() && !simplesEhMelhor)) {
                                PainelGravacaoEntregaModeloMelhor painelGravacaoEntregaModeloMelhor = new PainelGravacaoEntregaModeloMelhor(decAtual, simplesEhMelhor);
                                GuiUtil.exibeDialog(painelGravacaoEntregaModeloMelhor, true, "Confirma\u00e7\u00e3o", false);
                            }
                            if (idAtual.isAjuste() && decAtual.getModelo().getSaldoImpostoPagar().comparacao(">=", TabelaAliquotasIRPF.ConstantesAliquotas.valorMinIAP.getValor())) {
                                PainelImpostoPagarAcessivel painelImpostoPagar = new PainelImpostoPagarAcessivel(decAtual);
                                GuiUtil.exibeDialog(painelImpostoPagar, true, "Quotas do Imposto a Pagar", false);
                                if (decAtual.getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado().equals("autorizado")) {
                                    PainelDadosDebitoAutomatico painelDadosBancarios = new PainelDadosDebitoAutomatico(decAtual);
                                    GuiUtil.exibeDialog(painelDadosBancarios, true, "Dados do d\u00e9bito autom\u00e1tico", false);
                                    if (painelDadosBancarios.opcao == -1) {
                                        IRPFFacade.limpaCacheDeclaracoes();
                                        continue;
                                    }
                                }
                                ControladorGui.salvarDemonstrativo(decAtual);
                            } else if (decAtual.getModelo().getImpostoRestituir().comparacao(">", "0,00")) {
                                decAtual.getResumo().getCalculoImposto().getDebitoAutomatico().setConteudo("N");
                                PainelDadosRestituicao painelDadosBancarios = new PainelDadosRestituicao(decAtual);
                                GuiUtil.exibeDialog(painelDadosBancarios, true, "Dados da Restitui\u00e7\u00e3o", true);
                                if (painelDadosBancarios.opcao == -1) {
                                    IRPFFacade.limpaCacheDeclaracoes();
                                    continue;
                                }
                                ProcessoSwing.executarTarefa(new Tarefa(){

                                    @Override
                                    public Object definirTarefa() {
                                        try {
                                            ControladorGui.salvarDemonstrativo(decAtual);
                                        }
                                        catch (Exception ex) {
                                            ControladorGui.tratarException(ex);
                                        }
                                        return null;
                                    }
                                });
                            }
                            decAtual.getBens().limparReferenciasInvalidasDependente(decAtual);
                            decAtual.getBens().limparReferenciasInvalidasParticipacaoInventario(decAtual);
                            decAtual.getAlimentandos().limparReferenciasInvalidasAlimentando(decAtual);
                            ControladorGui.salvarDemonstrativo(decAtual);
                            List listaPendencias = FabricaUtilitarios.verificarPendencias((Object)decAtual);
                            PainelPendencias painelPendencias = new PainelPendencias(listaPendencias);
                            painelPendencias.preExibir();
                            if (painelPendencias.getQtdTotalErros() > 0) {
                                if (GuiUtil.mostrarConfirma(PainelGravarEntrega.this.getParent(), MensagemUtil.getMensagem((String)"gravacao_entrega_erros_impeditivos", (String[])new String[]{idAtual.getCpf().formatado(), path}))) {
                                    IRPFFacade.limpaCacheDeclaracoes();
                                    ControladorGui.abrirDemonstrativo(decAtual, true);
                                    ControladorGui.acionarPainel(painelPendencias);
                                    JTaskAction taskAction = ControladorGui.getJanelaPrincipal().getTaskActionDoPainel(PainelPendencias.class.getName());
                                    if (taskAction != null) {
                                        JTaskTabs tabs = ControladorGui.getJanelaPrincipal().getAbas();
                                        tabs.atualizaAbas(taskAction, true);
                                    }
                                    return;
                                }
                                IRPFFacade.limpaCacheDeclaracoes();
                                continue;
                            }
                            if (painelPendencias.getQtdTotalAvisos() > 0) {
                                PainelGravacaoEntregaPendenciasNaoImpeditivas painelGravacaoEntregaPendenciasNaoImpeditivas = new PainelGravacaoEntregaPendenciasNaoImpeditivas();
                                GuiUtil.exibeDialog(painelGravacaoEntregaPendenciasNaoImpeditivas, true, "Grava\u00e7\u00e3o da Declara\u00e7\u00e3o", true);
                                int opcao = PainelGravacaoEntregaPendenciasNaoImpeditivas.OPCAO_SELECIONADA;
                                if (opcao == 2) {
                                    IRPFFacade.limpaCacheDeclaracoes();
                                    ControladorGui.abrirDemonstrativo(decAtual, true);
                                    ControladorGui.acionarPainel(painelPendencias);
                                    JTaskAction taskAction = ControladorGui.getJanelaPrincipal().getTaskActionDoPainel(PainelPendencias.class.getName());
                                    if (taskAction != null) {
                                        JTaskTabs tabs = ControladorGui.getJanelaPrincipal().getAbas();
                                        tabs.atualizaAbas(taskAction, true);
                                    }
                                    return;
                                }
                                if (opcao == 0) {
                                    IRPFFacade.limpaCacheDeclaracoes();
                                    continue;
                                }
                                if (opcao == 1) {
                                    // empty if block
                                }
                            }
                            if ((usuarioGovBr = BarramentoIRPFService.getUsuarioLogado()) != null) {
                                decAtual.getUtlimoCPFAutenticado().setConteudo(usuarioGovBr.getCpf());
                                ControladorGui.salvarDemonstrativo(decAtual);
                            }
                            String nomeDec = GravadorTXT.montaNome((byte)0, (String)path, (IdentificadorDeclaracao)idAtual);
                            String nomeRec = nomeDec.substring(0, nomeDec.length() - ".DEC".length()) + ".REC";
                            String nomeRecBkp = nomeDec.substring(0, nomeDec.length() - ".DEC".length()) + ".RAK";
                            if (new File(nomeDec).exists() && (ret = JOptionPane.showConfirmDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"gravar_entrega_ja_existe"), "Declara\u00e7\u00e3o j\u00e1 foi gravada", 0)) == 1) {
                                IRPFFacade.limpaCacheDeclaracoes();
                                continue;
                            }
                            File fileRec = new File(nomeRec);
                            if (fileRec.exists() && !fileRec.renameTo(bkpRec = new File(nomeRecBkp))) {
                                LogPPGD.erro((String)"falha renomeando arquivo");
                            }
                            GravadorTXT.gravarDeclaracao((IdentificadorDeclaracao)idAtual, (String)path);
                            emiteMsgSucesso = true;
                        }
                    }
                    if (emiteMsgSucesso) {
                        GuiUtil.mostrarInfo("gravar_sucesso");
                        if (ControladorGui.getPainelAtualmenteExibido() instanceof IRPFBemVindos) {
                            ((IRPFBemVindos)ControladorGui.getPainelAtualmenteExibido()).atualizarListaDeclaracoesRecentes();
                        }
                    } else {
                        JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), "Grava\u00e7\u00e3o cancelada pelo usu\u00e1rio.", "Informa\u00e7\u00e3o", 1);
                    }
                }
            }
            catch (GeracaoTxtException ev) {
                LogPPGD.erro((String)ev.getMessage());
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ev.getMessage(), "Erro", 0);
                return;
            }
            catch (FileNotFoundException ev) {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"gravar_pasta_sem_permissao"), "Erro", 0);
                return;
            }
            catch (IOException ev) {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"gravar_pasta_sem_permissao"), "Erro", 0);
                return;
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
                GuiUtil.mostrarErroHTML("erro_inesperado_gravar", new String[]{AplicacaoPropertiesUtil.getVersao(), AplicacaoPropertiesUtil.getNomeAplicacao() + " " + AplicacaoPropertiesUtil.getExercicio()});
            }
            finally {
                IRPFFacade.getInstancia().setDeclaracaoEmGravacao(null);
                ControladorGui.terminarGravacaoDemonstrativo();
            }
        }
    }
}

